DROP TABLE IF EXISTS `fort_siege_guards`;
CREATE TABLE IF NOT EXISTS `fort_siege_guards` (
  `fortId` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `npcId` smallint(5) unsigned NOT NULL DEFAULT '0',
  `x` mediumint(6) NOT NULL DEFAULT '0',
  `y` mediumint(6) NOT NULL DEFAULT '0',
  `z` mediumint(6) NOT NULL DEFAULT '0',
  `heading` mediumint(6) NOT NULL DEFAULT '0',
  `respawnDelay` mediumint(5) NOT NULL DEFAULT '0',
  `isHired` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`fortId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `fort_siege_guards` VALUES
-- Shanty Guards
(101,null,35682,-53815,155646,-2024,56240,600,0),
(101,null,35681,-53824,155264,-2024,14952,600,0),
(101,null,35681,-53694,155121,-2024,13264,600,0),
(101,null,35681,-53711,155501,-2024,23976,600,0),
(101,null,35682,-53673,155308,-2024,17760,600,0),
(101,null,35681,-54208,155632,-2024,3672,600,0),
(101,null,35685,-53378,154775,-2048,0,0,0),
(101,null,35674,-54112,154912,-1672,37000,600,0),
(101,null,35674,-54080,154880,-1672,45000,600,0),
(101,null,35674,-53928,154752,-1672,43000,600,0),
(101,null,35674,-53882,154739,-1672,50000,600,0),
(101,null,35674,-54644,157598,-1672,8028,600,0),
(101,null,35672,-53279,156004,-1680,46167,600,0),
(101,null,35672,-53308,156012,-1680,46167,600,0),
(101,null,35672,-53339,156021,-1680,46167,600,0),
(101,null,35682,-54638,156499,-1872,3692,600,0),
(101,null,35674,-54665,156490,-1872,17332,600,0),
(101,null,35674,-54677,156521,-1872,17677,600,0),
(101,null,35681,-54706,157042,-2048,27522,600,0),
(101,null,35674,-54248,156312,-1696,36288,600,0),
(101,null,35674,-54237,156284,-1696,36288,600,0),
(101,null,35682,-54224,156320,-1696,36292,600,0),
(101,null,35681,-54214,156292,-1696,36292,600,0),
(101,null,35674,-54467,157550,-1872,10226,600,0),
(101,null,35674,-54445,157575,-1872,10108,600,0),
(101,null,35682,-54427,157559,-1872,57719,600,0),
(101,null,35681,-54626,157154,-2048,34565,600,0),
(101,null,35682,-53970,157575,-1696,25380,600,0),
(101,null,35674,-53990,157591,-1696,25380,600,0),
(101,null,35674,-53970,157615,-1696,25380,600,0),
(101,null,35681,-53951,157598,-1696,25380,600,0),
(101,null,35673,-54767,157106,-2048,28672,600,0),
(101,null,35674,-54488,156515,-1608,20000,600,0),
(101,null,35674,-54509,156473,-1608,20000,600,0),
(101,null,35674,-54556,156492,-1608,20000,600,0),
(101,null,35674,-54520,156504,-1608,20000,600,0),
(101,null,35674,-54363,157530,-1592,41216,600,0),
(101,null,35674,-54369,157577,-1608,41216,600,0),
(101,null,35674,-54419,157579,-1608,41216,600,0),
(101,null,35674,-54392,157553,-1608,41216,600,0),
(101,null,35674,-53899,156904,-2048,28672,600,0),
(101,null,35674,-53841,156940,-2048,28672,600,0),
(101,null,35674,-53862,156871,-2048,28672,600,0),
(101,null,35674,-53851,156906,-2048,28672,600,0),
(101,null,35674,-53873,156836,-2048,28672,600,0),
(101,null,35674,-54657,157544,-1656,8241,600,0),
(101,null,35674,-54912,156704,-1656,14303,600,0),
(101,null,35674,-54926,156651,-1672,14407,600,0),
(101,null,35673,-53338,156719,-2048,28672,600,0),
(101,null,35673,-53347,156689,-2048,28672,600,0),
(101,null,35673,-53358,156657,-2048,28672,600,0),
(101,null,35673,-53368,156625,-2048,28672,600,0),
(101,null,35673,-54747,157168,-2048,28672,600,0),
(101,null,35673,-54756,157138,-2048,28672,600,0),
(101,null,35673,-54777,157074,-2048,28672,600,0),
(101,null,35674,-51243,155431,-1608,8500,600,0),
(101,null,35684,-52131,155249,-1976,62488,600,0),
(101,null,35684,-52702,155018,-1976,30240,600,0),
(101,null,35684,-52465,155136,-1976,0,600,0),
(101,null,35684,-52604,155371,-1976,30328,600,0),
(101,null,35684,-52296,154863,-1976,45936,600,0),
(101,null,35684,-52671,154976,-1976,45936,600,0),
(101,null,35684,-52566,155402,-1976,12624,600,0),
(101,null,35684,-52170,155285,-1976,12624,600,0),
(101,null,35684,-52252,154873,-1976,62832,600,0),
(101,null,35684,-52550,154894,-1872,12624,600,0),
(101,null,35684,-52521,154884,-1872,12624,600,0),
(101,null,35684,-52285,155363,-1872,46392,600,0),
(101,null,35684,-52316,155373,-1872,45936,600,0),
(101,null,35674,-51569,155421,-1696,56696,600,0),
(101,null,35674,-51593,155400,-1696,56696,600,0),
(101,null,35682,-51590,155441,-1696,56696,600,0),
(101,null,35681,-51613,155421,-1696,56696,600,0),
(101,null,35674,-51269,155502,-1608,8500,600,0),
(101,null,35674,-51244,155478,-1608,8500,600,0),
(101,null,35674,-51219,155454,-1608,8500,600,0),
(101,null,35685,-53090,155633,-2048,0,0,0),
(101,null,35674,-52979,154458,-1656,42999,600,0),
(101,null,35674,-52929,154446,-1672,64153,600,0),
(101,null,35674,-51529,154796,-1672,59999,600,0),
(101,null,35674,-51563,154766,-1672,54000,600,0),
(101,null,35672,-52633,155907,-1536,29823,600,0),
(101,null,35672,-52625,155937,-1544,29823,600,0),
(101,null,35672,-52616,155967,-1536,29823,600,0),
(101,null,35672,-52277,156720,-1336,45999,600,0),
(101,null,35672,-52246,156710,-1336,45999,600,0),
(101,null,35672,-52307,156729,-1336,45999,600,0),
(101,null,35672,-53018,156745,-1160,29500,600,0),
(101,null,35672,-53009,156773,-1160,29500,600,0),
(101,null,35672,-53000,156801,-1160,29500,600,0),
(101,null,35672,-52991,156829,-1160,29500,600,0),
(101,null,35672,-53053,156622,-1160,29500,600,0),
(101,null,35672,-53044,156651,-1160,29500,600,0),
(101,null,35672,-53026,156707,-1160,29500,600,0),
(101,null,35672,-53035,156679,-1160,29500,600,0),
(101,null,35671,-52650,156505,-1128,62264,600,0),
(101,null,35671,-52659,156478,-1128,62264,600,0),
(101,null,35671,-52668,156451,-1128,62264,600,0),
(101,null,35671,-52846,156563,-1128,29992,600,0),
(101,null,35671,-52677,156424,-1128,62264,600,0),
(101,null,35671,-52854,156535,-1128,29992,600,0),
(101,null,35671,-52861,156508,-1128,29992,600,0),
(101,null,35671,-52869,156481,-1128,29992,600,0),
(101,null,35670,-52818,156512,-1128,29992,600,0),
(101,null,35678,-52279,157693,-2024,62372,600,0),
(101,null,35673,-52185,156258,-2048,62199,600,0),
(101,null,35685,-52000,157181,-2048,0,0,0),
(101,null,35674,-51679,156168,-2048,62199,600,0),
(101,null,35674,-51710,156231,-2048,62199,600,0),
(101,null,35674,-51730,156162,-2048,62199,600,0),
(101,null,35673,-52153,156362,-2048,62199,600,0),
(101,null,35673,-52174,156292,-2048,62199,600,0),
(101,null,35673,-52163,156328,-2048,62199,600,0),
(101,null,35674,-51741,156128,-2048,62199,600,0),
(101,null,35674,-51720,156198,-2048,62199,600,0),
(101,null,35674,-51068,155409,-1872,10396,600,0),
(101,null,35674,-51089,155386,-1872,10619,600,0),
(101,null,35682,-51049,155390,-1872,24632,600,0),
(101,null,35681,-50888,155864,-2056,3620,600,0),
(101,null,35674,-50871,155481,-1672,13190,600,0),
(101,null,35674,-50884,155429,-1672,13248,600,0),
(101,null,35674,-50934,156494,-1608,52148,600,0),
(101,null,35674,-50731,156483,-1872,16818,600,0),
(101,null,35674,-50722,156453,-1872,17146,600,0),
(101,null,35681,-50830,155970,-2056,64002,600,0),
(101,null,35682,-50703,156490,-1872,35592,600,0),
(101,null,35674,-51151,156716,-1696,3068,600,0),
(101,null,35674,-51161,156745,-1696,3068,600,0),
(101,null,35682,-51178,156708,-1696,3068,600,0),
(101,null,35681,-51186,156736,-1696,3068,600,0),
(101,null,35674,-50942,156526,-1608,52148,600,0),
(101,null,35674,-50969,156485,-1608,52148,600,0),
(101,null,35674,-50897,156503,-1608,52148,600,0),
(101,null,35674,-50602,156356,-1656,17810,600,0),
(101,null,35674,-50618,156304,-1672,16876,600,0),
(101,null,35674,-50787,157291,-1672,22514,600,0),
(101,null,35674,-50782,157246,-1656,22466,600,0),
(101,null,35673,-50779,155857,-2056,62199,600,0),
(101,null,35673,-50770,155889,-2056,62199,600,0),
(101,null,35673,-50759,155920,-2056,62199,600,0),
(101,null,35673,-50750,155952,-2056,62199,600,0),
(101,null,35679,-52278,157907,-2016,62372,600,0),
(101,null,35679,-52291,157857,-2016,62372,600,0),
(101,null,35679,-52305,157809,-2016,62372,600,0),
(101,null,35679,-52319,157760,-2016,62372,600,0),
(101,null,35679,-52335,157711,-2016,62372,600,0),
(101,null,35678,-52221,157889,-2024,62372,600,0),
(101,null,35678,-52234,157839,-2024,62372,600,0),
(101,null,35678,-52249,157791,-2016,62372,600,0),
(101,null,35678,-52263,157742,-2024,62372,600,0),
(101,null,35685,-53107,158323,-2048,0,0,0),
(101,null,35674,-53152,158544,-1672,23673,600,0),
(101,null,35674,-51796,158336,-1648,14064,600,0),
(101,null,35674,-53109,158560,-1648,26067,600,0),
(101,null,35674,-51757,158318,-1672,16217,600,0),
(101,null,35674,-53965,158258,-1672,4966,600,0),
(101,null,35674,-53999,158222,-1672,5495,600,0),

-- Southern Guards
(102,null,35706,-25056,218992,-2856,33596,600,0),
(102,null,35706,-25072,219008,-2856,33596,600,0),
(102,null,35706,-24640,218272,-2856,35420,600,0),
(102,null,35706,-24656,218288,-2856,35420,600,0),
(102,null,35705,-25156,219826,-3240,32716,600,0),
(102,null,35705,-25156,219923,-3240,32716,600,0),
(102,null,35706,-24972,219602,-3064,0,600,0),
(102,null,35706,-24972,219567,-3064,0,600,0),
(102,null,35717,-25008,219600,-3056,0,600,0),
(102,null,35718,-25008,219568,-3056,0,600,0),
(102,null,35706,-24701,219258,-2880,32768,600,0),
(102,null,35706,-24701,219226,-2880,32768,600,0),
(102,null,35717,-24669,219226,-2880,32768,600,0),
(102,null,35718,-24669,219258,-2880,32768,600,0),
(102,null,35706,-24960,220160,-3072,0,600,0),
(102,null,35706,-24960,220192,-3072,0,600,0),
(102,null,35718,-25008,220160,-3056,0,600,0),
(102,null,35717,-25008,220192,-3056,0,600,0),
(102,null,35706,-24699,220525,-2880,32768,600,0),
(102,null,35718,-24667,220525,-2880,32768,600,0),
(102,null,35706,-24699,220493,-2880,32768,600,0),
(102,null,35717,-24667,220493,-2880,32768,600,0),
(102,null,35706,-24928,219472,-2792,16552,600,0),
(102,null,35706,-24896,219520,-2792,16552,600,0),
(102,null,35706,-24960,219520,-2792,16552,600,0),
(102,null,35706,-24928,219520,-2792,16552,600,0),
(102,null,35706,-24944,220272,-2792,49120,600,0),
(102,null,35706,-24906,220224,-2792,49120,600,0),
(102,null,35706,-24976,220224,-2792,49120,600,0),
(102,null,35706,-24944,220224,-2792,49120,600,0),
(102,null,35706,-25056,220784,-2856,30696,600,0),
(102,null,35706,-25072,220752,-2856,30696,600,0),
(102,null,35705,-25156,219859,-3240,32716,600,0),
(102,null,35705,-25156,219891,-3240,32716,600,0),
(102,null,35712,-23984,218864,-3072,56680,600,0),
(102,null,35712,-24320,218768,-3136,20088,600,0),
(102,null,35708,-24394,219179,-3232,24964,600,0),
(102,null,35710,-24528,218864,-3136,0,600,0),
(102,null,35708,-24397,218548,-3232,40180,600,0),
(102,null,35707,-23992,218883,-3072,24440,600,0),
(102,null,35710,-24080,218416,-3104,17068,600,0),
(102,null,35710,-24096,219296,-3168,51760,600,0),
(102,null,35708,-23765,219176,-3232,8152,600,0),
(102,null,35708,-23764,218552,-3232,58036,600,0),
(102,null,35706,-24104,219918,-3232,32716,600,0),
(102,null,35706,-24656,221472,-2856,27176,600,0),
(102,null,35706,-24104,219950,-3232,32716,600,0),
(102,null,35706,-24144,219936,-3232,32716,600,0),
(102,null,35706,-24104,219982,-3232,32716,600,0),
(102,null,35706,-24640,221504,-2856,27176,600,0),
(102,null,35709,-23490,218863,-3232,0,600,0),
(102,null,35711,-23294,218987,-3232,0,600,0),
(102,null,35711,-23422,218987,-3232,0,600,0),
(102,null,35711,-23198,219033,-3232,0,600,0),
(102,null,35711,-23326,218849,-3232,0,600,0),
(102,null,35711,-23358,218849,-3232,0,600,0),
(102,null,35711,-23230,218711,-3232,0,600,0),
(102,null,35712,-24064,218576,-3104,29524,600,0),
(102,null,35715,-22851,218091,-3200,32716,600,0),
(102,null,35715,-22850,218204,-3200,32716,600,0),
(102,null,35715,-22850,218172,-3200,32716,600,0),
(102,null,35714,-22897,218091,-3208,32716,600,0),
(102,null,35715,-22850,218107,-3200,32716,600,0),
(102,null,35715,-22850,218140,-3200,32716,600,0),
(102,null,35714,-22895,218109,-3200,32716,600,0),
(102,null,35714,-22895,218141,-3200,32716,600,0),
(102,null,35714,-22895,218205,-3200,32716,600,0),
(102,null,35714,-22896,218173,-3200,32716,600,0),
(102,null,35723,-22740,218883,-3232,0,0,0),
(102,null,35706,-23248,217472,-2856,49996,600,0),
(102,null,35706,-23280,217472,-2856,49996,600,0),
(102,null,35704,-23040,220256,-2712,0,600,0),
(102,null,35704,-23040,220320,-2712,0,600,0),
(102,null,35704,-23071,219456,-2520,15616,600,0),
(102,null,35704,-23040,220288,-2712,0,600,0),
(102,null,35704,-23120,219456,-2520,15616,600,0),
(102,null,35704,-23094,219456,-2520,15616,600,0),
(102,null,35703,-22815,219785,-2312,32672,600,0),
(102,null,35703,-22815,219759,-2312,32672,600,0),
(102,null,35703,-22814,219841,-2312,32672,600,0),
(102,null,35703,-22815,219813,-2312,32672,600,0),
(102,null,35703,-22592,219760,-2312,0,600,0),
(102,null,35703,-22591,219840,-2312,0,600,0),
(102,null,35703,-22591,219785,-2312,0,600,0),
(102,null,35703,-22591,219813,-2312,0,600,0),
(102,null,35702,-22625,219799,-2312,0,600,0),
(102,null,35712,-24144,219136,-3168,0,600,0),
(102,null,35706,-24095,220448,-3088,16040,600,0),
(102,null,35706,-24058,220447,-3080,16040,600,0),
(102,null,35718,-23726,220704,-2864,49151,600,0),
(102,null,35718,-24096,220416,-3072,16040,600,0),
(102,null,35717,-24059,220414,-3064,16040,600,0),
(102,null,35706,-23726,220672,-2880,49151,600,0),
(102,null,35706,-23758,220672,-2880,49151,600,0),
(102,null,35717,-23758,220704,-2880,49151,600,0),
(102,null,35706,-23968,220288,-2792,41284,600,0),
(102,null,35706,-23984,220320,-2792,41284,600,0),
(102,null,35706,-24016,220352,-2792,41284,600,0),
(102,null,35706,-24016,220288,-2792,41284,600,0),
(102,null,35723,-22777,220679,-3232,0,0,0),
(102,null,35706,-24104,219886,-3232,32716,600,0),
(102,null,35705,-23327,219753,-3232,32716,600,0),
(102,null,35705,-23327,219786,-3232,32716,600,0),
(102,null,35705,-23327,219818,-3232,32716,600,0),
(102,null,35705,-23327,219850,-3232,32716,600,0),
(102,null,35722,-22729,221658,-3200,32628,600,0),
(102,null,35723,-23748,221847,-3232,0,0,0),
(102,null,35706,-23248,222288,-2856,18436,600,0),
(102,null,35706,-23280,222288,-2856,18436,600,0),
(102,null,35706,-21347,219734,-3232,0,600,0),
(102,null,35723,-21753,217807,-3232,0,0,0),
(102,null,35706,-22256,217472,-2856,48024,600,0),
(102,null,35706,-20658,220540,-2880,0,600,0),
(102,null,35706,-21296,220240,-2792,56880,600,0),
(102,null,35717,-20686,219235,-2880,0,600,0),
(102,null,35706,-21360,220160,-2792,56880,600,0),
(102,null,35706,-20654,219235,-2880,0,600,0),
(102,null,35706,-21296,220176,-2792,56880,600,0),
(102,null,35706,-20658,220508,-2880,0,600,0),
(102,null,35706,-21328,220208,-2792,56880,600,0),
(102,null,35706,-20654,219267,-2880,0,600,0),
(102,null,35718,-20690,220508,-2880,0,600,0),
(102,null,35706,-21562,220067,-2880,16384,600,0),
(102,null,35706,-21231,220329,-3064,49444,600,0),
(102,null,35717,-20690,220540,-2880,0,600,0),
(102,null,35718,-20686,219267,-2880,0,600,0),
(102,null,35720,-21248,219088,-3056,48744,600,0),
(102,null,35706,-21266,220328,-3064,49444,600,0),
(102,null,35720,-21060,218677,-3160,0,600,0),
(102,null,35717,-21594,220037,-2880,16384,600,0),
(102,null,35720,-21376,218592,-3056,16448,600,0),
(102,null,35720,-21104,219056,-3160,17016,600,0),
(102,null,35720,-21504,219056,-3160,17016,600,0),
(102,null,35720,-21312,218832,-3160,0,600,0),
(102,null,35718,-21562,220037,-2880,16384,600,0),
(102,null,35717,-21264,220368,-3056,49444,600,0),
(102,null,35706,-21594,220067,-2880,16384,600,0),
(102,null,35704,-22400,219577,-2344,0,600,0),
(102,null,35720,-21344,218592,-3056,16448,600,0),
(102,null,35720,-21552,219008,-3160,32872,600,0),
(102,null,35718,-21232,220368,-3056,49444,600,0),
(102,null,35704,-22400,219737,-2344,0,600,0),
(102,null,35704,-22400,219705,-2344,0,600,0),
(102,null,35720,-21280,219088,-3056,48744,600,0),
(102,null,35720,-21568,218672,-3160,32872,600,0),
(102,null,35720,-21104,218631,-3160,47608,600,0),
(102,null,35720,-21522,218629,-3160,47608,600,0),
(102,null,35704,-22400,219769,-2344,0,600,0),
(102,null,35720,-21056,219024,-3160,0,600,0),
(102,null,35704,-22400,219609,-2344,0,600,0),
(102,null,35704,-22317,220384,-2864,16604,600,0),
(102,null,35704,-22400,219641,-2344,0,600,0),
(102,null,35704,-22351,220384,-2864,16964,600,0),
(102,null,35706,-22288,217472,-2856,48024,600,0),
(102,null,35706,-20992,218000,-2856,0,600,0),
(102,null,35706,-21008,217984,-2856,0,600,0),
(102,null,35706,-21347,219670,-3232,0,600,0),
(102,null,35704,-22282,220384,-2864,16964,600,0),
(102,null,35704,-22400,219545,-2344,0,600,0),
(102,null,35704,-22400,219673,-2344,0,600,0),
(102,null,35706,-21347,219638,-3232,0,600,0),
(102,null,35706,-21347,219702,-3232,0,600,0),
(102,null,35706,-21297,219688,-3232,0,600,0),
(102,null,35705,-22081,219756,-3232,0,600,0),
(102,null,35705,-22081,219789,-3232,0,600,0),
(102,null,35705,-22081,219821,-3232,0,600,0),
(102,null,35705,-22081,219853,-3232,0,600,0),
(102,null,35706,-20304,218992,-2856,0,600,0),
(102,null,35706,-20304,219024,-2856,0,600,0),
(102,null,35705,-20207,219839,-3240,0,600,0),
(102,null,35705,-20208,219872,-3240,0,600,0),
(102,null,35705,-20208,219904,-3240,0,600,0),
(102,null,35705,-20208,219936,-3232,0,600,0),
(102,null,35706,-20416,219552,-2792,16836,600,0),
(102,null,35706,-20383,219552,-2792,16836,600,0),
(102,null,35706,-20412,220204,-3072,0,600,0),
(102,null,35706,-20411,220171,-3072,0,600,0),
(102,null,35718,-20368,220208,-3056,0,600,0),
(102,null,35717,-20368,220171,-3056,0,600,0),
(102,null,35706,-20385,219598,-3064,33388,600,0),
(102,null,35717,-20351,219568,-3056,33388,600,0),
(102,null,35706,-20384,219566,-3056,33388,600,0),
(102,null,35718,-20352,219601,-3056,33388,600,0),
(102,null,35706,-20400,220240,-2792,49904,600,0),
(102,null,35706,-20432,220272,-2792,49904,600,0),
(102,null,35706,-20464,220240,-2792,49904,600,0),
(102,null,35706,-20432,220240,-2792,49904,600,0),
(102,null,35706,-20413,219506,-2792,16836,600,0),
(102,null,35706,-20448,219552,-2776,16836,600,0),
(102,null,35706,-20400,220928,-2856,6864,600,0),
(102,null,35706,-20384,220896,-2856,0,600,0),
(102,null,35706,-21712,222176,-2856,8936,600,0),
(102,null,35717,-21776,221504,-3208,6672,600,0),
(102,null,35718,-21360,221344,-3208,22236,600,0),
(102,null,35717,-21568,221360,-3208,20132,600,0),
(102,null,35718,-21632,221680,-3208,48568,600,0),
(102,null,35717,-21312,221456,-3208,37504,600,0),
(102,null,35717,-21648,221408,-3208,10732,600,0),

-- Hive Guards
(103,null,35741,16284,188689,-2552,27344,600,0),
(103,null,35741,16319,188745,-2552,27344,600,0),
(103,null,35741,16301,188717,-2552,27344,600,0),
(103,null,35751,16256,189504,-2888,0,600,0),
(103,null,35750,16128,189680,-2888,0,600,0),
(103,null,35750,15968,189296,-2888,0,600,0),
(103,null,35750,15840,189472,-2888,0,600,0),
(103,null,35751,16144,189376,-2888,0,600,0),
(103,null,35750,15871,189294,-2888,0,600,0),
(103,null,35754,14974,188725,-2920,0,0,0),
(103,null,35754,15961,188781,-2920,0,0,0),
(103,null,35743,14656,188516,-2544,12724,600,0),
(103,null,35743,14640,188548,-2544,11642,600,0),
(103,null,35743,17296,189912,-2744,62559,600,0),
(103,null,35743,17328,189912,-2744,62492,600,0),
(103,null,35751,17297,189952,-2744,49124,600,0),
(103,null,35750,17723,189775,-2920,25935,600,0),
(103,null,35743,16950,189649,-2568,16512,600,0),
(103,null,35743,16982,189649,-2560,16512,600,0),
(103,null,35751,16950,189617,-2560,16512,600,0),
(103,null,35750,16982,189617,-2560,16512,600,0),
(103,null,35743,18148,189365,-2744,56218,600,0),
(103,null,35743,18161,189337,-2744,56396,600,0),
(103,null,35751,18174,189376,-2736,36884,600,0),
(103,null,35750,17866,189626,-2920,18898,600,0),
(103,null,35743,18047,188938,-2560,4980,600,0),
(103,null,35743,18063,188906,-2560,4980,600,0),
(103,null,35751,18015,188922,-2560,4980,600,0),
(103,null,35750,18031,188890,-2560,4980,600,0),
(103,null,35743,17200,189808,-2472,0,600,0),
(103,null,35743,17264,189760,-2472,0,600,0),
(103,null,35743,17264,189856,-2456,0,600,0),
(103,null,35743,17264,189808,-2472,0,600,0),
(103,null,35743,18081,189229,-2472,20960,600,0),
(103,null,35743,18098,189269,-2472,20960,600,0),
(103,null,35743,18041,189241,-2472,20960,600,0),
(103,null,35743,18069,189255,-2472,20960,600,0),
(103,null,35743,17326,189015,-2920,10136,600,0),
(103,null,35743,17340,188949,-2920,10136,600,0),
(103,null,35743,17313,188968,-2920,10136,600,0),
(103,null,35743,17284,188986,-2920,10136,600,0),
(103,null,35743,17256,189005,-2920,10136,600,0),
(103,null,35743,16791,190139,-2544,64316,600,0),
(103,null,35743,16775,190159,-2544,64616,600,0),
(103,null,35742,16969,188550,-2920,10136,600,0),
(103,null,35742,16941,188569,-2920,10136,600,0),
(103,null,35742,16913,188588,-2920,10136,600,0),
(103,null,35742,16884,188606,-2920,10136,600,0),
(103,null,35742,17885,189759,-2920,10136,600,0),
(103,null,35742,17858,189777,-2920,10136,600,0),
(103,null,35742,17829,189796,-2920,10136,600,0),
(103,null,35742,17801,189815,-2920,10136,600,0),
(103,null,35743,18750,188629,-2544,50082,600,0),
(103,null,35743,18734,188661,-2544,50280,600,0),
(103,null,35741,16631,187514,-2208,25584,600,0),
(103,null,35741,16650,187535,-2208,25584,600,0),
(103,null,35741,16667,187560,-2208,25584,600,0),
(103,null,35741,16944,188176,-2032,10096,600,0),
(103,null,35741,16765,188292,-2032,10096,600,0),
(103,null,35741,16919,188193,-2032,10096,600,0),
(103,null,35741,16868,188228,-2032,10096,600,0),
(103,null,35741,16894,188210,-2032,10096,600,0),
(103,null,35740,16652,188147,-2000,10096,600,0),
(103,null,35740,16677,188131,-2000,10096,600,0),
(103,null,35741,16841,188244,-2032,10096,600,0),
(103,null,35741,16790,188276,-2032,10096,600,0),
(103,null,35741,16816,188259,-2032,10096,600,0),
(103,null,35740,16604,188180,-1976,10096,600,0),
(103,null,35740,16628,188163,-2000,10096,600,0),
(103,null,35740,16554,187944,-2000,42948,600,0),
(103,null,35740,16481,187993,-2000,42948,600,0),
(103,null,35740,16504,187978,-2000,42948,600,0),
(103,null,35740,16529,187962,-2000,42948,600,0),
(103,null,35739,16621,188124,-2000,10096,600,0),
(103,null,35748,17846,187459,-2888,10792,600,0),
(103,null,35748,17978,187384,-2888,10792,600,0),
(103,null,35748,17878,187441,-2888,10792,600,0),
(103,null,35748,17945,187402,-2888,10792,600,0),
(103,null,35748,17911,187422,-2888,10792,600,0),
(103,null,35747,17978,187456,-2896,10792,600,0),
(103,null,35747,18012,187437,-2896,10792,600,0),
(103,null,35747,17944,187476,-2896,10792,600,0),
(103,null,35747,17879,187513,-2896,10792,600,0),
(103,null,35747,17911,187494,-2896,10792,600,0),
(103,null,35743,16481,186451,-2568,48068,600,0),
(103,null,35743,16449,186454,-2560,48068,600,0),
(103,null,35751,16484,186481,-2560,48068,600,0),
(103,null,35750,16452,186485,-2560,48068,600,0),
(103,null,35754,16981,187276,-2920,0,0,0),
(103,null,35754,18325,188158,-2920,0,0,0),
(103,null,35743,17925,186370,-2544,49152,600,0),
(103,null,35741,15963,188069,-2400,10208,600,0),
(103,null,35741,16011,188037,-2400,10208,600,0),
(103,null,35741,15987,188053,-2400,10208,600,0),
(103,null,35753,15120,188128,-2840,0,600,0),
(103,null,35753,14928,187872,-2840,48392,600,0),
(103,null,35753,14880,187920,-2840,32792,600,0),
(103,null,35753,15264,187840,-2840,48392,600,0),
(103,null,35753,15328,187888,-2840,0,600,0),
(103,null,35753,15376,188304,-2784,0,600,0),
(103,null,35753,15328,188352,-2840,15736,600,0),
(103,null,35753,14960,188384,-2840,15736,600,0),
(103,null,35753,14928,188352,-2840,32792,600,0),
(103,null,35753,14878,188165,-2736,0,600,0),
(103,null,35753,14880,188200,-2736,0,600,0),
(103,null,35753,15378,188062,-2736,31696,600,0),
(103,null,35753,15376,188030,-2736,31696,600,0),
(103,null,35743,15230,186752,-2744,24371,600,0),
(103,null,35743,15216,186784,-2752,25155,600,0),
(103,null,35751,15192,186732,-2736,4416,600,0),
(103,null,35750,15533,186398,-2920,44073,600,0),
(103,null,35743,15322,187178,-2560,37240,600,0),
(103,null,35743,15306,187210,-2560,37240,600,0),
(103,null,35751,15354,187194,-2560,37240,600,0),
(103,null,35750,15338,187226,-2560,37240,600,0),
(103,null,35743,15200,186832,-2472,54720,600,0),
(103,null,35743,15232,186848,-2472,54720,600,0),
(103,null,35743,15264,186864,-2472,54720,600,0),
(103,null,35743,15216,186880,-2472,54720,600,0),
(103,null,35743,15968,187143,-2920,42688,600,0),
(103,null,35743,16034,187146,-2920,42688,600,0),
(103,null,35743,16004,187167,-2920,42688,600,0),
(103,null,35743,15976,187186,-2920,42688,600,0),
(103,null,35743,15948,187204,-2920,42688,600,0),
(103,null,35743,14720,187296,-2544,19892,600,0),
(103,null,35743,14704,187328,-2544,22014,600,0),
(103,null,35742,16275,187520,-2920,42688,600,0),
(103,null,35742,16245,187540,-2920,42688,600,0),
(103,null,35742,16217,187559,-2920,42688,600,0),
(103,null,35742,16188,187577,-2920,42688,600,0),
(103,null,35743,16771,185956,-2544,53248,600,0),
(103,null,35743,16748,185947,-2544,53248,600,0),
(103,null,35743,17901,186362,-2544,49152,600,0),
(103,null,35742,15497,186310,-2920,42688,600,0),
(103,null,35743,16077,186219,-2744,15624,600,0),
(103,null,35743,16109,186217,-2752,15624,600,0),
(103,null,35751,16074,186186,-2744,15624,600,0),
(103,null,35750,16106,186184,-2744,15624,600,0),
(103,null,35743,16157,186220,-2472,31852,600,0),
(103,null,35743,16160,186256,-2472,31852,600,0),
(103,null,35743,16162,186289,-2472,31852,600,0),
(103,null,35743,16194,186254,-2472,31852,600,0),
(103,null,35742,15555,186271,-2920,42688,600,0),
(103,null,35742,15525,186292,-2920,42688,600,0),
(103,null,35742,15469,186329,-2920,42688,600,0),

-- Valley Guards
(104,null,35787,126687,120722,-2400,15996,600,0),
(104,null,35775,125471,120735,-2400,16148,600,0),
(104,null,35787,125470,120704,-2400,16148,600,0),
(104,null,35775,125440,120736,-2400,16148,600,0),
(104,null,35786,125440,120704,-2400,16148,600,0),
(104,null,35775,126688,120752,-2400,15996,600,0),
(104,null,35786,126657,120723,-2400,15996,600,0),
(104,null,35775,126658,120753,-2400,15996,600,0),
(104,null,35774,126013,120640,-2584,49024,600,0),
(104,null,35774,126045,120640,-2584,49024,600,0),
(104,null,35774,126077,120640,-2584,49024,600,0),
(104,null,35774,126109,120640,-2584,49024,600,0),
(104,null,35775,127056,120784,-2184,49320,600,0),
(104,null,35775,127024,120768,-2208,49320,600,0),
(104,null,35789,124560,121648,-2504,32720,600,0),
(104,null,35789,124608,121584,-2504,49152,600,0),
(104,null,35789,124560,122064,-2504,32720,600,0),
(104,null,35789,124608,122112,-2504,16152,600,0),
(104,null,35789,124768,121856,-2504,0,600,0),
(104,null,35789,124528,121884,-2400,0,600,0),
(104,null,35789,124528,121913,-2400,0,600,0),
(104,null,35792,124111,122246,-2584,0,0,0),
(104,null,35775,124208,121344,-2208,32728,600,0),
(104,null,35775,124192,121376,-2208,32728,600,0),
(104,null,35775,123808,122064,-2208,32672,600,0),
(104,null,35775,123792,122096,-2208,32672,600,0),
(104,null,35775,125728,120832,-2136,0,600,0),
(104,null,35780,126391,121328,-2584,0,600,0),
(104,null,35780,126453,122603,-2584,0,600,0),
(104,null,35780,126763,122178,-2584,0,600,0),
(104,null,35789,124960,121584,-2504,49152,600,0),
(104,null,35789,124976,122112,-2504,16152,600,0),
(104,null,35775,126368,120832,-2136,32728,600,0),
(104,null,35789,125008,122064,-2440,0,600,0),
(104,null,35789,125008,121632,-2448,0,600,0),
(104,null,35789,125036,121783,-2400,32840,600,0),
(104,null,35789,125036,121812,-2400,32840,600,0),
(104,null,35775,125776,122258,-2312,32748,600,0),
(104,null,35787,125808,122258,-2312,32748,600,0),
(104,null,35775,125776,122288,-2312,32748,600,0),
(104,null,35786,125808,122288,-2312,32748,600,0),
(104,null,35775,125761,121915,-2224,16488,600,0),
(104,null,35787,125760,121872,-2224,16488,600,0),
(104,null,35775,125808,121915,-2224,16488,600,0),
(104,null,35786,125808,121872,-2224,16488,600,0),
(104,null,35775,125792,121088,-2224,49148,600,0),
(104,null,35775,125760,121087,-2224,49148,600,0),
(104,null,35787,125792,121120,-2224,49148,600,0),
(104,null,35786,125760,121120,-2224,49148,600,0),
(104,null,35775,126341,121097,-2224,49140,600,0),
(104,null,35787,126341,121130,-2224,49140,600,0),
(104,null,35786,126368,121130,-2224,49140,600,0),
(104,null,35775,126368,121097,-2224,49140,600,0),
(104,null,35775,125728,122064,-2136,0,600,0),
(104,null,35775,125760,122096,-2136,0,600,0),
(104,null,35775,125760,122032,-2136,0,600,0),
(104,null,35775,125760,122064,-2136,0,600,0),
(104,null,35775,126148,122073,-2584,49024,600,0),
(104,null,35775,125728,120864,-2136,0,600,0),
(104,null,35775,125694,120863,-2136,0,600,0),
(104,null,35775,125728,120896,-2136,0,600,0),
(104,null,35775,126260,122073,-2584,49024,600,0),
(104,null,35775,126416,120864,-2136,32728,600,0),
(104,null,35775,126368,120896,-2136,32728,600,0),
(104,null,35775,126372,120863,-2136,32728,600,0),
(104,null,35775,126094,122075,-2584,49024,600,0),
(104,null,35775,126177,122005,-2584,49024,600,0),
(104,null,35775,126204,122073,-2584,49024,600,0),
(104,null,35775,124944,120864,-2208,38768,600,0),
(104,null,35775,124976,120848,-2208,38768,600,0),
(104,null,35778,126736,121808,-2584,32876,600,0),
(104,null,35777,126969,121480,-2584,41660,600,0),
(104,null,35777,126969,122128,-2584,24908,600,0),
(104,null,35774,126027,122713,-2584,49024,600,0),
(104,null,35774,126062,122713,-2584,49024,600,0),
(104,null,35774,126098,122713,-2584,49024,600,0),
(104,null,35774,126131,122712,-2584,49024,600,0),
(104,null,35780,127073,122858,-2584,0,600,0),
(104,null,35780,127321,122858,-2584,0,600,0),
(104,null,35780,127507,122518,-2584,0,600,0),
(104,null,35781,127120,121840,-2424,8544,600,0),
(104,null,35781,127440,121600,-2520,39460,600,0),
(104,null,35781,127488,121920,-2488,57212,600,0),
(104,null,35781,127024,121760,-2552,33324,600,0),
(104,null,35775,127984,121488,-2208,56868,600,0),
(104,null,35775,128000,121520,-2208,56868,600,0),
(104,null,35777,127615,121481,-2584,57540,600,0),
(104,null,35777,127618,122121,-2584,8112,600,0),
(104,null,35779,127296,122256,-2456,51072,600,0),
(104,null,35779,127728,121808,-2488,33328,600,0),
(104,null,35779,127296,121360,-2520,17444,600,0),
(104,null,35776,127189,121806,-2424,56872,600,0),
(104,null,35767,128106,122635,-2588,33036,600,0),
(104,null,35758,126080,123808,-2424,48972,600,0),
(104,null,35784,124267,123480,-2552,16352,600,0),
(104,null,35784,124239,123479,-2552,16352,600,0),
(104,null,35784,124356,123479,-2552,16352,600,0),
(104,null,35784,124297,123480,-2552,16352,600,0),
(104,null,35784,124326,123480,-2552,16352,600,0),
(104,null,35783,124355,123520,-2552,16352,600,0),
(104,null,35783,124326,123520,-2552,16352,600,0),
(104,null,35783,124297,123520,-2552,16352,600,0),
(104,null,35783,124240,123520,-2552,16352,600,0),
(104,null,35783,124269,123520,-2552,16352,600,0),
(104,null,35786,124560,124624,-2552,1484,600,0),
(104,null,35786,124624,124400,-2528,13072,600,0),
(104,null,35786,124704,124416,-2552,17088,600,0),
(104,null,35787,124816,124448,-2552,19892,600,0),
(104,null,35775,123648,123424,-2208,26908,600,0),
(104,null,35775,123648,123472,-2208,26908,600,0),
(104,null,35773,126435,122923,-1872,32648,600,0),
(104,null,35773,125560,123006,-2064,16384,600,0),
(104,null,35773,125592,123006,-2064,16384,600,0),
(104,null,35773,125624,123006,-2064,16384,600,0),
(104,null,35773,126435,122979,-1872,32648,600,0),
(104,null,35773,126435,122951,-1872,32648,600,0),
(104,null,35773,125504,123770,-2216,33088,600,0),
(104,null,35773,125505,123698,-2216,33088,600,0),
(104,null,35773,125504,123735,-2216,33088,600,0),
(104,null,35773,126298,123644,-1688,16248,600,0),
(104,null,35773,126330,123644,-1688,16248,600,0),
(104,null,35773,126266,123644,-1688,16248,600,0),
(104,null,35773,126234,123644,-1688,16248,600,0),
(104,null,35773,126202,123644,-1688,16248,600,0),
(104,null,35773,126170,123644,-1688,16248,600,0),
(104,null,35773,126138,123644,-1688,16248,600,0),
(104,null,35773,126106,123644,-1688,16248,600,0),
(104,null,35772,126064,123234,-1656,48972,600,0),
(104,null,35772,126094,123233,-1656,48972,600,0),
(104,null,35772,126034,123234,-1656,48972,600,0),
(104,null,35772,126124,123233,-1656,48972,600,0),
(104,null,35772,126094,123452,-1656,16248,600,0),
(104,null,35772,126125,123452,-1656,16248,600,0),
(104,null,35772,126065,123452,-1656,16248,600,0),
(104,null,35772,126035,123453,-1656,16248,600,0),
(104,null,35771,126079,123550,-1688,16248,600,0),
(104,null,35787,124944,124864,-2552,47800,600,0),
(104,null,35786,125040,124544,-2552,25844,600,0),
(104,null,35775,126842,124595,-2400,49068,600,0),
(104,null,35775,126874,124595,-2400,49068,600,0),
(104,null,35787,126842,124627,-2400,49068,600,0),
(104,null,35786,126874,124627,-2400,49068,600,0),
(104,null,35775,126960,124576,-2136,32376,600,0),
(104,null,35775,126928,124544,-2136,32376,600,0),
(104,null,35775,126928,124608,-2136,32376,600,0),
(104,null,35775,126928,124576,-2136,32376,600,0),
(104,null,35792,126826,122978,-2584,0,0,0),
(104,null,35792,125120,123360,-2584,0,0,0),
(104,null,35775,126056,124654,-2584,16384,600,0),
(104,null,35775,126126,124608,-2584,16384,600,0),
(104,null,35775,126032,124608,-2584,16384,600,0),
(104,null,35775,125984,124608,-2584,16384,600,0),
(104,null,35775,126080,124608,-2584,16384,600,0),
(104,null,35774,126025,123961,-2584,16384,600,0),
(104,null,35774,126129,123962,-2584,16384,600,0),
(104,null,35774,126095,123962,-2584,16384,600,0),
(104,null,35774,126060,123962,-2584,16384,600,0),
(104,null,35775,127184,124241,-2224,16348,600,0),
(104,null,35775,127217,124241,-2224,16348,600,0),
(104,null,35787,127184,124208,-2224,16348,600,0),
(104,null,35786,127216,124208,-2224,16348,600,0),
(104,null,35775,128464,123424,-2208,0,600,0),
(104,null,35792,127575,124886,-2584,0,0,0),
(104,null,35775,128464,123456,-2208,0,600,0),
(104,null,35775,127984,124736,-2208,0,600,0),
(104,null,35775,128000,124704,-2208,0,600,0),
(104,null,35791,128056,123440,-2536,33000,600,0),
(104,null,35775,124800,125280,-2208,16292,600,0),
(104,null,35775,124832,125296,-2208,16292,600,0),
(104,null,35775,126656,125472,-2400,49124,600,0),
(104,null,35775,126688,125472,-2400,49124,600,0),
(104,null,35787,126656,125504,-2400,49124,600,0),
(104,null,35786,126688,125504,-2400,49124,600,0),
(104,null,35775,126352,125088,-2224,16080,600,0),
(104,null,35775,126320,125088,-2224,16080,600,0),
(104,null,35787,126320,125120,-2224,16080,600,0),
(104,null,35786,126352,125120,-2224,16080,600,0),
(104,null,35775,125422,125482,-2400,49188,600,0),
(104,null,35775,125454,125482,-2400,49188,600,0),
(104,null,35787,125422,125514,-2400,49188,600,0),
(104,null,35786,125454,125514,-2400,49188,600,0),
(104,null,35787,125792,125088,-2224,15912,600,0),
(104,null,35775,125792,125120,-2224,15912,600,0),
(104,null,35786,125760,125088,-2224,15912,600,0),
(104,null,35775,125759,125120,-2224,15912,600,0),
(104,null,35775,126415,125360,-2136,32828,600,0),
(104,null,35775,126384,125392,-2136,32828,600,0),
(104,null,35775,126384,125328,-2136,32828,600,0),
(104,null,35775,126384,125360,-2136,32828,600,0),
(104,null,35775,125708,125359,-2136,0,600,0),
(104,null,35775,125744,125392,-2136,0,600,0),
(104,null,35775,125744,125328,-2136,0,600,0),
(104,null,35775,125744,125360,-2136,0,600,0),
(104,null,35774,126112,125584,-2584,16384,600,0),
(104,null,35774,126080,125584,-2584,16384,600,0),
(104,null,35774,126048,125584,-2584,16384,600,0),
(104,null,35774,126016,125584,-2584,16384,600,0),
(104,null,35775,127024,125472,-2192,4964,600,0),
(104,null,35775,127056,125440,-2192,4964,600,0);

INSERT INTO `fort_siege_guards` VALUES
-- Ivory Guards
(105,null,35810,72672,3684,-2520,24056,600,0),
(105,null,35810,72719,3723,-2520,24056,600,0),
(105,null,35810,72695,3703,-2520,24056,600,0),
(105,null,35822,72384,2912,-2960,0,600,0),
(105,null,35822,72704,2976,-2960,61536,600,0),
(105,null,35822,72560,2624,-2960,61536,600,0),
(105,null,35822,72512,2608,-2960,45756,600,0),
(105,null,35822,72096,2784,-2960,45756,600,0),
(105,null,35822,72080,2832,-2960,28780,600,0),
(105,null,35822,72272,3184,-2960,11896,600,0),
(105,null,35822,72224,3168,-2960,28780,600,0),
(105,null,35822,72688,3024,-2896,11896,600,0),
(105,null,35822,72265,2679,-2856,12340,600,0),
(105,null,35822,72236,2691,-2856,12340,600,0),
(105,null,35822,72517,3121,-2856,44924,600,0),
(105,null,35822,72548,3109,-2856,44924,600,0),
(105,null,35812,71856,2560,-2664,45816,600,0),
(105,null,35812,73568,3440,-3040,56456,600,0),
(105,null,35812,73648,3408,-3040,56456,600,0),
(105,null,35812,73700,2538,-2856,18232,600,0),
(105,null,35819,73705,2507,-2856,18232,600,0),
(105,null,35812,73317,2827,-2680,50816,600,0),
(105,null,35812,73350,2833,-2680,50816,600,0),
(105,null,35820,73312,2855,-2680,50816,600,0),
(105,null,35819,73345,2861,-2680,50816,600,0),
(105,null,35812,73602,2615,-2592,2300,600,0),
(105,null,35812,73633,2656,-2592,2300,600,0),
(105,null,35812,73646,2594,-2592,2300,600,0),
(105,null,35812,73640,2625,-2592,2300,600,0),
(105,null,35823,71777,3073,-3040,0,0,0),
(105,null,35823,72186,3762,-3040,0,0,0),
(105,null,35812,73680,3536,-3040,56456,600,0),
(105,null,35812,73616,3488,-3040,56456,600,0),
(105,null,35812,73520,3392,-3040,56456,600,0),
(105,null,35812,73008,2272,-2664,50792,600,0),
(105,null,35812,73056,2272,-2640,50792,600,0),
(105,null,35812,71824,2576,-2664,45816,600,0),
(105,null,35811,73221,3766,-3040,56456,600,0),
(105,null,35811,73287,3821,-3040,56456,600,0),
(105,null,35811,73243,3784,-3040,56456,600,0),
(105,null,35811,73265,3803,-3040,56456,600,0),
(105,null,35810,73357,4207,-2328,39880,600,0),
(105,null,35810,73395,4161,-2328,39880,600,0),
(105,null,35810,73376,4184,-2328,39880,600,0),
(105,null,35810,72172,4177,-2672,40028,600,0),
(105,null,35810,72132,4223,-2672,40028,600,0),
(105,null,35810,72152,4200,-2672,40028,600,0),
(105,null,35810,72788,4607,-2152,23660,600,0),
(105,null,35810,72695,4528,-2152,23660,600,0),
(105,null,35810,72718,4548,-2152,23660,600,0),
(105,null,35810,72857,4664,-2152,23660,600,0),
(105,null,35810,72835,4645,-2152,23664,600,0),
(105,null,35810,72811,4626,-2152,23664,600,0),
(105,null,35809,72917,4185,-2120,56456,600,0),
(105,null,35810,72742,4568,-2152,23660,600,0),
(105,null,35809,72961,4222,-2120,56456,600,0),
(105,null,35809,72938,4203,-2120,56456,600,0),
(105,null,35810,72765,4588,-2152,23660,600,0),
(105,null,35809,72802,4369,-2120,23656,600,0),
(105,null,35809,72896,4167,-2120,56456,600,0),
(105,null,35809,72822,4386,-2120,23656,600,0),
(105,null,35809,72759,4334,-2120,23660,600,0),
(105,null,35808,72814,4327,-2120,23656,600,0),
(105,null,35809,72781,4351,-2120,23656,600,0),
(105,null,35812,72459,5917,-2680,18360,600,0),
(105,null,35812,72489,5923,-2680,18360,600,0),
(105,null,35820,72465,5892,-2680,18360,600,0),
(105,null,35819,72494,5898,-2680,18360,600,0),
(105,null,35812,72190,6117,-2592,34332,600,0),
(105,null,35812,72155,6143,-2592,34332,600,0),
(105,null,35812,72165,6078,-2592,34332,600,0),
(105,null,35812,72160,6112,-2592,34332,600,0),
(105,null,35823,73616,6096,-3040,0,0,0),
(105,null,35812,72165,5223,-3040,23840,600,0),
(105,null,35812,72238,5193,-3040,23840,600,0),
(105,null,35812,72279,5228,-3040,23840,600,0),
(105,null,35812,72192,5152,-3040,23840,600,0),
(105,null,35812,72149,5113,-3040,23840,600,0),
(105,null,35811,72495,4784,-3040,23840,600,0),
(105,null,35811,72474,4766,-3040,23840,600,0),
(105,null,35811,72453,4748,-3040,23840,600,0),
(105,null,35811,72431,4730,-3040,23840,600,0),
(105,null,35812,74554,3250,-2864,28652,600,0),
(105,null,35812,74543,3223,-2864,28652,600,0),
(105,null,35820,74584,3239,-2864,28652,600,0),
(105,null,35819,74572,3210,-2864,28652,600,0),
(105,null,35812,74363,3716,-2688,61980,600,0),
(105,null,35812,74353,3688,-2688,61980,600,0),
(105,null,35820,74338,3725,-2688,61980,600,0),
(105,null,35819,74328,3697,-2688,61980,600,0),
(105,null,35812,73728,2544,-2856,18232,600,0),
(105,null,35820,73734,2511,-2856,18232,600,0),
(105,null,35812,74488,3381,-2592,44728,600,0),
(105,null,35812,74448,3362,-2592,44728,600,0),
(105,null,35812,74501,3339,-2592,44728,600,0),
(105,null,35812,74474,3350,-2592,44728,600,0),
(105,null,35812,74944,3856,-2648,0,600,0),
(105,null,35812,74928,3824,-2664,0,600,0),
(105,null,35811,74183,2741,-3040,56456,600,0),
(105,null,35811,74205,2759,-3040,56456,600,0),
(105,null,35811,74226,2778,-3040,56456,600,0),
(105,null,35811,74248,2796,-3040,56456,600,0),
(105,null,35817,73810,5358,-3008,24564,600,0),
(105,null,35817,73895,5443,-3016,24564,600,0),
(105,null,35817,73874,5422,-3016,24564,600,0),
(105,null,35817,73853,5402,-3016,24564,600,0),
(105,null,35817,73830,5380,-3016,24564,600,0),
(105,null,35816,73841,5455,-3016,24564,600,0),
(105,null,35816,73777,5392,-3016,24564,600,0),
(105,null,35816,73863,5475,-3016,24564,600,0),
(105,null,35816,73820,5434,-3016,24564,600,0),
(105,null,35816,73798,5414,-3016,24564,600,0),
(105,null,35823,73799,4465,-3040,0,0,0),
(105,null,35812,74864,5072,-2664,0,600,0),
(105,null,35812,74880,5040,-2664,0,600,0),
(105,null,35819,71200,3920,-3008,8836,600,0),
(105,null,35820,71472,3872,-3008,23492,600,0),
(105,null,35819,71440,3984,-3008,25044,600,0),
(105,null,35819,71136,4320,-3008,56236,600,0),
(105,null,35820,71488,4288,-3008,40056,600,0),
(105,null,35819,71488,4112,-2992,32492,600,0),
(105,null,35812,71230,5576,-2864,62020,600,0),
(105,null,35812,71220,5544,-2864,62020,600,0),
(105,null,35820,71208,5584,-2864,62020,600,0),
(105,null,35819,71198,5553,-2864,62020,600,0),
(105,null,35812,71469,5126,-2688,12506,600,0),
(105,null,35812,71458,5097,-2688,12512,600,0),
(105,null,35820,71488,5086,-2688,12512,600,0),
(105,null,35819,71498,5116,-2688,12502,600,0),
(105,null,35812,71319,5413,-2592,12944,600,0),
(105,null,35812,71356,5430,-2592,12944,600,0),
(105,null,35812,71299,5449,-2592,12944,600,0),
(105,null,35812,71328,5440,-2592,12944,600,0),
(105,null,35812,70912,5056,-2664,28632,600,0),
(105,null,35812,70928,5088,-2664,28632,600,0),
(105,null,35811,71613,6009,-3040,23840,600,0),
(105,null,35811,71591,5990,-3040,23840,600,0),
(105,null,35811,71570,5972,-3040,23840,600,0),
(105,null,35811,71549,5954,-3040,23840,600,0),
(105,null,35812,72048,6244,-2856,50940,600,0),
(105,null,35812,72079,6249,-2856,50940,600,0),
(105,null,35820,72044,6266,-2856,50940,600,0),
(105,null,35819,72074,6272,-2856,50940,600,0),
(105,null,35812,72912,6496,-2664,15392,600,0),
(105,null,35812,72944,6500,-2664,15392,600,0),

-- Narsell Guards
(106,null,35843,155976,53878,-2800,3592,600,0),
(106,null,35843,156778,54594,-3072,30476,600,0),
(106,null,35843,156784,54624,-3072,30476,600,0),
(106,null,35851,156810,54619,-3072,30476,600,0),
(106,null,35850,156803,54588,-3072,30476,600,0),
(106,null,35843,156475,55045,-2896,63272,600,0),
(106,null,35843,156466,55012,-2896,63272,600,0),
(106,null,35851,156449,55049,-2896,63272,600,0),
(106,null,35850,156442,55017,-2896,63272,600,0),
(106,null,35843,156113,53748,-3072,20484,600,0),
(106,null,35843,156083,53737,-3072,20484,600,0),
(106,null,35851,156122,53722,-3072,20484,600,0),
(106,null,35850,156093,53710,-3072,20484,600,0),
(106,null,35843,156666,54743,-2808,46792,600,0),
(106,null,35843,156627,54720,-2808,46792,600,0),
(106,null,35843,156693,54705,-2808,46792,600,0),
(106,null,35843,156660,54712,-2808,46792,600,0),
(106,null,35843,155960,53837,-2800,3592,600,0),
(106,null,35843,156000,53816,-2800,3592,600,0),
(106,null,35843,155987,53846,-2784,3592,600,0),
(106,null,35843,156096,54449,-3256,58368,600,0),
(106,null,35843,156094,54561,-3256,58368,600,0),
(106,null,35843,156059,54523,-3256,58368,600,0),
(106,null,35843,156022,54483,-3256,58368,600,0),
(106,null,35843,155988,54441,-3256,58368,600,0),
(106,null,35843,157024,55264,-2872,0,600,0),
(106,null,35842,156486,54058,-3256,58368,600,0),
(106,null,35842,156506,54081,-3256,58368,600,0),
(106,null,35842,156526,54105,-3256,58368,600,0),
(106,null,35842,156545,54129,-3256,58368,600,0),
(106,null,35841,154830,54689,-2736,25576,600,0),
(106,null,35841,154849,54712,-2736,25576,600,0),
(106,null,35841,154868,54735,-2736,25576,600,0),
(106,null,35841,154202,55118,-2880,41980,600,0),
(106,null,35841,154227,55098,-2880,41980,600,0),
(106,null,35841,154252,55078,-2880,41980,600,0),
(106,null,35840,154971,55224,-2328,58368,600,0),
(106,null,35840,154989,55247,-2328,58368,600,0),
(106,null,35840,154953,55200,-2328,58368,600,0),
(106,null,35840,155008,55268,-2312,58368,600,0),
(106,null,35853,154704,53872,-3168,0,600,0),
(106,null,35853,154416,53728,-3168,30512,600,0),
(106,null,35853,154492,54081,-3168,30512,600,0),
(106,null,35853,154992,53984,-3168,63400,600,0),
(106,null,35853,154928,53632,-3168,63400,600,0),
(106,null,35853,154528,54112,-3168,14128,600,0),
(106,null,35853,154976,54032,-3168,14128,600,0),
(106,null,35853,154880,53600,-3168,46952,600,0),
(106,null,35853,154448,53680,-3168,46952,600,0),
(106,null,35853,154594,53627,-3064,14128,600,0),
(106,null,35853,154627,53621,-3064,14128,600,0),
(106,null,35853,154821,54102,-3064,46952,600,0),
(106,null,35853,154788,54109,-3064,46952,600,0),
(106,null,35851,153600,54784,-3216,34208,600,0),
(106,null,35843,155641,53981,-2888,52976,600,0),
(106,null,35843,155613,53971,-2888,52976,600,0),
(106,null,35851,155632,54006,-2896,52976,600,0),
(106,null,35850,155603,53994,-2888,52976,600,0),
(106,null,35854,154220,53714,-3256,0,0,0),
(106,null,35854,154282,54682,-3256,0,0,0),
(106,null,35843,155472,53376,-2872,52320,600,0),
(106,null,35843,155440,53360,-2872,52320,600,0),
(106,null,35843,154256,53424,-2872,47120,600,0),
(106,null,35843,154224,53440,-2872,47120,600,0),
(106,null,35842,155345,54872,-3256,58368,600,0),
(106,null,35842,155365,54897,-3248,58368,600,0),
(106,null,35842,155386,54922,-3248,58368,600,0),
(106,null,35842,155406,54947,-3248,58368,600,0),
(106,null,35851,153705,57100,-3072,52912,600,0),
(106,null,35841,155401,55344,-2536,41552,600,0),
(106,null,35841,155449,55303,-2536,41552,600,0),
(106,null,35841,155425,55323,-2536,41552,600,0),
(106,null,35841,154729,55564,-2360,25416,600,0),
(106,null,35841,154833,55691,-2360,25416,600,0),
(106,null,35841,154812,55665,-2360,25416,600,0),
(106,null,35841,154792,55640,-2360,25416,600,0),
(106,null,35841,154685,55513,-2360,25416,600,0),
(106,null,35841,154708,55538,-2360,25416,600,0),
(106,null,35841,154771,55615,-2360,25416,600,0),
(106,null,35841,154749,55589,-2360,25416,600,0),
(106,null,35840,154808,55358,-2328,25416,600,0),
(106,null,35840,154828,55380,-2328,25416,600,0),
(106,null,35840,154847,55401,-2328,25416,600,0),
(106,null,35840,154790,55337,-2328,25416,600,0),
(106,null,35839,154848,55344,-2328,25416,600,0),
(106,null,35848,155639,56458,-3224,26156,600,0),
(106,null,35847,155601,56484,-3224,26156,600,0),
(106,null,35847,155643,56547,-3224,26156,600,0),
(106,null,35847,155622,56516,-3224,26156,600,0),
(106,null,35843,153714,57077,-3072,52912,600,0),
(106,null,35843,153743,57089,-3072,52912,600,0),
(106,null,35850,153733,57111,-3072,52912,600,0),
(106,null,35843,154178,56827,-2888,20188,600,0),
(106,null,35843,154208,56840,-2888,20188,600,0),
(106,null,35851,154218,56814,-2896,20188,600,0),
(106,null,35850,154189,56803,-2896,20188,600,0),
(106,null,35843,153881,56993,-2800,36816,600,0),
(106,null,35843,153867,56948,-2800,36816,600,0),
(106,null,35843,153840,57013,-2800,36816,600,0),
(106,null,35843,153853,56981,-2800,36816,600,0),
(106,null,35854,155351,57202,-3256,0,0,0),
(106,null,35843,153968,56176,-3256,25416,600,0),
(106,null,35843,154027,56167,-3256,25416,600,0),
(106,null,35843,154055,56205,-3256,25416,600,0),
(106,null,35843,153997,56126,-3256,25416,600,0),
(106,null,35843,153965,56087,-3256,25416,600,0),
(106,null,35842,154451,55730,-3248,25416,600,0),
(106,null,35842,154430,55706,-3248,25416,600,0),
(106,null,35842,154410,55681,-3256,25416,600,0),
(106,null,35842,154389,55658,-3248,25416,600,0),
(106,null,35848,155662,56488,-3224,26156,600,0),
(106,null,35848,155727,56578,-3224,26156,600,0),
(106,null,35848,155683,56518,-3224,26156,600,0),
(106,null,35848,155706,56549,-3224,26156,600,0),
(106,null,35847,155689,56602,-3224,26156,600,0),
(106,null,35847,155666,56576,-3224,26156,600,0),
(106,null,35854,155690,55650,-3256,0,0,0),
(106,null,35843,156720,56464,-2872,0,600,0),
(106,null,35843,156736,56432,-2856,0,600,0),
(106,null,35843,157024,55296,-2856,0,600,0),
(106,null,35851,153216,55024,-3216,55104,600,0),
(106,null,35850,153536,55024,-3216,39772,600,0),
(106,null,35850,153591,54867,-3216,34712,600,0),
(106,null,35850,153332,54643,-3216,14292,600,0),
(106,null,35850,153568,54672,-3216,29608,600,0),
(106,null,35843,153160,56118,-2808,14756,600,0),
(106,null,35843,153032,56228,-3072,64072,600,0),
(106,null,35843,153036,56260,-3072,64072,600,0),
(106,null,35851,153016,56263,-3072,64072,600,0),
(106,null,35850,153011,56233,-3072,64072,600,0),
(106,null,35843,153374,55829,-2896,30996,600,0),
(106,null,35843,153378,55860,-2896,30996,600,0),
(106,null,35851,153399,55825,-2896,30996,600,0),
(106,null,35850,153402,55857,-2896,30996,600,0),
(106,null,35843,153193,56142,-2808,14756,600,0),
(106,null,35843,153131,56151,-2808,14756,600,0),
(106,null,35843,153164,56146,-2808,14756,600,0),
(106,null,35843,152832,55696,-2872,32888,600,0),
(106,null,35843,152848,55728,-2872,32888,600,0),
(106,null,35842,153320,56734,-3256,25416,600,0),
(106,null,35842,153340,56757,-3256,25416,600,0),
(106,null,35842,153300,56710,-3256,25416,600,0),
(106,null,35842,153279,56686,-3257,25416,600,0),
(106,null,35843,154512,57504,-2872,20056,600,0),
(106,null,35843,154544,57512,-2872,20056,600,0),

-- Bayou Guards
(107,null,35886,190198,41484,-3048,16600,600,0),
(107,null,35875,190168,41512,-3048,16600,600,0),
(107,null,35886,188436,41034,-3376,0,600,0),
(107,null,35886,188795,41211,-3376,44352,600,0),
(107,null,35887,188832,40960,-3376,24344,600,0),
(107,null,35886,189660,41484,-3048,16572,600,0),
(107,null,35875,189272,41890,-3232,48972,600,0),
(107,null,35887,189630,41483,-3056,16572,600,0),
(107,null,35875,190200,41512,-3048,16600,600,0),
(107,null,35887,190167,41484,-3048,16600,600,0),
(107,null,35875,189302,41889,-3232,48972,600,0),
(107,null,35887,189274,41918,-3232,48972,600,0),
(107,null,35875,189630,41511,-3048,16572,600,0),
(107,null,35886,189304,41918,-3232,48972,600,0),
(107,null,35875,189661,41512,-3048,16572,600,0),
(107,null,35875,189549,41759,-2960,0,600,0),
(107,null,35875,189584,41728,-2960,0,600,0),
(107,null,35875,189584,41792,-2960,0,600,0),
(107,null,35875,189584,41760,-2960,0,600,0),
(107,null,35875,190276,41760,-2960,32908,600,0),
(107,null,35875,190240,41790,-2960,32908,600,0),
(107,null,35875,190240,41728,-2960,32908,600,0),
(107,null,35875,190240,41760,-2960,32908,600,0),
(107,null,35875,188656,41680,-3032,21816,600,0),
(107,null,35875,188688,41696,-3032,21816,600,0),
(107,null,35874,189960,41975,-3408,16316,600,0),
(107,null,35874,189928,41975,-3408,16316,600,0),
(107,null,35874,189896,41976,-3408,16316,600,0),
(107,null,35874,189864,41975,-3408,16316,600,0),
(107,null,35868,189776,41872,-3408,49148,600,0),
(107,null,35875,190693,41001,-3232,49420,600,0),
(107,null,35875,190723,41002,-3232,49420,600,0),
(107,null,35886,190723,41026,-3232,49420,600,0),
(107,null,35887,190692,41026,-3232,49420,600,0),
(107,null,35875,190524,41885,-3224,49024,600,0),
(107,null,35875,190556,41885,-3224,49024,600,0),
(107,null,35887,190524,41917,-3224,49024,600,0),
(107,null,35886,190556,41917,-3224,49024,600,0),
(107,null,35875,190816,40976,-2960,28000,600,0),
(107,null,35875,190800,41024,-2960,28000,600,0),
(107,null,35875,190784,40992,-2960,28000,600,0),
(107,null,35875,191856,41136,-3016,0,600,0),
(107,null,35875,191864,41104,-3032,0,600,0),
(107,null,35875,190864,41856,-3032,10808,600,0),
(107,null,35875,190896,41840,-3032,10808,600,0),
(107,null,35884,188243,39796,-3376,16376,600,0),
(107,null,35884,188073,39796,-3376,16376,600,0),
(107,null,35884,188115,39796,-3376,16376,600,0),
(107,null,35884,188160,39797,-3376,16376,600,0),
(107,null,35884,188201,39796,-3376,16376,600,0),
(107,null,35883,188243,39861,-3376,16376,600,0),
(107,null,35883,188072,39861,-3376,16376,600,0),
(107,null,35883,188114,39861,-3376,16376,600,0),
(107,null,35883,188200,39861,-3376,16376,600,0),
(107,null,35883,188160,39861,-3376,16376,600,0),
(107,null,35875,187504,39840,-3032,33328,600,0),
(107,null,35875,187504,39872,-3032,33328,600,0),
(107,null,35873,189411,39403,-2888,16384,600,0),
(107,null,35873,189443,39403,-2888,16384,600,0),
(107,null,35873,189475,39403,-2888,16384,600,0),
(107,null,35873,190288,39376,-2696,32824,600,0),
(107,null,35873,190288,39312,-2696,32824,600,0),
(107,null,35873,190288,39344,-2696,32824,600,0),
(107,null,35873,189344,40160,-3040,32704,600,0),
(107,null,35873,189344,40096,-3040,32704,600,0),
(107,null,35873,190053,40032,-2512,16316,600,0),
(107,null,35873,189344,40128,-3040,32704,600,0),
(107,null,35873,190087,40032,-2512,16316,600,0),
(107,null,35873,190122,40032,-2512,16316,600,0),
(107,null,35873,190019,40032,-2512,16316,600,0),
(107,null,35873,190156,40032,-2512,16316,600,0),
(107,null,35873,189984,40032,-2512,16316,600,0),
(107,null,35873,190192,40032,-2472,16316,600,0),
(107,null,35873,189952,40032,-2512,16316,600,0),
(107,null,35872,189917,39637,-2480,49148,600,0),
(107,null,35872,189974,39635,-2480,49148,600,0),
(107,null,35872,189946,39637,-2480,49148,600,0),
(107,null,35872,189889,39637,-2480,49148,600,0),
(107,null,35872,189944,39843,-2480,16316,600,0),
(107,null,35872,189916,39843,-2480,16316,600,0),
(107,null,35872,189972,39843,-2480,16316,600,0),
(107,null,35872,189888,39843,-2480,16316,600,0),
(107,null,35871,189930,39808,-2480,16316,600,0),
(107,null,35887,188768,40896,-3352,22872,600,0),
(107,null,35886,188672,40848,-3376,20656,600,0),
(107,null,35886,188542,40815,-3376,16340,600,0),
(107,null,35874,189918,40364,-3408,16316,600,0),
(107,null,35874,189885,40365,-3408,16316,600,0),
(107,null,35892,189082,39869,-3408,0,0,0),
(107,null,35875,189940,40946,-3408,16316,600,0),
(107,null,35875,190020,40895,-3408,16316,600,0),
(107,null,35875,189969,40895,-3408,16316,600,0),
(107,null,35875,189908,40897,-3408,16316,600,0),
(107,null,35875,189852,40896,-3408,16316,600,0),
(107,null,35874,189946,39117,-3408,49148,600,0),
(107,null,35874,189978,39117,-3408,49148,600,0),
(107,null,35874,189882,39117,-3408,49148,600,0),
(107,null,35874,189914,39116,-3408,49148,600,0),
(107,null,35874,189982,40364,-3408,16316,600,0),
(107,null,35874,189950,40364,-3408,16316,600,0),
(107,null,35886,191088,40596,-3056,15964,600,0),
(107,null,35880,191917,39044,-3408,0,600,0),
(107,null,35875,191057,40623,-3056,15964,600,0),
(107,null,35887,191056,40597,-3056,15964,600,0),
(107,null,35875,191088,40622,-3056,15964,600,0),
(107,null,35875,190784,40944,-2960,28000,600,0),
(107,null,35892,190711,39356,-3408,0,0,0),
(107,null,35875,192320,39856,-3032,0,600,0),
(107,null,35875,192320,39824,-3032,0,600,0),
(107,null,35891,191846,39844,-3368,33020,600,0),
(107,null,35875,189594,38482,-2960,60184,600,0),
(107,null,35889,188624,38240,-3328,0,600,0),
(107,null,35889,188816,37984,-3328,49428,600,0),
(107,null,35889,188480,37984,-3328,49428,600,0),
(107,null,35889,188464,38496,-3328,16324,600,0),
(107,null,35889,188800,38496,-3328,16324,600,0),
(107,null,35889,188848,38016,-3328,0,600,0),
(107,null,35889,188848,38464,-3328,0,600,0),
(107,null,35889,188416,38016,-3328,32788,600,0),
(107,null,35889,188416,38464,-3328,32788,600,0),
(107,null,35889,188880,38176,-3224,32788,600,0),
(107,null,35889,188880,38208,-3224,32788,600,0),
(107,null,35875,189273,38674,-3232,48832,600,0),
(107,null,35875,189302,38674,-3232,48832,600,0),
(107,null,35887,189303,38699,-3232,48832,600,0),
(107,null,35886,189272,38700,-3232,48832,600,0),
(107,null,35875,189632,38268,-3056,16556,600,0),
(107,null,35875,189631,38300,-3048,16556,600,0),
(107,null,35887,189663,38268,-3048,16556,600,0),
(107,null,35875,190197,37500,-3048,48928,600,0),
(107,null,35886,189663,38300,-3048,16556,600,0),
(107,null,35875,190163,37502,-3056,48928,600,0),
(107,null,35887,190199,37533,-3056,48928,600,0),
(107,null,35886,190164,37533,-3048,48928,600,0),
(107,null,35875,189304,37127,-3224,16356,600,0),
(107,null,35887,189303,37101,-3224,16356,600,0),
(107,null,35875,189273,37127,-3224,16356,600,0),
(107,null,35886,189272,37101,-3224,16356,600,0),
(107,null,35875,189662,37505,-3048,49428,600,0),
(107,null,35875,189632,37504,-3048,49428,600,0),
(107,null,35887,189661,37532,-3048,49428,600,0),
(107,null,35886,189630,37532,-3048,49428,600,0),
(107,null,35875,189572,38437,-2960,60184,600,0),
(107,null,35875,189607,38452,-2960,60184,600,0),
(107,null,35875,189600,38416,-2960,60184,600,0),
(107,null,35875,190229,37296,-2960,32824,600,0),
(107,null,35875,190265,37261,-2960,32824,600,0),
(107,null,35875,190231,37230,-2960,32824,600,0),
(107,null,35875,190231,37262,-2960,32824,600,0),
(107,null,35875,189558,37260,-2960,0,600,0),
(107,null,35875,189592,37226,-2960,0,600,0),
(107,null,35875,189592,37296,-2960,0,600,0),
(107,null,35875,189592,37260,-2960,0,600,0),
(107,null,35875,189959,37691,-3408,49148,600,0),
(107,null,35875,190032,37744,-3408,49148,600,0),
(107,null,35875,189984,37744,-3408,49148,600,0),
(107,null,35875,189936,37744,-3408,49148,600,0),
(107,null,35875,189888,37744,-3408,49148,600,0),
(107,null,35875,188816,37232,-3032,44232,600,0),
(107,null,35875,188784,37248,-3032,44232,600,0),
(107,null,35874,189862,37046,-3408,49148,600,0),
(107,null,35874,189894,37046,-3408,49148,600,0),
(107,null,35874,189926,37046,-3408,49148,600,0),
(107,null,35874,189957,37046,-3408,49148,600,0),
(107,null,35869,189776,36960,-3408,49148,600,0),
(107,null,35869,190048,37152,-3408,16316,600,0),
(107,null,35880,191502,38810,-3408,0,600,0),
(107,null,35880,191668,38576,-3408,0,600,0),
(107,null,35880,190672,38732,-3408,0,600,0),
(107,null,35880,190672,38654,-3408,0,600,0),
(107,null,35880,191336,38888,-3408,0,600,0),
(107,null,35881,190976,38240,-3256,9736,600,0),
(107,null,35881,191376,38288,-3320,50656,600,0),
(107,null,35881,191248,37968,-3352,35624,600,0),
(107,null,35881,190864,38176,-3384,32732,600,0),
(107,null,35875,190550,37128,-3232,16680,600,0),
(107,null,35875,190518,37128,-3232,16680,600,0),
(107,null,35886,190518,37103,-3232,16680,600,0),
(107,null,35887,190548,37104,-3232,16680,600,0),
(107,null,35892,192019,38645,-3408,0,0,0),
(107,null,35875,190896,37168,-3032,0,600,0),
(107,null,35875,190864,37152,-3032,0,600,0),
(107,null,35878,190570,38200,-3408,32704,600,0),
(107,null,35875,191856,37904,-3032,0,600,0),
(107,null,35875,191840,37872,-3032,0,600,0),
(107,null,35877,190825,37882,-3408,41856,600,0),
(107,null,35877,191465,37881,-3408,57244,600,0),
(107,null,35877,191465,38521,-3408,9028,600,0),
(107,null,35877,190825,38526,-3408,24516,600,0),
(107,null,35879,191152,38640,-3288,49304,600,0),
(107,null,35879,191600,38208,-3320,33536,600,0),
(107,null,35879,191152,37760,-3352,17036,600,0),
(107,null,35876,191056,38179,-3256,57256,600,0),
(107,null,35889,188369,38276,-3224,0,600,0),
(107,null,35889,188369,38308,-3224,0,600,0),
(107,null,35892,187714,38906,-3408,0,0,0),
(107,null,35875,187664,38448,-3032,38724,600,0),
(107,null,35875,187648,38480,-3032,38724,600,0),
(107,null,35875,188064,37744,-3032,38336,600,0),
(107,null,35875,188048,37776,-3032,38336,600,0),

-- White Sands Guards
(108,null,35912,116450,204522,-3152,0,600,0),
(108,null,35912,116450,204490,-3152,0,600,0),
(108,null,35920,116418,204522,-3152,0,600,0),
(108,null,35919,116418,204490,-3152,0,600,0),
(108,null,35912,116577,204609,-2888,48708,600,0),
(108,null,35912,116544,204577,-2888,48708,600,0),
(108,null,35912,116607,204575,-2888,48708,600,0),
(108,null,35912,116575,204576,-2888,48708,600,0),
(108,null,35912,116368,204304,-2952,38104,600,0),
(108,null,35912,116368,204336,-2952,38104,600,0),
(108,null,35911,116570,203971,-3336,38352,600,0),
(108,null,35911,116585,203942,-3336,38352,600,0),
(108,null,35911,116616,203885,-3336,38352,600,0),
(108,null,35911,116600,203913,-3336,38352,600,0),
(108,null,35910,118251,204437,-2616,21528,600,0),
(108,null,35910,118228,204425,-2616,21528,600,0),
(108,null,35910,118203,204411,-2616,21528,600,0),
(108,null,35912,116965,203481,-3152,11132,600,0),
(108,null,35912,116939,203495,-3152,11132,600,0),
(108,null,35919,116928,203474,-3152,11132,600,0),
(108,null,35920,116953,203461,-3152,11132,600,0),
(108,null,35920,117471,203645,-2976,43400,600,0),
(108,null,35912,117458,203625,-2976,43400,600,0),
(108,null,35912,117434,203639,-2976,43400,600,0),
(108,null,35919,117447,203660,-2976,43400,600,0),
(108,null,35912,117109,203546,-2888,26964,600,0),
(108,null,35912,117085,203561,-2888,26964,600,0),
(108,null,35912,117069,203534,-2888,26964,600,0),
(108,null,35912,117101,203587,-2888,26964,600,0),
(108,null,35912,117279,204244,-3336,38352,600,0),
(108,null,35923,118694,203076,-3336,0,0,0),
(108,null,35923,118378,204000,-3336,0,0,0),
(108,null,35912,117266,204332,-3336,38352,600,0),
(108,null,35912,117296,204288,-3336,38352,600,0),
(108,null,35912,117324,204240,-3336,38352,600,0),
(108,null,35912,117351,204198,-3336,38352,600,0),
(108,null,35912,116800,203504,-2952,37708,600,0),
(108,null,35912,116784,203536,-2952,37708,600,0),
(108,null,35912,117584,202976,-2952,43160,600,0),
(108,null,35912,117552,202992,-2952,43160,600,0),
(108,null,35911,117840,204673,-3328,38352,600,0),
(108,null,35911,117855,204643,-3336,38352,600,0),
(108,null,35911,117872,204612,-3328,38352,600,0),
(108,null,35911,117888,204583,-3328,38352,600,0),
(108,null,35922,117216,205648,-3256,0,600,0),
(108,null,35922,117301,205401,-3152,21480,600,0),
(108,null,35922,116912,205728,-3256,21480,600,0),
(108,null,35922,117072,205376,-3256,38832,600,0),
(108,null,35909,118483,205009,-2408,5396,600,0),
(108,null,35912,116826,204835,-2976,32332,600,0),
(108,null,35909,118497,204983,-2408,5396,600,0),
(108,null,35909,118341,204830,-2408,38352,600,0),
(108,null,35922,117271,205388,-3152,21480,600,0),
(108,null,35919,116851,204864,-2960,32332,600,0),
(108,null,35909,118314,204880,-2408,38352,600,0),
(108,null,35922,117120,205344,-3256,54132,600,0),
(108,null,35910,117881,205192,-2808,5416,600,0),
(108,null,35910,117897,205164,-2808,5416,600,0),
(108,null,35909,118327,204855,-2408,38352,600,0),
(108,null,35910,118759,204927,-2440,5396,600,0),
(108,null,35922,117520,205600,-3256,5400,600,0),
(108,null,35922,117520,205552,-3256,54132,600,0),
(108,null,35922,116912,205664,-3256,38832,600,0),
(108,null,35910,118512,205632,-2960,21528,600,0),
(108,null,35910,118742,204955,-2440,5396,600,0),
(108,null,35910,118695,205038,-2440,5396,600,0),
(108,null,35910,117865,205220,-2808,5416,600,0),
(108,null,35909,118525,204932,-2408,5396,600,0),
(108,null,35910,118448,205600,-2960,21528,600,0),
(108,null,35909,118511,204958,-2408,5396,600,0),
(108,null,35910,118710,205011,-2440,5396,600,0),
(108,null,35909,118299,204905,-2408,38352,600,0),
(108,null,35908,118472,204952,-2408,5396,600,0),
(108,null,35910,118774,204899,-2440,5396,600,0),
(108,null,35910,118726,204983,-2440,5396,600,0),
(108,null,35910,118480,205616,-2960,21528,600,0),
(108,null,35912,116352,205264,-2952,33428,600,0),
(108,null,35912,116352,205296,-2952,33428,600,0),
(108,null,35922,117296,205936,-3256,21480,600,0),
(108,null,35922,117344,205920,-3256,5400,600,0),
(108,null,35922,117147,205901,-3152,54132,600,0),
(108,null,35922,117116,205884,-3152,54132,600,0),
(108,null,35920,118292,206421,-3304,5576,600,0),
(108,null,35919,118715,206601,-3304,37536,600,0),
(108,null,35920,118496,206384,-3304,13508,600,0),
(108,null,35919,118614,206327,-3304,13584,600,0),
(108,null,35919,118348,206360,-3304,7708,600,0),
(108,null,35919,118375,206630,-3304,57676,600,0),
(108,null,35912,116827,204864,-2976,32332,600,0),
(108,null,35920,116850,204834,-2976,32332,600,0),
(108,null,35923,117077,206107,-3336,0,0,0),
(108,null,35923,118004,205749,-3336,0,0,0),
(108,null,35912,117104,206480,-2952,20696,600,0),
(108,null,35912,117136,206496,-2952,20696,600,0),
(108,null,35912,117984,206944,-2952,21772,600,0),
(108,null,35912,118256,206976,-2936,14472,600,0),
(108,null,35912,118016,206960,-2952,21772,600,0),
(108,null,35912,118224,206976,-2952,14472,600,0),
(108,null,35912,119472,205504,-3336,5396,600,0),
(108,null,35912,119763,206220,-2888,60016,600,0),
(108,null,35912,119779,206246,-2888,60016,600,0),
(108,null,35912,119440,205552,-3336,5396,600,0),
(108,null,35912,119504,205456,-3336,5396,600,0),
(108,null,35920,119392,206171,-2976,11844,600,0),
(108,null,35912,119747,206264,-2888,60016,600,0),
(108,null,35912,119794,206273,-2888,60016,600,0),
(108,null,35912,119531,205508,-3336,5396,600,0),
(108,null,35919,119419,206158,-2976,11844,600,0),
(108,null,35912,119430,206179,-2976,11844,600,0),
(108,null,35912,119403,206191,-2976,11844,600,0),
(108,null,35920,119912,206345,-3152,43536,600,0),
(108,null,35912,119900,206325,-3152,43536,600,0),
(108,null,35910,118805,204842,-2440,5396,600,0),
(108,null,35910,118789,204870,-2440,5396,600,0),
(108,null,35917,118948,203642,-3304,38352,600,0),
(108,null,35912,119024,202944,-2952,51912,600,0),
(108,null,35912,120496,204560,-2952,0,600,0),
(108,null,35916,118967,203538,-3304,38352,600,0),
(108,null,35912,120064,206288,-2952,0,600,0),
(108,null,35912,119527,205417,-3336,5396,600,0),
(108,null,35916,118897,203650,-3304,38352,600,0),
(108,null,35912,120128,203744,-2952,0,600,0),
(108,null,35916,118914,203622,-3304,38352,600,0),
(108,null,35916,118931,203595,-3304,38352,600,0),
(108,null,35917,118965,203615,-3304,38352,600,0),
(108,null,35917,118930,203669,-3304,38352,600,0),
(108,null,35917,119000,203557,-3304,38352,600,0),
(108,null,35917,118982,203585,-3304,38352,600,0),
(108,null,35916,118948,203565,-3304,38352,600,0),
(108,null,35912,118992,202944,-2952,51912,600,0),
(108,null,35912,120096,203712,-2952,0,600,0),
(108,null,35912,120496,204528,-2952,0,600,0),
(108,null,35912,119924,206311,-3152,43536,600,0),
(108,null,35919,119936,206330,-3152,43536,600,0),
(108,null,35919,120446,205346,-3152,32412,600,0),
(108,null,35912,120425,205377,-3152,32412,600,0),
(108,null,35912,120030,205042,-2976,0,600,0),
(108,null,35920,120447,205375,-3152,32412,600,0),
(108,null,35912,120424,205348,-3152,32412,600,0),
(108,null,35920,120000,205008,-2976,0,600,0),
(108,null,35919,120000,205042,-2976,0,600,0),
(108,null,35912,120029,205007,-2976,0,600,0),
(108,null,35912,120286,205253,-2888,15872,600,0),
(108,null,35912,120319,205293,-2888,15872,600,0),
(108,null,35912,120256,205296,-2888,15872,600,0),
(108,null,35912,120288,205294,-2888,15872,600,0),
(108,null,35912,120048,206320,-2952,0,600,0),
(108,null,35912,120480,205520,-2952,0,600,0),
(108,null,35912,120496,205488,-2952,0,600,0),
(108,null,35911,118984,205165,-3328,5396,600,0),
(108,null,35911,118968,205196,-3328,5396,600,0),
(108,null,35911,118952,205226,-3328,5396,600,0),
(108,null,35911,118935,205258,-3328,5396,600,0),
(108,null,35911,120292,205846,-3336,5396,600,0),
(108,null,35911,120276,205874,-3336,5396,600,0),
(108,null,35911,120261,205901,-3336,5396,600,0),
(108,null,35911,120245,205931,-3336,5396,600,0);

INSERT INTO `fort_siege_guards` VALUES
-- Borderland Guards
(109,null,35956,157328,-70800,-2832,16472,600,0),
(109,null,35955,157463,-70870,-2832,25440,600,0),
(109,null,35955,157492,-70713,-2832,30712,600,0),
(109,null,35956,157492,-70607,-2832,32980,600,0),
(109,null,35955,157533,-70508,-2832,36940,600,0),
(109,null,35955,157337,-70477,-2832,50800,600,0),
(109,null,35944,156999,-69660,-2688,59524,600,0),
(109,null,35956,156975,-69646,-2688,59524,600,0),
(109,null,35944,157015,-69635,-2688,59524,600,0),
(109,null,35944,156816,-70288,-2488,31496,600,0),
(109,null,35944,156816,-70256,-2488,31496,600,0),
(109,null,35944,157507,-69567,-2504,25844,600,0),
(109,null,35955,156992,-69621,-2688,59524,600,0),
(109,null,35944,157525,-69544,-2512,25844,600,0),
(109,null,35956,157529,-69582,-2504,25844,600,0),
(109,null,35944,157691,-68621,-2680,59472,600,0),
(109,null,35955,157546,-69558,-2504,25844,600,0),
(109,null,35956,157668,-68608,-2680,59472,600,0),
(109,null,35955,157685,-68583,-2680,59472,600,0),
(109,null,35944,157639,-68938,-2416,43096,600,0),
(109,null,35944,157277,-69490,-2416,11300,600,0),
(109,null,35944,157658,-68909,-2416,43096,600,0),
(109,null,35944,157267,-69448,-2416,11300,600,0),
(109,null,35944,157292,-69461,-2416,11300,600,0),
(109,null,35944,157663,-68953,-2416,43096,600,0),
(109,null,35944,157614,-68922,-2416,43096,600,0),
(109,null,35944,157317,-69475,-2416,11300,600,0),
(109,null,35943,157304,-69040,-2864,27244,600,0),
(109,null,35943,157286,-69067,-2864,27244,600,0),
(109,null,35943,157269,-69095,-2864,27244,600,0),
(109,null,35943,157252,-69122,-2864,27244,600,0),
(109,null,35942,158995,-70013,-1968,27244,600,0),
(109,null,35942,158498,-70578,-2496,43156,600,0),
(109,null,35942,159140,-70926,-2344,26960,600,0),
(109,null,35942,159156,-70900,-2344,26960,600,0),
(109,null,35942,159173,-70875,-2344,26960,600,0),
(109,null,35942,159647,-70215,-2104,43156,600,0),
(109,null,35942,159699,-70249,-2144,43156,600,0),
(109,null,35942,159674,-70231,-2144,43156,600,0),
(109,null,35942,158473,-70562,-2496,43156,600,0),
(109,null,35942,158524,-70595,-2496,43156,600,0),
(109,null,35942,158976,-70041,-1968,27244,600,0),
(109,null,35942,159013,-69985,-1968,27244,600,0),
(109,null,35942,158958,-70070,-1968,27244,600,0),
(109,null,35942,159030,-69956,-1968,27244,600,0),
(109,null,35942,158940,-70099,-1968,27244,600,0),
(109,null,35942,159048,-69930,-1968,27244,600,0),
(109,null,35942,158923,-70128,-1968,27244,600,0),
(109,null,35941,159217,-70399,-1936,59020,600,0),
(109,null,35941,159232,-70377,-1936,59020,600,0),
(109,null,35941,159247,-70355,-1936,59020,600,0),
(109,null,35941,159262,-70334,-1936,59020,600,0),
(109,null,35941,159057,-70263,-1936,27244,600,0),
(109,null,35941,159071,-70240,-1936,27244,600,0),
(109,null,35941,159084,-70219,-1936,27244,600,0),
(109,null,35940,159088,-70272,-1936,27244,600,0),
(109,null,35941,159044,-70283,-1936,27244,600,0),
(109,null,35953,158057,-71678,-2832,27244,600,0),
(109,null,35953,158076,-71648,-2832,27244,600,0),
(109,null,35952,158018,-71654,-2832,27244,600,0),
(109,null,35952,158035,-71626,-2832,27244,600,0),
(109,null,35944,159691,-71423,-2688,59460,600,0),
(109,null,35944,159669,-71408,-2688,59460,600,0),
(109,null,35956,159676,-71448,-2688,59460,600,0),
(109,null,35955,159653,-71433,-2688,59460,600,0),
(109,null,35961,158676,-71010,-2864,0,0,0),
(109,null,35944,158247,-69664,-2864,27244,600,0),
(109,null,35944,158181,-69690,-2864,27244,600,0),
(109,null,35943,159674,-70639,-2864,59020,600,0),
(109,null,35944,158226,-69696,-2864,27244,600,0),
(109,null,35944,158208,-69728,-2864,27244,600,0),
(109,null,35944,158192,-69760,-2864,27244,600,0),
(109,null,35943,159637,-70692,-2864,59020,600,0),
(109,null,35943,159656,-70666,-2864,59020,600,0),
(109,null,35943,159693,-70612,-2864,59020,600,0),
(109,null,35943,158661,-69918,-2864,27244,600,0),
(109,null,35943,158643,-69946,-2864,27244,600,0),
(109,null,35943,158625,-69974,-2864,27244,600,0),
(109,null,35943,158607,-70003,-2864,27244,600,0),
(109,null,35944,158538,-68946,-2688,60068,600,0),
(109,null,35944,158524,-68970,-2688,60068,600,0),
(109,null,35955,158503,-68958,-2688,60068,600,0),
(109,null,35956,158517,-68934,-2688,60068,600,0),
(109,null,35944,159031,-68885,-2512,26024,600,0),
(109,null,35944,159050,-68857,-2512,26024,600,0),
(109,null,35956,159053,-68898,-2512,26024,600,0),
(109,null,35955,159072,-68873,-2512,26024,600,0),
(109,null,35944,157707,-68595,-2680,59472,600,0),
(109,null,35944,157821,-69104,-2504,26492,600,0),
(109,null,35944,157843,-69118,-2504,26492,600,0),
(109,null,35956,157804,-69128,-2504,26492,600,0),
(109,null,35955,157826,-69142,-2504,26493,600,0),
(109,null,35944,158603,-68865,-2416,35548,600,0),
(109,null,35944,158613,-68901,-2416,35548,600,0),
(109,null,35944,158566,-68862,-2416,35548,600,0),
(109,null,35944,158576,-68896,-2416,35548,600,0),
(109,null,35944,159056,-67952,-2488,16860,600,0),
(109,null,35944,157904,-68352,-2488,19356,600,0),
(109,null,35944,159088,-67952,-2472,16860,600,0),
(109,null,35944,157936,-68336,-2488,19356,600,0),
(109,null,35953,158007,-71763,-2832,27244,600,0),
(109,null,35953,158022,-71733,-2832,27244,600,0),
(109,null,35953,158041,-71706,-2832,27244,600,0),
(109,null,35952,157968,-71739,-2832,27244,600,0),
(109,null,35952,157984,-71712,-2832,27244,600,0),
(109,null,35952,158000,-71683,-2832,27244,600,0),
(109,null,35958,159664,-72208,-2784,0,600,0),
(109,null,35958,159552,-71936,-2784,26704,600,0),
(109,null,35958,159360,-72224,-2784,26704,600,0),
(109,null,35958,159376,-72288,-2784,43156,600,0),
(109,null,35958,159728,-72528,-2784,43156,600,0),
(109,null,35958,159616,-71920,-2784,10768,600,0),
(109,null,35958,159501,-72419,-2680,10768,600,0),
(109,null,35958,159471,-72400,-2672,10768,600,0),
(109,null,35961,158667,-72530,-2864,0,0,0),
(109,null,35944,157696,-72256,-2488,44404,600,0),
(109,null,35944,157728,-72272,-2488,44404,600,0),
(109,null,35944,158960,-72912,-2488,48900,600,0),
(109,null,35944,158912,-72912,-2488,48900,600,0),
(109,null,35944,160837,-71800,-2504,59636,600,0),
(109,null,35958,159792,-72512,-2784,59860,600,0),
(109,null,35958,159984,-72224,-2784,59860,600,0),
(109,null,35958,159984,-72160,-2720,10768,600,0),
(109,null,35958,159840,-72026,-2680,43156,600,0),
(109,null,35958,159869,-72046,-2680,43156,600,0),
(109,null,35955,160815,-71786,-2504,59636,600,0),
(109,null,35944,160977,-72282,-2680,26660,600,0),
(109,null,35944,160962,-72304,-2680,26660,600,0),
(109,null,35956,160831,-71761,-2504,59636,600,0),
(109,null,35955,160981,-72318,-2680,26660,600,0),
(109,null,35956,160997,-72295,-2680,26660,600,0),
(109,null,35944,160854,-71775,-2504,59636,600,0),
(109,null,35944,160996,-72002,-2416,9824,600,0),
(109,null,35944,161049,-71986,-2416,9824,600,0),
(109,null,35944,160995,-71948,-2416,9824,600,0),
(109,null,35944,161022,-71966,-2416,9824,600,0),
(109,null,35944,159776,-72976,-2488,47640,600,0),
(109,null,35944,159744,-72976,-2488,47640,600,0),
(109,null,35944,160608,-72624,-2488,55604,600,0),
(109,null,35944,160576,-72640,-2488,55604,600,0),
(109,null,35943,161370,-71836,-2864,59020,600,0),
(109,null,35943,161352,-71863,-2864,59020,600,0),
(109,null,35943,161390,-71809,-2864,59020,600,0),
(109,null,35943,161409,-71781,-2864,59020,600,0),
(109,null,35949,160527,-70042,-2864,0,600,0),
(109,null,35949,161003,-70843,-2864,0,600,0),
(109,null,35949,160663,-70754,-2864,0,600,0),
(109,null,35949,160527,-70042,-2864,0,600,0),
(109,null,35950,160960,-70272,-2712,18576,600,0),
(109,null,35950,161168,-69904,-2776,58276,600,0),
(109,null,35950,160944,-70400,-2840,44664,600,0),
(109,null,35950,161344,-70240,-2808,44536,600,0),
(109,null,35947,160753,-70682,-2864,42660,600,0),
(109,null,35946,160657,-70243,-2864,34940,600,0),
(109,null,35946,161010,-69712,-2864,19060,600,0),
(109,null,35946,161548,-70064,-2864,1580,600,0),
(109,null,35946,161200,-70592,-2864,51012,600,0),
(109,null,35948,160736,-69904,-2744,59956,600,0),
(109,null,35948,161367,-69758,-2776,44008,600,0),
(109,null,35948,161504,-70400,-2808,26872,600,0),
(109,null,35945,161066,-70241,-2712,1744,600,0),
(109,null,35944,160185,-71361,-2504,27084,600,0),
(109,null,35944,160200,-71338,-2512,27084,600,0),
(109,null,35956,160207,-71373,-2504,27084,600,0),
(109,null,35955,160222,-71348,-2504,27084,600,0),
(109,null,35956,161685,-71255,-2688,26400,600,0),
(109,null,35944,161663,-71242,-2688,26400,600,0),
(109,null,35944,161647,-71266,-2688,26400,600,0),
(109,null,35955,161668,-71279,-2688,26400,600,0),
(109,null,35944,161156,-71330,-2504,58224,600,0),
(109,null,35956,161135,-71313,-2512,58224,600,0),
(109,null,35944,161136,-71355,-2504,58224,600,0),
(109,null,35955,161115,-71338,-2504,58224,600,0),
(109,null,35944,161377,-71431,-2416,43456,600,0),
(109,null,35944,160048,-71328,-2416,0,600,0),
(109,null,35944,160048,-71296,-2416,0,600,0),
(109,null,35961,160000,-69863,-2864,0,0,0),
(109,null,35944,160271,-70936,-2864,59020,600,0),
(109,null,35944,160224,-70928,-2864,59020,600,0),
(109,null,35944,160193,-70967,-2864,59020,600,0),
(109,null,35944,160254,-70890,-2864,59020,600,0),
(109,null,35944,160280,-70855,-2864,59020,600,0),
(109,null,35944,161760,-69760,-2488,4788,600,0),
(109,null,35944,161760,-69728,-2472,3788,600,0),
(109,null,35944,161395,-71401,-2416,43456,600,0),
(109,null,35944,160080,-71344,-2416,0,600,0),
(109,null,35944,161347,-71413,-2416,43456,600,0),
(109,null,35944,160080,-71312,-2416,0,600,0),
(109,null,35944,161406,-71448,-2416,43456,600,0),
(109,null,35949,161411,-69508,-2864,0,600,0),
(109,null,35949,160595,-69597,-2864,0,600,0),
(109,null,35960,160146,-68656,-2824,43272,600,0),
(109,null,35961,161272,-69361,-2864,0,0,0),
(109,null,35944,160384,-68256,-2488,10548,600,0),
(109,null,35944,160416,-68272,-2464,10548,600,0),
(109,null,35944,161824,-70944,-2488,0,600,0),
(109,null,35944,161824,-70976,-2472,0,600,0),

-- Swamp Guards
(110,null,35998,68146,-60737,-2744,44530,600,0),
(110,null,35980,69437,-60801,-2416,28628,600,0),
(110,null,35980,69409,-60868,-2416,28628,600,0),
(110,null,35980,69423,-60834,-2416,28628,600,0),
(110,null,35994,68784,-59536,-2752,43868,600,0),
(110,null,35993,68910,-59805,-2752,24424,600,0),
(110,null,35993,68828,-59866,-2752,22032,600,0),
(110,null,35994,68720,-59920,-2752,19692,600,0),
(110,null,35993,68637,-59870,-2752,14780,600,0),
(110,null,35993,68544,-59888,-2752,10500,600,0),
(110,null,35999,68990,-61040,-2784,0,0,0),
(110,null,35982,68000,-59616,-2408,22760,600,0),
(110,null,35982,68016,-59600,-2408,22760,600,0),
(110,null,35982,67696,-60096,-2408,28804,600,0),
(110,null,35982,67712,-60064,-2408,28804,600,0),
(110,null,35980,70097,-61213,-1888,12388,600,0),
(110,null,35980,70065,-61201,-1888,12388,600,0),
(110,null,35980,70129,-61224,-1888,12388,600,0),
(110,null,35980,70033,-61189,-1888,12388,600,0),
(110,null,35980,70161,-61236,-1888,12388,600,0),
(110,null,35980,70003,-61177,-1888,12388,600,0),
(110,null,35980,70190,-61247,-1888,12388,600,0),
(110,null,35980,69972,-61165,-1888,12388,600,0),
(110,null,35979,69890,-61333,-1856,12388,600,0),
(110,null,35979,69861,-61321,-1856,12388,600,0),
(110,null,35979,69917,-61345,-1856,12388,600,0),
(110,null,35978,69860,-61364,-1856,12388,600,0),
(110,null,35979,69833,-61310,-1856,12388,600,0),
(110,null,35996,71248,-60512,-2704,0,600,0),
(110,null,35996,71323,-60817,-2704,45160,600,0),
(110,null,35996,70990,-60678,-2704,45160,600,0),
(110,null,35996,71520,-60336,-2704,12076,600,0),
(110,null,35996,71186,-60196,-2704,12076,600,0),
(110,null,35996,71385,-60786,-2704,61032,600,0),
(110,null,35996,71546,-60401,-2704,61032,600,0),
(110,null,35996,71120,-60228,-2704,28628,600,0),
(110,null,35996,70962,-60610,-2704,28628,600,0),
(110,null,35996,71481,-60638,-2600,28628,600,0),
(110,null,35996,71468,-60669,-2600,28628,600,0),
(110,null,35996,71027,-60378,-2600,61032,600,0),
(110,null,35996,71040,-60347,-2600,61032,600,0),
(110,null,35982,69817,-59833,-2608,61256,600,0),
(110,null,35982,69828,-59808,-2608,61256,600,0),
(110,null,35994,69794,-59823,-2608,61256,600,0),
(110,null,35993,69805,-59798,-2608,61256,600,0),
(110,null,35982,70042,-60280,-2432,28620,600,0),
(110,null,35982,70031,-60306,-2432,28620,600,0),
(110,null,35994,70064,-60289,-2432,28620,600,0),
(110,null,35993,70053,-60314,-2432,28620,600,0),
(110,null,35982,71095,-59761,-2432,12588,600,0),
(110,null,35982,71123,-59771,-2432,12588,600,0),
(110,null,35994,71086,-59783,-2432,12588,600,0),
(110,null,35993,71113,-59794,-2432,12588,600,0),
(110,null,35982,70012,-60004,-2336,4192,600,0),
(110,null,35982,69999,-59974,-2336,4192,600,0),
(110,null,35982,70044,-60009,-2336,4192,600,0),
(110,null,35982,70029,-59979,-2336,4192,600,0),
(110,null,35982,70976,-59448,-2336,28356,600,0),
(110,null,35982,70957,-59404,-2336,28356,600,0),
(110,null,35982,70931,-59462,-2336,28356,600,0),
(110,null,35982,70944,-59433,-2336,28356,600,0),
(110,null,35982,70609,-60237,-2784,12388,600,0),
(110,null,35982,70576,-60224,-2784,12388,600,0),
(110,null,35982,70541,-60210,-2784,12388,600,0),
(110,null,35982,70506,-60195,-2784,12388,600,0),
(110,null,35982,70572,-60185,-2784,12388,600,0),
(110,null,35982,71488,-59504,-2408,0,600,0),
(110,null,35982,71504,-59536,-2408,0,600,0),
(110,null,35981,70126,-60877,-2784,12388,600,0),
(110,null,35981,70091,-60862,-2784,12388,600,0),
(110,null,35981,70055,-60847,-2784,12388,600,0),
(110,null,35981,70019,-60832,-2784,12388,600,0),
(110,null,35982,70403,-59058,-2608,45208,600,0),
(110,null,35982,70427,-59068,-2608,45208,600,0),
(110,null,35994,70412,-59037,-2608,45208,600,0),
(110,null,35993,70435,-59046,-2608,45208,600,0),
(110,null,35982,69931,-59280,-2432,12220,600,0),
(110,null,35982,69957,-59291,-2432,12220,600,0),
(110,null,35994,69923,-59302,-2432,12220,600,0),
(110,null,35993,69948,-59313,-2432,12220,600,0),
(110,null,35982,70916,-59275,-2608,45188,600,0),
(110,null,35982,70942,-59285,-2608,45188,600,0),
(110,null,35994,70926,-59252,-2608,45188,600,0),
(110,null,35993,70952,-59263,-2608,45188,600,0),
(110,null,35982,70269,-59154,-2336,61308,600,0),
(110,null,35982,70290,-59192,-2336,61308,600,0),
(110,null,35982,70312,-59142,-2336,61308,600,0),
(110,null,35982,70301,-59167,-2336,61308,600,0),
(110,null,35982,69680,-58864,-2408,19180,600,0),
(110,null,35982,69712,-58864,-2408,19180,600,0),
(110,null,35981,70722,-59105,-2784,12388,600,0),
(110,null,35981,70752,-59119,-2784,12388,600,0),
(110,null,35981,70691,-59093,-2784,12388,600,0),
(110,null,35981,70659,-59080,-2784,12388,600,0),
(110,null,35982,72160,-60528,-2408,0,600,0),
(110,null,35982,72160,-60560,-2408,0,600,0),
(110,null,35981,69614,-62009,-2784,45292,600,0),
(110,null,35980,69252,-61552,-2264,12552,600,0),
(110,null,35984,68592,-62160,-2784,4136,600,0),
(110,null,35984,68013,-61916,-2784,21000,600,0),
(110,null,35985,68722,-62554,-2784,61508,600,0),
(110,null,35984,68356,-62741,-2784,53344,600,0),
(110,null,35984,67767,-62500,-2784,37948,600,0),
(110,null,35986,68352,-61936,-2720,46212,600,0),
(110,null,35986,68016,-62736,-2656,13892,600,0),
(110,null,35986,67776,-62160,-2688,62716,600,0),
(110,null,35983,68289,-62354,-2624,20544,600,0),
(110,null,35980,69222,-61541,-2264,12552,600,0),
(110,null,35980,69282,-61564,-2264,12552,600,0),
(110,null,35987,68667,-62063,-2784,0,600,0),
(110,null,35987,68744,-62671,-2784,0,600,0),
(110,null,35987,68898,-62367,-2784,0,600,0),
(110,null,35987,68898,-62367,-2784,0,600,0),
(110,null,35987,68436,-62823,-2784,0,600,0),
(110,null,35987,68975,-62519,-2784,0,600,0),
(110,null,35988,68336,-62400,-2624,38144,600,0),
(110,null,35988,67936,-62320,-2688,12636,600,0),
(110,null,35988,68192,-62080,-2720,61064,600,0),
(110,null,35988,68464,-62432,-2752,60752,600,0),
(110,null,35982,69575,-63461,-2432,44768,600,0),
(110,null,35982,69600,-63472,-2432,44768,600,0),
(110,null,35994,69584,-63440,-2432,44768,600,0),
(110,null,35993,69610,-63451,-2432,44768,600,0),
(110,null,35982,68590,-63468,-2608,12512,600,0),
(110,null,35982,68616,-63477,-2608,12512,600,0),
(110,null,35982,68411,-62981,-2432,45576,600,0),
(110,null,35982,68438,-62990,-2432,45576,600,0),
(110,null,35994,68447,-62968,-2432,45576,600,0),
(110,null,35993,68420,-62959,-2432,45576,600,0),
(110,null,35982,68563,-63308,-2336,61368,600,0),
(110,null,35982,68579,-63346,-2336,61368,600,0),
(110,null,35982,68590,-63320,-2336,61368,600,0),
(110,null,35982,68602,-63293,-2336,61368,600,0),
(110,null,35982,69231,-62973,-2784,45292,600,0),
(110,null,35982,69151,-62943,-2784,45292,600,0),
(110,null,35982,69191,-62958,-2784,45292,600,0),
(110,null,35982,69110,-62926,-2784,45292,600,0),
(110,null,35982,69154,-62996,-2784,45292,600,0),
(110,null,35982,68048,-63248,-2408,40016,600,0),
(110,null,35982,68016,-63216,-2408,40016,600,0),
(110,null,35981,69543,-61980,-2784,45292,600,0),
(110,null,35981,69578,-61995,-2784,45292,600,0),
(110,null,35980,70006,-61926,-2072,28628,600,0),
(110,null,35980,70017,-61899,-2072,28628,600,0),
(110,null,35980,69995,-61953,-2072,28628,600,0),
(110,null,35979,69779,-61521,-1856,45292,600,0),
(110,null,35979,69807,-61534,-1856,45292,600,0),
(110,null,35979,69750,-61509,-1856,45292,600,0),
(110,null,35979,69835,-61545,-1856,45292,600,0),
(110,null,35991,71345,-62287,-2752,45292,600,0),
(110,null,35991,71315,-62274,-2752,45292,600,0),
(110,null,35991,71254,-62249,-2752,45292,600,0),
(110,null,35991,71285,-62261,-2752,45292,600,0),
(110,null,35991,71222,-62236,-2752,45292,600,0),
(110,null,35990,71331,-62323,-2752,45292,600,0),
(110,null,35990,71300,-62311,-2752,45292,600,0),
(110,null,35990,71269,-62299,-2752,45292,600,0),
(110,null,35990,71239,-62287,-2752,45292,600,0),
(110,null,35990,71207,-62274,-2752,45292,600,0),
(110,null,35994,70191,-62696,-2608,45224,600,0),
(110,null,35982,70183,-62719,-2608,45224,600,0),
(110,null,35982,70208,-62728,-2608,45224,600,0),
(110,null,35982,69737,-62945,-2432,12244,600,0),
(110,null,35993,70216,-62706,-2608,45224,600,0),
(110,null,35982,69711,-62934,-2432,12244,600,0),
(110,null,35994,69728,-62966,-2432,12244,600,0),
(110,null,35993,69702,-62955,-2432,12244,600,0),
(110,null,35982,69847,-62847,-2336,34624,600,0),
(110,null,35982,69840,-62816,-2336,34624,600,0),
(110,null,35982,69813,-62836,-2336,34624,600,0),
(110,null,35982,69819,-62866,-2336,34624,600,0),
(110,null,35999,70603,-61725,-2784,0,0,0),
(110,null,35981,69649,-62023,-2784,45292,600,0),
(110,null,35999,71984,-61487,-2784,0,0,0),
(110,null,35982,71760,-62816,-2408,0,600,0),
(110,null,35982,71744,-62848,-2408,0,600,0),
(110,null,35982,72160,-61904,-2408,0,600,0),
(110,null,35982,72144,-61936,-2408,0,600,0),
(110,null,35982,67536,-62592,-2408,41036,600,0),
(110,null,35982,67520,-62560,-2408,41036,600,0),
(110,null,35982,67312,-61008,-2408,28824,600,0),
(110,null,35999,67459,-61298,-2784,0,0,0),
(110,null,35982,67328,-60976,-2408,28824,600,0),
(110,null,35982,69133,-63688,-2608,12516,600,0),
(110,null,35982,69108,-63679,-2608,12516,600,0),
(110,null,35994,69124,-63709,-2608,12516,600,0),
(110,null,35993,69099,-63699,-2608,12516,600,0),
(110,null,35994,68582,-63490,-2608,12512,600,0),
(110,null,35993,68606,-63500,-2608,12512,600,0),
(110,null,35982,69271,-63600,-2336,28844,600,0),
(110,null,35982,69254,-63561,-2336,28844,600,0),
(110,null,35982,69232,-63616,-2336,28844,600,0),
(110,null,35982,69243,-63588,-2336,28844,600,0),
(110,null,35981,68779,-63634,-2784,45292,600,0),
(110,null,35981,68810,-63646,-2784,45292,600,0),
(110,null,35981,68842,-63660,-2784,45292,600,0),
(110,null,35981,68872,-63673,-2784,45292,600,0),
(110,null,35982,69696,-63920,-2408,50516,600,0),
(110,null,35982,69664,-63920,-2408,50516,600,0),
(110,null,35982,70512,-63808,-2408,50588,600,0),
(110,null,35982,70480,-63808,-2408,50588,600,0),

-- Archaic Guards
(111,null,36018,111457,-141672,-2960,62612,600,0),
(111,null,36018,111447,-141703,-2960,62612,600,0),
(111,null,36018,111438,-141736,-2960,62612,600,0),
(111,null,36018,111428,-141768,-2960,62612,600,0),
(111,null,36019,111369,-141092,-2512,51072,600,0),
(111,null,36019,110720,-142800,-2576,57632,600,0),
(111,null,36019,110752,-142784,-2576,57632,600,0),
(111,null,36019,110720,-139456,-2576,8564,600,0),
(111,null,36019,110752,-139472,-2552,8564,600,0),
(111,null,36019,111456,-140416,-2552,4172,600,0),
(111,null,36019,111456,-140448,-2576,4172,600,0),
(111,null,36019,110834,-141561,-2952,62612,600,0),
(111,null,36019,110768,-141637,-2952,62612,600,0),
(111,null,36019,110785,-141576,-2952,62612,600,0),
(111,null,36019,110800,-141520,-2952,62612,600,0),
(111,null,36019,110818,-141462,-2952,62612,600,0),
(111,null,36030,111206,-140667,-2952,0,0,0),
(111,null,36019,111339,-141097,-2512,51072,600,0),
(111,null,36019,111040,-142160,-2504,8252,600,0),
(111,null,36019,111019,-142139,-2504,8252,600,0),
(111,null,36019,111060,-142180,-2504,8252,600,0),
(111,null,36019,111021,-142178,-2504,8252,600,0),
(111,null,36019,111309,-141104,-2512,51072,600,0),
(111,null,36019,111334,-141069,-2512,51072,600,0),
(111,null,36026,110641,-142162,-2592,57028,600,0),
(111,null,36019,110658,-142181,-2600,57028,600,0),
(111,null,36019,110679,-142161,-2592,57028,600,0),
(111,null,36026,111222,-142214,-2776,24388,600,0),
(111,null,36027,111202,-142233,-2776,24388,600,0),
(111,null,36019,111205,-142196,-2776,24388,600,0),
(111,null,36019,111185,-142216,-2776,24388,600,0),
(111,null,36026,111020,-140860,-2600,2748,600,0),
(111,null,36027,111027,-140889,-2600,2748,600,0),
(111,null,36019,111044,-140854,-2600,2748,600,0),
(111,null,36019,111052,-140883,-2600,2748,600,0),
(111,null,36026,111517,-141157,-2776,35104,600,0),
(111,null,36027,111510,-141129,-2776,35104,600,0),
(111,null,36019,111492,-141163,-2776,35104,600,0),
(111,null,36019,111486,-141134,-2776,35104,600,0),
(111,null,36019,109584,-143216,-2576,52864,600,0),
(111,null,36018,110095,-141353,-2952,62612,600,0),
(111,null,36018,110085,-141386,-2952,62612,600,0),
(111,null,36018,110064,-141453,-2952,62612,600,0),
(111,null,36019,109616,-143200,-2576,52864,600,0),
(111,null,36018,110074,-141419,-2952,62612,600,0),
(111,null,36030,110118,-140598,-2952,0,0,0),
(111,null,36029,110032,-142368,-2872,18368,600,0),
(111,null,36027,110662,-142143,-2600,57028,600,0),
(111,null,36024,109705,-139732,-2928,29804,600,0),
(111,null,36029,109875,-142365,-2768,51260,600,0),
(111,null,36029,109843,-142889,-2768,18368,600,0),
(111,null,36029,109874,-142883,-2768,18368,600,0),
(111,null,36023,109636,-139821,-2928,29804,600,0),
(111,null,36029,109843,-142372,-2768,51260,600,0),
(111,null,36029,110151,-142753,-2872,2772,600,0),
(111,null,36023,109665,-139720,-2928,29804,600,0),
(111,null,36029,109642,-142868,-2872,34944,600,0),
(111,null,36024,109716,-139698,-2928,29804,600,0),
(111,null,36029,109600,-142448,-2872,18368,600,0),
(111,null,36023,109676,-139687,-2928,29804,600,0),
(111,null,36023,109656,-139752,-2928,29804,600,0),
(111,null,36024,109675,-139832,-2928,29804,600,0),
(111,null,36024,109685,-139798,-2928,29804,600,0),
(111,null,36024,109695,-139764,-2928,29804,600,0),
(111,null,36029,109568,-142496,-2872,34944,600,0),
(111,null,36016,109592,-141241,-2032,62612,600,0),
(111,null,36016,109575,-141297,-2032,62612,600,0),
(111,null,36023,109646,-139787,-2928,29804,600,0),
(111,null,36029,110080,-142400,-2872,2772,600,0),
(111,null,36017,109674,-141758,-2432,29856,600,0),
(111,null,36029,110128,-142800,-2872,51260,600,0),
(111,null,36029,109696,-142896,-2872,51260,600,0),
(111,null,36029,109856,-142624,-2872,0,600,0),
(111,null,36017,109967,-141004,-2240,46084,600,0),
(111,null,36017,109665,-141788,-2432,29856,600,0),
(111,null,36017,109656,-141818,-2432,29856,600,0),
(111,null,36016,109601,-141213,-2008,62612,600,0),
(111,null,36017,109994,-141012,-2240,46084,600,0),
(111,null,36017,109939,-140996,-2240,46084,600,0),
(111,null,36016,109584,-141269,-2032,62612,600,0),
(111,null,36017,108912,-141654,-2584,46084,600,0),
(111,null,36017,108975,-141673,-2584,46084,600,0),
(111,null,36017,108944,-141664,-2584,46084,600,0),
(111,null,36030,108958,-142888,-2960,0,0,0),
(111,null,36030,109179,-142057,-2952,0,0,0),
(111,null,36017,109238,-140982,-2064,29804,600,0),
(111,null,36017,109228,-141012,-2064,29804,600,0),
(111,null,36017,109219,-141042,-2064,29804,600,0),
(111,null,36017,109248,-140950,-2064,29804,600,0),
(111,null,36017,109257,-140919,-2064,29804,600,0),
(111,null,36017,109209,-141073,-2064,29804,600,0),
(111,null,36017,109200,-141104,-2064,29804,600,0),
(111,null,36017,109266,-140889,-2064,29804,600,0),
(111,null,36016,109387,-141178,-2032,29804,600,0),
(111,null,36016,109379,-141206,-2032,29804,600,0),
(111,null,36016,109395,-141150,-2032,29804,600,0),
(111,null,36016,109371,-141234,-2032,29804,600,0),
(111,null,36015,109423,-141204,-2032,29804,600,0),
(111,null,36018,108906,-140993,-2952,29804,600,0),
(111,null,36018,108896,-141025,-2952,29804,600,0),
(111,null,36018,108886,-141059,-2952,29804,600,0),
(111,null,36018,108875,-141093,-2952,29804,600,0),
(111,null,36027,108107,-141920,-2920,56268,600,0),
(111,null,36026,108476,-142277,-2920,29120,600,0),
(111,null,36026,108286,-142320,-2920,20180,600,0),
(111,null,36027,108437,-142101,-2920,39544,600,0),
(111,null,36026,108271,-141965,-2920,47208,600,0),
(111,null,36026,108124,-142146,-2920,60980,600,0),
(111,null,36019,107873,-141326,-2600,35900,600,0),
(111,null,36026,107897,-141319,-2600,35900,600,0),
(111,null,36019,107424,-141632,-2576,34436,600,0),
(111,null,36019,107440,-141664,-2576,34436,600,0),
(111,null,36019,108335,-140753,-2952,29804,600,0),
(111,null,36019,107414,-141076,-2776,3308,600,0),
(111,null,36019,107405,-141048,-2776,3308,600,0),
(111,null,36027,107391,-141083,-2776,3308,600,0),
(111,null,36026,107382,-141056,-2776,3308,600,0),
(111,null,36019,107864,-141298,-2600,35900,600,0),
(111,null,36027,107888,-141291,-2600,35900,600,0),
(111,null,36019,107737,-140023,-2776,56356,600,0),
(111,null,36019,107715,-140042,-2776,56356,600,0),
(111,null,36027,107721,-140005,-2776,56356,600,0),
(111,null,36026,107700,-140023,-2776,56356,600,0),
(111,null,36019,108238,-140078,-2592,23836,600,0),
(111,null,36019,108259,-140060,-2600,23836,600,0),
(111,null,36027,108255,-140096,-2592,23836,600,0),
(111,null,36026,108276,-140078,-2592,23836,600,0),
(111,null,36019,107568,-141135,-2512,18972,600,0),
(111,null,36019,107589,-141098,-2512,18972,600,0),
(111,null,36019,107532,-141113,-2512,18972,600,0),
(111,null,36019,107560,-141105,-2512,18972,600,0),
(111,null,36019,107894,-140060,-2504,40748,600,0),
(111,null,36019,107852,-140059,-2504,40748,600,0),
(111,null,36019,107894,-140101,-2504,40748,600,0),
(111,null,36019,107873,-140080,-2504,40748,600,0),
(111,null,36018,107479,-140502,-2960,29804,600,0),
(111,null,36019,108320,-140797,-2952,29804,600,0),
(111,null,36019,108304,-140848,-2952,29804,600,0),
(111,null,36019,108287,-140899,-2952,29804,600,0),
(111,null,36019,108260,-140804,-2952,29804,600,0),
(111,null,36019,108320,-139312,-2560,25276,600,0),
(111,null,36019,108288,-139344,-2576,25276,600,0),
(111,null,36018,107490,-140471,-2960,29804,600,0),
(111,null,36018,107470,-140534,-2960,29804,600,0),
(111,null,36018,107461,-140566,-2960,29804,600,0),

-- Floran Guards
(112,null,36065,6304,151648,-2808,49151,600,0),
(112,null,36065,6736,151647,-2808,49151,600,0),
(112,null,36065,6736,152096,-2808,16384,600,0),
(112,null,36065,6303,152096,-2808,16384,600,0),
(112,null,36065,6262,151683,-2808,32768,600,0),
(112,null,36065,6260,152059,-2808,32768,600,0),
(112,null,36065,6776,152057,-2808,0,600,0),
(112,null,36065,6773,151668,-2808,0,600,0),
(112,null,36065,6528,151872,-2808,0,600,0),
(112,null,36065,6486,151617,-2704,16384,600,0),
(112,null,36065,6453,151616,-2704,16384,600,0),
(112,null,36065,6552,152129,-2704,49151,600,0),
(112,null,36065,6584,152129,-2704,49151,600,0),
(112,null,36051,7472,151728,-2504,0,600,0),
(112,null,36051,7472,151776,-2504,0,600,0),
(112,null,36051,7344,152320,-2512,0,600,0),
(112,null,36051,7312,152352,-2512,0,600,0),
(112,null,36051,6976,152688,-2512,16384,600,0),
(112,null,36051,6960,152704,-2512,16384,600,0),
(112,null,36051,6496,152816,-2504,16384,600,0),
(112,null,36051,6448,152816,-2504,16384,600,0),
(112,null,36050,7457,150716,-2888,0,600,0),
(112,null,36051,7370,151012,-2712,32768,600,0),
(112,null,36063,7394,151012,-2712,32768,600,0),
(112,null,36051,7370,150983,-2712,32768,600,0),
(112,null,36051,6997,151344,-2528,0,600,0),
(112,null,36062,7394,150984,-2712,32768,600,0),
(112,null,36051,6997,151373,-2528,0,600,0),
(112,null,36063,6973,151344,-2528,0,600,0),
(112,null,36062,6972,151372,-2528,0,600,0),
(112,null,36051,7364,150458,-2712,32768,600,0),
(112,null,36051,7363,150487,-2712,32768,600,0),
(112,null,36063,7388,150486,-2712,32768,600,0),
(112,null,36062,7388,150459,-2712,32768,600,0),
(112,null,36063,6968,150125,-2528,0,600,0),
(112,null,36051,6993,150125,-2528,0,600,0),
(112,null,36051,6993,150097,-2528,0,600,0),
(112,null,36062,6969,150097,-2528,0,600,0),
(112,null,36051,7248,151102,-2440,49151,600,0),
(112,null,36051,7216,151072,-2440,49151,600,0),
(112,null,36051,7280,151072,-2440,49151,600,0),
(112,null,36051,7248,151072,-2440,49151,600,0),
(112,null,36051,7248,150384,-2440,16384,600,0),
(112,null,36051,7248,150351,-2440,16384,600,0),
(112,null,36051,7280,150384,-2440,16384,600,0),
(112,null,36051,7216,150384,-2440,16384,600,0),
(112,null,36051,6631,150558,-2888,9440,600,0),
(112,null,36051,6591,150587,-2888,9440,600,0),
(112,null,36051,6675,150524,-2888,9440,600,0),
(112,null,36051,6716,150495,-2888,9440,600,0),
(112,null,36051,6687,150580,-2888,9440,600,0),
(112,null,36051,7472,149584,-2504,0,600,0),
(112,null,36051,7472,149616,-2504,0,600,0),
(112,null,36050,6234,149696,-2888,0,600,0),
(112,null,36050,6234,149731,-2888,0,600,0),
(112,null,36050,6233,149765,-2888,0,600,0),
(112,null,36050,6233,149799,-2888,0,600,0),
(112,null,36050,7457,150683,-2888,0,600,0),
(112,null,36050,7457,150749,-2888,0,600,0),
(112,null,36050,7457,150783,-2888,0,600,0),
(112,null,36049,5314,149781,-1992,32768,600,0),
(112,null,36049,5978,150102,-2176,49151,600,0),
(112,null,36049,6033,150102,-2176,49151,600,0),
(112,null,36049,5314,149940,-1992,32768,600,0),
(112,null,36049,6005,150102,-2176,49151,600,0),
(112,null,36049,5314,149877,-1992,32768,600,0),
(112,null,36048,5719,149767,-1960,0,600,0),
(112,null,36049,5314,149845,-1992,32768,600,0),
(112,null,36049,5314,149909,-1992,32768,600,0),
(112,null,36049,5314,149971,-1992,32768,600,0),
(112,null,36049,5314,149813,-1992,32768,600,0),
(112,null,36049,5314,150003,-1992,32768,600,0),
(112,null,36048,5719,149737,-1960,0,600,0),
(112,null,36048,5719,149707,-1960,0,600,0),
(112,null,36048,5719,149797,-1960,0,600,0),
(112,null,36048,5505,149767,-1960,32768,600,0),
(112,null,36047,5542,149751,-1960,32768,600,0),
(112,null,36048,5505,149737,-1960,32768,600,0),
(112,null,36048,5505,149708,-1960,32768,600,0),
(112,null,36048,5505,149796,-1960,32768,600,0),
(112,null,36062,4353,150837,-2856,12848,600,0),
(112,null,36063,4544,151232,-2856,42296,600,0),
(112,null,36063,4560,150832,-2856,25720,600,0),
(112,null,36062,4352,151120,-2856,53848,600,0),
(112,null,36062,4624,150896,-2856,28720,600,0),
(112,null,36062,4633,151067,-2856,36136,600,0),
(112,null,36062,5618,151196,-2712,0,600,0),
(112,null,36051,5642,151169,-2712,0,600,0),
(112,null,36051,5642,151196,-2712,0,600,0),
(112,null,36063,5618,151169,-2712,0,600,0),
(112,null,36051,6010,150829,-2528,32768,600,0),
(112,null,36063,6035,150830,-2528,32768,600,0),
(112,null,36051,6010,150802,-2528,32768,600,0),
(112,null,36062,6035,150802,-2528,32768,600,0),
(112,null,36051,5859,150870,-2440,58016,600,0),
(112,null,36051,5886,150901,-2440,58016,600,0),
(112,null,36051,5916,150898,-2440,58016,600,0),
(112,null,36051,5890,150869,-2440,58016,600,0),
(112,null,36068,5610,150544,-2888,0,0,0),
(112,null,36050,4996,149801,-2888,32768,600,0),
(112,null,36050,4995,149766,-2888,32768,600,0),
(112,null,36050,4995,149732,-2888,32768,600,0),
(112,null,36050,4995,149699,-2888,32768,600,0),
(112,null,36468,4326,149651,-2888,0,600,0),
(112,null,36067,5182,152320,-2848,49151,600,0),
(112,null,36068,5907,152603,-2888,0,0,0),
(112,null,36051,5824,152832,-2504,16384,600,0),
(112,null,36051,5792,152832,-2504,16384,600,0),
(112,null,36051,4496,152704,-2512,16384,600,0),
(112,null,36051,4464,152672,-2512,16384,600,0),
(112,null,36051,5152,152832,-2504,16384,600,0),
(112,null,36051,5120,152832,-2504,16384,600,0),
(112,null,36051,4128,152352,-2512,32768,600,0),
(112,null,36051,4112,152320,-2512,32768,600,0),
(112,null,36054,4816,148016,-2888,16384,600,0),
(112,null,36053,5136,147744,-2888,7600,600,0),
(112,null,36053,4499,147751,-2888,25408,600,0),
(112,null,36052,4794,147528,-2728,40880,600,0),
(112,null,36049,5951,149230,-2368,32768,600,0),
(112,null,36049,5951,149262,-2368,32768,600,0),
(112,null,36049,5951,149294,-2368,32768,600,0),
(112,null,36049,5193,149154,-2520,49151,600,0),
(112,null,36049,5225,149154,-2520,49151,600,0),
(112,null,36049,5257,149154,-2520,49151,600,0),
(112,null,36056,5238,147853,-2888,0,600,0),
(112,null,36056,5570,147483,-2888,0,600,0),
(112,null,36056,4325,147705,-2888,0,600,0),
(112,null,36056,4740,148149,-2888,0,600,0),
(112,null,36056,5487,147557,-2888,0,600,0),
(112,null,36057,4848,147632,-2728,58432,600,0),
(112,null,36057,4800,147728,-2856,14988,600,0),
(112,null,36051,4463,148113,-2528,32768,600,0),
(112,null,36063,4487,148113,-2528,32768,600,0),
(112,null,36051,4463,148086,-2528,32768,600,0),
(112,null,36062,4488,148087,-2528,32768,600,0),
(112,null,36051,4097,149019,-2712,0,600,0),
(112,null,36051,4097,148992,-2712,0,600,0),
(112,null,36051,4467,149355,-2528,32768,600,0),
(112,null,36051,4467,149384,-2528,32768,600,0),
(112,null,36063,4492,149354,-2528,32768,600,0),
(112,null,36051,5634,148502,-2712,49151,600,0),
(112,null,36051,5662,148502,-2712,49151,600,0),
(112,null,36062,4492,149383,-2528,32768,600,0),
(112,null,36063,5634,148527,-2712,49151,600,0),
(112,null,36062,5662,148527,-2712,49151,600,0),
(112,null,36051,5304,148130,-2528,0,600,0),
(112,null,36051,5304,148102,-2528,0,600,0),
(112,null,36063,5280,148131,-2528,0,600,0),
(112,null,36062,5280,148103,-2528,0,600,0),
(112,null,36051,4254,148384,-2440,16384,600,0),
(112,null,36051,4222,148352,-2440,16384,600,0),
(112,null,36051,4190,148384,-2440,16384,600,0),
(112,null,36051,4222,148384,-2440,16384,600,0),
(112,null,36051,4197,149085,-2440,49151,600,0),
(112,null,36051,4229,149117,-2440,49151,600,0),
(112,null,36051,4261,149085,-2440,49151,600,0),
(112,null,36051,4229,149085,-2440,49151,600,0),
(112,null,36051,5336,148458,-2440,28400,600,0),
(112,null,36051,5359,148494,-2440,28400,600,0),
(112,null,36051,5345,148519,-2440,28400,600,0),
(112,null,36051,5331,148489,-2440,28400,600,0),
(112,null,36068,5530,148820,-2888,0,0,0),
(112,null,36051,4719,148896,-2888,32768,600,0),
(112,null,36051,4719,148832,-2888,32768,600,0),
(112,null,36051,4720,148764,-2888,32768,600,0),
(112,null,36051,4719,148704,-2888,32768,600,0),
(112,null,36051,4672,148797,-2888,32768,600,0),
(112,null,36060,6912,148339,-2856,0,600,0),
(112,null,36060,6911,148288,-2856,0,600,0),
(112,null,36060,6910,148242,-2856,0,600,0),
(112,null,36060,6909,148196,-2856,0,600,0),
(112,null,36060,6908,148148,-2856,0,600,0),
(112,null,36059,6953,148338,-2856,0,600,0),
(112,null,36059,6950,148242,-2856,0,600,0),
(112,null,36059,6952,148288,-2856,0,600,0),
(112,null,36059,6949,148196,-2856,0,600,0),
(112,null,36059,6949,148148,-2856,0,600,0),
(112,null,36051,7472,147936,-2504,0,600,0),
(112,null,36051,7472,147968,-2504,0,600,0),
(112,null,36051,7472,148752,-2504,0,600,0),
(112,null,36051,7472,148800,-2488,0,600,0),
(112,null,36056,5653,147187,-2888,0,600,0),
(112,null,36057,4576,147344,-2824,15104,600,0),
(112,null,36055,4368,147424,-2824,2312,600,0),
(112,null,36053,4501,147117,-2888,40716,600,0),
(112,null,36057,4912,147200,-2792,32172,600,0),
(112,null,36055,5264,147424,-2760,32684,600,0),
(112,null,36055,4816,146992,-2792,16576,600,0),
(112,null,36053,5132,147118,-2888,57864,600,0),
(112,null,36051,5792,146640,-2504,49151,600,0),
(112,null,36051,6496,146624,-2504,49151,600,0),
(112,null,36051,7344,147136,-2512,0,600,0),
(112,null,36051,4496,146768,-2512,49151,600,0),
(112,null,36051,4480,146800,-2512,49151,600,0),
(112,null,36051,6448,146624,-2504,49151,600,0),
(112,null,36051,4112,147152,-2512,32768,600,0),
(112,null,36051,6992,146784,-2512,49151,600,0),
(112,null,36068,6687,146909,-2888,0,0,0),
(112,null,36051,7328,147104,-2512,0,600,0),
(112,null,36051,5840,146640,-2504,49151,600,0),
(112,null,36051,6960,146768,-2512,49151,600,0),
(112,null,36051,5152,146640,-2504,49151,600,0),
(112,null,36051,4144,147120,-2512,32768,600,0),
(112,null,36051,5120,146640,-2504,49151,600,0),
(112,null,36051,3984,149840,-2504,32768,600,0),
(112,null,36051,3984,151536,-2504,32768,600,0),
(112,null,36051,3984,151488,-2504,32768,600,0),
(112,null,36051,3984,150672,-2504,32768,600,0),
(112,null,36051,3984,150704,-2504,32768,600,0),
(112,null,36051,3984,149872,-2504,32768,600,0),
(112,null,36050,3995,148715,-2888,32768,600,0),
(112,null,36050,3995,148747,-2888,32768,600,0),
(112,null,36050,3995,148779,-2888,32768,600,0),
(112,null,36051,4091,148447,-2712,0,600,0),
(112,null,36051,4091,148475,-2712,0,600,0),
(112,null,36063,4067,148448,-2712,0,600,0),
(112,null,36062,4067,148475,-2712,0,600,0),
(112,null,36063,4073,149019,-2712,0,600,0),
(112,null,36062,4073,148992,-2712,0,600,0),
(112,null,36051,3984,147632,-2504,32768,600,0),
(112,null,36051,3984,147600,-2504,32768,600,0),
(112,null,36050,3995,148683,-2888,32768,600,0);

INSERT INTO `fort_siege_guards` VALUES
-- Cloud Mansion Guards
(113,null,36089,-56352,90480,-2440,32768,600,0),
(113,null,36089,-56336,91104,-2440,32768,600,0),
(113,null,36089,-56336,91136,-2440,32768,600,0),
(113,null,36089,-56336,92096,-2440,32768,600,0),
(113,null,36089,-56352,90448,-2440,32768,600,0),
(113,null,36089,-56336,92128,-2440,32768,600,0),
(113,null,36098,-55695,91856,-2792,32768,600,0),
(113,null,36097,-55728,91792,-2792,32768,600,0),
(113,null,36103,-55472,90704,-2736,32768,600,0),
(113,null,36097,-55728,91824,-2792,32768,600,0),
(113,null,36097,-55727,91920,-2792,32768,600,0),
(113,null,36098,-55695,91888,-2792,32768,600,0),
(113,null,36103,-55504,90519,-2632,0,600,0),
(113,null,36098,-55695,91792,-2792,32768,600,0),
(113,null,36097,-55728,91888,-2792,32768,600,0),
(113,null,36103,-55481,90275,-2736,32768,600,0),
(113,null,36097,-55727,91856,-2792,32768,600,0),
(113,null,36103,-55428,90748,-2736,16384,600,0),
(113,null,36103,-55505,90553,-2632,0,600,0),
(113,null,36103,-55440,90224,-2736,49151,600,0),
(113,null,36089,-56128,89968,-2440,40960,600,0),
(113,null,36089,-56144,89984,-2440,40960,600,0),
(113,null,36089,-55600,89536,-2440,49152,600,0),
(113,null,36089,-55632,89536,-2440,49152,600,0),
(113,null,36089,-54656,89760,-2368,0,600,0),
(113,null,36089,-54656,89824,-2368,0,600,0),
(113,null,36089,-54656,89792,-2368,0,600,0),
(113,null,36089,-54688,89792,-2368,0,600,0),
(113,null,36101,-54910,90064,-2464,49151,600,0),
(113,null,36100,-54942,90064,-2456,49151,600,0),
(113,null,36101,-54578,89629,-2640,16384,600,0),
(113,null,36089,-54942,90032,-2456,49151,600,0),
(113,null,36100,-54554,89630,-2640,16384,600,0),
(113,null,36089,-54578,89661,-2640,16384,600,0),
(113,null,36089,-54554,89662,-2640,16384,600,0),
(113,null,36089,-54910,90032,-2456,49151,600,0),
(113,null,36089,-53903,89662,-2640,16384,600,0),
(113,null,36089,-53935,89662,-2640,16384,600,0),
(113,null,36101,-53903,89630,-2640,16384,600,0),
(113,null,36100,-53935,89630,-2640,16384,600,0),
(113,null,36101,-53545,90063,-2464,49151,600,0),
(113,null,36089,-53545,90031,-2464,49151,600,0),
(113,null,36100,-53577,90063,-2464,49151,600,0),
(113,null,36089,-53577,90031,-2464,49151,600,0),
(113,null,36089,-53840,89824,-2376,32768,600,0),
(113,null,36089,-53810,89792,-2376,32768,600,0),
(113,null,36089,-53840,89758,-2376,32768,600,0),
(113,null,36089,-53840,89792,-2376,32768,600,0),
(113,null,36089,-53360,89536,-2440,49152,600,0),
(113,null,36089,-53392,89536,-2440,49152,600,0),
(113,null,36088,-54294,89561,-2824,49151,600,0),
(113,null,36088,-54262,89561,-2824,49151,600,0),
(113,null,36088,-54230,89561,-2824,49151,600,0),
(113,null,36088,-54198,89561,-2824,49151,600,0),
(113,null,36089,-54338,91013,-2376,49151,600,0),
(113,null,36100,-51832,91057,-2640,16384,600,0),
(113,null,36089,-54366,90982,-2376,49151,600,0),
(113,null,36089,-51831,91091,-2640,16384,600,0),
(113,null,36089,-51863,91091,-2640,16384,600,0),
(113,null,36089,-54257,90892,-2464,16384,600,0),
(113,null,36101,-51864,91057,-2640,16384,600,0),
(113,null,36100,-54257,90860,-2464,16384,600,0),
(113,null,36101,-54289,90860,-2464,16384,600,0),
(113,null,36103,-55248,90496,-2736,0,600,0),
(113,null,36103,-54992,90422,-2632,32768,600,0),
(113,null,36089,-54379,91013,-2376,49151,600,0),
(113,null,36103,-55058,90224,-2736,49151,600,0),
(113,null,36094,-51723,90308,-2824,0,600,0),
(113,null,36094,-51577,90956,-2824,0,600,0),
(113,null,36086,-53247,91117,-1896,49151,600,0),
(113,null,36089,-54289,90890,-2464,16384,600,0),
(113,null,36103,-54992,90455,-2632,32768,600,0),
(113,null,36094,-51723,90164,-2824,0,600,0),
(113,null,36086,-53215,91117,-1896,49151,600,0),
(113,null,36086,-53279,91117,-1896,49151,600,0),
(113,null,36103,-55019,90276,-2736,0,600,0),
(113,null,36103,-55024,90704,-2736,0,600,0),
(113,null,36087,-52879,90857,-2104,32768,600,0),
(113,null,36087,-53719,90883,-2296,16384,600,0),
(113,null,36103,-55072,90746,-2736,16384,600,0),
(113,null,36086,-53183,91117,-1872,49151,600,0),
(113,null,36087,-53687,90883,-2296,16384,600,0),
(113,null,36087,-52879,90793,-2104,32768,600,0),
(113,null,36095,-51280,90320,-2792,31640,600,0),
(113,null,36087,-52879,90825,-2104,32768,600,0),
(113,null,36087,-53751,90883,-2296,16384,600,0),
(113,null,36092,-51616,90336,-2824,32768,600,0),
(113,null,36091,-51296,90656,-2824,25400,600,0),
(113,null,36088,-53248,90598,-2824,49151,600,0),
(113,null,36088,-53184,90598,-2824,49151,600,0),
(113,null,36088,-53280,90598,-2824,49151,600,0),
(113,null,36089,-54032,90144,-2824,45056,600,0),
(113,null,36088,-53216,90598,-2824,49151,600,0),
(113,null,36089,-54121,90151,-2824,45055,600,0),
(113,null,36089,-54176,90240,-2824,45055,600,0),
(113,null,36089,-54080,90176,-2824,45056,600,0),
(113,null,36089,-54132,90205,-2824,45055,600,0),
(113,null,36089,-54326,90982,-2376,49151,600,0),
(113,null,36098,-55696,91824,-2792,32768,600,0),
(113,null,36098,-55696,91920,-2792,32768,600,0),
(113,null,36106,-56018,91068,-2824,0,0,0),
(113,null,36087,-53808,91644,-2448,32768,600,0),
(113,null,36087,-53808,91612,-2448,32768,600,0),
(113,null,36087,-53809,91580,-2448,32768,600,0),
(113,null,36086,-53280,91326,-1896,16384,600,0),
(113,null,36089,-54625,91262,-2640,49151,600,0),
(113,null,36089,-54652,91262,-2640,49151,600,0),
(113,null,36101,-54625,91294,-2640,49151,600,0),
(113,null,36100,-54652,91294,-2640,49151,600,0),
(113,null,36106,-54097,91252,-2824,0,0,0),
(113,null,36088,-53280,91845,-2824,16384,600,0),
(113,null,36091,-51299,90015,-2824,41768,600,0),
(113,null,36094,-51504,89732,-2824,0,600,0),
(113,null,36089,-52032,89536,-2440,49152,600,0),
(113,null,36089,-52080,89536,-2440,49152,600,0),
(113,null,36079,-52080,89808,-2824,16384,600,0),
(113,null,36087,-53108,91519,-1928,16384,600,0),
(113,null,36087,-53076,91519,-1928,16384,600,0),
(113,null,36087,-53140,91519,-1928,16384,600,0),
(113,null,36087,-53044,91519,-1928,16384,600,0),
(113,null,36087,-53204,91519,-1928,16384,600,0),
(113,null,36087,-53172,91519,-1928,16384,600,0),
(113,null,36087,-53012,91519,-1928,16384,600,0),
(113,null,36086,-53216,91326,-1896,16384,600,0),
(113,null,36087,-52980,91519,-1928,16384,600,0),
(113,null,36086,-53248,91326,-1896,16384,600,0),
(113,null,36085,-53232,91297,-1896,16384,600,0),
(113,null,36086,-53184,91326,-1896,16384,600,0),
(113,null,36089,-52221,91456,-2464,49151,600,0),
(113,null,36089,-52189,91456,-2464,49151,600,0),
(113,null,36101,-52221,91488,-2464,49151,600,0),
(113,null,36100,-52189,91488,-2464,49151,600,0),
(113,null,36089,-52133,91330,-2376,16384,600,0),
(113,null,36089,-52149,91362,-2376,16384,600,0),
(113,null,36089,-52165,91330,-2376,16384,600,0),
(113,null,36089,-52117,91362,-2376,16384,600,0),
(113,null,36106,-52478,91254,-2824,0,0,0),
(113,null,36088,-53183,91842,-2824,16384,600,0),
(113,null,36088,-53215,91842,-2824,16384,600,0),
(113,null,36088,-53248,91843,-2824,16384,600,0),
(113,null,36089,-54432,93024,-2440,16384,600,0),
(113,null,36089,-54464,93024,-2440,16384,600,0),
(113,null,36100,-54317,92638,-2784,61472,600,0),
(113,null,36101,-54297,92392,-2784,10168,600,0),
(113,null,36100,-54074,92396,-2784,20344,600,0),
(113,null,36101,-54010,92639,-2784,37928,600,0),
(113,null,36100,-54167,92359,-2784,16408,600,0),
(113,null,36100,-54403,92484,-2784,4604,600,0),
(113,null,36095,-50896,90096,-2760,31716,600,0),
(113,null,36090,-51075,90317,-2664,57456,600,0),
(113,null,36094,-50555,91100,-2824,0,600,0),
(113,null,36095,-51168,90368,-2664,7612,600,0),
(113,null,36093,-50992,90784,-2696,50056,600,0),
(113,null,36095,-50736,90416,-2728,48068,600,0),
(113,null,36093,-50544,90336,-2728,32452,600,0),
(113,null,36093,-50976,89904,-2760,16252,600,0),
(113,null,36091,-50657,90654,-2824,7176,600,0),
(113,null,36091,-50659,90017,-2824,56916,600,0),
(113,null,36089,-50192,91088,-2440,0,600,0),
(113,null,36089,-50896,89536,-2440,49152,600,0),
(113,null,36089,-50928,89536,-2440,49152,600,0),
(113,null,36094,-50409,90884,-2824,0,600,0),
(113,null,36106,-50336,91840,-2816,0,0,0),
(113,null,36089,-50192,90464,-2440,0,600,0),
(113,null,36089,-50192,90448,-2440,0,600,0),
(113,null,36089,-50192,91120,-2440,0,600,0),
(113,null,36089,-50192,92128,-2440,0,600,0),
(113,null,36089,-50192,92080,-2440,0,600,0),
(113,null,36089,-51376,93024,-2424,16384,600,0),
(113,null,36089,-52595,92242,-2824,12288,600,0),
(113,null,36089,-52541,92274,-2824,12288,600,0),
(113,null,36088,-52206,93008,-2821,16384,600,0),
(113,null,36089,-50880,93024,-2440,16384,600,0),
(113,null,36089,-50912,93024,-2440,16384,600,0),
(113,null,36089,-52499,92178,-2824,12288,600,0),
(113,null,36089,-51875,92776,-2368,32768,600,0),
(113,null,36089,-52547,92210,-2824,12288,600,0),
(113,null,36089,-51875,92808,-2368,32768,600,0),
(113,null,36089,-51875,92744,-2368,32768,600,0),
(113,null,36089,-52639,92270,-2824,12288,600,0),
(113,null,36089,-52593,92904,-2640,49151,600,0),
(113,null,36089,-51609,92525,-2456,16384,600,0),
(113,null,36100,-51577,92500,-2456,16384,600,0),
(113,null,36100,-51933,92940,-2640,49151,600,0),
(113,null,36089,-51962,92914,-2640,49151,600,0),
(113,null,36089,-52721,92773,-2376,0,600,0),
(113,null,36089,-53104,93024,-2440,16384,600,0),
(113,null,36089,-52686,92741,-2376,0,600,0),
(113,null,36089,-53136,93024,-2440,16384,600,0),
(113,null,36101,-52985,92500,-2464,16384,600,0),
(113,null,36101,-51962,92940,-2640,49151,600,0),
(113,null,36089,-51933,92914,-2640,49151,600,0),
(113,null,36089,-52686,92773,-2376,0,600,0),
(113,null,36089,-51843,92776,-2368,32768,600,0),
(113,null,36089,-52686,92805,-2376,0,600,0),
(113,null,36089,-52985,92532,-2464,16384,600,0),
(113,null,36089,-52625,92904,-2640,49151,600,0),
(113,null,36100,-52625,92936,-2640,49151,600,0),
(113,null,36101,-52593,92936,-2640,49151,600,0),
(113,null,36089,-52953,92532,-2464,16384,600,0),
(113,null,36089,-51576,92526,-2456,16384,600,0),
(113,null,36100,-52953,92500,-2464,16384,600,0),
(113,null,36101,-51609,92500,-2464,16384,600,0),
(113,null,36089,-51408,93024,-2440,16384,600,0),
(113,null,36088,-52239,93008,-2816,16384,600,0),
(113,null,36088,-52271,93008,-2816,16384,600,0),
(113,null,36088,-52304,93008,-2816,16384,600,0),
(113,null,36105,-50967,92305,-2776,41188,600,0),
(113,null,36089,-50368,92608,-2416,0,600,0),
(113,null,36089,-50352,92576,-2440,0,600,0),

-- Tanor Guards
(114,null,36131,61771,139177,-1728,14280,600,0),
(114,null,36131,61808,139170,-1728,14280,600,0),
(114,null,36131,61844,139164,-1728,14280,600,0),
(114,null,36131,61879,139157,-1728,14280,600,0),
(114,null,36131,61916,139151,-1728,14280,600,0),
(114,null,36130,61778,139215,-1728,14280,600,0),
(114,null,36130,61815,139207,-1728,14280,600,0),
(114,null,36130,61851,139200,-1728,14280,600,0),
(114,null,36130,61886,139193,-1728,14280,600,0),
(114,null,36130,61923,139186,-1728,14280,600,0),
(114,null,36126,61584,137568,-1376,2321,600,0),
(114,null,36126,61616,137552,-1376,2364,600,0),
(114,null,36126,62672,138256,-1376,3125,600,0),
(114,null,36126,62688,138288,-1376,2789,600,0),
(114,null,36126,62864,139232,-1376,0,600,0),
(114,null,36134,61870,140645,-1568,46936,600,0),
(114,null,36133,62134,140145,-1392,14420,600,0),
(114,null,36126,62139,140170,-1392,14420,600,0),
(114,null,36126,61865,140621,-1568,14638,600,0),
(114,null,36126,61835,140628,-1568,14764,600,0),
(114,null,36134,62103,140151,-1392,14420,600,0),
(114,null,36133,61578,140687,-1752,10553,600,0),
(114,null,36126,62108,140176,-1392,14420,600,0),
(114,null,36126,61933,140466,-1304,30684,600,0),
(114,null,36126,61903,140503,-1304,30684,600,0),
(114,null,36126,61891,140444,-1304,30684,600,0),
(114,null,36126,61897,140473,-1304,30684,600,0),
(114,null,36137,62720,139538,-1752,0,0,0),
(114,null,36126,62880,139280,-1360,0,600,0),
(114,null,36126,62400,140624,-1376,1797,600,0),
(114,null,36126,62368,140624,-1376,4532,600,0),
(114,null,36125,61596,140760,-1752,5133,600,0),
(114,null,36125,61565,140766,-1752,4274,600,0),
(114,null,36125,61531,140772,-1752,14480,600,0),
(114,null,36125,61498,140779,-1752,14480,600,0),
(114,null,36124,59760,139901,-1384,30752,600,0),
(114,null,36124,59774,139965,-1384,30752,600,0),
(114,null,36124,59767,139933,-1384,30752,600,0),
(114,null,36124,60362,139714,-856,14480,600,0),
(114,null,36124,60425,139703,-856,14480,600,0),
(114,null,36124,60394,139708,-856,14480,600,0),
(114,null,36124,60456,139697,-856,14480,600,0),
(114,null,36124,60488,139691,-856,14480,600,0),
(114,null,36124,60551,139680,-856,14480,600,0),
(114,null,36124,60520,139685,-856,14480,600,0),
(114,null,36124,60582,139674,-856,14480,600,0),
(114,null,36123,60303,139321,-824,46872,600,0),
(114,null,36123,60272,139328,-824,46872,600,0),
(114,null,36123,60243,139334,-824,46872,600,0),
(114,null,36123,60213,139341,-824,46872,600,0),
(114,null,36123,60348,139528,-824,14480,600,0),
(114,null,36123,60317,139534,-824,14480,600,0),
(114,null,36123,60287,139539,-824,14480,600,0),
(114,null,36123,60254,139545,-824,14480,600,0),
(114,null,36122,60296,139508,-824,14480,600,0),
(114,null,36134,59502,140575,-1720,19184,600,0),
(114,null,36133,59677,140648,-1720,27056,600,0),
(114,null,36133,59590,140849,-1720,35344,600,0),
(114,null,36126,61198,140754,-1568,47132,600,0),
(114,null,36126,61227,140749,-1568,47132,600,0),
(114,null,36134,61204,140780,-1568,47132,600,0),
(114,null,36133,61232,140774,-1560,47132,600,0),
(114,null,36126,60774,140444,-1392,14196,600,0),
(114,null,36126,60804,140438,-1392,14196,600,0),
(114,null,36134,60769,140420,-1392,14196,600,0),
(114,null,36133,60798,140414,-1392,14196,600,0),
(114,null,36126,61118,140660,-1304,63356,600,0),
(114,null,36126,61072,140639,-1304,63356,600,0),
(114,null,36126,61105,140600,-1304,63356,600,0),
(114,null,36126,61111,140630,-1304,63356,600,0),
(114,null,36137,61079,139309,-1752,0,0,0),
(114,null,36137,59454,139641,-1752,0,0,0),
(114,null,36126,61024,140144,-1752,7020,600,0),
(114,null,36126,60992,140176,-1752,7020,600,0),
(114,null,36126,60960,140224,-1752,7020,600,0),
(114,null,36126,60928,140272,-1752,7020,600,0),
(114,null,36126,61034,140240,-1752,7020,600,0),
(114,null,36126,60416,141024,-1360,14540,600,0),
(114,null,36126,60368,141024,-1376,14540,600,0),
(114,null,36125,60349,140053,-1752,14480,600,0),
(114,null,36125,60383,140046,-1752,14480,600,0),
(114,null,36125,60415,140040,-1752,14480,600,0),
(114,null,36125,60449,140033,-1752,14480,600,0),
(114,null,36124,59705,139207,-1232,14424,600,0),
(114,null,36124,59735,139202,-1232,14424,600,0),
(114,null,36124,59765,139196,-1232,14424,600,0),
(114,null,36124,60563,139009,-1040,30840,600,0),
(114,null,36124,60552,138951,-1040,30840,600,0),
(114,null,36124,60557,138980,-1040,30840,600,0),
(114,null,36126,59733,138438,-1392,46756,600,0),
(114,null,36126,59763,138432,-1392,46756,600,0),
(114,null,36134,59738,138463,-1392,46756,600,0),
(114,null,36133,59768,138457,-1392,46756,600,0),
(114,null,36126,59453,138242,-1304,30576,600,0),
(114,null,36126,59429,138278,-1304,30576,600,0),
(114,null,36126,59422,138249,-1304,30576,600,0),
(114,null,36126,59416,138219,-1304,30576,600,0),
(114,null,36126,59489,138738,-1752,39680,600,0),
(114,null,36126,59552,138658,-1752,39680,600,0),
(114,null,36126,59521,138698,-1752,39680,600,0),
(114,null,36126,59461,138686,-1752,39680,600,0),
(114,null,36126,59456,138784,-1752,39680,600,0),
(114,null,36126,60112,137856,-1376,62063,600,0),
(114,null,36126,60144,137856,-1376,62418,600,0),
(114,null,36125,60110,138835,-1752,46872,600,0),
(114,null,36125,60143,138829,-1752,46872,600,0),
(114,null,36125,60175,138822,-1752,46872,600,0),
(114,null,36125,60207,138815,-1752,46872,600,0),
(114,null,36126,59336,138125,-1568,14120,600,0),
(114,null,36126,59307,138131,-1568,14120,600,0),
(114,null,36134,59331,138101,-1568,14120,600,0),
(114,null,36133,59302,138107,-1568,14120,600,0),
(114,null,36126,58697,138254,-1568,13984,600,0),
(114,null,36126,58669,138260,-1568,13984,600,0),
(114,null,36134,58663,138235,-1568,13984,600,0),
(114,null,36126,58421,138702,-1392,46940,600,0),
(114,null,36133,58691,138229,-1568,13984,600,0),
(114,null,36126,58392,138707,-1392,46940,600,0),
(114,null,36134,58425,138726,-1392,46940,600,0),
(114,null,36133,58396,138732,-1392,46940,600,0),
(114,null,36126,58602,138414,-1304,63152,600,0),
(114,null,36126,58640,138435,-1304,63152,600,0),
(114,null,36126,58634,138406,-1304,63152,600,0),
(114,null,36126,58628,138378,-1304,63152,600,0),
(114,null,36126,57568,139152,-1376,18523,600,0),
(114,null,36126,57552,139120,-1376,16081,600,0),
(114,null,36126,58112,138256,-1376,22889,600,0),
(114,null,36126,58160,138256,-1376,24963,600,0),
(114,null,36125,59028,138102,-1752,46872,600,0),
(114,null,36125,58963,138116,-1752,46872,600,0),
(114,null,36125,58996,138109,-1752,46872,600,0),
(114,null,36125,58929,138124,-1752,46872,600,0),
(114,null,36136,58783,139771,-1672,63536,600,0),
(114,null,36136,58656,139377,-1672,46872,600,0),
(114,null,36136,58707,139408,-1664,63536,600,0),
(114,null,36136,58240,139457,-1672,46872,600,0),
(114,null,36136,58205,139512,-1672,30776,600,0),
(114,null,36136,58275,139866,-1672,30776,600,0),
(114,null,36136,58320,139904,-1616,14480,600,0),
(114,null,36136,58752,139825,-1608,14480,600,0),
(114,null,36136,58496,139649,-1672,0,600,0),
(114,null,36136,58410,139394,-1568,14480,600,0),
(114,null,36136,58374,139402,-1568,14480,600,0),
(114,null,36136,58574,139888,-1568,46872,600,0),
(114,null,36136,58607,139881,-1568,46872,600,0),
(114,null,36134,59280,140903,-1720,58000,600,0),
(114,null,36133,59283,140618,-1720,9912,600,0),
(114,null,36133,59138,140756,-1720,2480,600,0),
(114,null,36137,57903,139845,-1752,0,0,0),
(114,null,36126,57824,140448,-1376,34068,600,0),
(114,null,36126,57808,140416,-1376,33730,600,0),
(114,null,36126,58896,141328,-1376,64594,600,0),
(114,null,36126,58944,141312,-1360,64653,600,0),

-- Dragonspine Guards
(115,null,36153,11537,95056,-2496,16384,600,0),
(115,null,36154,11488,95088,-2496,16384,600,0),
(115,null,36154,11489,94886,-2496,49151,600,0),
(115,null,36154,11584,95088,-2480,16384,600,0),
(115,null,36154,11521,94886,-2496,49151,600,0),
(115,null,36154,11553,94886,-2496,49151,600,0),
(115,null,36154,11585,94886,-2496,49151,600,0),
(115,null,36154,11552,95088,-2496,16384,600,0),
(115,null,36154,11520,95088,-2496,16384,600,0),
(115,null,36155,11567,95280,-2528,16384,600,0),
(115,null,36155,11759,95280,-2528,16384,600,0),
(115,null,36155,11903,94560,-2712,32768,600,0),
(115,null,36155,10960,95376,-3056,32768,600,0),
(115,null,36155,11903,94624,-2712,32768,600,0),
(115,null,36155,11014,94644,-2904,16384,600,0),
(115,null,36155,11695,95280,-2528,16384,600,0),
(115,null,36155,11791,95280,-2528,16384,600,0),
(115,null,36155,10960,95344,-3056,32768,600,0),
(115,null,36155,11903,94592,-2712,32768,600,0),
(115,null,36155,11078,94644,-2904,16384,600,0),
(115,null,36155,11046,94644,-2904,16384,600,0),
(115,null,36155,10960,95408,-3056,32768,600,0),
(115,null,36155,11727,95280,-2528,16384,600,0),
(115,null,36155,11663,95280,-2528,16384,600,0),
(115,null,36155,11631,95280,-2528,16384,600,0),
(115,null,36155,11599,95280,-2528,16384,600,0),
(115,null,36156,12512,93488,-3424,39347,600,0),
(115,null,36156,12544,93488,-3424,49152,600,0),
(115,null,36156,11487,94361,-3424,49151,600,0),
(115,null,36156,11519,95609,-3424,16384,600,0),
(115,null,36156,11583,94361,-3424,49151,600,0),
(115,null,36156,12448,93488,-3424,49152,600,0),
(115,null,36156,12480,93488,-3424,49152,600,0),
(115,null,36156,11519,94361,-3424,49151,600,0),
(115,null,36156,11551,94361,-3424,49151,600,0),
(115,null,36156,10436,96588,-3424,16384,600,0),
(115,null,36156,10530,96589,-3424,16384,600,0),
(115,null,36156,11583,95609,-3424,16384,600,0),
(115,null,36156,11487,95609,-3424,16384,600,0),
(115,null,36156,10468,96588,-3424,16384,600,0),
(115,null,36156,11551,95609,-3424,16384,600,0),
(115,null,36156,10499,96589,-3424,16384,600,0),
(115,null,36157,12206,93591,-3248,16384,600,0),
(115,null,36157,13170,93936,-3072,49151,600,0),
(115,null,36157,12841,93590,-3248,16384,600,0),
(115,null,36157,12174,93591,-3248,57674,600,0),
(115,null,36157,8896,94448,-3048,32768,600,0),
(115,null,36157,13296,93472,-3048,49152,600,0),
(115,null,36157,13264,93472,-3048,49152,600,0),
(115,null,36157,11568,93472,-3048,49152,600,0),
(115,null,36157,10720,93472,-3048,49152,600,0),
(115,null,36157,9024,93984,-3048,40960,600,0),
(115,null,36157,8896,95424,-3048,32768,600,0),
(115,null,36157,8896,95456,-3048,32768,600,0),
(115,null,36157,9056,93968,-3048,40960,600,0),
(115,null,36157,14080,95600,-3048,0,600,0),
(115,null,36157,14080,94624,-3048,0,600,0),
(115,null,36157,14080,94656,-3048,0,600,0),
(115,null,36157,13952,94000,-3048,57344,600,0),
(115,null,36157,13920,93968,-3048,57344,600,0),
(115,null,36157,12304,94096,-3424,54044,600,0),
(115,null,36157,12267,94077,-3424,54044,600,0),
(115,null,36157,10622,95920,-3424,20480,600,0),
(115,null,36157,10730,95971,-3424,20480,600,0),
(115,null,36157,12112,93744,-2976,0,600,0),
(115,null,36157,12112,93680,-2976,0,600,0),
(115,null,36157,12898,93676,-2976,32768,600,0),
(115,null,36157,12898,93742,-2976,32768,600,0),
(115,null,36157,12930,93708,-2976,32768,600,0),
(115,null,36157,11843,93930,-3072,49151,600,0),
(115,null,36157,12809,93590,-3248,16384,600,0),
(115,null,36157,12343,94061,-3424,54044,600,0),
(115,null,36157,11536,93472,-3048,49152,600,0),
(115,null,36157,9872,93472,-3048,49152,600,0),
(115,null,36157,12373,94132,-3424,54044,600,0),
(115,null,36157,12112,93712,-2976,0,600,0),
(115,null,36157,10752,93472,-3048,49152,600,0),
(115,null,36157,9920,93472,-3048,49152,600,0),
(115,null,36157,12898,93708,-2976,32768,600,0),
(115,null,36157,12080,93712,-2976,0,600,0),
(115,null,36157,13202,93936,-3072,49151,600,0),
(115,null,36157,12340,94114,-3424,54044,600,0),
(115,null,36157,11811,93930,-3072,49151,600,0),
(115,null,36157,9680,96608,-3048,16384,600,0),
(115,null,36157,11584,96608,-3048,16384,600,0),
(115,null,36157,10912,96368,-2976,32768,600,0),
(115,null,36157,10912,96336,-2976,32768,600,0),
(115,null,36157,10912,96400,-2976,32768,600,0),
(115,null,36157,10944,96368,-2976,32768,600,0),
(115,null,36157,10112,96400,-2976,0,600,0),
(115,null,36157,10112,96334,-2976,0,600,0),
(115,null,36157,10805,96480,-3248,49151,600,0),
(115,null,36157,11616,96608,-3048,16384,600,0),
(115,null,36157,10200,96480,-3248,49151,600,0),
(115,null,36157,10168,96480,-3248,49151,600,0),
(115,null,36157,9712,96608,-3048,16384,600,0),
(115,null,36157,12448,96608,-3024,16384,600,0),
(115,null,36157,10837,96480,-3248,49151,600,0),
(115,null,36157,10112,96368,-2960,0,600,0),
(115,null,36157,10656,95936,-3424,20480,600,0),
(115,null,36157,10693,95951,-3424,20480,600,0),
(115,null,36157,10080,96368,-2976,0,600,0),
(115,null,36157,11165,96144,-3072,16384,600,0),
(115,null,36157,9806,96139,-3072,16384,600,0),
(115,null,36157,9838,96139,-3072,16384,600,0),
(115,null,36157,11197,96144,-3072,16384,600,0),
(115,null,36157,10640,95987,-3424,20480,600,0),
(115,null,36157,14080,95632,-3048,0,600,0),
(115,null,36157,12400,96608,-3048,16384,600,0),
(115,null,36161,9529,94927,-3392,32768,600,0),
(115,null,36161,9529,95023,-3392,32768,600,0),
(115,null,36161,9529,94991,-3392,32768,600,0),
(115,null,36161,9529,95055,-3392,32768,600,0),
(115,null,36161,9529,94959,-3392,32768,600,0),
(115,null,36162,9561,95055,-3392,32768,600,0),
(115,null,36162,9561,95023,-3392,32768,600,0),
(115,null,36162,9561,94991,-3392,32768,600,0),
(115,null,36162,9561,94959,-3392,32768,600,0),
(115,null,36162,9561,94927,-3392,32768,600,0),
(115,null,36164,12258,93598,-3424,0,600,0),
(115,null,36164,12414,93598,-3424,59404,600,0),
(115,null,36164,12750,93598,-3424,32767,600,0),
(115,null,36164,12594,93598,-3424,38902,600,0),
(115,null,36164,9838,96107,-3072,16384,600,0),
(115,null,36164,11811,93962,-3072,49151,600,0),
(115,null,36164,12809,93558,-3248,16384,600,0),
(115,null,36164,13120,96085,-3392,27864,600,0),
(115,null,36164,12174,93559,-3248,16384,600,0),
(115,null,36164,12827,95980,-3392,16232,600,0),
(115,null,36164,13202,93968,-3072,49151,600,0),
(115,null,36164,11197,96112,-3072,16384,600,0),
(115,null,36164,12704,95984,-3392,10308,600,0),
(115,null,36164,12992,96260,-3392,35780,600,0),
(115,null,36164,10200,96512,-3248,59067,600,0),
(115,null,36164,10242,96482,-3424,0,600,0),
(115,null,36164,10398,96482,-3424,6132,600,0),
(115,null,36164,10446,96514,-3424,17151,600,0),
(115,null,36164,10837,96512,-3248,35725,600,0),
(115,null,36164,10492,96609,-3424,10835,600,0),
(115,null,36164,10578,96482,-3424,27931,600,0),
(115,null,36164,10514,96514,-3424,19632,600,0),
(115,null,36165,12592,96096,-3392,6296,600,0),
(115,null,36165,12206,93559,-3248,16384,600,0),
(115,null,36165,11843,93962,-3072,49151,600,0),
(115,null,36165,12841,93558,-3248,16384,600,0),
(115,null,36165,11165,96112,-3072,16384,600,0),
(115,null,36165,13170,93968,-3072,49151,600,0),
(115,null,36165,10805,96512,-3248,49151,600,0),
(115,null,36165,12928,95968,-3392,19600,600,0),
(115,null,36165,10168,96512,-3248,49151,600,0),
(115,null,36165,9806,96107,-3072,16384,600,0),
(115,null,36167,13119,94688,-3240,16384,600,0),
(115,null,36167,13447,94764,-3344,0,600,0),
(115,null,36167,13447,95116,-3344,0,600,0),
(115,null,36167,13216,95200,-3240,49152,600,0),
(115,null,36167,12927,94758,-3344,32768,600,0),
(115,null,36167,13248,95200,-3240,49152,600,0),
(115,null,36167,13151,94688,-3240,16384,600,0),
(115,null,36167,12928,95112,-3344,32768,600,0),
(115,null,36167,12986,95168,-3344,16384,600,0),
(115,null,36167,13380,95167,-3344,16384,600,0),
(115,null,36167,12988,94714,-3344,49151,600,0),
(115,null,36167,13184,94944,-3344,0,600,0),
(115,null,36167,13388,94712,-3344,49151,600,0),
(115,null,36168,13894,95136,-3424,0,0,0),
(115,null,36168,9086,94588,-3424,0,0,0),
(115,null,36168,12330,94991,-3424,0,0,0),
(115,null,36168,10675,95036,-3424,0,0,0),

-- Antharas Guards
(116,null,36188,80164,92755,-2880,5012,600,0),
(116,null,36188,80179,92726,-2880,5012,600,0),
(116,null,36188,80194,92696,-2880,5012,600,0),
(116,null,36188,80209,92667,-2880,5012,600,0),
(116,null,36189,80720,91728,-2504,4916,600,0),
(116,null,36189,80736,91696,-2504,4916,600,0),
(116,null,36189,81104,91008,-2504,4916,600,0),
(116,null,36189,81120,90976,-2504,4916,600,0),
(116,null,36189,81488,90272,-2504,4916,600,0),
(116,null,36189,81504,90240,-2504,4916,600,0),
(116,null,36189,81760,89488,-2512,62536,600,0),
(116,null,36189,81744,89456,-2512,62536,600,0),
(116,null,36189,81632,89008,-2512,62536,600,0),
(116,null,36189,81616,88976,-2512,62536,600,0),
(116,null,36189,81120,88576,-2504,54360,600,0),
(116,null,36189,81088,88560,-2504,54360,600,0),
(116,null,36189,80528,88256,-2504,54360,600,0),
(116,null,36189,80496,88240,-2504,54360,600,0),
(116,null,36206,80247,88389,-2880,0,0,0),
(116,null,36189,80144,92288,-2440,21316,600,0),
(116,null,36189,80157,92261,-2440,21316,600,0),
(116,null,36189,80169,92301,-2440,21316,600,0),
(116,null,36188,79814,91293,-2880,5012,600,0),
(116,null,36188,79798,91325,-2880,5012,600,0),
(116,null,36200,80041,91903,-2520,5204,600,0),
(116,null,36201,80027,91928,-2528,5204,600,0),
(116,null,36189,80063,91914,-2528,5204,600,0),
(116,null,36189,80049,91939,-2528,5204,600,0),
(116,null,36189,80229,92406,-2704,37100,600,0),
(116,null,36188,79766,91389,-2880,5012,600,0),
(116,null,36188,79782,91357,-2880,5012,600,0),
(116,null,36189,79680,93696,-2504,4916,600,0),
(116,null,36189,79408,87840,-2512,46132,600,0),
(116,null,36189,79440,87824,-2512,46132,600,0),
(116,null,36189,80218,92432,-2704,37100,600,0),
(116,null,36201,80241,92443,-2704,37100,600,0),
(116,null,36200,80253,92417,-2704,37100,600,0),
(116,null,36200,80002,92905,-2696,37568,600,0),
(116,null,36189,79980,92894,-2704,37568,600,0),
(116,null,36201,79989,92931,-2704,37568,600,0),
(116,null,36189,79966,92920,-2704,37568,600,0),
(116,null,36189,79664,93712,-2504,4916,600,0),
(116,null,36189,79904,87936,-2504,54360,600,0),
(116,null,36189,78928,87968,-2512,46132,600,0),
(116,null,36189,78960,87968,-2512,46132,600,0),
(116,null,36189,79936,87952,-2504,54360,600,0),
(116,null,36189,78848,94192,-2512,13736,600,0),
(116,null,36189,79648,92192,-2880,8328,600,0),
(116,null,36206,78912,91925,-2880,0,0,0),
(116,null,36200,79914,89779,-2704,22244,600,0),
(116,null,36189,79696,92160,-2880,8328,600,0),
(116,null,36189,79296,94064,-2512,13532,600,0),
(116,null,36189,79328,94048,-2512,13532,600,0),
(116,null,36189,79600,92224,-2880,8328,600,0),
(116,null,36189,79845,92922,-2440,54004,600,0),
(116,null,36201,79901,89800,-2704,22244,600,0),
(116,null,36189,79889,89764,-2704,22244,600,0),
(116,null,36189,79875,89784,-2704,22244,600,0),
(116,null,36200,80877,90674,-2856,50196,600,0),
(116,null,36200,80651,90653,-2856,60240,600,0),
(116,null,36201,80655,90503,-2856,64396,600,0),
(116,null,36200,80744,90436,-2856,3800,600,0),
(116,null,36200,80752,90336,-2856,6872,600,0),
(116,null,36201,81068,90402,-2856,26684,600,0),
(116,null,36189,79794,92896,-2440,54004,600,0),
(116,null,36189,79649,92243,-2880,8328,600,0),
(116,null,36206,79252,90176,-2880,0,0,0),
(116,null,36189,78870,92275,-2440,0,600,0),
(116,null,36189,79820,92909,-2440,54004,600,0),
(116,null,36189,79481,93035,-2528,54744,600,0),
(116,null,36189,79514,89875,-2440,35876,600,0),
(116,null,36189,79549,89870,-2440,35876,600,0),
(116,null,36189,79552,92256,-2880,8328,600,0),
(116,null,36189,79469,93057,-2528,54744,600,0),
(116,null,36189,79806,92935,-2440,54004,600,0),
(116,null,36189,79504,89904,-2440,35876,600,0),
(116,null,36189,79538,89899,-2440,35876,600,0),
(116,null,36201,79457,93021,-2528,54744,600,0),
(116,null,36200,79359,89915,-2528,5508,600,0),
(116,null,36189,78893,92259,-2440,0,600,0),
(116,null,36189,78870,92312,-2440,0,600,0),
(116,null,36200,79444,93042,-2528,54744,600,0),
(116,null,36203,79721,88646,-2808,53247,600,0),
(116,null,36203,79502,88494,-2704,20480,600,0),
(116,null,36189,79396,89902,-2528,5508,600,0),
(116,null,36205,80801,89028,-2848,21984,600,0),
(116,null,36189,79380,89927,-2528,5508,600,0),
(116,null,36203,79532,88508,-2704,20480,600,0),
(116,null,36201,79374,89890,-2528,5508,600,0),
(116,null,36203,79584,89030,-2808,5500,600,0),
(116,null,36189,80118,92274,-2440,21316,600,0),
(116,null,36203,79125,88784,-2808,38143,600,0),
(116,null,36203,79151,88858,-2808,20480,600,0),
(116,null,36195,79008,93664,-2824,54296,600,0),
(116,null,36186,79351,91057,-1960,5012,600,0),
(116,null,36186,79338,91082,-1960,5012,600,0),
(116,null,36187,79613,90998,-1992,5012,600,0),
(116,null,36203,79366,88459,-2808,53247,600,0),
(116,null,36195,78992,93200,-2856,54256,600,0),
(116,null,36185,79297,91077,-1960,5012,600,0),
(116,null,36186,79124,91037,-1960,37660,600,0),
(116,null,36187,79550,91110,-1992,5012,600,0),
(116,null,36203,79439,88751,-2808,0,600,0),
(116,null,36203,79741,88735,-2800,5500,600,0),
(116,null,36203,79507,89047,-2808,20480,600,0),
(116,null,36203,79290,88472,-2808,38143,600,0),
(116,null,36187,79597,91025,-1992,5012,600,0),
(116,null,36187,79582,91053,-1992,5012,600,0),
(116,null,36187,79566,91082,-1992,5012,600,0),
(116,null,36186,79150,90986,-1960,37660,600,0),
(116,null,36194,79585,93376,-2880,0,600,0),
(116,null,36203,79374,89007,-2704,53247,600,0),
(116,null,36186,79325,91107,-1960,5012,600,0),
(116,null,36186,79137,91011,-1960,37660,600,0),
(116,null,36195,78912,93312,-2728,28220,600,0),
(116,null,36187,79519,91168,-1952,5012,600,0),
(116,null,36203,79345,88993,-2704,53247,600,0),
(116,null,36187,79629,90970,-1992,5012,600,0),
(116,null,36187,79535,91139,-1992,5012,600,0),
(116,null,36187,79080,90569,-2168,22200,600,0),
(116,null,36187,79029,90537,-2168,22200,600,0),
(116,null,36187,79312,91744,-2512,20576,600,0),
(116,null,36187,79342,91757,-2512,20576,600,0),
(116,null,36186,79311,91132,-1960,5012,600,0),
(116,null,36187,79280,91729,-2512,20576,600,0),
(116,null,36189,78894,92293,-2440,0,600,0),
(116,null,36186,79164,90960,-1960,37660,600,0),
(116,null,36192,79137,92935,-2880,54492,600,0),
(116,null,36190,78915,93374,-2728,13024,600,0),
(116,null,36193,79248,93680,-2824,38128,600,0),
(116,null,36191,78978,93899,-2880,13396,600,0),
(116,null,36187,79055,90553,-2168,22200,600,0),
(116,null,36191,79279,93337,-2880,62180,600,0),
(116,null,36189,78099,89743,-2440,54000,600,0),
(116,null,36189,78285,89106,-2704,5816,600,0),
(116,null,36200,78249,89119,-2704,5816,600,0),
(116,null,36189,78270,89131,-2704,5816,600,0),
(116,null,36201,78264,89095,-2704,5816,600,0),
(116,null,36189,78764,88989,-2528,37492,600,0),
(116,null,36189,78778,88963,-2528,37492,600,0),
(116,null,36200,78800,88975,-2520,37492,600,0),
(116,null,36201,78786,89001,-2528,37492,600,0),
(116,null,36189,78020,89602,-2704,5388,600,0),
(116,null,36189,78034,89577,-2704,5388,600,0),
(116,null,36201,77999,89590,-2704,5388,600,0),
(116,null,36200,78012,89566,-2704,5388,600,0),
(116,null,36189,78203,90067,-2528,37536,600,0),
(116,null,36189,78191,90092,-2528,37536,600,0),
(116,null,36201,78225,90077,-2528,37536,600,0),
(116,null,36200,78212,90103,-2528,37536,600,0),
(116,null,36189,78438,89097,-2440,21948,600,0),
(116,null,36189,78449,89135,-2440,21948,600,0),
(116,null,36189,78400,89106,-2440,21948,600,0),
(116,null,36189,78424,89120,-2424,21948,600,0),
(116,null,36189,78085,89705,-2440,54000,600,0),
(116,null,36189,78138,89731,-2440,54000,600,0),
(116,null,36189,78111,89718,-2440,54000,600,0),
(116,null,36189,78768,89840,-2880,42084,600,0),
(116,null,36189,78576,89936,-2880,42084,600,0),
(116,null,36189,78704,89872,-2880,42084,600,0),
(116,null,36189,78640,89840,-2880,42084,600,0),
(116,null,36189,78640,89904,-2880,42084,600,0),
(116,null,36189,78544,88432,-2504,38660,600,0),
(116,null,36189,78560,88400,-2504,38660,600,0),
(116,null,36188,78049,89354,-2880,37920,600,0),
(116,null,36188,78064,89325,-2880,37920,600,0),
(116,null,36188,78079,89296,-2880,37920,600,0),
(116,null,36188,78095,89267,-2880,37920,600,0),
(116,null,36187,78692,91346,-2360,5536,600,0),
(116,null,36187,78708,91320,-2360,5536,600,0),
(116,null,36187,78724,91294,-2360,5536,600,0),
(116,null,36189,78634,92136,-2704,21324,600,0),
(116,null,36189,78609,92123,-2704,21324,600,0),
(116,null,36201,78645,92115,-2704,21324,600,0),
(116,null,36200,78620,92101,-2704,21324,600,0),
(116,null,36188,78664,90798,-2880,37660,600,0),
(116,null,36188,78680,90767,-2880,37660,600,0),
(116,null,36188,78696,90737,-2880,37660,600,0),
(116,null,36188,78711,90707,-2880,37660,600,0),
(116,null,36191,78418,93601,-2880,29984,600,0),
(116,null,36191,78715,93037,-2880,46336,600,0),
(116,null,36193,78448,93248,-2760,5940,600,0),
(116,null,36193,78624,93872,-2792,54360,600,0),
(116,null,36194,78721,92784,-2880,0,600,0),
(116,null,36194,78145,93228,-2880,0,600,0),
(116,null,36194,78721,92858,-2880,0,600,0),
(116,null,36194,78817,92932,-2880,0,600,0),
(116,null,36194,78625,92858,-2880,0,600,0),
(116,null,36195,78656,93648,-2792,3972,600,0),
(116,null,36189,78757,92614,-2528,37756,600,0),
(116,null,36201,78780,92626,-2528,37756,600,0),
(116,null,36189,78743,92640,-2528,37756,600,0),
(116,null,36200,78766,92652,-2528,37756,600,0),
(116,null,36206,78023,93737,-2880,0,0,0),
(116,null,36189,78816,94192,-2512,13736,600,0),
(116,null,36189,78208,94016,-2504,22340,600,0),
(116,null,36189,78176,94000,-2504,22340,600,0),
(116,null,36198,77399,91689,-2856,36863,600,0),
(116,null,36198,77383,91721,-2856,36863,600,0),
(116,null,36198,77367,91753,-2856,36863,600,0),
(116,null,36198,77351,91785,-2856,36863,600,0),
(116,null,36198,77335,91817,-2856,36863,600,0),
(116,null,36197,77351,91673,-2856,36863,600,0),
(116,null,36197,77335,91705,-2856,36863,600,0),
(116,null,36197,77319,91737,-2856,36863,600,0),
(116,null,36197,77303,91769,-2856,36863,600,0),
(116,null,36197,77287,91801,-2856,36863,600,0),
(116,null,36189,76752,91776,-2504,38340,600,0),
(116,null,36189,76768,91744,-2504,38340,600,0),
(116,null,36189,77136,91056,-2504,38340,600,0),
(116,null,36189,77152,91024,-2504,38340,600,0),
(116,null,36189,77520,90320,-2504,38660,600,0),
(116,null,36189,77536,90304,-2504,38660,600,0),
(116,null,36189,77600,93696,-2504,22340,600,0),
(116,null,36189,77568,93680,-2504,22340,600,0),
(116,null,36189,77024,93392,-2504,22340,600,0),
(116,null,36189,76992,93376,-2504,22340,600,0),
(116,null,36189,76656,93040,-2512,29668,600,0),
(116,null,36189,76640,93008,-2512,29668,600,0),
(116,null,36189,76496,92560,-2512,29668,600,0),
(116,null,36189,76480,92528,-2512,29668,600,0);

INSERT INTO `fort_siege_guards` VALUES
-- Western Guards
(117,null,36223,111366,-15077,-72,16384,600,0),
(117,null,36224,111324,-15042,-72,16384,600,0),
(117,null,36224,111352,-15041,-72,16384,600,0),
(117,null,36224,111380,-15041,-72,16384,600,0),
(117,null,36224,111416,-15252,-72,49151,600,0),
(117,null,36225,111397,-14848,-96,16384,600,0),
(117,null,36225,111461,-14848,-96,16384,600,0),
(117,null,36225,111429,-14848,-96,16384,600,0),
(117,null,36225,111493,-14848,-96,16384,600,0),
(117,null,36225,111525,-14848,-96,16384,600,0),
(117,null,36225,111557,-14848,-96,16384,600,0),
(117,null,36225,111589,-14848,-96,16384,600,0),
(117,null,36225,111621,-14848,-96,16384,600,0),
(117,null,36225,110772,-14761,-624,32768,600,0),
(117,null,36225,110772,-14793,-624,32768,600,0),
(117,null,36225,110772,-14729,-624,32768,600,0),
(117,null,36225,111720,-15576,-280,32768,600,0),
(117,null,36225,111720,-15512,-280,32768,600,0),
(117,null,36225,110912,-15488,-432,16384,600,0),
(117,null,36225,110848,-15488,-472,16384,600,0),
(117,null,36225,110880,-15488,-472,16384,600,0),
(117,null,36226,110299,-13524,-992,16384,600,0),
(117,null,36226,110363,-13524,-992,16384,600,0),
(117,null,36226,110395,-13524,-992,16384,600,0),
(117,null,36226,111319,-15773,-992,49151,600,0),
(117,null,36226,111320,-14526,-992,16384,600,0),
(117,null,36226,111351,-15773,-992,49151,600,0),
(117,null,36226,111352,-14526,-992,16384,600,0),
(117,null,36226,111383,-15773,-992,49151,600,0),
(117,null,36226,111384,-14526,-992,16384,600,0),
(117,null,36226,111415,-15773,-992,49151,600,0),
(117,null,36226,111416,-14526,-992,16384,600,0),
(117,null,36227,108736,-16864,-616,41508,600,0),
(117,null,36227,108752,-16880,-616,41508,600,0),
(117,null,36227,109552,-17008,-616,49152,600,0),
(117,null,36227,109584,-17008,-616,49152,600,0),
(117,null,36227,109727,-14847,-640,0,600,0),
(117,null,36227,109759,-14847,-640,0,600,0),
(117,null,36227,110000,-13792,-552,0,600,0),
(117,null,36227,110000,-13760,-552,0,600,0),
(117,null,36227,110100,-14904,-552,16384,600,0),
(117,null,36227,110107,-15194,-816,32768,600,0),
(117,null,36227,110107,-15164,-816,32768,600,0),
(117,null,36227,110116,-14872,-552,16384,600,0),
(117,null,36227,110148,-14904,-552,16384,600,0),
(117,null,36227,110368,-17008,-616,49152,600,0),
(117,null,36227,110368,-14224,-992,16384,600,0),
(117,null,36227,110400,-17008,-616,49152,600,0),
(117,null,36227,110432,-14177,-992,16384,600,0),
(117,null,36227,110705,-13766,-552,32768,600,0),
(117,null,36227,111200,-17008,-616,49152,600,0),
(117,null,36227,111232,-17008,-616,49152,600,0),
(117,null,36227,111504,-13520,-616,16384,600,0),
(117,null,36227,111715,-16527,-640,49151,600,0),
(117,null,36227,111741,-16527,-640,49151,600,0),
(117,null,36227,111968,-16768,-552,0,600,0),
(117,null,36227,112000,-16768,-552,0,600,0),
(117,null,36227,112070,-16895,-816,16384,600,0),
(117,null,36227,112102,-16895,-816,16384,600,0),
(117,null,36227,112112,-16080,-992,49151,600,0),
(117,null,36227,112160,-16080,-992,49151,600,0),
(117,null,36227,112192,-16144,-992,49151,600,0),
(117,null,36227,112208,-16080,-992,49151,600,0),
(117,null,36227,112256,-16080,-992,49151,600,0),
(117,null,36227,112288,-13520,-616,16384,600,0),
(117,null,36227,112320,-13520,-616,16384,600,0),
(117,null,36227,112421,-15550,-640,16384,600,0),
(117,null,36227,112449,-15550,-640,16384,600,0),
(117,null,36227,112496,-15456,-552,49152,600,0),
(117,null,36227,112510,-15432,-552,49151,600,0),
(117,null,36227,112528,-15456,-552,49152,600,0),
(117,null,36227,112542,-15432,-552,49151,600,0),
(117,null,36227,112597,-16895,-816,16384,600,0),
(117,null,36227,112629,-16895,-816,16384,600,0),
(117,null,36227,112691,-16775,-552,32768,600,0),
(117,null,36227,112691,-16807,-552,32768,600,0),
(117,null,36227,112691,-16743,-552,32768,600,0),
(117,null,36227,112723,-16775,-552,32768,600,0),
(117,null,36227,112781,-15187,-816,49151,600,0),
(117,null,36227,112813,-15187,-816,49151,600,0),
(117,null,36227,112960,-16532,-640,49151,600,0),
(117,null,36227,112988,-16533,-640,49151,600,0),
(117,null,36227,113104,-13536,-616,16384,600,0),
(117,null,36227,113344,-17008,-616,49152,600,0),
(117,null,36227,113376,-17008,-616,49152,600,0),
(117,null,36227,113936,-16880,-616,56016,600,0),
(117,null,36227,113968,-16848,-616,56016,600,0),
(117,null,36227,114288,-14016,-616,8876,600,0),
(117,null,36227,114288,-16512,-616,56016,600,0),
(117,null,36227,114320,-16480,-616,56016,600,0),
(117,null,36227,114320,-14032,-616,8876,600,0),
(117,null,36227,114432,-15344,-616,0,600,0),
(117,null,36227,114448,-15376,-616,0,600,0),
(117,null,36227,114448,-14688,-616,0,600,0),
(117,null,36227,114448,-14656,-616,0,600,0),
(117,null,36228,109146,-14351,-832,24928,600,0),
(117,null,36229,109366,-14677,-992,57636,600,0),
(117,null,36229,108734,-14683,-992,40688,600,0),
(117,null,36230,109641,-14345,-992,0,600,0),
(117,null,36231,108608,-14352,-896,1888,600,0),
(117,null,36231,109056,-14800,-864,19140,600,0),
(117,null,36232,108690,-14981,-992,0,600,0),
(117,null,36232,109586,-14831,-992,0,600,0),
(117,null,36232,109522,-15056,-992,0,600,0),
(117,null,36232,109522,-15056,-992,0,600,0),
(117,null,36232,109266,-15056,-992,0,600,0),
(117,null,36232,109394,-15056,-992,0,600,0),
(117,null,36233,108816,-14448,-896,15956,600,0),
(117,null,36233,109216,-14368,-832,40824,600,0),
(117,null,36235,109808,-16560,-968,49151,600,0),
(117,null,36235,109840,-16560,-968,49151,600,0),
(117,null,36235,109872,-16560,-968,49151,600,0),
(117,null,36235,109904,-16560,-968,49151,600,0),
(117,null,36235,109936,-16560,-968,49151,600,0),
(117,null,36236,109808,-16528,-968,49151,600,0),
(117,null,36236,109936,-16528,-968,49151,600,0),
(117,null,36236,109840,-16528,-968,49151,600,0),
(117,null,36236,109872,-16528,-968,49151,600,0),
(117,null,36236,109904,-16528,-968,49151,600,0),
(117,null,36238,109727,-14812,-624,0,600,0),
(117,null,36238,110144,-15194,-816,32768,600,0),
(117,null,36238,111714,-16502,-640,49151,600,0),
(117,null,36238,112102,-16927,-816,16384,600,0),
(117,null,36238,112302,-16914,-992,51212,600,0),
(117,null,36238,112302,-16914,-992,49999,600,0),
(117,null,36238,112302,-16914,-992,49999,600,0),
(117,null,36238,112302,-16914,-992,52710,600,0),
(117,null,36238,112302,-16914,-992,55980,600,0),
(117,null,36238,112421,-15574,-640,16384,600,0),
(117,null,36238,112597,-16927,-816,16384,600,0),
(117,null,36238,112813,-15155,-816,49151,600,0),
(117,null,36238,112987,-16508,-640,49151,600,0),
(117,null,36239,109759,-14812,-640,0,600,0),
(117,null,36239,110144,-15164,-816,32768,600,0),
(117,null,36239,111742,-16502,-640,49151,600,0),
(117,null,36239,112070,-16927,-816,16384,600,0),
(117,null,36239,112449,-15574,-640,16384,600,0),
(117,null,36239,112629,-16927,-816,16384,600,0),
(117,null,36239,112781,-15155,-816,49151,600,0),
(117,null,36239,112959,-16508,-640,49151,600,0),
(117,null,36241,113229,-15995,-808,0,600,0),
(117,null,36241,113229,-16027,-808,0,600,0),
(117,null,36241,113257,-15839,-920,32768,600,0),
(117,null,36241,113260,-16272,-920,32768,600,0),
(117,null,36241,113311,-16317,-920,49151,600,0),
(117,null,36241,113663,-16316,-920,49151,600,0),
(117,null,36241,113663,-15798,-920,16384,600,0),
(117,null,36241,113713,-16273,-912,0,600,0),
(117,null,36241,113713,-15840,-912,0,600,0),
(117,null,36241,113746,-16121,-808,32768,600,0),
(117,null,36241,113746,-16089,-808,32768,600,0),
(117,null,36243,113929,-14705,-960,32768,600,0),
(117,null,36244,108546,-16253,-992,0,0,0),
(117,null,36244,110422,-15180,-992,0,0,0),
(117,null,36244,112241,-15030,-992,0,0,0),
(117,null,36244,114254,-15503,-992,0,0,0),

-- Hunters Guards
(118,null,36279,123001,94183,-2056,32768,600,0),
(118,null,36279,123056,94144,-2056,49152,600,0),
(118,null,36279,123407,94143,-2056,49151,600,0),
(118,null,36279,123455,94184,-2056,0,600,0),
(118,null,36265,124567,93601,-1960,16384,600,0),
(118,null,36265,124535,93601,-1960,16384,600,0),
(118,null,36277,124567,93569,-1960,16384,600,0),
(118,null,36276,124535,93569,-1960,16384,600,0),
(118,null,36265,124896,93968,-1784,49151,600,0),
(118,null,36276,124896,94000,-1784,49151,600,0),
(118,null,36265,123916,93605,-1952,16384,600,0),
(118,null,36265,123884,93605,-1952,16384,600,0),
(118,null,36277,123916,93573,-1952,16384,600,0),
(118,null,36276,123884,93573,-1952,16384,600,0),
(118,null,36265,123558,93967,-1776,49151,600,0),
(118,null,36265,123526,93967,-1776,49151,600,0),
(118,null,36277,123558,93999,-1776,49151,600,0),
(118,null,36276,123526,93999,-1776,49151,600,0),
(118,null,36265,124658,93731,-1688,32768,600,0),
(118,null,36265,124626,93763,-1688,32768,600,0),
(118,null,36265,124626,93699,-1688,32768,600,0),
(118,null,36265,124626,93731,-1688,32768,600,0),
(118,null,36265,123791,93730,-1688,0,600,0),
(118,null,36265,123823,93698,-1688,0,600,0),
(118,null,36265,123823,93762,-1688,0,600,0),
(118,null,36265,123823,93730,-1688,0,600,0),
(118,null,36265,124378,94188,-2144,45055,600,0),
(118,null,36265,124420,94170,-2144,45055,600,0),
(118,null,36265,124339,94157,-2144,45055,600,0),
(118,null,36265,123528,93442,-1760,49152,600,0),
(118,null,36265,123493,93444,-1760,49152,600,0),
(118,null,36264,124165,93471,-2144,49151,600,0),
(118,null,36264,124197,93471,-2144,49151,600,0),
(118,null,36264,124229,93471,-2144,49151,600,0),
(118,null,36264,124261,93471,-2144,49151,600,0),
(118,null,36270,126803,93911,-2144,0,600,0),
(118,null,36265,124928,93968,-1784,49151,600,0),
(118,null,36277,124928,94000,-1768,49151,600,0),
(118,null,36265,125072,93440,-1760,49152,600,0),
(118,null,36265,125104,93440,-1760,49152,600,0),
(118,null,36265,126384,93456,-1760,49152,600,0),
(118,null,36265,126416,93456,-1760,49152,600,0),
(118,null,36267,127184,93923,-2144,41572,600,0),
(118,null,36267,127819,93930,-2144,58004,600,0),
(118,null,36269,127504,93792,-2080,16788,600,0),
(118,null,36270,127091,93838,-2144,0,600,0),
(118,null,36271,127584,94000,-2080,31244,600,0),
(118,null,36263,124726,94814,-1616,16384,600,0),
(118,null,36263,124758,94814,-1616,16384,600,0),
(118,null,36263,124790,94814,-1616,16384,600,0),
(118,null,36263,124655,95570,-1768,32768,600,0),
(118,null,36263,124655,95506,-1768,32768,600,0),
(118,null,36263,124655,95538,-1768,32768,600,0),
(118,null,36279,123001,94615,-2056,32768,600,0),
(118,null,36279,123457,94614,-2048,0,600,0),
(118,null,36279,123405,94657,-2056,16384,600,0),
(118,null,36279,123053,94657,-2056,16384,600,0),
(118,null,36279,123487,94371,-1952,32768,600,0),
(118,null,36279,123487,94339,-1952,32768,600,0),
(118,null,36279,122980,94443,-1952,0,600,0),
(118,null,36279,122980,94472,-1952,0,600,0),
(118,null,36279,123232,94416,-2056,0,600,0),
(118,null,36265,123858,95189,-1960,49151,600,0),
(118,null,36265,123826,95189,-1960,49151,600,0),
(118,null,36277,123858,95221,-1960,49151,600,0),
(118,null,36276,123826,95221,-1960,49151,600,0),
(118,null,36265,124187,94821,-1784,16384,600,0),
(118,null,36265,124219,94821,-1784,16384,600,0),
(118,null,36277,124187,94792,-1784,16384,600,0),
(118,null,36276,124219,94792,-1784,16384,600,0),
(118,null,36265,124079,94943,-1688,49152,600,0),
(118,null,36265,124123,94943,-1688,49152,600,0),
(118,null,36265,124101,94912,-1688,49152,600,0),
(118,null,36265,124144,94912,-1688,49152,600,0),
(118,null,36282,124362,95188,-2144,0,0,0),
(118,null,36265,124293,94226,-2144,45055,600,0),
(118,null,36265,124336,94208,-2144,45055,600,0),
(118,null,36264,125262,94509,-2144,49151,600,0),
(118,null,36268,126864,94248,-2144,32768,600,0),
(118,null,36262,125263,95047,-1216,49151,600,0),
(118,null,36263,125600,94720,-1424,32768,600,0),
(118,null,36263,125600,94784,-1424,32768,600,0),
(118,null,36263,125600,94752,-1424,32768,600,0),
(118,null,36263,125501,95453,-1248,16384,600,0),
(118,null,36263,125469,95453,-1248,16384,600,0),
(118,null,36263,125437,95453,-1248,16384,600,0),
(118,null,36263,125341,95453,-1248,16384,600,0),
(118,null,36263,125405,95453,-1248,16384,600,0),
(118,null,36263,125373,95453,-1248,16384,600,0),
(118,null,36263,125308,95453,-1248,16384,600,0),
(118,null,36263,125276,95453,-1248,16384,600,0),
(118,null,36262,125199,95047,-1216,49151,600,0),
(118,null,36262,125231,95047,-1216,49151,600,0),
(118,null,36262,125295,95047,-1216,49151,600,0),
(118,null,36262,125293,95249,-1216,16384,600,0),
(118,null,36262,125261,95249,-1216,16384,600,0),
(118,null,36262,125229,95249,-1216,16384,600,0),
(118,null,36262,125197,95249,-1192,16384,600,0),
(118,null,36261,125246,95204,-1216,16384,600,0),
(118,null,36270,126875,94495,-2144,0,600,0),
(118,null,36270,126947,94860,-2144,0,600,0),
(118,null,36265,126614,95022,-1960,16384,600,0),
(118,null,36265,126646,95022,-1960,16384,600,0),
(118,null,36277,126614,94990,-1960,16384,600,0),
(118,null,36276,126646,94990,-1960,16384,600,0),
(118,null,36265,126285,95385,-1784,49151,600,0),
(118,null,36265,126253,95385,-1784,49151,600,0),
(118,null,36277,126285,95417,-1784,49151,600,0),
(118,null,36276,126253,95417,-1784,49151,600,0),
(118,null,36265,126368,95272,-1688,16384,600,0),
(118,null,36265,126336,95272,-1688,16384,600,0),
(118,null,36265,126352,95296,-1688,16384,600,0),
(118,null,36265,126320,95296,-1688,16384,600,0),
(118,null,36282,126092,94780,-2144,0,0,0),
(118,null,36265,125991,96178,-2144,12288,600,0),
(118,null,36265,125955,96192,-2144,12288,600,0),
(118,null,36265,125920,96208,-2144,12288,600,0),
(118,null,36265,125883,96221,-2144,12288,600,0),
(118,null,36265,125957,96243,-2144,12288,600,0),
(118,null,36264,125200,95760,-2144,16384,600,0),
(118,null,36264,125232,95760,-2144,16384,600,0),
(118,null,36264,125264,95760,-2144,16384,600,0),
(118,null,36264,125296,95760,-2144,16384,600,0),
(118,null,36264,125198,94509,-2144,49151,600,0),
(118,null,36264,125230,94509,-2144,49151,600,0),
(118,null,36264,125294,94509,-2144,49151,600,0),
(118,null,36267,127181,94569,-2144,24824,600,0),
(118,null,36267,127818,94572,-2144,8220,600,0),
(118,null,36269,127488,94704,-2016,49764,600,0),
(118,null,36269,127952,94256,-2048,32768,600,0),
(118,null,36266,127398,94229,-1984,57488,600,0),
(118,null,36270,127955,94933,-2144,0,600,0),
(118,null,36270,127955,94641,-2144,0,600,0),
(118,null,36271,127328,94256,-1984,10416,600,0),
(118,null,36271,127744,94336,-2048,47164,600,0),
(118,null,36271,127200,94240,-2112,32768,600,0),
(118,null,36282,128035,94889,-2144,0,0,0),
(118,null,36265,128272,94336,-1760,0,600,0),
(118,null,36265,128272,94384,-1760,0,600,0),
(118,null,36265,128272,95008,-1760,0,600,0),
(118,null,36265,128272,95040,-1760,0,600,0),
(118,null,36265,128288,96000,-1760,0,600,0),
(118,null,36265,128288,96048,-1744,0,600,0),
(118,null,36264,126145,96921,-2144,16384,600,0),
(118,null,36265,125861,96825,-1960,49151,600,0),
(118,null,36265,125893,96825,-1960,49151,600,0),
(118,null,36277,125861,96857,-1960,49151,600,0),
(118,null,36276,125893,96857,-1960,49151,600,0),
(118,null,36265,125530,96463,-1784,16384,600,0),
(118,null,36265,125498,96463,-1784,16384,600,0),
(118,null,36277,125530,96432,-1784,16384,600,0),
(118,null,36276,125498,96432,-1784,16384,600,0),
(118,null,36265,126544,96824,-1952,49151,600,0),
(118,null,36265,126516,96825,-1952,49151,600,0),
(118,null,36277,126544,96856,-1952,49151,600,0),
(118,null,36276,126516,96857,-1952,49151,600,0),
(118,null,36265,126880,96466,-1776,16384,600,0),
(118,null,36265,126912,96466,-1776,16384,600,0),
(118,null,36277,126880,96434,-1776,16384,600,0),
(118,null,36276,126912,96434,-1776,16384,600,0),
(118,null,36265,125759,96697,-1688,0,600,0),
(118,null,36265,125791,96665,-1688,0,600,0),
(118,null,36265,125791,96729,-1688,0,600,0),
(118,null,36265,126640,96704,-1688,32768,600,0),
(118,null,36265,125791,96697,-1688,0,600,0),
(118,null,36265,126608,96736,-1688,32768,600,0),
(118,null,36265,126608,96672,-1688,32768,600,0),
(118,null,36265,126608,96704,-1688,32768,600,0),
(118,null,36265,125344,96944,-1760,16384,600,0),
(118,null,36265,125312,96944,-1760,16384,600,0),
(118,null,36264,126177,96921,-2144,16384,600,0),
(118,null,36264,126241,96921,-2144,16384,600,0),
(118,null,36264,126209,96921,-2144,16384,600,0),
(118,null,36281,127584,96288,-2096,40892,600,0),
(118,null,36265,128112,96496,-1744,7848,600,0),
(118,null,36265,128080,96512,-1760,7848,600,0),
(118,null,36265,127584,96944,-1744,16384,600,0),
(118,null,36265,127552,96944,-1760,16384,600,0),
(118,null,36265,127088,96944,-1744,16384,600,0),
(118,null,36265,127056,96944,-1760,16384,600,0),
(118,null,36265,122831,93439,-1736,49151,600,0),
(118,null,36265,122864,93440,-1760,49152,600,0),
(118,null,36265,122336,93904,-1760,40364,600,0),
(118,null,36265,122368,93872,-1760,40364,600,0),
(118,null,36274,122768,95696,-2112,32768,600,0),
(118,null,36274,122768,95760,-2112,32768,600,0),
(118,null,36274,122768,95728,-2112,32768,600,0),
(118,null,36274,122768,95792,-2112,32768,600,0),
(118,null,36274,122768,95824,-2112,32768,600,0),
(118,null,36273,122735,95727,-2112,32768,600,0),
(118,null,36273,122736,95824,-2112,32768,600,0),
(118,null,36273,122736,95696,-2112,32768,600,0),
(118,null,36273,122736,95792,-2112,32768,600,0),
(118,null,36273,122736,95760,-2112,32768,600,0),
(118,null,36282,122416,94913,-2144,0,0,0),
(118,null,36265,122128,96048,-1760,32768,600,0),
(118,null,36265,122144,96016,-1760,32768,600,0),
(118,null,36265,122144,95040,-1760,32768,600,0),
(118,null,36265,122144,95008,-1760,32768,600,0),
(118,null,36265,122144,94384,-1760,32768,600,0),
(118,null,36265,122144,94352,-1760,32768,600,0),
(118,null,36277,124128,96576,-2104,62952,600,0),
(118,null,36276,124084,96348,-2104,5676,600,0),
(118,null,36276,124189,96308,-2104,11132,600,0),
(118,null,36277,124253,96348,-2104,13384,600,0),
(118,null,36276,124351,96340,-2104,18220,600,0),
(118,null,36276,124593,96397,-2104,26972,600,0),
(118,null,36265,123536,96944,-1744,16384,600,0),
(118,null,36265,123504,96944,-1760,16384,600,0),

-- Aaru Guards
(119,null,36302,73127,187231,-2584,16848,600,0),
(119,null,36302,72368,187424,-2200,23132,600,0),
(119,null,36302,72336,187408,-2200,23132,600,0),
(119,null,36310,71688,186473,-2552,37880,600,0),
(119,null,36302,72802,187576,-2400,55620,600,0),
(119,null,36302,72828,187594,-2400,55620,600,0),
(119,null,36310,72786,187597,-2400,55620,600,0),
(119,null,36309,72813,187617,-2400,55620,600,0),
(119,null,36302,72704,187084,-2224,22296,600,0),
(119,null,36302,72732,187100,-2224,22296,600,0),
(119,null,36309,72744,187079,-2224,22296,600,0),
(119,null,36310,72717,187063,-2224,22296,600,0),
(119,null,36302,73332,187931,-2400,55612,600,0),
(119,null,36302,73358,187948,-2400,55612,600,0),
(119,null,36310,73316,187954,-2400,55612,600,0),
(119,null,36309,73342,187973,-2400,55612,600,0),
(119,null,36302,72781,187428,-2136,5528,600,0),
(119,null,36302,72827,187418,-2136,5528,600,0),
(119,null,36302,72793,187474,-2136,5528,600,0),
(119,null,36302,72810,187445,-2136,5528,600,0),
(119,null,36302,73504,187902,-2136,38232,600,0),
(119,null,36302,73455,187913,-2136,38236,600,0),
(119,null,36302,73491,187855,-2136,38232,600,0),
(119,null,36302,73473,187883,-2136,38232,600,0),
(119,null,36302,73198,187170,-2584,16848,600,0),
(119,null,36302,73056,187167,-2584,16848,600,0),
(119,null,36302,73151,187168,-2584,16848,600,0),
(119,null,36302,73104,187168,-2584,16848,600,0),
(119,null,36302,73680,188304,-2200,23132,600,0),
(119,null,36302,73648,188288,-2200,23132,600,0),
(119,null,36301,72814,186536,-2584,22248,600,0),
(119,null,36301,72782,186515,-2584,22248,600,0),
(119,null,36301,72750,186494,-2584,22248,600,0),
(119,null,36301,72719,186474,-2584,22248,600,0),
(119,null,36301,73042,187862,-2584,22248,600,0),
(119,null,36301,73070,187881,-2584,22248,600,0),
(119,null,36301,73013,187843,-2584,22248,600,0),
(119,null,36301,72985,187824,-2584,22248,600,0),
(119,null,36312,74386,186682,-2400,22180,600,0),
(119,null,36312,74359,186665,-2400,22180,600,0),
(119,null,36312,74157,187142,-2400,55552,600,0),
(119,null,36312,74183,187161,-2400,55552,600,0),
(119,null,36312,74562,186834,-2504,55552,600,0),
(119,null,36312,74584,186906,-2504,6016,600,0),
(119,null,36312,74388,187201,-2504,6016,600,0),
(119,null,36312,74310,187212,-2504,22180,600,0),
(119,null,36312,73979,186992,-2448,22180,600,0),
(119,null,36312,73959,186913,-2504,39396,600,0),
(119,null,36312,74154,186624,-2504,39396,600,0),
(119,null,36312,74232,186613,-2504,55552,600,0),
(119,null,36312,74272,186912,-2504,0,600,0),
(119,null,36302,73821,187845,-2224,22196,600,0),
(119,null,36302,73849,187863,-2224,22196,600,0),
(119,null,36310,73836,187822,-2224,22200,600,0),
(119,null,36309,73866,187839,-2224,22200,600,0),
(119,null,36313,75424,186515,-2584,0,0,0),
(119,null,36302,75664,186496,-2200,63880,600,0),
(119,null,36302,75424,187088,-2200,6752,600,0),
(119,null,36302,75408,187120,-2200,6752,600,0),
(119,null,36302,74896,187904,-2200,6752,600,0),
(119,null,36302,74880,187936,-2200,6752,600,0),
(119,null,36302,75664,186464,-2200,63880,600,0),
(119,null,36302,71552,186880,-2200,23132,600,0),
(119,null,36302,71520,186864,-2200,23132,600,0),
(119,null,36302,70864,186432,-2200,23132,600,0),
(119,null,36302,70832,186400,-2200,23132,600,0),
(119,null,36307,71534,184716,-2552,38592,600,0),
(119,null,36307,71514,184748,-2552,38592,600,0),
(119,null,36307,71492,184781,-2544,38592,600,0),
(119,null,36307,71470,184813,-2544,38592,600,0),
(119,null,36307,71447,184846,-2552,38592,600,0),
(119,null,36306,71393,184812,-2552,38592,600,0),
(119,null,36306,71479,184681,-2552,38592,600,0),
(119,null,36306,71458,184714,-2552,38592,600,0),
(119,null,36306,71416,184779,-2552,38592,600,0),
(119,null,36306,71437,184747,-2552,38592,600,0),
(119,null,36309,71671,186192,-2552,23024,600,0),
(119,null,36310,71520,186178,-2552,14836,600,0),
(119,null,36309,71389,186131,-2552,11224,600,0),
(119,null,36309,71397,186364,-2552,2152,600,0),
(119,null,36313,70726,186034,-2584,0,0,0),
(119,null,36302,70656,184912,-2200,38980,600,0),
(119,null,36302,70672,184880,-2200,38980,600,0),
(119,null,36300,72869,185413,-2056,22656,600,0),
(119,null,36300,72895,185430,-2056,22656,600,0),
(119,null,36300,72921,185447,-2056,22656,600,0),
(119,null,36300,73648,185828,-1864,38960,600,0),
(119,null,36300,73611,185882,-1864,38960,600,0),
(119,null,36300,73629,185854,-1864,38960,600,0),
(119,null,36300,72384,186007,-2208,38872,600,0),
(119,null,36300,72423,185950,-2208,38872,600,0),
(119,null,36300,72404,185978,-2208,38872,600,0),
(119,null,36300,73084,186312,-1688,22248,600,0),
(119,null,36300,73169,186365,-1688,22248,600,0),
(119,null,36300,73141,186348,-1688,22248,600,0),
(119,null,36300,73112,186330,-1688,22248,600,0),
(119,null,36300,73054,186293,-1688,22248,600,0),
(119,null,36300,73026,186275,-1688,22248,600,0),
(119,null,36300,72996,186255,-1688,22248,600,0),
(119,null,36300,72968,186237,-1688,22248,600,0),
(119,null,36299,73212,185926,-1656,54844,600,0),
(119,null,36299,73183,185908,-1656,54844,600,0),
(119,null,36299,73154,185891,-1656,54844,600,0),
(119,null,36299,73126,185873,-1656,54844,600,0),
(119,null,36299,73099,186100,-1656,22248,600,0),
(119,null,36299,73071,186082,-1656,22248,600,0),
(119,null,36299,73043,186064,-1656,22248,600,0),
(119,null,36299,73014,186046,-1656,22248,600,0),
(119,null,36298,73070,186048,-1656,22248,600,0),
(119,null,36309,71781,186270,-2552,26852,600,0),
(119,null,36302,73297,184432,-2400,22448,600,0),
(119,null,36302,73272,184416,-2400,22448,600,0),
(119,null,36310,73311,184409,-2400,22448,600,0),
(119,null,36309,73286,184392,-2400,22448,600,0),
(119,null,36302,73401,184921,-2224,56004,600,0),
(119,null,36302,73375,184901,-2224,56004,600,0),
(119,null,36310,73386,184940,-2224,56004,600,0),
(119,null,36309,73361,184920,-2224,56004,600,0),
(119,null,36302,73307,184581,-2136,39088,600,0),
(119,null,36302,73298,184532,-2136,39088,600,0),
(119,null,36302,73258,184588,-2136,39088,600,0),
(119,null,36302,73278,184560,-2136,39088,600,0),
(119,null,36313,72244,185588,-2584,0,0,0),
(119,null,36302,72818,184751,-2584,50940,600,0),
(119,null,36302,72955,184775,-2584,50940,600,0),
(119,null,36302,72912,184768,-2584,50940,600,0),
(119,null,36302,72865,184759,-2584,50940,600,0),
(119,null,36302,72896,184720,-2584,50940,600,0),
(119,null,36301,73415,185440,-2576,54844,600,0),
(119,null,36301,73443,185459,-2576,54844,600,0),
(119,null,36301,73472,185478,-2584,54844,600,0),
(119,null,36301,73501,185497,-2576,54844,600,0),
(119,null,36313,73995,186114,-2584,0,0,0),
(119,null,36302,73856,184672,-2200,55096,600,0),
(119,null,36302,73888,184688,-2200,55096,600,0),
(119,null,36302,74544,185136,-2200,55096,600,0),
(119,null,36302,74576,185152,-2200,55096,600,0),
(119,null,36302,75232,185584,-2200,55096,600,0),
(119,null,36302,75264,185600,-2184,55096,600,0),
(119,null,36302,71184,184096,-2200,38980,600,0),
(119,null,36302,71216,184080,-2200,38980,600,0),
(119,null,36302,71584,183776,-2200,47036,600,0),
(119,null,36302,71632,183760,-2200,47036,600,0),
(119,null,36302,72768,184072,-2400,22560,600,0),
(119,null,36302,72741,184054,-2400,22560,600,0),
(119,null,36310,72781,184052,-2400,22560,600,0),
(119,null,36309,72755,184035,-2400,22560,600,0),
(119,null,36302,72279,184160,-2224,55092,600,0),
(119,null,36302,72251,184143,-2224,55092,600,0),
(119,null,36310,72266,184183,-2224,55092,600,0),
(119,null,36309,72237,184166,-2224,55092,600,0),
(119,null,36302,72595,184110,-2136,5160,600,0),
(119,null,36302,72636,184093,-2136,5160,600,0),
(119,null,36302,72602,184152,-2136,5160,600,0),
(119,null,36302,72619,184123,-2136,5160,600,0),
(119,null,36302,72416,183712,-2200,55096,600,0),
(119,null,36302,72448,183728,-2200,55096,600,0),
(119,null,36301,73026,184130,-2584,54844,600,0),
(119,null,36301,73056,184147,-2584,54844,600,0),
(119,null,36301,73085,184165,-2584,54844,600,0),
(119,null,36301,73114,184183,-2584,54844,600,0),

-- Demon Guards
(120,null,36342,100758,-57376,-616,49152,600,0),
(120,null,36342,100624,-57376,-616,49151,600,0),
(120,null,36342,100722,-57375,-616,49151,600,0),
(120,null,36342,100656,-57376,-616,49151,600,0),
(120,null,36342,100688,-57376,-616,49151,600,0),
(120,null,36334,101744,-57792,-264,57224,600,0),
(120,null,36334,101712,-57824,-264,57224,600,0),
(120,null,36334,101216,-57952,-264,49152,600,0),
(120,null,36334,101264,-57952,-264,49152,600,0),
(120,null,36332,101055,-55840,-120,32768,600,0),
(120,null,36332,101055,-55808,-120,32768,600,0),
(120,null,36332,101055,-55776,-80,32768,600,0),
(120,null,36332,100360,-55911,-272,49152,600,0),
(120,null,36331,100820,-55303,272,0,600,0),
(120,null,36331,100820,-55335,272,0,600,0),
(120,null,36331,100820,-55367,272,0,600,0),
(120,null,36331,100614,-55302,272,32768,600,0),
(120,null,36331,100614,-55334,272,32768,600,0),
(120,null,36331,100614,-55366,272,32768,600,0),
(120,null,36330,100645,-55318,272,32768,600,0),
(120,null,36343,100758,-57343,-616,49152,600,0),
(120,null,36343,100722,-57343,-616,49152,600,0),
(120,null,36343,100688,-57344,-616,49152,600,0),
(120,null,36343,100656,-57344,-616,49152,600,0),
(120,null,36343,100623,-57343,-616,49152,600,0),
(120,null,36351,100681,-56214,-640,0,0,0),
(120,null,36334,102224,-55312,-264,0,600,0),
(120,null,36334,102224,-56112,-264,0,600,0),
(120,null,36334,102224,-56144,-264,0,600,0),
(120,null,36334,102224,-56944,-264,0,600,0),
(120,null,36334,102224,-56976,-264,0,600,0),
(120,null,36333,101342,-55309,-640,0,600,0),
(120,null,36333,101342,-55341,-640,0,600,0),
(120,null,36333,101342,-55373,-640,0,600,0),
(120,null,36334,101961,-53952,-200,49151,600,0),
(120,null,36334,101992,-54783,-200,16384,600,0),
(120,null,36332,101144,-54964,64,49151,600,0),
(120,null,36332,101080,-54964,64,49151,600,0),
(120,null,36332,101112,-54964,64,49151,600,0),
(120,null,36332,100414,-55128,240,32768,600,0),
(120,null,36332,100414,-55064,240,32768,600,0),
(120,null,36332,100414,-55096,240,32768,600,0),
(120,null,36332,100414,-55160,240,32768,600,0),
(120,null,36332,100414,-55192,240,32768,600,0),
(120,null,36332,100414,-55224,240,32768,600,0),
(120,null,36332,100414,-55256,240,32768,600,0),
(120,null,36332,100414,-55288,240,32768,600,0),
(120,null,36331,100820,-55271,272,0,600,0),
(120,null,36331,100614,-55270,272,32768,600,0),
(120,null,36348,100752,-53680,-568,0,600,0),
(120,null,36348,100919,-53409,-568,16384,600,0),
(120,null,36348,100601,-53412,-568,16384,600,0),
(120,null,36348,100532,-53467,-568,32768,600,0),
(120,null,36348,100532,-53868,-568,32768,600,0),
(120,null,36348,100599,-53924,-568,49151,600,0),
(120,null,36348,100925,-53926,-568,49151,600,0),
(120,null,36348,100991,-53470,-568,0,600,0),
(120,null,36348,100989,-53867,-568,0,600,0),
(120,null,36348,100501,-53638,-464,0,600,0),
(120,null,36348,100501,-53606,-464,0,600,0),
(120,null,36348,101024,-53728,-464,32768,600,0),
(120,null,36348,101024,-53696,-464,32768,600,0),
(120,null,36334,102113,-54014,-464,32768,600,0),
(120,null,36334,102113,-54046,-464,32768,600,0),
(120,null,36346,102145,-54014,-464,32768,600,0),
(120,null,36334,101772,-53684,-288,0,600,0),
(120,null,36345,102145,-54046,-464,32768,600,0),
(120,null,36346,101740,-53684,-288,0,600,0),
(120,null,36334,101772,-53652,-288,0,600,0),
(120,null,36345,101740,-53652,-288,0,600,0),
(120,null,36334,102109,-54684,-464,32768,600,0),
(120,null,36334,102110,-54652,-464,32768,600,0),
(120,null,36346,102142,-54684,-464,32768,600,0),
(120,null,36345,102142,-54652,-464,32768,600,0),
(120,null,36334,101767,-55011,-288,0,600,0),
(120,null,36334,101767,-55043,-288,0,600,0),
(120,null,36346,101735,-55011,-288,0,600,0),
(120,null,36345,101735,-55043,-288,0,600,0),
(120,null,36334,101993,-53920,-200,49151,600,0),
(120,null,36334,102025,-53952,-200,49151,600,0),
(120,null,36334,101993,-53952,-200,49151,600,0),
(120,null,36334,102024,-54751,-200,16384,600,0),
(120,null,36334,101960,-54751,-200,16384,600,0),
(120,null,36334,101992,-54751,-200,16384,600,0),
(120,null,36334,101648,-54480,-640,2796,600,0),
(120,null,36334,101664,-54528,-640,2796,600,0),
(120,null,36351,100715,-54512,-640,0,0,0),
(120,null,36334,101613,-54374,-640,2796,600,0),
(120,null,36334,101629,-54424,-640,2796,600,0),
(120,null,36334,101680,-54432,-640,2796,600,0),
(120,null,36334,102224,-53568,-264,0,600,0),
(120,null,36334,102224,-53600,-264,0,600,0),
(120,null,36334,102224,-55280,-264,0,600,0),
(120,null,36333,101342,-55277,-640,0,600,0),
(120,null,36333,102216,-54305,-640,0,600,0),
(120,null,36333,102216,-54337,-640,0,600,0),
(120,null,36333,102216,-54369,-640,0,600,0),
(120,null,36333,102216,-54401,-640,0,600,0),
(120,null,36351,100007,-57770,-648,0,0,0),
(120,null,36334,100240,-57952,-264,49152,600,0),
(120,null,36334,100288,-57952,-264,49152,600,0),
(120,null,36334,99304,-56751,-200,16384,600,0),
(120,null,36332,100296,-55911,-272,49151,600,0),
(120,null,36332,100328,-55911,-272,49152,600,0),
(120,null,36334,99222,-56686,-464,0,600,0),
(120,null,36334,99222,-56654,-464,0,600,0),
(120,null,36346,99190,-56686,-464,0,600,0),
(120,null,36345,99190,-56654,-464,0,600,0),
(120,null,36334,99563,-57017,-288,32768,600,0),
(120,null,36334,99563,-57049,-288,32768,600,0),
(120,null,36346,99595,-57017,-288,32768,600,0),
(120,null,36345,99595,-57049,-288,32768,600,0),
(120,null,36334,99222,-56019,-464,0,600,0),
(120,null,36334,99222,-56051,-464,0,600,0),
(120,null,36346,99190,-56019,-464,0,600,0),
(120,null,36345,99190,-56051,-464,0,600,0),
(120,null,36334,99560,-55688,-288,32768,600,0),
(120,null,36334,99560,-55656,-288,32768,600,0),
(120,null,36346,99592,-55688,-288,32768,600,0),
(120,null,36345,99592,-55656,-288,32768,600,0),
(120,null,36334,99336,-56783,-200,16384,600,0),
(120,null,36334,99371,-56751,-200,16384,600,0),
(120,null,36333,100094,-55305,-640,32768,600,0),
(120,null,36334,99336,-56751,-200,16384,600,0),
(120,null,36334,99336,-55926,-200,49151,600,0),
(120,null,36334,99304,-55958,-200,49151,600,0),
(120,null,36334,99368,-55958,-200,49151,600,0),
(120,null,36334,99336,-55958,-200,49151,600,0),
(120,null,36334,99776,-56224,-640,37988,600,0),
(120,null,36334,99680,-56080,-640,37988,600,0),
(120,null,36334,99744,-56176,-640,37988,600,0),
(120,null,36334,99712,-56128,-640,37988,600,0),
(120,null,36334,99680,-56176,-640,37988,600,0),
(120,null,36334,99104,-57168,-264,32768,600,0),
(120,null,36334,99104,-57136,-264,32768,600,0),
(120,null,36333,100094,-55369,-640,32768,600,0),
(120,null,36333,100094,-55337,-640,32768,600,0),
(120,null,36333,99107,-56322,-640,32768,600,0),
(120,null,36333,99107,-56418,-640,32768,600,0),
(120,null,36333,99107,-56354,-640,32768,600,0),
(120,null,36333,99107,-56386,-640,32768,600,0),
(120,null,36346,99440,-53876,-616,52868,600,0),
(120,null,36345,99608,-53789,-616,44316,600,0),
(120,null,36346,99712,-54134,-616,27680,600,0),
(120,null,36345,99676,-53977,-616,34940,600,0),
(120,null,36345,99671,-54236,-616,24092,600,0),
(120,null,36345,99427,-54218,-616,12368,600,0),
(120,null,36334,99104,-55280,-264,32768,600,0),
(120,null,36334,99104,-55248,-264,32768,600,0),
(120,null,36334,99104,-54448,-264,32768,600,0),
(120,null,36334,99104,-54416,-264,32768,600,0),
(120,null,36333,100095,-55273,-640,32768,600,0),
(120,null,36334,100064,-52768,-264,16384,600,0),
(120,null,36334,100112,-52768,-264,16384,600,0),
(120,null,36351,100968,-52973,-640,0,0,0),
(120,null,36334,101056,-52784,-264,16384,600,0),
(120,null,36334,101088,-52784,-264,16384,600,0),
(120,null,36334,101712,-52912,-264,8556,600,0),
(120,null,36334,101728,-52928,-264,8556,600,0),

-- Monastic Guards
(121,null,36384,71489,-92828,-1248,45600,600,0),
(121,null,36372,71480,-92852,-1248,45600,600,0),
(121,null,36371,71822,-92889,-1424,12456,600,0),
(121,null,36371,71758,-92864,-1431,12456,600,0),
(121,null,36371,71854,-92902,-1424,12456,600,0),
(121,null,36371,71790,-92876,-1424,12456,600,0),
(121,null,36372,71072,-92560,-1048,12304,600,0),
(121,null,36372,71104,-92576,-1048,12304,600,0),
(121,null,36372,71372,-92913,-984,61424,600,0),
(121,null,36381,70249,-94036,-1400,28812,600,0),
(121,null,36381,70263,-94003,-1400,28812,600,0),
(121,null,36381,70276,-93970,-1400,28812,600,0),
(121,null,36381,70290,-93936,-1400,28812,600,0),
(121,null,36381,70302,-93903,-1400,28812,600,0),
(121,null,36380,70266,-93889,-1400,28812,600,0),
(121,null,36380,70210,-94023,-1400,28812,600,0),
(121,null,36380,70252,-93922,-1400,28812,600,0),
(121,null,36380,70225,-93988,-1400,28812,600,0),
(121,null,36380,70238,-93955,-1400,28812,600,0),
(121,null,36372,71507,-92862,-1248,45600,600,0),
(121,null,36383,71516,-92837,-1248,45600,600,0),
(121,null,36372,71035,-93057,-1072,12600,600,0),
(121,null,36372,71006,-93045,-1072,12600,600,0),
(121,null,36384,71025,-93081,-1072,12600,600,0),
(121,null,36383,70996,-93070,-1072,12600,600,0),
(121,null,36372,71331,-92932,-984,61424,600,0),
(121,null,36372,71348,-92973,-984,61424,600,0),
(121,null,36372,71360,-92944,-984,61424,600,0),
(121,null,36372,69888,-93360,-1048,28820,600,0),
(121,null,36372,69904,-93321,-1048,28820,600,0),
(121,null,36370,71771,-94143,-1056,28812,600,0),
(121,null,36370,71757,-94176,-1056,28812,600,0),
(121,null,36370,71743,-94208,-1056,28812,600,0),
(121,null,36384,73623,-94208,-1400,4688,600,0),
(121,null,36383,73556,-94135,-1400,1184,600,0),
(121,null,36383,73717,-94018,-1400,58180,600,0),
(121,null,36372,71765,-93634,-1424,17048,600,0),
(121,null,36384,72112,-93079,-1248,45104,600,0),
(121,null,36372,72101,-93103,-1248,45104,600,0),
(121,null,36372,72297,-93580,-1072,12248,600,0),
(121,null,36372,72073,-93091,-1248,45104,600,0),
(121,null,36383,72084,-93067,-1248,45104,600,0),
(121,null,36384,72259,-93593,-1072,12248,600,0),
(121,null,36372,72268,-93569,-1072,12248,600,0),
(121,null,36383,72286,-93604,-1072,12248,600,0),
(121,null,36372,72138,-93256,-984,29160,600,0),
(121,null,36372,72124,-93215,-984,29160,600,0),
(121,null,36372,72099,-93280,-984,29160,600,0),
(121,null,36372,72112,-93248,-984,29160,600,0),
(121,null,36372,71893,-93625,-1424,17048,600,0),
(121,null,36372,71849,-93629,-1424,17048,600,0),
(121,null,36372,71807,-93632,-1424,17048,600,0),
(121,null,36372,71825,-93586,-1424,17048,600,0),
(121,null,36372,73584,-93600,-1048,12304,600,0),
(121,null,36372,73616,-93616,-1048,12304,600,0),
(121,null,36372,72848,-93296,-1048,12304,600,0),
(121,null,36372,72816,-93280,-1048,12304,600,0),
(121,null,36371,72423,-94197,-1424,12456,600,0),
(121,null,36371,72387,-94182,-1424,12456,600,0),
(121,null,36371,72353,-94169,-1424,12456,600,0),
(121,null,36372,69472,-94736,-1048,36416,600,0),
(121,null,36372,69488,-94768,-1048,36416,600,0),
(121,null,36372,69536,-94224,-1048,28820,600,0),
(121,null,36389,72939,-95085,-1424,0,0,0),
(121,null,36371,72458,-94212,-1424,12456,600,0),
(121,null,36372,69520,-94256,-1048,28820,600,0),
(121,null,36370,71555,-94880,-904,12272,600,0),
(121,null,36370,71585,-94892,-904,12272,600,0),
(121,null,36370,71614,-94904,-904,12272,600,0),
(121,null,36389,69741,-94242,-1424,0,0,0),
(121,null,36389,71327,-94354,-1424,0,0,0),
(121,null,36372,70864,-95856,-1048,44884,600,0),
(121,null,36372,71632,-96176,-1048,44884,600,0),
(121,null,36372,71600,-96160,-1048,44884,600,0),
(121,null,36372,70832,-95840,-1048,44884,600,0),
(121,null,36372,70048,-95520,-1048,44884,600,0),
(121,null,36372,70096,-95536,-1048,44884,600,0),
(121,null,36383,72032,-95812,-1072,45336,600,0),
(121,null,36370,72354,-95235,-712,28812,600,0),
(121,null,36370,72330,-95294,-712,28812,600,0),
(121,null,36370,72342,-95265,-712,28812,600,0),
(121,null,36370,72493,-94582,-536,12456,600,0),
(121,null,36370,72525,-94594,-536,12456,600,0),
(121,null,36370,72461,-94568,-536,12456,600,0),
(121,null,36370,72429,-94556,-536,12456,600,0),
(121,null,36370,72365,-94532,-536,12456,600,0),
(121,null,36370,72397,-94544,-536,12456,600,0),
(121,null,36370,72333,-94519,-536,12456,600,0),
(121,null,36370,72300,-94506,-536,12456,600,0),
(121,null,36369,72177,-94880,-504,45152,600,0),
(121,null,36369,72146,-94868,-504,45152,600,0),
(121,null,36369,72115,-94856,-504,45152,600,0),
(121,null,36369,72254,-94692,-504,12456,600,0),
(121,null,36369,72084,-94844,-504,45152,600,0),
(121,null,36369,72221,-94679,-504,12456,600,0),
(121,null,36369,72187,-94666,-504,12456,600,0),
(121,null,36369,72154,-94653,-504,12456,600,0),
(121,null,36368,72195,-94701,-504,12456,600,0),
(121,null,36386,73587,-95156,-1352,12456,600,0),
(121,null,36386,73496,-95194,-1344,28812,600,0),
(121,null,36386,73373,-95502,-1344,28812,600,0),
(121,null,36386,73415,-95576,-1352,44872,600,0),
(121,null,36386,73664,-95440,-1352,0,600,0),
(121,null,36386,73549,-95662,-1240,12456,600,0),
(121,null,36386,73517,-95650,-1240,12456,600,0),
(121,null,36383,73647,-94295,-1400,8212,600,0),
(121,null,36372,72052,-95858,-1072,45336,600,0),
(121,null,36372,72019,-95844,-1072,45336,600,0),
(121,null,36384,72064,-95826,-1072,45336,600,0),
(121,null,36372,72186,-96154,-984,61072,600,0),
(121,null,36372,72199,-96196,-984,61072,600,0),
(121,null,36372,72225,-96137,-984,61072,600,0),
(121,null,36372,72213,-96166,-984,61072,600,0),
(121,null,36372,72679,-95988,-1424,48408,600,0),
(121,null,36372,72612,-96024,-1424,48408,600,0),
(121,null,36372,72635,-95986,-1424,48408,600,0),
(121,null,36372,72548,-95982,-1424,48408,600,0),
(121,null,36372,72592,-95984,-1424,48408,600,0),
(121,null,36371,71880,-95321,-1424,44872,600,0),
(121,null,36371,71912,-95334,-1424,44872,600,0),
(121,null,36371,71945,-95348,-1424,44872,600,0),
(121,null,36371,71977,-95361,-1424,44872,600,0),
(121,null,36386,73801,-95215,-1240,44872,600,0),
(121,null,36386,73770,-95720,-1352,44872,600,0),
(121,null,36386,73834,-95229,-1240,44872,600,0),
(121,null,36386,73855,-95686,-1352,61404,600,0),
(121,null,36386,73979,-95392,-1344,61404,600,0),
(121,null,36384,73987,-94125,-1400,34024,600,0),
(121,null,36372,74384,-96048,-1048,61356,600,0),
(121,null,36372,74368,-96080,-1048,61356,600,0),
(121,null,36389,74346,-95685,-1424,0,0,0),
(121,null,36383,73813,-94313,-1400,15520,600,0),
(121,null,36386,73937,-95304,-1352,12456,600,0),
(121,null,36372,74768,-95152,-1048,61356,600,0),
(121,null,36372,74752,-95184,-1048,61356,600,0),
(121,null,36371,72466,-96510,-1424,44872,600,0),
(121,null,36371,72499,-96524,-1424,44872,600,0),
(121,null,36372,73184,-96816,-1048,44884,600,0),
(121,null,36372,73984,-96624,-1048,53408,600,0),
(121,null,36372,74016,-96608,-1048,53408,600,0),
(121,null,36371,72530,-96537,-1424,44872,600,0),
(121,null,36371,72435,-96496,-1424,44872,600,0),
(121,null,36372,73216,-96832,-1048,44884,600,0),
(121,null,36372,72929,-96499,-984,28696,600,0),
(121,null,36372,72942,-96468,-984,28696,600,0),
(121,null,36372,72975,-96481,-984,28696,600,0),
(121,null,36372,72246,-96313,-1248,12200,600,0),
(121,null,36372,72955,-96437,-984,28696,600,0),
(121,null,36372,73277,-96353,-1072,44848,600,0),
(121,null,36372,72218,-96300,-1248,12200,600,0),
(121,null,36372,73305,-96364,-1072,44848,600,0),
(121,null,36384,73286,-96329,-1072,44848,600,0),
(121,null,36383,73315,-96341,-1072,44848,600,0),
(121,null,36372,72834,-96557,-1248,12304,600,0),
(121,null,36372,72806,-96547,-1248,12304,600,0),
(121,null,36384,72796,-96571,-1248,12304,600,0),
(121,null,36383,72824,-96582,-1248,12304,600,0),
(121,null,36384,72236,-96339,-1248,12200,600,0),
(121,null,36383,72207,-96327,-1248,12200,600,0);