/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectLaunchModesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectLaunchersDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab2;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class LaunchConfigurationTabGroupViewer {
    private ILaunchConfigurationDialog fDialog;
    private ILaunchConfiguration fOriginal;
    private ILaunchConfigurationWorkingCopy fWorkingCopy;
    private Composite fViewerControl;
    private Text fNameWidget;
    private Composite fGroupComposite;
    private CTabFolder fTabFolder;
    private ILaunchConfigurationTabGroup fTabGroup;
    private int fCurrentTabIndex = -1;
    private Button fApplyButton;
    private Button fRevertButton;
    private boolean fDisposingTabs = false;
    private boolean fInitializingTabs = false;
    private String fDescription = null;
    private Composite fTabPlaceHolder = null;
    private Link fOptionsLink = null;
    private Label fOptionsErrorLabel = null;
    private Composite fGettingStarted = null;
    private ViewForm fViewform;
    private Job fRefreshJob;

    public LaunchConfigurationTabGroupViewer(Composite parent, ILaunchConfigurationDialog dialog) {
        this.fDialog = dialog;
        this.createControl(parent);
    }

    public void dispose() {
        this.disposeTabGroup();
    }

    protected void disposeTabGroup() {
        if (this.fTabGroup != null) {
            this.fTabGroup.dispose();
            this.fTabGroup = null;
        }
    }

    private void createControl(Composite parent) {
        this.fViewerControl = parent;
        this.fViewform = new ViewForm(parent, 0x800800);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fViewform.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.fViewform.setLayoutData((Object)gd);
        this.fViewform.setTopLeft(null);
        Composite mainComp = SWTFactory.createComposite((Composite)this.fViewform, this.fViewform.getFont(), 1, 1, 1, 0, 0);
        this.fViewform.setContent((Control)mainComp);
        this.fTabPlaceHolder = SWTFactory.createComposite(mainComp, 1, 1, 1808);
        this.fTabPlaceHolder.setLayout((Layout)new StackLayout());
        this.fGettingStarted = SWTFactory.createComposite(this.fTabPlaceHolder, 1, 1, 1808);
        this.createGettingStarted(this.fGettingStarted);
        this.fGroupComposite = SWTFactory.createComposite(this.fTabPlaceHolder, this.fTabPlaceHolder.getFont(), 2, 2, 1808, 5, 5);
        SWTFactory.createLabel(this.fGroupComposite, LaunchConfigurationsMessages.LaunchConfigurationDialog__Name__16, 1);
        this.fNameWidget = new Text(this.fGroupComposite, 2052);
        this.fNameWidget.setLayoutData((Object)new GridData(768));
        this.fNameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!LaunchConfigurationTabGroupViewer.this.fInitializingTabs) {
                    LaunchConfigurationTabGroupViewer.this.handleNameModified();
                }
            }
        });
        this.createTabFolder(this.fGroupComposite);
        Composite blComp = SWTFactory.createComposite(mainComp, mainComp.getFont(), 2, 1, 768);
        Composite linkComp = SWTFactory.createComposite(blComp, blComp.getFont(), 2, 1, 768);
        this.fOptionsErrorLabel = new Label(linkComp, 0);
        gd = new GridData();
        this.fOptionsErrorLabel.setLayoutData((Object)gd);
        this.fOptionsLink = new Link(linkComp, 64);
        this.fOptionsLink.setFont(linkComp.getFont());
        gd = new GridData(16384);
        gd.grabExcessHorizontalSpace = true;
        this.fOptionsLink.setLayoutData((Object)gd);
        this.fOptionsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SelectLaunchersDialog sldd;
                    if (!LaunchConfigurationTabGroupViewer.this.canLaunchWithModes()) {
                        Object[] res;
                        SelectLaunchModesDialog sld = new SelectLaunchModesDialog(LaunchConfigurationTabGroupViewer.this.getShell(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode(), (ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.getWorkingCopy());
                        if (sld.open() == 0 && (res = sld.getResult()) != null) {
                            Set modes = (Set)res[0];
                            modes.remove(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                            ILaunchConfigurationWorkingCopy wc = LaunchConfigurationTabGroupViewer.this.getWorkingCopy();
                            wc.setModes(modes);
                            LaunchConfigurationTabGroupViewer.this.refreshStatus();
                        }
                    } else if (LaunchConfigurationTabGroupViewer.this.hasMultipleDelegates() && (sldd = new SelectLaunchersDialog(LaunchConfigurationTabGroupViewer.this.getShell(), LaunchConfigurationTabGroupViewer.this.getWorkingCopy().getType().getDelegates(LaunchConfigurationTabGroupViewer.this.getCurrentModeSet()), LaunchConfigurationTabGroupViewer.this.getWorkingCopy(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode())).open() == 0) {
                        LaunchConfigurationTabGroupViewer.this.displayInstanceTabs(true);
                        LaunchConfigurationTabGroupViewer.this.refreshStatus();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
        this.fOptionsLink.setVisible(false);
        Composite buttonComp = SWTFactory.createComposite(blComp, 2, 1, 128);
        this.fApplyButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.LaunchConfigurationDialog__Apply_17, null, 128);
        this.fApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleApplyPressed();
            }
        });
        this.fRevertButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.LaunchConfigurationDialog_Revert_2, null, 128);
        this.fRevertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleRevertPressed();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    private void createGettingStarted(Composite parent) {
        Font font = parent.getFont();
        GridData gd = null;
        int width = parent.getBounds().width - 30;
        SWTFactory.createWrapLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_1, 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_2, DebugUITools.getImage("IMG_ELCL_NEW_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_6, DebugUITools.getImage("IMG_ELCL_DUPLICATE_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_4, DebugUITools.getImage("IMG_ELCL_DELETE_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_8, DebugUITools.getImage("IMG_ELCL_FILTER_CONFIGS"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_3, DebugUITools.getImage("IMG_OVR_TRANSPARENT"), 1, width);
        SWTFactory.createHorizontalSpacer(parent, 2);
        Link link = new Link(parent, 16448);
        link.setText(LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_5);
        link.setFont(font);
        gd = new GridData(768);
        gd.widthHint = width;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.PerspectivePreferencePage");
            }
        });
    }

    private void createTabFolder(Composite parent) {
        if (this.fTabFolder == null) {
            ColorRegistry reg = JFaceResources.getColorRegistry();
            Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            this.fTabFolder = new CTabFolder(parent, 0x900000);
            this.fTabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
            this.fTabFolder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
            this.fTabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            this.fTabFolder.setBorderVisible(true);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.fTabFolder.setLayoutData((Object)gd);
            this.fTabFolder.setFont(parent.getFont());
            this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!LaunchConfigurationTabGroupViewer.this.fInitializingTabs) {
                        LaunchConfigurationTabGroupViewer.this.handleTabSelected();
                        LaunchConfigurationTabGroupViewer.this.refresh();
                    }
                }
            });
        }
    }

    protected Button getApplyButton() {
        return this.fApplyButton;
    }

    protected Button getRevertButton() {
        return this.fRevertButton;
    }

    public void setName(String name) {
        if (this.getWorkingCopy() != null) {
            if (name == null) {
                this.fNameWidget.setText("");
            } else {
                this.fNameWidget.setText(name.trim());
            }
            this.refreshStatus();
        }
    }

    public Control getControl() {
        return this.fViewerControl;
    }

    private Shell getShell() {
        return this.getControl().getShell();
    }

    public Object getInput() {
        return this.getConfiguration();
    }

    public void refresh() {
        if (this.fInitializingTabs) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs != null) {
            boolean newwc = !this.getWorkingCopy().isDirty();
            ILaunchConfigurationTab tab = this.getActiveTab();
            if (tab != null) {
                tab.performApply(this.getWorkingCopy());
            }
            if (this.fOriginal instanceof ILaunchConfigurationWorkingCopy && newwc) {
                try {
                    ILaunchConfigurationWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        copy.doSave();
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            this.updateButtons();
            CTabItem item = null;
            boolean error = false;
            Image image = null;
            int i = 0;
            while (i < tabs.length) {
                item = this.fTabFolder.getItem(i);
                image = tabs[i].getImage();
                item.setImage(image);
                if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                    boolean bl = error = tabs[i].getErrorMessage() != null;
                    if (error) {
                        item.setImage(DebugUIPlugin.getDefault().getLaunchConfigurationManager().getErrorTabImage(tabs[i]));
                    }
                }
                ++i;
            }
            this.showLink();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    private void showLink() {
        String text = null;
        if (!this.canLaunchWithModes()) {
            text = LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_13;
        } else if (this.hasMultipleDelegates()) {
            String name;
            ILaunchDelegate delegate = this.getPreferredDelegate();
            text = delegate != null ? ((name = delegate.getName()) == null ? LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_15 : MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_16, (Object[])new Object[]{name})) : LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_17;
        }
        if (text != null) {
            this.fOptionsLink.setText(text);
        }
        this.fOptionsLink.setVisible(!this.canLaunchWithModes() || this.hasMultipleDelegates());
        if (this.hasDuplicateDelegates()) {
            this.fOptionsErrorLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        } else {
            this.fOptionsErrorLabel.setImage(null);
        }
        this.fViewform.layout(true, true);
    }

    protected ILaunchDelegate getPreferredDelegate() {
        ILaunchDelegate preferred = null;
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                Set<String> modes = this.getCurrentModeSet();
                preferred = config.getPreferredDelegate(modes);
                if (preferred == null) {
                    preferred = config.getType().getPreferredDelegate(modes);
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return preferred;
    }

    private Set<String> getCurrentModeSet() {
        HashSet<String> set = new HashSet<String>();
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                set.addAll(config.getModes());
                set.add(this.getLaunchConfigurationDialog().getMode());
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return set;
    }

    ILaunchConfiguration getConfiguration() {
        if (this.fOriginal == null) {
            return this.getWorkingCopy();
        }
        return this.fOriginal;
    }

    private void updateButtons() {
        boolean dirty = this.isDirty() && this.canSave();
        this.fApplyButton.setEnabled(dirty);
        this.fRevertButton.setEnabled(dirty);
    }

    public void setInput(final Object input) {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            this.setInput0(input);
        } else {
            DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LaunchConfigurationTabGroupViewer.this.setInput0(input);
                }
            });
        }
    }

    private void setInput0(Object input) {
        if (input == null) {
            if (this.getConfiguration() == null) {
                return;
            }
            this.inputChanged(input);
        } else if (!input.equals(this.getConfiguration())) {
            this.inputChanged(input);
        }
    }

    protected void inputChanged(Object input) {
        final Object finput = input;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        try {
                            LaunchConfigurationTabGroupViewer.this.fViewform.setRedraw(false);
                            if (finput instanceof ILaunchConfiguration) {
                                ILaunchConfiguration configuration = (ILaunchConfiguration)finput;
                                boolean refreshtabs = !LaunchConfigurationTabGroupViewer.this.delegatesEqual((ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.fWorkingCopy, configuration);
                                LaunchConfigurationTabGroupViewer.this.fOriginal = configuration;
                                LaunchConfigurationTabGroupViewer.this.fWorkingCopy = configuration.getWorkingCopy();
                                LaunchConfigurationTabGroupViewer.this.displayInstanceTabs(refreshtabs);
                                break block7;
                            }
                            if (finput instanceof ILaunchConfigurationType) {
                                LaunchConfigurationTabGroupViewer.this.fDescription = LaunchConfigurationTabGroupViewer.this.getDescription((ILaunchConfigurationType)finput);
                                LaunchConfigurationTabGroupViewer.this.setNoInput();
                                break block7;
                            }
                            LaunchConfigurationTabGroupViewer.this.setNoInput();
                        }
                        catch (CoreException ce) {
                            LaunchConfigurationTabGroupViewer.this.errorDialog(ce);
                            LaunchConfigurationTabGroupViewer.this.setNoInput();
                            LaunchConfigurationTabGroupViewer.this.refreshStatus();
                            LaunchConfigurationTabGroupViewer.this.fViewform.setRedraw(true);
                        }
                    }
                    finally {
                        LaunchConfigurationTabGroupViewer.this.refreshStatus();
                        LaunchConfigurationTabGroupViewer.this.fViewform.setRedraw(true);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    private void setNoInput() {
        this.fOriginal = null;
        this.fWorkingCopy = null;
        this.disposeExistingTabs();
        this.updateButtons();
        this.updateVisibleControls(false);
        ILaunchConfigurationDialog lcd = this.getLaunchConfigurationDialog();
        if (lcd instanceof LaunchConfigurationsDialog && ((LaunchConfigurationsDialog)lcd).isTreeSelectionEmpty()) {
            this.fDescription = "";
        }
    }

    protected boolean delegatesEqual(ILaunchConfiguration config1, ILaunchConfiguration config2) {
        block7: {
            if (config1 != null && config2 != null) break block7;
            return false;
        }
        try {
            if (config1.getType().equals(config2.getType())) {
                ILaunchDelegate d2;
                Set<String> modes = this.getCurrentModeSet();
                ILaunchDelegate d1 = config1.getPreferredDelegate(modes);
                if (d1 == null) {
                    d1 = config1.getType().getPreferredDelegate(modes);
                }
                if ((d2 = config2.getPreferredDelegate(modes)) == null) {
                    d2 = config2.getType().getPreferredDelegate(modes);
                }
                if (d1 == null) {
                    return d2 == null;
                }
                return d1.equals(d2);
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return false;
    }

    private void updateVisibleControls(boolean visible) {
        this.fApplyButton.setVisible(visible);
        this.fRevertButton.setVisible(visible);
        this.fOptionsLink.setVisible(visible);
        ((StackLayout)this.fTabPlaceHolder.getLayout()).topControl = visible ? this.fGroupComposite : this.fGettingStarted;
        this.fTabPlaceHolder.layout(true, true);
    }

    protected void setFocusOnName() {
        this.fNameWidget.setFocus();
    }

    protected void displayInstanceTabs(boolean redrawTabs) {
        this.fInitializingTabs = true;
        ILaunchConfigurationType type = null;
        try {
            type = this.getWorkingCopy().getType();
        }
        catch (CoreException e) {
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        if (redrawTabs) {
            this.showInstanceTabsFor(type);
        }
        this.updateVisibleControls(true);
        ILaunchConfigurationTabGroup tabGroup = this.getTabGroup();
        if (tabGroup == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_No_tabs_defined_for_launch_configuration_type__0__1, (Object[])new Object[]{type.getName()}), null);
            CoreException e = new CoreException((IStatus)status);
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        tabGroup.initializeFrom((ILaunchConfiguration)this.getWorkingCopy());
        this.fNameWidget.setText(this.getWorkingCopy().getName());
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
        this.fInitializingTabs = false;
        if (!this.fViewform.isVisible()) {
            this.fViewform.setVisible(true);
        }
    }

    private void showInstanceTabsFor(ILaunchConfigurationType configType) {
        Class<?> tabKind = null;
        if (this.getActiveTab() != null) {
            tabKind = this.getActiveTab().getClass();
        }
        ILaunchConfigurationTabGroup group = null;
        try {
            group = this.createGroup();
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_creating_launch_configuration_tabs_27, ce);
            return;
        }
        this.disposeExistingTabs();
        this.fTabGroup = group;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        CTabItem tab = null;
        String name = "";
        Control control = null;
        int i = 0;
        while (i < tabs.length) {
            tab = new CTabItem(this.fTabFolder, 2048);
            name = tabs[i].getName();
            if (name == null) {
                name = LaunchConfigurationsMessages.LaunchConfigurationDialog_unspecified_28;
            }
            tab.setText(name);
            tab.setImage(tabs[i].getImage());
            ScrolledComposite sc = new ScrolledComposite((Composite)tab.getParent(), 768);
            sc.setFont(tab.getParent().getFont());
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setShowFocusedControl(true);
            tabs[i].createControl((Composite)sc);
            control = tabs[i].getControl();
            if (control != null) {
                sc.setContent(control);
                sc.setMinSize(control.computeSize(-1, -1));
                tab.setControl((Control)control.getParent());
            }
            ++i;
        }
        if (tabs.length > 0) {
            this.setActiveTab(tabs[0]);
        }
        i = 0;
        while (i < tabs.length) {
            if (tabs[i].getClass().equals(tabKind)) {
                this.setActiveTab(tabs[i]);
                break;
            }
            ++i;
        }
        this.fDescription = this.getDescription(configType);
    }

    private String getDescription(ILaunchConfigurationType configType) {
        String description = null;
        if (configType != null) {
            String mode = this.fDialog.getMode();
            description = LaunchConfigurationPresentationManager.getDefault().getDescription(configType, mode);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    protected ILaunchConfigurationTabGroup createGroup() throws CoreException {
        final Object[] finalArray = new Object[2];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ILaunchConfigurationTabGroup tabGroup = null;
                try {
                    tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.getWorkingCopy(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                    finalArray[0] = tabGroup;
                }
                catch (CoreException ce) {
                    finalArray[1] = ce;
                    return;
                }
                tabGroup.createTabs(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].setLaunchConfigurationDialog(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog());
                    ++i;
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)runnable);
        if (finalArray[1] != null) {
            throw (CoreException)((Object)finalArray[1]);
        }
        return (ILaunchConfigurationTabGroup)finalArray[0];
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() != null) {
            return this.getTabGroup().getTabs();
        }
        return null;
    }

    public ILaunchConfigurationTab getActiveTab() {
        int pageIndex;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fTabFolder != null && tabs != null && (pageIndex = this.fTabFolder.getSelectionIndex()) >= 0) {
            return tabs[pageIndex];
        }
        return null;
    }

    public boolean isDirty() {
        ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return false;
        }
        if (workingCopy.getParent() != null) {
            return !workingCopy.getParent().contentsEqual((ILaunchConfiguration)workingCopy);
        }
        if (workingCopy.getOriginal() == null) {
            return true;
        }
        return this.fOriginal != null && !this.fOriginal.contentsEqual((ILaunchConfiguration)workingCopy);
    }

    private Job getUpdateJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = this.createUpdateJob();
            this.fRefreshJob.setSystem(true);
        }
        return this.fRefreshJob;
    }

    protected void scheduleUpdateJob() {
        Job job = this.getUpdateJob();
        job.cancel();
        job.schedule(this.getUpdateJobDelay());
    }

    protected long getUpdateJobDelay() {
        return 200L;
    }

    protected Job createUpdateJob() {
        return new WorkbenchJob(this.getControl().getDisplay(), "Update LCD"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!LaunchConfigurationTabGroupViewer.this.getControl().isDisposed()) {
                    LaunchConfigurationTabGroupViewer.this.refreshStatus();
                }
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !LaunchConfigurationTabGroupViewer.this.getControl().isDisposed();
            }
        };
    }

    protected void refreshStatus() {
        if (!this.fInitializingTabs) {
            LaunchConfigurationsDialog lcd = (LaunchConfigurationsDialog)this.getLaunchConfigurationDialog();
            lcd.refreshStatus();
        }
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fDialog;
    }

    protected ILaunchConfiguration getOriginal() {
        return this.fOriginal;
    }

    protected ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public boolean canSave() {
        if (this.fInitializingTabs) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].canSave()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.fInitializingTabs) {
            return false;
        }
        if (this.getWorkingCopy() == null) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canLaunchWithModes() {
        if (this.fInitializingTabs) {
            return false;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                return wc.getType().supportsModeCombination(this.getCurrentModeSet());
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public boolean hasDuplicateDelegates() {
        if (this.fInitializingTabs) {
            return false;
        }
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null && this.hasMultipleDelegates()) {
            return this.getPreferredDelegate() == null;
        }
        return false;
    }

    private boolean hasMultipleDelegates() {
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                Set<String> modes = this.getCurrentModeSet();
                ILaunchDelegate[] delegates = LaunchConfigurationManager.filterLaunchDelegates(config.getType(), modes);
                return delegates.length > 1;
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return false;
    }

    public String getErrorMesssage() {
        if (this.fInitializingTabs) {
            return null;
        }
        if (this.getWorkingCopy() == null) {
            return null;
        }
        try {
            this.verifyName();
        }
        catch (CoreException ce) {
            return ce.getStatus().getMessage();
        }
        if (this.hasDuplicateDelegates()) {
            return LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_18;
        }
        String message = null;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab == null) {
            return null;
        }
        message = activeTab.getErrorMessage();
        if (message != null) {
            return message;
        }
        ILaunchConfigurationTab[] allTabs = this.getTabs();
        int i = 0;
        while (i < allTabs.length) {
            ILaunchConfigurationTab tab = allTabs[i];
            if (tab != activeTab && (message = tab.getErrorMessage()) != null) {
                StringBuffer temp = new StringBuffer();
                temp.append('[');
                temp.append(DebugUIPlugin.removeAccelerators(tab.getName()));
                temp.append("]: ");
                temp.append(message);
                return temp.toString();
            }
            ++i;
        }
        if (!this.canLaunchWithModes()) {
            Set<String> modes = this.getCurrentModeSet();
            List<String> names = LaunchConfigurationPresentationManager.getDefault().getLaunchModeNames(modes);
            return MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_14, (Object[])new Object[]{names.toString()});
        }
        return null;
    }

    public String getMessage() {
        String tabMessage;
        if (this.fInitializingTabs) {
            return null;
        }
        String message = this.fDescription;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab != null && (tabMessage = tab.getMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    public String getWarningMessage() {
        String tabMessage;
        if (this.fInitializingTabs) {
            return null;
        }
        String message = null;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab instanceof ILaunchConfigurationTab2 && (tabMessage = ((ILaunchConfigurationTab2)tab).getWarningMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    protected void verifyName() throws CoreException {
        if (this.fNameWidget.isVisible()) {
            ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
            String currentName = this.fNameWidget.getText().trim();
            if (currentName.length() < 1) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_Name_required_for_launch_configuration_11, null));
            }
            try {
                mgr.isValidLaunchConfigurationName(currentName);
            }
            catch (IllegalArgumentException iae) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, iae.getMessage(), null));
            }
            if (this.fOriginal != null && !this.fOriginal.getName().equals(currentName)) {
                Set<String> reservednames = ((LaunchConfigurationsDialog)this.getLaunchConfigurationDialog()).getReservedNameSet();
                if (mgr.isExistingLaunchConfigurationName(currentName) || reservednames != null && reservednames.contains(currentName)) {
                    ILaunchConfiguration config = ((LaunchManager)mgr).findLaunchConfiguration(currentName);
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, NLS.bind((String)LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_configuration_already_exists_with_this_name_12, (Object)config.getType().getName()), null));
                }
            }
        }
    }

    private void disposeExistingTabs() {
        this.fDisposingTabs = true;
        this.fTabFolder.dispose();
        this.fTabFolder = null;
        this.createTabFolder(this.fGroupComposite);
        this.disposeTabGroup();
        this.fDisposingTabs = false;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        return this.fTabGroup;
    }

    protected void handleTabSelected() {
        if (this.fDisposingTabs || this.fInitializingTabs) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fCurrentTabIndex == this.fTabFolder.getSelectionIndex() || tabs == null || tabs.length == 0 || this.fCurrentTabIndex > tabs.length - 1) {
            return;
        }
        if (this.fCurrentTabIndex != -1) {
            ILaunchConfigurationTab tab = tabs[this.fCurrentTabIndex];
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                tab.deactivated(wc);
                this.getActiveTab().activated(wc);
            }
        }
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
    }

    protected void handleNameModified() {
        this.getWorkingCopy().rename(this.fNameWidget.getText().trim());
        this.scheduleUpdateJob();
    }

    protected ILaunchConfiguration handleApplyPressed() {
        IStatus status;
        if (this.fOriginal != null && this.fOriginal.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.fOriginal.getFile()}, (Object)this.fViewerControl.getShell())).isOK()) {
            return null;
        }
        Throwable exception = null;
        final ILaunchConfiguration[] saved = new ILaunchConfiguration[1];
        try {
            this.fInitializingTabs = true;
            String trimmed = this.fNameWidget.getText().trim();
            this.fNameWidget.setText(trimmed);
            if (this.fWorkingCopy == null) {
                this.fWorkingCopy = this.fOriginal.getWorkingCopy();
            }
            this.fWorkingCopy.rename(trimmed);
            this.getTabGroup().performApply(this.fWorkingCopy);
            if (this.isDirty()) {
                if (!this.fWorkingCopy.isLocal()) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                saved[0] = ((LaunchConfigurationWorkingCopy)LaunchConfigurationTabGroupViewer.this.fWorkingCopy).doSave(monitor);
                            }
                            catch (CoreException e) {
                                DebugUIPlugin.log(e);
                            }
                        }
                    };
                    this.getLaunchConfigurationDialog().run(true, false, runnable);
                } else {
                    saved[0] = this.fWorkingCopy.doSave();
                }
            }
            this.updateButtons();
            this.fInitializingTabs = false;
        }
        catch (CoreException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = e;
        }
        if (exception != null) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configuration_Error_46, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_while_saving_launch_configuration_47, exception);
            return null;
        }
        return saved[0];
    }

    protected void handleRevertPressed() {
        try {
            if (this.fTabGroup != null) {
                this.fTabGroup.initializeFrom(this.fOriginal);
                this.fNameWidget.setText(this.fOriginal.getName());
                this.fWorkingCopy = this.fOriginal.getWorkingCopy();
                this.refreshStatus();
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    protected void errorDialog(CoreException exception) {
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)exception.getStatus());
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs != null) {
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i].getClass().equals(tab.getClass())) {
                    this.setActiveTab(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void setActiveTab(int index) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (index >= 0 && index < tabs.length) {
            this.fTabFolder.setSelection(index);
            this.handleTabSelected();
        }
    }
}

