/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.util.OutputStreamMonitor;
import org.epic.debug.util.RemotePort;

public class CGIProxy
extends PlatformObject
implements IProcess,
ITerminate {
    private volatile boolean mIsConnected;
    private Thread mWaitThread;
    private OutputStreamMonitor mMonitorError;
    private OutputStreamMonitor mMonitorOut;
    private OutputStreamMonitor mMonitorIn;
    private ILaunch mLaunch;
    private String mLabel;
    private RemotePort mInStream;
    private RemotePort mOutStream;
    private RemotePort mErrorStream;
    private boolean mIsTerminated;
    private IStreamsProxy mStreamsProxy;

    public CGIProxy(ILaunch fLaunch, String fLabel) {
        this.mLaunch = fLaunch;
        this.setAttribute(ATTR_PROCESS_TYPE, "EpicCGIProxy");
        this.mIsConnected = false;
        this.mIsTerminated = false;
        this.mLabel = fLabel;
        this.mInStream = new RemotePort("CGIProxy.mInStream");
        this.mInStream.startConnect();
        this.mOutStream = new RemotePort("CGIProxy.mOutStream");
        this.mOutStream.startConnect();
        this.mErrorStream = new RemotePort("CGIProxy.mErrorStream");
        this.mErrorStream.startConnect();
        this.mWaitThread = new Thread("EPIC-Debugger:CGIProxy"){

            @Override
            public void run() {
                try {
                    int ret = CGIProxy.this.mInStream.waitForConnect(false);
                    if (ret == 3) {
                        PerlDebugPlugin.getDefault().logError("Could not connect to CGI-Console");
                    }
                    if (ret == 1 && (ret = CGIProxy.this.mOutStream.waitForConnect(true)) == 1) {
                        ret = CGIProxy.this.mErrorStream.waitForConnect(true);
                    }
                    if (ret != 1) {
                        if (ret == 3) {
                            PerlDebugPlugin.getDefault().logError("Could not connect to CGI-Console");
                        }
                        CGIProxy.this.terminate();
                        return;
                    }
                }
                catch (DebugException e) {
                    PerlDebugPlugin.getDefault().logError("Could not connect to CGI-Console", (Exception)((Object)e));
                }
                CGIProxy.this.mMonitorIn = new OutputStreamMonitor(CGIProxy.this.mInStream.getInStream());
                CGIProxy.this.mMonitorOut = new OutputStreamMonitor(CGIProxy.this.mOutStream.getInStream());
                CGIProxy.this.mMonitorError = new OutputStreamMonitor(CGIProxy.this.mErrorStream.getInStream());
                CGIProxy.this.mMonitorIn.startMonitoring();
                CGIProxy.this.mMonitorOut.startMonitoring();
                CGIProxy.this.mMonitorError.startMonitoring();
                CGIProxy.this.mStreamsProxy = new IStreamsProxy(){

                    public IStreamMonitor getErrorStreamMonitor() {
                        return CGIProxy.this.mMonitorError;
                    }

                    public IStreamMonitor getOutputStreamMonitor() {
                        return CGIProxy.this.mMonitorOut;
                    }

                    public void write(String input) throws IOException {
                    }
                };
                CGIProxy.this.mIsConnected = true;
                CGIProxy.this.fireCreationEvent();
            }
        };
        this.mWaitThread.start();
    }

    public boolean isConnected() {
        return this.mIsConnected;
    }

    public int getErrorPort() {
        return this.mErrorStream.getServerPort();
    }

    public int getInPort() {
        return this.mInStream.getServerPort();
    }

    public int getOutPort() {
        return this.mOutStream.getServerPort();
    }

    public String getLabel() {
        return this.mLabel;
    }

    public ILaunch getLaunch() {
        return this.mLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.mStreamsProxy;
    }

    public void setAttribute(String key, String value) {
        try {
            ILaunchConfigurationWorkingCopy workingcopy = this.mLaunch.getLaunchConfiguration().getWorkingCopy();
            workingcopy.setAttribute(key, value);
            workingcopy.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getAttribute(String key) {
        try {
            return this.mLaunch.getLaunchConfiguration().getAttribute(key, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.mIsTerminated;
    }

    public void terminate() throws DebugException {
        this.shutdown();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.mMonitorError;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.mMonitorOut;
    }

    public IStreamMonitor getInputStreamMonitor() {
        return this.mMonitorIn;
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    void shutdown() {
        this.mMonitorError.kill();
        this.mMonitorOut.kill();
        this.mMonitorIn.kill();
        this.mInStream.shutdown();
        this.mOutStream.shutdown();
        this.mErrorStream.shutdown();
        this.mIsTerminated = true;
        this.fireTerminateEvent();
    }

    public Thread getWaitThread() {
        return this.mWaitThread;
    }

    public void waitForConnect() {
        try {
            this.mWaitThread.join(30000L);
        }
        catch (InterruptedException interruptedException) {}
    }
}

