/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.epic.core.util.MarkerUtilities;
import org.epic.perleditor.actions.PerlUserJobAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceCritic;
import org.epic.perleditor.preferences.PerlCriticPreferencePage;

public class PerlCriticAction
extends PerlUserJobAction {
    private static String METRICS_MARKER = "org.epic.perleditor.markers.critic";

    public PerlCriticAction(PerlEditor editor) {
        super(editor);
    }

    @Override
    protected Map createMarkerAttributes(MarkerUtilities factory, Object violation) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        SourceCritic.Violation v = (SourceCritic.Violation)violation;
        factory.setMessage(attributes, String.valueOf(v.message) + " (" + v.pbp + ")");
        factory.setLineNumber(attributes, v.lineNumber);
        factory.setSeverity((Map)attributes, this.getSeverity(v.severity));
        attributes.put("pbp", v.pbp);
        return attributes;
    }

    @Override
    protected Object[] doJob(IResource resource) {
        return SourceCritic.critique(resource, this.getLog());
    }

    @Override
    protected String getJobTitle(IResource resource) {
        return "Executing Perl::Critic against " + resource.getName();
    }

    @Override
    protected String getMarker() {
        return METRICS_MARKER;
    }

    @Override
    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.PerlCriticAction";
    }

    private int getSeverity(int severity) {
        return PerlCriticPreferencePage.getMarkerSeverity(severity);
    }
}

