/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.editors;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.editors.BytecodeBufferManager;
import de.loskutov.bco.editors.BytecodeDocumentProvider;
import de.loskutov.bco.editors.BytecodeSourceMapper;
import de.loskutov.bco.ui.JdtUtils;
import java.lang.reflect.Constructor;
import java.util.BitSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class BytecodeClassFileEditor
extends ClassFileEditor {
    private final InputUpdater fInputUpdater;
    public static final String ID = "de.loskutov.bco.editors.BytecodeClassFileEditor";
    public static final String MARK = "// class version ";
    private final BitSet decompilerFlags;
    private static BytecodeSourceMapper sourceMapper;
    private BytecodeDocumentProvider fClassFileDocumentProvider;
    private boolean hasMappedSource;
    private boolean decompiled;
    private boolean initDone;
    private boolean sourceAttachmentPossible;

    public BytecodeClassFileEditor() {
        if (sourceMapper == null) {
            sourceMapper = new BytecodeSourceMapper();
        }
        this.fInputUpdater = new InputUpdater();
        this.setDocumentProvider((IDocumentProvider)this.getClassFileDocumentProvider());
        this.setEditorContextMenuId("#ClassFileEditorContext");
        this.setRulerContextMenuId("#ClassFileRulerContext");
        this.setOutlinerContextMenuId("#ClassFileOutlinerContext");
        this.decompilerFlags = new BitSet();
        this.decompilerFlags.set(4, true);
        this.decompilerFlags.set(5, true);
        this.decompilerFlags.set(3, false);
        this.setSourceAttachmentPossible(true);
    }

    protected boolean hasMappedSource() {
        return this.hasMappedSource;
    }

    protected void setHasMappedSource(boolean hasMappedSource) {
        this.hasMappedSource = hasMappedSource;
    }

    private ClassFileDocumentProvider getClassFileDocumentProvider() {
        if (this.fClassFileDocumentProvider == null) {
            this.fClassFileDocumentProvider = new BytecodeDocumentProvider(this);
        }
        return this.fClassFileDocumentProvider;
    }

    public void setDecompilerFlag(int flag, boolean value) {
        this.decompilerFlags.set(flag, value);
    }

    public boolean getDecompilerFlag(int flag) {
        return this.decompilerFlags.get(flag);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        input = this.doOpenBuffer(input, false, true);
        super.init(site, input);
    }

    public void doSetInput(boolean force, boolean reuseSource) {
        IEditorInput input = this.getEditorInput();
        if ((input = this.doOpenBuffer(input, force, reuseSource)) != null) {
            try {
                this.doSetInput(input);
            }
            catch (Exception e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (!((input = this.transformEditorInput(input)) instanceof IClassFileEditorInput)) {
            throw new CoreException(JavaUIStatus.createError((int)996, (String)"invalid input", null));
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener((ClassFileDocumentProvider.InputChangeListener)this);
        }
        super.doSetInput(input);
        documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).addInputChangeListener((ClassFileDocumentProvider.InputChangeListener)this);
        }
    }

    public boolean isDecompiled() {
        return this.decompiled;
    }

    private IEditorInput doOpenBuffer(IJavaReferenceType type, IClassFile parent, boolean externalClass) {
        IClassFile classFile = null;
        try {
            classFile = JdtUtils.getInnerType(parent, BytecodeClassFileEditor.getSourceMapper().getDecompiledClass(parent), type.getSignature());
        }
        catch (DebugException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return this.doOpenBuffer(classFile, externalClass);
    }

    private IEditorInput doOpenBuffer(IClassFile classFile, boolean externalClass) {
        IClassFileEditorInput input = null;
        if (classFile == null) {
            return null;
        }
        if (!externalClass) {
            input = this.transformEditorInput(classFile);
        }
        return this.doOpenBuffer((IEditorInput)input, false, true);
    }

    private IEditorInput doOpenBuffer(IEditorInput input, boolean force, boolean reuseSource) {
        if (input instanceof IClassFileEditorInput) {
            IClassFile cf = ((IClassFileEditorInput)input).getClassFile();
            String origSrc = BytecodeClassFileEditor.getAttachedJavaSource(cf, force);
            if (origSrc != null && !this.hasMappedSource) {
                this.setHasMappedSource(true);
            }
            if (origSrc == null || force && !reuseSource) {
                char[] src;
                this.setDecompiled(true);
                if (input instanceof ExternalClassFileEditorInput) {
                    ExternalClassFileEditorInput extInput = (ExternalClassFileEditorInput)input;
                    src = BytecodeClassFileEditor.getSourceMapper().getSource(extInput.getFile(), cf, this.decompilerFlags);
                } else {
                    src = BytecodeClassFileEditor.getSourceMapper().getSource(cf, this.decompilerFlags);
                }
                BytecodeClassFileEditor.changeBufferContent(cf, src);
            } else {
                this.setDecompiled(false);
            }
        } else if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            IClassFileEditorInput cfi = (IClassFileEditorInput)this.transformEditorInput(input);
            input = cfi;
            this.setDecompiled(true);
            IClassFile cf = cfi.getClassFile();
            char[] src = BytecodeClassFileEditor.getSourceMapper().getSource(fileEditorInput.getFile(), cf, this.decompilerFlags);
            BytecodeClassFileEditor.changeBufferContent(cf, src);
        }
        return input;
    }

    private void setDecompiled(boolean decompiled) {
        boolean oldDecompiled = this.decompiled;
        this.decompiled = decompiled;
        if (this.initDone && oldDecompiled != decompiled) {
            if (decompiled) {
                this.uninstallOccurrencesFinder();
            } else {
                this.installOccurrencesFinder(true);
            }
        }
    }

    private static String getAttachedJavaSource(IClassFile cf, boolean force) {
        IBuffer buffer;
        String origSrc = null;
        if (force && (buffer = BytecodeBufferManager.getBuffer((IOpenable)cf)) != null) {
            BytecodeBufferManager.removeBuffer(buffer);
        }
        try {
            origSrc = cf.getSource();
            if (origSrc != null && origSrc.startsWith(MARK)) {
                origSrc = null;
            }
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return origSrc;
    }

    private static void changeBufferContent(IClassFile cf, char[] src) {
        IBuffer buffer = BytecodeBufferManager.getBuffer((IOpenable)cf);
        boolean addBuffer = false;
        buffer = BytecodeBufferManager.createBuffer((IOpenable)cf);
        addBuffer = true;
        if (src == null) {
            src = new char[]{'\n', '/', '/', 'E', 'r', 'r', 'o', 'r'};
        }
        buffer.setContents(src);
        if (addBuffer) {
            BytecodeBufferManager.addBuffer(buffer);
            buffer.addBufferChangedListener((IBufferChangedListener)cf);
        }
    }

    protected IJavaElement getElementAt(int offset) {
        IClassFile classFile = this.getClassFile();
        if (classFile == null) {
            return null;
        }
        IJavaElement result = null;
        if (this.isDecompiled()) {
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            try {
                if (document.getLength() > offset) {
                    int lineAtOffset = document.getLineOfOffset(offset);
                    result = BytecodeClassFileEditor.getSourceMapper().findElement(classFile, lineAtOffset);
                }
            }
            catch (BadLocationException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        } else {
            try {
                result = classFile.getElementAt(offset);
            }
            catch (JavaModelException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return result;
    }

    public IClassFile getClassFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IClassFileEditorInput)) {
            return null;
        }
        return ((IClassFileEditorInput)editorInput).getClassFile();
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        if (reference == null) {
            if (moveCursor) {
                this.resetHighlightRange();
            }
            return;
        }
        try {
            ISourceViewer sourceViewer;
            IMember member;
            int length;
            int offset;
            ISourceRange range = null;
            if (this.isDecompiled() && BytecodeClassFileEditor.isSupportedMember(reference)) {
                int decompLine = -1 + BytecodeClassFileEditor.getSourceMapper().getDecompiledLine((IMember)reference, this.getClassFile());
                if (decompLine < 0) {
                    return;
                }
                IRegion region = ((BytecodeDocumentProvider)this.getDocumentProvider()).getDecompiledLineInfo(this.getEditorInput(), decompLine);
                if (region == null) {
                    return;
                }
                offset = region.getOffset();
                length = region.getLength();
            } else if (!this.isDecompiled()) {
                range = reference.getSourceRange();
                if (range == null) {
                    return;
                }
                offset = range.getOffset();
                length = range.getLength();
            } else {
                return;
            }
            if (offset > -1 && length > 0) {
                this.setHighlightRange(offset, length, moveCursor);
            }
            if (reference instanceof IMember && !this.isDecompiled() && (range = (member = (IMember)reference).getNameRange()) != null) {
                offset = range.getOffset();
                length = range.getLength();
            }
            if (moveCursor && offset > -1 && length > 0 && (sourceViewer = this.getSourceViewer()) != null) {
                sourceViewer.revealRange(offset, length);
                sourceViewer.setSelectedRange(offset, length);
            }
            return;
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.log(e, 4);
            if (moveCursor) {
                this.resetHighlightRange();
            }
            return;
        }
    }

    private static boolean isSupportedMember(ISourceReference reference) {
        return reference instanceof IMethod || reference instanceof IInitializer;
    }

    public Object getAdapter(Class required) {
        if (IToggleBreakpointsTarget.class == required) {
            return null;
        }
        return super.getAdapter(required);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        if (!this.isDecompiled()) {
            return super.computeHighlightRangeSourceReference();
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(caret);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)element;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, CompilationUnit astRoot) {
        if (this.hasMappedSource()) {
            super.updateOccurrenceAnnotations(selection, astRoot);
        }
    }

    protected IJavaElement getCorrespondingElement(IJavaElement element) {
        IClassFile classFile = this.getClassFile();
        if (classFile == null) {
            return super.getCorrespondingElement(element);
        }
        if (classFile.equals(element.getAncestor(6))) {
            return element;
        }
        return super.getCorrespondingElement(element);
    }

    public boolean isEditable() {
        return this.isDecompiled();
    }

    public boolean isEditorInputReadOnly() {
        return !this.isDecompiled();
    }

    public boolean isEditorInputModifiable() {
        return this.isDecompiled();
    }

    public boolean isSaveAsAllowed() {
        return this.isDecompiled();
    }

    protected IClassFileEditorInput transformEditorInput(Object input) {
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                Constructor cons = ExternalClassFileEditorInput.class.getDeclaredConstructor(IFile.class);
                cons.setAccessible(true);
                IClassFileEditorInput classFileInput = (IClassFileEditorInput)cons.newInstance(file);
                return classFileInput;
            }
            catch (Exception e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        } else {
            if (input instanceof IClassFileEditorInput) {
                return (IClassFileEditorInput)input;
            }
            if (input instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)input);
            }
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.initDone = true;
    }

    public void inputChanged(final IClassFileEditorInput input) {
        Runnable updateInput = new Runnable(){

            @Override
            public void run() {
                BytecodeClassFileEditor.this.fInputUpdater.post(input);
                IClassFile cf = input.getClassFile();
                try {
                    String source = cf.getSource();
                    BytecodeClassFileEditor.this.setDecompiled(source != null && source.startsWith(BytecodeClassFileEditor.MARK));
                }
                catch (JavaModelException e) {
                    BytecodeOutlinePlugin.log(e, 4);
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(updateInput);
        } else {
            updateInput.run();
        }
    }

    public void dispose() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener((ClassFileDocumentProvider.InputChangeListener)this);
        }
        IClassFile classFile = this.getClassFile();
        BytecodeBufferManager.removeBuffer(BytecodeBufferManager.getBuffer((IOpenable)classFile));
        super.dispose();
    }

    public static BytecodeSourceMapper getSourceMapper() {
        return sourceMapper;
    }

    public static IRegion checkForInnerClass(int sourceLine, IClassFile parent) {
        Region region = new Region(0, 0);
        BytecodeClassFileEditor editor = BytecodeClassFileEditor.getBytecodeEditor(parent);
        if (editor == null) {
            return region;
        }
        IJavaReferenceType debugType = sourceMapper.getLastTypeInDebugger();
        if (debugType == null) {
            return region;
        }
        boolean externalClass = editor.getEditorInput() instanceof ExternalClassFileEditorInput;
        IEditorInput input = null;
        if (!BytecodeClassFileEditor.hasInnerClass(debugType, parent)) {
            IClassFile classFile = BytecodeClassFileEditor.getLocalTypeClass(debugType, parent);
            if (classFile != null) {
                input = editor.doOpenBuffer(classFile, externalClass);
            }
        } else {
            input = editor.doOpenBuffer(debugType, parent, externalClass);
        }
        if (input == null) {
            return region;
        }
        try {
            editor.doSetInput(input);
        }
        catch (CoreException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return region;
        }
        int decompiledLine = sourceMapper.mapToDecompiled(sourceLine + 1, editor.getClassFile());
        if (decompiledLine >= 0) {
            try {
                region = editor.getDocumentProvider().getDocument((Object)input).getLineInformation(decompiledLine);
            }
            catch (BadLocationException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return region;
    }

    private static IClassFile getLocalTypeClass(IJavaReferenceType debugType, IClassFile parent) {
        try {
            IType type = parent.getType();
            if (type.isLocal() || type.isMember()) {
                return null;
            }
            String binarySignature = debugType.getSignature();
            int idx = binarySignature.lastIndexOf(47);
            if (idx > 0 && idx < binarySignature.length() - 1) {
                String name = binarySignature.substring(idx + 1);
                if (name.charAt(name.length() - 1) == ';') {
                    name = name.substring(0, name.length() - 1);
                }
                return type.getPackageFragment().getClassFile(name + ".class");
            }
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return null;
    }

    private static boolean hasInnerClass(IJavaReferenceType debugType, IClassFile parent) {
        try {
            String parentName = parent.getType().getFullyQualifiedName();
            String childName = debugType.getName();
            return childName != null && childName.startsWith(parentName + "$");
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.log(e, 4);
            return false;
        }
    }

    IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
        IJavaElement element;
        for (element = file.getParent(); element != null && element.getElementType() != 3; element = element.getParent()) {
        }
        return (IPackageFragmentRoot)element;
    }

    private static BytecodeClassFileEditor getBytecodeEditor(IClassFile parent) {
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        for (int i = 0; i < editorReferences.length; ++i) {
            BytecodeClassFileEditor bytecodeEditor;
            IEditorPart editor = editorReferences[i].getEditor(false);
            if (!(editor instanceof BytecodeClassFileEditor) || !parent.equals((bytecodeEditor = (BytecodeClassFileEditor)editor).getClassFile())) continue;
            return bytecodeEditor;
        }
        return null;
    }

    public ITextSelection convertSelection(ITextSelection textSelection, boolean toDecompiled) {
        int startLine = textSelection.getStartLine();
        int newLine = toDecompiled ? sourceMapper.mapToDecompiled(startLine + 1, this.getClassFile()) + 1 : sourceMapper.mapToSource(startLine, this.getClassFile()) - 1;
        if (newLine < 0) {
            return null;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            int lineOffset = document.getLineOffset(newLine);
            return new TextSelection(lineOffset, 0);
        }
        catch (BadLocationException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
    }

    public int getSourceLine(ITextSelection bytecodeSelection) {
        int startLine = bytecodeSelection.getStartLine();
        return sourceMapper.mapToSource(startLine, this.getClassFile()) - 1;
    }

    public ITextSelection convertLine(int sourceLine) {
        int newLine = sourceMapper.mapToDecompiled(sourceLine + 1, this.getClassFile()) + 1;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            int lineOffset = document.getLineOffset(newLine);
            return new TextSelection(lineOffset, 0);
        }
        catch (BadLocationException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
    }

    public int getBytecodeInstructionAtLine(int line) {
        if (this.isDecompiled()) {
            DecompiledClass decompiledClass = sourceMapper.getDecompiledClass(this.getClassFile());
            if (line > 0 && decompiledClass != null) {
                return decompiledClass.getBytecodeInsn(line);
            }
        }
        return -1;
    }

    public void setSourceAttachmentPossible(boolean sourceAttachmentPossible) {
        this.sourceAttachmentPossible = sourceAttachmentPossible;
    }

    public boolean isSourceAttachmentPossible() {
        return this.sourceAttachmentPossible && this.isDecompiled() && !this.hasMappedSource();
    }

    private class InputUpdater
    implements Runnable {
        private boolean fPosted = false;
        private IClassFileEditorInput fClassFileEditorInput;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IClassFileEditorInput input;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                input = this.fClassFileEditorInput;
            }
            try {
                if (BytecodeClassFileEditor.this.getSourceViewer() != null) {
                    BytecodeClassFileEditor.this.setInput((IEditorInput)input);
                }
            }
            finally {
                inputUpdater = this;
                synchronized (inputUpdater) {
                    this.fPosted = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(IClassFileEditorInput input) {
            StyledText textWidget;
            ISourceViewer viewer;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                if (this.fPosted) {
                    if (input != null && input.equals(this.fClassFileEditorInput)) {
                        this.fClassFileEditorInput = input;
                    }
                    return;
                }
            }
            if (input != null && input.equals(BytecodeClassFileEditor.this.getEditorInput()) && (viewer = BytecodeClassFileEditor.this.getSourceViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = true;
                    this.fClassFileEditorInput = input;
                }
                textWidget.getDisplay().asyncExec((Runnable)this);
            }
        }
    }
}

