/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.ui.actions;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.compare.BytecodeCompare;
import de.loskutov.bco.compare.TypedElement;
import de.loskutov.bco.ui.JdtUtils;
import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BytecodeAction
implements IObjectActionDelegate {
    protected IStructuredSelection selection;
    protected Shell shell;

    public void selectionChanged(IAction action, ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)newSelection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    protected void exec(IJavaElement element1, IJavaElement element2) throws Exception {
        BitSet modes = BytecodeAction.getModes();
        CompareUI.openCompareEditor((CompareEditorInput)new BytecodeCompare(this.createTypedElement(element1, modes), this.createTypedElement(element2, modes)));
    }

    protected TypedElement createTypedElement(IJavaElement javaElement, BitSet modes) {
        String name;
        IClassFile classFile = (IClassFile)javaElement.getAncestor(6);
        if (classFile != null) {
            name = classFile.getPath().toOSString();
            if (!name.endsWith(".class")) {
                name = name + '/' + JdtUtils.getFullBytecodeName(classFile);
            }
        } else {
            name = JdtUtils.getByteCodePath(javaElement);
        }
        String methodName = null;
        if ((javaElement.getElementType() == 9 || javaElement.getElementType() == 10) && (methodName = JdtUtils.getMethodSignature(javaElement)) != null) {
            name = name + ":" + methodName;
        }
        return new TypedElement(name, methodName, "bytecode", javaElement, modes);
    }

    private static BitSet getModes() {
        IPreferenceStore store = BytecodeOutlinePlugin.getDefault().getPreferenceStore();
        BitSet modes = new BitSet();
        modes.set(0, store.getBoolean("linkViewToEditor"));
        modes.set(1, store.getBoolean("showOnlySelectedElement"));
        modes.set(3, store.getBoolean("showRawBytecode"));
        modes.set(4, store.getBoolean("diff_showLineInfo"));
        modes.set(5, store.getBoolean("diff_showVariables"));
        modes.set(2, store.getBoolean("diff_showASMifierCode"));
        modes.set(8, store.getBoolean("showAnalyzer"));
        modes.set(9, store.getBoolean("diff_showStackmap"));
        modes.set(7, store.getBoolean("diff_expandStackmap"));
        return modes;
    }

    protected IJavaElement[] getSelectedResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            for (Object next : this.selection) {
                if (next instanceof IFile) {
                    resources.add(JavaCore.create((IFile)((IFile)next)));
                    continue;
                }
                if (next instanceof IJavaElement) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Object adapter = a.getAdapter(IFile.class);
                if (adapter instanceof IFile) {
                    resources.add(JavaCore.create((IFile)((IFile)adapter)));
                    continue;
                }
                adapter = a.getAdapter(ICompilationUnit.class);
                if (adapter instanceof ICompilationUnit) {
                    resources.add(adapter);
                    continue;
                }
                adapter = a.getAdapter(IClassFile.class);
                if (!(adapter instanceof IClassFile)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new IJavaElement[resources.size()]);
        }
        return new IJavaElement[0];
    }
}

