/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.ui.actions;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.ui.actions.BytecodeAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class OpenAction
extends BytecodeAction
implements IObjectActionDelegate {
    public void run(IAction action) {
        IJavaElement[] resources = this.getSelectedResources();
        IJavaElement element2 = this.selectJavaElement();
        if (element2 == null) {
            return;
        }
        try {
            this.exec(resources[0], element2);
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.error("Failed to run Compare: " + e.getMessage(), e);
        }
    }

    private IJavaElement selectJavaElement() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        OpenClassFileDialog dialog = new OpenClassFileDialog(this.shell, (IContainer)input, 1);
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return JavaCore.create((IFile)((IFile)result[0]));
    }

    private static final class OpenClassFileDialog
    extends ResourceListSelectionDialog {
        public OpenClassFileDialog(Shell parentShell, IContainer container, int typesMask) {
            super(parentShell, container, typesMask);
            this.setTitle("Bytecode compare");
            this.setMessage("Please select class file to compare");
        }

        protected boolean select(IResource resource) {
            if (resource == null) {
                return false;
            }
            String fileExtension = resource.getFileExtension();
            return super.select(resource) && ("java".equals(fileExtension) || "class".equals(fileExtension));
        }
    }
}

