/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class DecompilerOutputUtil {
    private final String input;
    private final List inputLines = new ArrayList();
    private CompilationUnit unit;
    private final List javaSrcLines = new ArrayList();
    private final String line_separator = System.getProperty("line.separator", "\r\n");
    private final int line_separator_len = this.line_separator.length();
    private String decompilerType;

    public DecompilerOutputUtil(String decompilerType, String input) {
        this.input = String.valueOf(input) + this.line_separator;
        this.decompilerType = decompilerType;
    }

    public String realign() {
        if (this.input.length() == 0) {
            return this.input;
        }
        if (this.input == null) {
            return null;
        }
        this.fillOutputList();
        this.javaSrcLines.add(null);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(this.input.toCharArray());
        this.unit = (CompilationUnit)parser.createAST(null);
        List types = this.unit.types();
        int i = 0;
        while (i < types.size()) {
            if (types.get(i) instanceof AbstractTypeDeclaration) {
                this.processElements((AbstractTypeDeclaration)types.get(i));
            }
            ++i;
        }
        int firstTypeLine = Integer.MAX_VALUE;
        int lastTypeLine = Integer.MIN_VALUE;
        int i2 = 0;
        while (i2 < types.size()) {
            if (types.get(i2) instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(i2);
                this.processTypes(type);
                int numLine = this.unit.getLineNumber(type.getStartPosition());
                if (numLine < firstTypeLine) {
                    firstTypeLine = numLine;
                }
                if ((numLine = this.unit.getLineNumber(type.getStartPosition() + type.getLength() - 1)) > lastTypeLine) {
                    lastTypeLine = numLine;
                }
            }
            ++i2;
        }
        if (this.javaSrcLines.size() == 1) {
            String warning = "\r\n// Warning: No line numbers available in class file\r\n";
            return "/*** Eclipse Class Decompiler plugin, copyright (c) 2012 Chao Chen (cnfree2000@hotmail.com) ***/\r\n" + warning + DecompilerOutputUtil.replace(this.input, "/*** Eclipse Class Decompiler plugin, copyright (c) 2012 Chao Chen (cnfree2000@hotmail.com) ***/", "");
        }
        if (firstTypeLine != Integer.MAX_VALUE) {
            this.addBelow(firstTypeLine - 1, 0, 0);
        }
        if (lastTypeLine != Integer.MIN_VALUE) {
            this.addBelow(this.inputLines.size() - 2, lastTypeLine, this.javaSrcLines.size() - 1);
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer realignOutput = new StringBuffer();
        int i = 1;
        while (i < this.javaSrcLines.size()) {
            JavaSrcLine javaSrcLine = this.initJavaSrcListItem(i);
            if (javaSrcLine.inputLines.size() > 0) {
                int j = 0;
                while (j < javaSrcLine.inputLines.size()) {
                    int numLine = (Integer)javaSrcLine.inputLines.get(j);
                    String line = ((InputLine)this.inputLines.get((int)numLine)).line;
                    line = line.substring(0, line.length() - this.line_separator_len);
                    realignOutput.append(line);
                    ++j;
                }
            } else if ("JD-Core".equals(this.decompilerType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("/*");
                int j = 0;
                while (j < new Integer(this.javaSrcLines.size()).toString().length() + 2) {
                    buffer.append(" ");
                    ++j;
                }
                buffer.append("*/");
                realignOutput.append(buffer.toString());
            }
            realignOutput.append(this.line_separator);
            ++i;
        }
        return realignOutput.toString();
    }

    private void fillOutputList() {
        int lineStart = 0;
        int lineEnd = 0;
        this.inputLines.add(null);
        while (lineStart < this.input.length()) {
            lineEnd = (lineEnd = this.input.indexOf(10, lineEnd)) == -1 ? this.input.length() : ++lineEnd;
            InputLine outputLine = new InputLine();
            outputLine.line = this.input.substring(lineStart, lineEnd);
            this.inputLines.add(outputLine);
            lineStart = lineEnd;
        }
    }

    private int parseJavaLineNumber(String line) {
        Pattern pattern = Pattern.compile("/\\*\\s*\\d+\\s*\\*/", 2);
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.find() && matcher.start() == 0) {
            return Integer.parseInt(matcher.group().substring(2, matcher.group().length() - 2).trim());
        }
        return -1;
    }

    private JavaSrcLine initJavaSrcListItem(int outputLineNum) {
        JavaSrcLine javaSrcLine;
        if (this.javaSrcLines.size() <= outputLineNum) {
            int a = this.javaSrcLines.size();
            while (a <= outputLineNum) {
                this.javaSrcLines.add(null);
                ++a;
            }
        }
        if ((javaSrcLine = (JavaSrcLine)this.javaSrcLines.get(outputLineNum)) == null) {
            javaSrcLine = new JavaSrcLine();
            this.javaSrcLines.set(outputLineNum, javaSrcLine);
        }
        return javaSrcLine;
    }

    private void addAbove(int inputBeginLineNo, int inputLineNo, int outputLineNo) {
        if (outputLineNo == 1) {
            return;
        }
        int offset = 1;
        block0: while (inputBeginLineNo <= inputLineNo - offset) {
            int offsetInputLine = inputLineNo - offset;
            InputLine inputLine = (InputLine)this.inputLines.get(offsetInputLine);
            if (inputLine.outputLineNum != -1) break;
            JavaSrcLine javaSrcLine = null;
            int offsetOutputLine = outputLineNo - offset;
            if (offsetOutputLine > 0) {
                javaSrcLine = this.initJavaSrcListItem(offsetOutputLine);
            }
            if (offsetOutputLine == 1 || javaSrcLine.inputLines.size() > 0) {
                int offsetOutputLineNext = offsetOutputLine + 1;
                JavaSrcLine javaSrcLineNext = this.initJavaSrcListItem(offsetOutputLineNext);
                int innerOffset = offset;
                while (inputLineNo - innerOffset >= inputBeginLineNo) {
                    int innerOffsetInputLine = inputLineNo - innerOffset;
                    inputLine = (InputLine)this.inputLines.get(innerOffsetInputLine);
                    if (inputLine.outputLineNum != -1) break block0;
                    javaSrcLineNext.inputLines.add(0, new Integer(innerOffsetInputLine));
                    inputLine.calculatedNumLineJavaSrc = offsetOutputLineNext;
                    ++innerOffset;
                }
                break;
            }
            javaSrcLine.inputLines.add(new Integer(offsetInputLine));
            inputLine.calculatedNumLineJavaSrc = offsetOutputLine;
            ++offset;
        }
    }

    private void addBelow(int inputEndLineNo, int inputLineNo, int outputLineNo) {
        int offset = 1;
        block0: while (inputLineNo + offset <= inputEndLineNo) {
            int offsetInputLine = inputLineNo + offset;
            InputLine outputLine = (InputLine)this.inputLines.get(offsetInputLine);
            if (outputLine.outputLineNum != -1) break;
            int offsetOutputLine = outputLineNo + offset;
            JavaSrcLine javaSrcLine = this.initJavaSrcListItem(offsetOutputLine);
            if (javaSrcLine.inputLines.size() > 0) {
                int offsetOutputLinePrev = offsetOutputLine - 1;
                JavaSrcLine javaSrcLinePrev = this.initJavaSrcListItem(offsetOutputLinePrev);
                int innerOffset = offset;
                while (inputLineNo + innerOffset <= inputEndLineNo) {
                    int innerOffsetInputLine = inputLineNo + innerOffset;
                    outputLine = (InputLine)this.inputLines.get(innerOffsetInputLine);
                    if (outputLine.outputLineNum != -1) break block0;
                    javaSrcLinePrev.inputLines.add(new Integer(innerOffsetInputLine));
                    outputLine.calculatedNumLineJavaSrc = offsetOutputLinePrev;
                    ++innerOffset;
                }
                break;
            }
            javaSrcLine.inputLines.add(new Integer(offsetInputLine));
            outputLine.calculatedNumLineJavaSrc = offsetOutputLine;
            ++offset;
        }
    }

    private void processTypes(AbstractTypeDeclaration rootType) {
        List declarations = rootType.bodyDeclarations();
        int i = 0;
        while (i < declarations.size()) {
            Object declaration = declarations.get(i);
            if (declaration instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)declaration;
                this.processTypes(typeDeclaration);
            }
            ++i;
        }
        int beginTypeLine = Integer.MAX_VALUE;
        int endTypeLine = Integer.MIN_VALUE;
        int firstMethodLine = Integer.MAX_VALUE;
        int lastMethodLine = Integer.MIN_VALUE;
        int beginTypeInputLineNo = this.unit.getLineNumber(rootType.getStartPosition());
        int endTypeInputLineNo = this.unit.getLineNumber(rootType.getStartPosition() + rootType.getLength() - 1);
        int inputLineNo = beginTypeInputLineNo;
        while (inputLineNo <= endTypeInputLineNo) {
            InputLine inputLine = (InputLine)this.inputLines.get(inputLineNo);
            int numLineJavaSrc = inputLine.outputLineNum;
            if (numLineJavaSrc == -1) {
                numLineJavaSrc = inputLine.calculatedNumLineJavaSrc;
            }
            if (numLineJavaSrc != -1) {
                if (beginTypeLine > numLineJavaSrc) {
                    beginTypeLine = numLineJavaSrc;
                }
                if (endTypeLine < numLineJavaSrc) {
                    endTypeLine = numLineJavaSrc;
                }
                if (firstMethodLine > inputLineNo) {
                    firstMethodLine = inputLineNo;
                }
                if (lastMethodLine < inputLineNo) {
                    lastMethodLine = inputLineNo;
                }
            }
            ++inputLineNo;
        }
        if (beginTypeLine != Integer.MAX_VALUE) {
            this.addAbove(beginTypeInputLineNo, firstMethodLine, beginTypeLine);
            this.addBelow(endTypeInputLineNo, lastMethodLine, endTypeLine);
        }
    }

    private void processMembers(AbstractTypeDeclaration rootType) {
        ArrayList bodyDeclarations = new ArrayList();
        if (rootType instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)rootType;
            List enumDeclarations = enumDeclaration.enumConstants();
            int lastInputLineNo = -1;
            int i = 0;
            while (i < enumDeclarations.size()) {
                Object enumDeclObj = enumDeclarations.get(i);
                if (enumDeclObj instanceof EnumConstantDeclaration) {
                    ASTNode element = (ASTNode)enumDeclObj;
                    int p = element.getStartPosition();
                    int inputBeginLine = this.unit.getLineNumber(p);
                    if (inputBeginLine != lastInputLineNo) {
                        bodyDeclarations.add(enumDeclObj);
                    }
                    lastInputLineNo = inputBeginLine;
                }
                ++i;
            }
        }
        bodyDeclarations.addAll(rootType.bodyDeclarations());
        int i = 0;
        while (i < bodyDeclarations.size()) {
            Object bodyDeclaration = bodyDeclarations.get(i);
            if (bodyDeclaration instanceof MethodDeclaration || bodyDeclaration instanceof Initializer || bodyDeclaration instanceof FieldDeclaration || bodyDeclaration instanceof EnumConstantDeclaration) {
                ASTNode element = (ASTNode)bodyDeclaration;
                int p = element.getStartPosition();
                int inputBeginLine = this.unit.getLineNumber(p);
                int inputEndLine = this.unit.getLineNumber(p + element.getLength() - 1);
                this.processMember(inputBeginLine, inputEndLine);
            }
            ++i;
        }
    }

    private void processMember(int inputBeginLine, int inputEndLine) {
        int lastOutputLine = -1;
        int lastInputLine = -1;
        int inputNumLine = inputBeginLine;
        while (inputNumLine <= inputEndLine) {
            InputLine inputLine = (InputLine)this.inputLines.get(inputNumLine);
            inputLine.outputLineNum = this.parseJavaLineNumber(inputLine.line);
            if (inputLine.outputLineNum > 1) {
                lastOutputLine = inputLine.outputLineNum;
                lastInputLine = inputNumLine;
                JavaSrcLine javaSrcLine = this.initJavaSrcListItem(inputLine.outputLineNum);
                javaSrcLine.inputLines.add(new Integer(inputNumLine));
                this.addAbove(inputBeginLine, inputNumLine, inputLine.outputLineNum);
            }
            ++inputNumLine;
        }
        if (lastInputLine != -1 && lastInputLine < inputEndLine) {
            this.addBelow(inputEndLine, lastInputLine, lastOutputLine);
        }
    }

    private void processElements(AbstractTypeDeclaration rootType) {
        if (rootType instanceof TypeDeclaration || rootType instanceof EnumDeclaration) {
            this.processMembers(rootType);
        }
        List bodyDeclarations = rootType.bodyDeclarations();
        int i = 0;
        while (i < bodyDeclarations.size()) {
            Object bodyDeclaration = bodyDeclarations.get(i);
            if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                this.processElements((AbstractTypeDeclaration)bodyDeclaration);
            }
            ++i;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replace(String text, String searchString, String replacement) {
        if (DecompilerOutputUtil.isEmpty(text) || DecompilerOutputUtil.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            end = text.indexOf(searchString, 2);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    private class InputLine {
        String line;
        int outputLineNum = -1;
        int calculatedNumLineJavaSrc = -1;

        private InputLine() {
        }

        public String toString() {
            return this.line;
        }
    }

    private class JavaSrcLine {
        List inputLines = new ArrayList();

        private JavaSrcLine() {
        }

        public String toString() {
            return this.inputLines.toString();
        }
    }
}

