/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileUtil {
    static /* synthetic */ Class class$0;

    public static void writeToFile(File file, String string) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            out.print(string);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToBinarayFile(File file, InputStream source, boolean close) {
        block23: {
            BufferedInputStream bis = null;
            BufferedOutputStream fouts = null;
            try {
                bis = new BufferedInputStream(source);
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                fouts = new BufferedOutputStream(new FileOutputStream(file));
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = bis.read(b)) != -1) {
                    fouts.write(b, 0, i);
                }
                fouts.flush();
                fouts.close();
                if (close) {
                    bis.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.getLogger(clazz.getName()).log(Level.WARNING, "Write binaray file failed.", e);
                try {
                    if (fouts != null) {
                        fouts.close();
                    }
                }
                catch (IOException f) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.getLogger(clazz2.getName()).log(Level.WARNING, "Close output stream failed.", f);
                }
                if (!close) break block23;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException f) {
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.getLogger(clazz3.getName()).log(Level.WARNING, "Close input stream failed.", f);
                }
            }
        }
    }

    public static boolean copyFile(String src, String des) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            FileUtil.writeToBinarayFile(new File(des), fis, false);
            fis.close();
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.getLogger(clazz.getName()).log(Level.WARNING, "Copy file failed.", e);
            try {
                fis.close();
                return true;
            }
            catch (IOException f) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.getLogger(clazz2.getName()).log(Level.WARNING, "Close input stream failed.", f);
            }
        }
        return false;
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory) {
        return FileUtil.copyDirectory(srcDirectory, desDirectory, null);
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory, FileFilter filter) {
        try {
            File des = new File(desDirectory);
            if (!des.exists()) {
                des.mkdirs();
            }
            File src = new File(srcDirectory);
            File[] allFile = src.listFiles();
            int totalNum = allFile.length;
            String srcName = "";
            String desName = "";
            int currentFile = 0;
            currentFile = 0;
            while (currentFile < totalNum) {
                if (!allFile[currentFile].isDirectory()) {
                    srcName = allFile[currentFile].toString();
                    desName = String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName();
                    if (filter == null || filter.accept(new File(srcName))) {
                        FileUtil.copyFile(srcName, desName);
                    }
                } else if (!FileUtil.copyDirectory(allFile[currentFile].getPath().toString(), String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName().toString(), filter)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.getLogger(clazz.getName()).log(Level.WARNING, "Copy sub directory " + srcDirectory + "failed.");
                }
                ++currentFile;
            }
            return true;
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.sf.feeling.decompiler.util.FileUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.getLogger(clazz.getName()).log(Level.WARNING, "Copy directory " + srcDirectory + "failed.", e);
            return false;
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileUtil.copyDirectoryToDirectory(srcDir, destDir, null);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (srcDir.exists() && !srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source '" + destDir + "' is not a directory");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileUtil.copyDirectory(srcDir.getAbsolutePath(), new File(destDir, srcDir.getName()).getAbsolutePath(), filter);
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(monitor, directory, base, step);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, int step) throws IOException {
        FileUtil.deleteDirectory(monitor, directory, directory, step);
    }

    public static void cleanDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        boolean isPackage = false;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (!isPackage && file.isFile()) {
                isPackage = true;
            }
            try {
                FileUtil.forceDelete(monitor, file, base, step);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (isPackage) {
            monitor.worked(step);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void forceDelete(IProgressMonitor monitor, File file, File base, int step) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(monitor, file, base, step);
        } else {
            monitor.subTask(file.getAbsolutePath().substring(base.getAbsolutePath().length() + new Long(System.currentTimeMillis()).toString().length() + 2));
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static void recursiveZip(IProgressMonitor monitor, ZipOutputStream zos, File file, String path, FileFilter filter, int step) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    FileUtil.recursiveZip(monitor, zos, files[i], String.valueOf(path.length() > 0 ? String.valueOf(path) + "/" : path) + files[i].getName(), filter, step);
                    ++i;
                }
            }
            monitor.worked(step);
        }
        if (file.isFile()) {
            monitor.subTask(path);
            byte[] bt = new byte[512];
            ZipEntry ze = new ZipEntry(path);
            ze.setSize(file.length());
            zos.putNextEntry(ze);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            int i = 0;
            while ((i = fis.read(bt)) != -1) {
                zos.write(bt, 0, i);
            }
            fis.close();
        }
    }
}

