/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ChangeCommitPropertiesCommand
implements ISVNCommand {
    private ISVNRepositoryLocation repositoryLocation;
    private SVNRevision.Number revisionNo;
    private String logMessage;
    private String author;
    private boolean logMessageChanged = false;
    private boolean authorChanged = false;

    public ChangeCommitPropertiesCommand(ISVNRepositoryLocation theRepositoryLocation, SVNRevision.Number theRevisionNo, String theLogMessage, String theAuthor) {
        this.repositoryLocation = theRepositoryLocation;
        this.revisionNo = theRevisionNo;
        this.logMessage = theLogMessage;
        this.author = theAuthor;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        monitor.beginTask(null, 100);
        ISVNClientAdapter svnClient = this.repositoryLocation.getSVNClient();
        try {
            OperationManager.getInstance().beginOperation(svnClient);
            try {
                if (this.logMessage != null) {
                    svnClient.setRevProperty(this.repositoryLocation.getUrl(), this.revisionNo, "svn:log", this.logMessage, true);
                    this.logMessageChanged = true;
                }
                if (this.author != null) {
                    svnClient.setRevProperty(this.repositoryLocation.getUrl(), this.revisionNo, "svn:author", this.author, true);
                    this.authorChanged = true;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.repositoryLocation.returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
            monitor.done();
        }
    }

    public boolean isAuthorChanged() {
        return this.authorChanged;
    }

    public boolean isLogMessageChanged() {
        return this.logMessageChanged;
    }
}

