/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.AddIgnoredPatternCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalResource
implements ISVNLocalResource,
Comparable {
    protected IResource resource;

    protected LocalResource(IResource resource) {
        Assert.isNotNull(resource);
        this.resource = resource;
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public ISVNLocalFolder getParent() {
        IContainer parent = this.resource.getParent();
        if (parent == null) {
            return null;
        }
        return new LocalFolder(parent);
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public boolean isIgnored() throws SVNException {
        if (this.resource.isTeamPrivateMember() || this.resource.isLinked()) {
            return true;
        }
        if (this.resource.getType() == 2 && SVNProviderPlugin.getPlugin().isAdminDirectory(this.getName())) {
            return true;
        }
        if (this.resource.getType() == 8 || this.resource.getType() == 4) {
            return false;
        }
        if (this.isParentInSvnIgnore()) {
            return true;
        }
        LocalResourceStatus status = this.getStatusFromCache();
        if (this.resource.isDerived() && (SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_managed_derived_resources") || !status.isManaged())) {
            return true;
        }
        if (status.isManaged()) {
            return false;
        }
        if (status.isIgnored()) {
            return true;
        }
        if (Team.isIgnoredHint((IResource)this.resource)) {
            return true;
        }
        ISVNLocalFolder parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.isIgnored();
    }

    protected boolean isParentInSvnIgnore() throws SVNException {
        LocalResourceStatus status;
        StatusCacheManager cacheMgr = SVNProviderPlugin.getPlugin().getStatusCacheManager();
        IContainer parent = this.resource.getParent();
        while (parent != null && !cacheMgr.hasCachedStatus((IResource)parent)) {
            parent = parent.getParent();
        }
        return parent != null && (status = cacheMgr.getStatusFromCache((IResource)parent)) != null && SVNStatusKind.IGNORED.equals((Object)status.getTextStatus());
    }

    @Override
    public void setIgnored() throws SVNException {
        AddIgnoredPatternCommand command = new AddIgnoredPatternCommand(this.getParent(), this.resource.getName());
        command.run(null);
    }

    @Override
    public boolean isManaged() throws SVNException {
        return this.getStatusFromCache().isManaged();
    }

    @Override
    public boolean isAdded() throws SVNException {
        return this.getStatusFromCache().isAdded();
    }

    @Override
    public boolean hasRemote() throws SVNException {
        return !this.isLinked() && this.getStatusFromCache().hasRemote();
    }

    public boolean isLinked() {
        return SVNWorkspaceRoot.isLinkedResource(this.resource);
    }

    @Override
    public LocalResourceStatus getStatus() throws SVNException {
        if (this.isLinked()) {
            return LocalResourceStatus.NONE;
        }
        LocalResourceStatus aStatus = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatus(this.resource);
        return aStatus != null ? aStatus : LocalResourceStatus.NONE;
    }

    @Override
    public LocalResourceStatus getStatusFromCache() throws SVNException {
        if (this.isLinked()) {
            return LocalResourceStatus.NONE;
        }
        LocalResourceStatus aStatus = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatusFromCache(this.resource);
        return aStatus != null ? aStatus : LocalResourceStatus.NONE;
    }

    @Override
    public SVNRevision getRevision() throws SVNException {
        if (this.isLinked()) {
            return null;
        }
        return SVNProviderPlugin.getPlugin().getStatusCacheManager().getResourceRevision(this);
    }

    public int compareTo(Object arg0) {
        LocalResource other = (LocalResource)arg0;
        return this.resource.getFullPath().toString().compareTo(other.resource.getFullPath().toString());
    }

    @Override
    public IResource getIResource() {
        return this.resource;
    }

    @Override
    public File getFile() {
        return this.resource.getLocation().toFile();
    }

    @Override
    public SVNWorkspaceRoot getWorkspaceRoot() {
        SVNTeamProvider teamProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)SVNProviderPlugin.getTypeId());
        if (teamProvider == null) {
            return null;
        }
        return teamProvider.getSVNWorkspaceRoot();
    }

    @Override
    public ISVNRepositoryLocation getRepository() {
        SVNWorkspaceRoot root;
        block3: {
            try {
                root = this.getWorkspaceRoot();
                if (root != null) break block3;
                SVNProviderPlugin.log(2, Policy.bind("LocalResource.errorGettingTeamProvider", this.resource.toString()), null);
                return null;
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(e);
                return null;
            }
        }
        return root.getRepository();
    }

    @Override
    public SVNUrl getUrl() {
        SVNUrl parentUrl;
        block5: {
            try {
                LocalResourceStatus status = this.getStatusFromCache();
                if (status.isManaged()) {
                    return status.getUrl();
                }
                parentUrl = null;
                ISVNLocalFolder parent = this.getParent();
                if (parent != null) {
                    parentUrl = parent.getUrl();
                }
                if (parentUrl != null) break block5;
                return null;
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return parentUrl.appendPath(this.resource.getName());
    }

    @Override
    public ISVNRemoteResource getLatestRemoteResource() throws SVNException {
        return this.getRemoteResource(SVNRevision.HEAD);
    }

    @Override
    public ISVNRemoteResource getRemoteResource(SVNRevision revision) throws SVNException {
        if (SVNRevision.BASE.equals((Object)revision)) {
            return this.getBaseResource();
        }
        GetRemoteResourceCommand command = new GetRemoteResourceCommand(this.getRepository(), this.getUrl(), revision);
        command.run(null);
        return command.getRemoteResource();
    }

    @Override
    public void delete() throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.remove(new File[]{this.getFile()}, true);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.getRepository().returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
        }
    }

    public void revert(boolean recurse) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                try {
                    Util.saveLocalHistory(this.resource);
                }
                catch (CoreException e) {
                    SVNProviderPlugin.log(4, e.getMessage(), e);
                }
                svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.revert(this.getFile(), recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            this.getRepository().returnSVNClient(svnClient);
            HashSet<IResource> refreshList = new HashSet<IResource>();
            refreshList.add(this.getResource());
            OperationManager.getInstance().endOperation(true, refreshList);
            throw throwable;
        }
        this.getRepository().returnSVNClient(svnClient);
        HashSet<IResource> refreshList = new HashSet<IResource>();
        refreshList.add(this.getResource());
        OperationManager.getInstance().endOperation(true, refreshList);
    }

    @Override
    public void resolve() throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.resolved(this.getFile());
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.getRepository().returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
        }
    }

    @Override
    public void setSvnProperty(String name, String value, boolean recurse) throws SVNException {
        OperationResourceCollector operationResourceCollector = new OperationResourceCollector();
        ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
        try {
            try {
                svnClient.addNotifyListener((ISVNNotifyListener)operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertySet(this.getFile(), name, value, recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            OperationManager.getInstance().endOperation(true, operationResourceCollector.getOperationResources());
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)operationResourceCollector);
                this.getRepository().returnSVNClient(svnClient);
            }
        }
    }

    @Override
    public void setSvnProperty(String name, File value, boolean recurse) throws SVNException {
        OperationResourceCollector operationResourceCollector = new OperationResourceCollector();
        ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
        try {
            try {
                svnClient.addNotifyListener((ISVNNotifyListener)operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertySet(this.getFile(), name, value, recurse);
            }
            catch (IOException e) {
                throw SVNException.wrapException(e);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            OperationManager.getInstance().endOperation(true, operationResourceCollector.getOperationResources());
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)operationResourceCollector);
                this.getRepository().returnSVNClient(svnClient);
            }
        }
    }

    @Override
    public void deleteSvnProperty(String name, boolean recurse) throws SVNException {
        OperationResourceCollector operationResourceCollector = new OperationResourceCollector();
        ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
        try {
            try {
                svnClient.addNotifyListener((ISVNNotifyListener)operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertyDel(this.getFile(), name, recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            OperationManager.getInstance().endOperation(true, operationResourceCollector.getOperationResources());
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)operationResourceCollector);
                this.getRepository().returnSVNClient(svnClient);
            }
        }
    }

    @Override
    public ISVNProperty getSvnProperty(String name) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            ISVNProperty prop;
            svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            ISVNProperty iSVNProperty = prop = svnClient.propertyGet(this.getFile(), name);
            return iSVNProperty;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
        }
    }

    @Override
    public ISVNProperty[] getSvnProperties() throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            ISVNProperty[] properties;
            svnClient = this.getRepository().getSVNClient();
            ISVNProperty[] iSVNPropertyArray = properties = svnClient.getProperties(this.getFile());
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
        finally {
            this.getRepository().returnSVNClient(svnClient);
        }
    }

    @Override
    public ISVNProperty[] getPropertiesIncludingInherited(boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            ISVNProperty[] properties;
            svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            ISVNProperty[] iSVNPropertyArray = properties = svnClient.getPropertiesIncludingInherited(this.getFile(), includeEmptyProperties, includeClosestOnly, filterProperties);
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
        }
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.getIResource())) {
            return this.getIResource();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalResource) {
            LocalResource resource = (LocalResource)obj;
            return resource.getResource().getFullPath().equals((Object)this.getResource().getFullPath());
        }
        return false;
    }

    public int hashCode() {
        return 23 * this.resource.getFullPath().hashCode();
    }
}

