/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.ResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteResourceStatus
extends ResourceStatus {
    public static final RemoteResourceStatus NONE = new RemoteResourceStatusNone();
    static final long serialVersionUID = 1L;
    protected long repositoryRevision;

    public static RemoteResourceStatus fromBytes(byte[] bytes) throws SVNException {
        return bytes != null && bytes.length > 0 ? new RemoteResourceStatus(bytes) : null;
    }

    protected RemoteResourceStatus() {
    }

    public RemoteResourceStatus(ISVNStatus realStatus, SVNRevision.Number revision) {
        super(realStatus, null, true);
        this.textStatus = realStatus.getRepositoryTextStatus().toInt();
        this.propStatus = realStatus.getRepositoryPropStatus().toInt();
        this.repositoryRevision = revision == null ? -1L : revision.getNumber();
        if (SVNStatusKind.EXTERNAL.equals((Object)realStatus.getTextStatus())) {
            this.textStatus = realStatus.getTextStatus().toInt();
        }
    }

    protected RemoteResourceStatus(byte[] bytes) throws SVNException {
        ResourceStatus.StatusFromBytesStream in = new ResourceStatus.StatusFromBytesStream(bytes);
        this.initFromBytes(in);
    }

    public SVNRevision.Number getRepositoryRevision() {
        if (this.repositoryRevision == -1L) {
            return null;
        }
        return new SVNRevision.Number(this.repositoryRevision);
    }

    public void updateFromInfo(ISVNInfo info) {
        if (info == null) {
            return;
        }
        Object aValue = null;
        aValue = info.getNodeKind();
        if (aValue != null) {
            this.nodeKind = aValue.toInt();
        }
        this.lastChangedDate = (aValue = info.getLastChangedDate()) == null ? -1L : ((Date)aValue).getTime();
        aValue = info.getLastChangedRevision();
        this.lastChangedRevision = aValue == null ? -1L : ((SVNRevision.Number)aValue).getNumber();
        this.lastCommitAuthor = info.getLastCommitAuthor();
        aValue = info.getUrl();
        this.url = aValue == null ? null : ((SVNUrl)aValue).toString();
    }

    protected void getBytesInto(ResourceStatus.StatusToBytesStream dos) {
        super.getBytesInto(dos);
        try {
            dos.writeLong(this.repositoryRevision);
            dos.writeString(this.file.getAbsolutePath());
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected int initFromBytes(ResourceStatus.StatusFromBytesStream dis) throws SVNException {
        int version = super.initFromBytes(dis);
        try {
            if (version >= 3) {
                this.readFromVersion3Stream(dis);
            } else {
                this.readFromVersion2Stream(dis);
            }
        }
        catch (IOException e) {
            throw new SVNException("cannot create RemoteResourceStatus from bytes", e);
        }
        return version;
    }

    private void readFromVersion3Stream(ResourceStatus.StatusFromBytesStream dis) throws IOException {
        this.repositoryRevision = dis.readLong();
        this.file = new File(dis.readString());
    }

    private void readFromVersion2Stream(ResourceStatus.StatusFromBytesStream dis) throws IOException {
        this.file = new File(dis.readUTF());
    }

    protected void setRevisionNumber(long revision) {
        this.repositoryRevision = revision;
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return this.getPropStatus();
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return this.getTextStatus();
    }

    public SVNRevision.Number getRevision() {
        return this.getRepositoryRevision();
    }

    public String getMovedFromAbspath() {
        return null;
    }

    public String getMovedToAbspath() {
        return null;
    }

    public File getConflictNew() {
        return null;
    }

    public File getConflictOld() {
        return null;
    }

    public File getConflictWorking() {
        return null;
    }

    public boolean isCopied() {
        return false;
    }

    public boolean isSwitched() {
        return false;
    }

    public boolean isWcLocked() {
        return false;
    }

    public String getLockComment() {
        throw new UnsupportedOperationException("Locks are not suported for RemoteResourceStatus");
    }

    public Date getLockCreationDate() {
        throw new UnsupportedOperationException("Locks are not suported for RemoteResourceStatus");
    }

    public String getLockOwner() {
        throw new UnsupportedOperationException("Locks are not suported for RemoteResourceStatus");
    }

    public static class RemoteResourceStatusNone
    extends RemoteResourceStatus {
        static final long serialVersionUID = 1L;

        protected RemoteResourceStatusNone() {
            this.nodeKind = SVNNodeKind.UNKNOWN.toInt();
            this.repositoryRevision = -1L;
            this.textStatus = SVNStatusKind.NONE.toInt();
            this.propStatus = SVNStatusKind.NONE.toInt();
        }

        public IResource getResource() {
            return null;
        }
    }
}

