/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConstraintNameSorter;
import zigen.plugin.db.core.ConstraintSeqSorter;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;

public class OracleConstraintSearcharFactory
extends DefaultConstraintSearcherFactory {
    private String getOtherCounstraintQuery(String schemaPattern, String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        CON.CONSTRAINT_NAME CONSTRAINT_NAME");
        sb.append("        ,COL.COLUMN_POSITION AS ORDINAL_POSITION");
        sb.append("        ,COL.COLUMN_NAME");
        sb.append("        ,IND.UNIQUENESS");
        sb.append("        ,IND.INDEX_TYPE");
        sb.append("        ,CON.SEARCH_CONDITION");
        sb.append("        ,CON.TABLE_NAME");
        sb.append("        ,DECODE(CON.CONSTRAINT_TYPE, 'P','PRIMARY KEY', 'R','FOREIGN KEY', 'C','CHECK', 'U', 'UNIQUE', 'UNKNOWN') CONSTRAINT_TYPE");
        sb.append("    FROM");
        sb.append("        ALL_INDEXES IND");
        sb.append("        ,ALL_CONSTRAINTS CON");
        sb.append("        ,ALL_IND_COLUMNS COL");
        sb.append("    WHERE");
        sb.append("        CON.OWNER = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
        sb.append("        AND CON.TABLE_NAME = '" + SQLUtil.encodeQuotation(tableName) + "'");
        sb.append("        AND (CON.GENERATED = 'USER NAME' OR (CON.GENERATED = 'GENERATED NAME' AND COLUMN_POSITION IS NOT NULL))");
        sb.append("        AND CON.OWNER = COL.INDEX_OWNER(+)");
        sb.append("        AND CON.CONSTRAINT_NAME = COL.INDEX_NAME(+)");
        sb.append("        AND CON.OWNER = COL.TABLE_OWNER(+)");
        sb.append("        AND CON.OWNER = IND.TABLE_OWNER(+)");
        sb.append("        AND CON.TABLE_NAME = IND.TABLE_NAME(+)");
        sb.append("        AND CON.CONSTRAINT_NAME = IND.INDEX_NAME(+)");
        sb.append("        AND CON.CONSTRAINT_TYPE NOT IN('P','R')");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableConstraintColumn[] getConstraintColumns(Connection con, String schemaPattern, String tableName) throws Exception {
        TableConstraintColumn[] tableConstraintColumnArray;
        ArrayList<TableConstraintColumn> list = new ArrayList<TableConstraintColumn>();
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                TimeWatcher tw = new TimeWatcher();
                tw.start();
                String sql = this.getOtherCounstraintQuery(schemaPattern, tableName);
                rs = st.executeQuery(sql);
                tw.stop();
                while (true) {
                    if (!rs.next()) {
                        Collections.sort(list, new ConstraintSeqSorter());
                        Collections.sort(list, new ConstraintNameSorter());
                        tableConstraintColumnArray = list.toArray(new TableConstraintColumn[0]);
                        Object var11_15 = null;
                        break;
                    }
                    String constraintName = rs.getString("CONSTRAINT_NAME");
                    if (constraintName == null) continue;
                    TableConstraintColumn column = new TableConstraintColumn();
                    column.setName(constraintName);
                    column.setOrdinal_position(rs.getInt("ORDINAL_POSITION"));
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    if ("UNIQUE".equals(rs.getString("UNIQUENESS"))) {
                        column.setNonUnique(false);
                    } else {
                        column.setNonUnique(true);
                    }
                    column.setIndexType(rs.getString("INDEX_TYPE"));
                    column.setSearch_condition(rs.getString("SEARCH_CONDITION"));
                    column.setConstraintType(rs.getString("CONSTRAINT_TYPE"));
                    list.add(column);
                }
            }
            catch (SQLException e) {
                DbPlugin.log(e);
                TableConstraintColumn[] tableConstraintColumnArray2 = new TableConstraintColumn[]{};
                Object var11_16 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                return tableConstraintColumnArray2;
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return tableConstraintColumnArray;
    }
}

