/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.JobException;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.views.SQLExecuteView;

public abstract class AbstractJob
extends Job {
    protected IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();

    public AbstractJob(String msg) {
        super(msg);
    }

    protected void showResults(Runnable action) {
        Display.getDefault().asyncExec(action);
    }

    protected void showSyncResults(Runnable action) {
        Display.getDefault().syncExec(action);
    }

    protected void showMessage(IStatusLineManager statusLineManager, String message) {
        Display.getDefault().asyncExec((Runnable)new ShowInformationMessageAction(statusLineManager, message));
    }

    protected void showWarningMessage(IStatusLineManager statusLineManager, String message) {
        Display.getDefault().asyncExec((Runnable)new ShowWarningMessageAction(statusLineManager, message));
    }

    protected void showErrorMessage(IStatusLineManager statusLineManager, String message, Throwable e) {
        Display.getDefault().asyncExec((Runnable)new ShowErrorMessageAction(message, e));
    }

    protected void showWarningMessage(String message) {
        Display.getDefault().asyncExec((Runnable)new ShowWarningMessageAction(message));
    }

    protected void showErrorMessage(String message, Throwable e) {
        Display.getDefault().asyncExec((Runnable)new ShowErrorMessageAction(message, e));
    }

    protected void updateMessage(IDBConfig config, String message, String secondaryId) {
        Display.getDefault().asyncExec((Runnable)new UpdateStatusMessageAction(message, secondaryId));
    }

    public class ShowErrorMessageAction
    implements Runnable {
        Throwable e;
        String msg;

        public ShowErrorMessageAction(String msg, Throwable e) {
            this.msg = msg;
            this.e = e;
        }

        public void run() {
            try {
                JobException je = new JobException(this.msg, this.e);
                DbPlugin.getDefault().showErrorDialog(je);
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }

    public class ShowInformationMessageAction
    implements Runnable {
        String msg = null;
        IStatusLineManager statusLineManager;

        public ShowInformationMessageAction(String msg) {
            this.msg = msg;
        }

        public ShowInformationMessageAction(IStatusLineManager statusLineManager, String msg) {
            this.msg = msg;
            this.statusLineManager = statusLineManager;
        }

        public void run() {
            try {
                if (this.statusLineManager == null) {
                    DbPlugin.getDefault().showInformationMessage(this.msg);
                } else {
                    this.statusLineManager.setMessage(this.msg);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }

    public class ShowWarningMessageAction
    implements Runnable {
        String msg = null;
        IStatusLineManager statusLineManager;

        public ShowWarningMessageAction(String msg) {
            this.msg = msg;
        }

        public ShowWarningMessageAction(IStatusLineManager statusLineManager, String msg) {
            this.msg = msg;
            this.statusLineManager = statusLineManager;
        }

        public void run() {
            try {
                if (this.statusLineManager == null) {
                    DbPlugin.getDefault().showWarningMessage(this.msg);
                } else {
                    this.statusLineManager.setErrorMessage(this.msg);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }

    public class UpdateStatusMessageAction
    implements Runnable {
        private String message;
        private String secondaryId;

        public UpdateStatusMessageAction(String message, String secondaryId) {
            this.message = message;
            this.secondaryId = secondaryId;
        }

        public void run() {
            try {
                SQLExecuteView view = null;
                view = this.secondaryId == null ? (SQLExecuteView)DbPlugin.findView("zigen.plugin.db.ui.views.SQLExecuteView") : (SQLExecuteView)DbPlugin.findView("zigen.plugin.db.ui.views.SQLExecuteView", this.secondaryId);
                if (view != null) {
                    view.setStatusMessage(this.message);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

