/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.QualifiedName;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;

public class FileUtil {
    public static IDBConfig getDBConfig(IFile file) {
        String dbName = FileUtil.getDBConfigName(file);
        if (dbName != null) {
            return DBConfigManager.getDBConfig(dbName);
        }
        return null;
    }

    static String getDBConfigName(IFile file) {
        String dbName = null;
        try {
            if (file.isAccessible()) {
                dbName = file.getPersistentProperty(new QualifiedName("zigen.plugin.db", "SELECTED_DB"));
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return dbName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContents(IFile file) {
        char[] buffer = new char[4096];
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            String string;
            reader = new BufferedReader(new InputStreamReader(file.getContents()));
            while (true) {
                int len;
                if ((len = reader.read(buffer)) == -1) {
                    string = sb.toString();
                    Object var6_6 = null;
                    break;
                }
                sb.append(new String(buffer, 0, len));
            }
            try {
                if (reader == null) return string;
                reader.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException iOException) {}
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (reader == null) return null;
        reader.close();
        return null;
    }

    public static boolean isSqlFile(IFile file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".sql");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContents(File file) {
        char[] buffer = new char[4096];
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            String string;
            reader = new BufferedReader(new FileReader(file));
            while (true) {
                int len;
                if ((len = reader.read(buffer)) == -1) {
                    string = sb.toString();
                    Object var6_6 = null;
                    break;
                }
                sb.append(new String(buffer, 0, len));
            }
            try {
                if (reader == null) return string;
                reader.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException iOException) {}
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (reader == null) return null;
        reader.close();
        return null;
    }

    public static boolean isSqlFile(File file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".sql");
    }

    public static boolean rename(File file) {
        String folder = file.getParent();
        String fileName = file.getName();
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd");
        String date = format.format(Calendar.getInstance().getTime());
        String suffix = "." + date + "_bak";
        return file.renameTo(new File(String.valueOf(folder) + File.separator + fileName + suffix));
    }
}

