/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import com.collabnet.subversion.merge.wizards.MergeWizardRevisionsPage;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BlockMergeInputProvider
implements IMergeInputProvider {
    private String text;
    private String description;
    private Image image;
    private int sequence;
    private MergeWizardStandardPage standardPage;
    private MergeWizardRevisionsPage revisionsPage;
    private WizardPage[] wizardPages;

    public boolean enabledForMultipleSelection() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.standardPage) {
            return this.revisionsPage;
        }
        return null;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getText() {
        return this.text;
    }

    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.standardPage = new MergeWizardStandardPage("standardBlock", Messages.BlockMergeInputProvider_selectMergeSource, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), Messages.BlockMergeInputProvider_specifyLocations, false, false);
            this.revisionsPage = new MergeWizardRevisionsPage("revisionsBlock", Messages.BlockMergeInputProvider_selectRevisions, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), this.standardPage, Messages.BlockMergeInputProvider_specifyRevisions);
            WizardPage[] pages = new WizardPage[]{this.standardPage, this.revisionsPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        IResource[] resources = this.standardPage.getResources();
        SVNUrl[] urls = this.standardPage.getUrls();
        SVNRevisionRange[] revisions = this.revisionsPage.getRevisions();
        HashSet<IResource> usedResources = new HashSet<IResource>();
        Map<SVNRevision.Number, List<IResource>> map = this.revisionsPage.getRevisionToResource();
        if (map.size() > 0) {
            ILogEntry[] entries = this.revisionsPage.getSelectedLogEntries();
            int i = 0;
            while (i < entries.length) {
                List<IResource> lst = map.get(entries[i].getRevision());
                usedResources.addAll(lst);
                ++i;
            }
            if (usedResources.size() > 0) {
                ArrayList<SVNUrl> urlsList = new ArrayList<SVNUrl>();
                ArrayList<IResource> resourcesList = new ArrayList<IResource>();
                int i2 = 0;
                while (i2 < resources.length) {
                    if (usedResources.contains(resources[i2])) {
                        urlsList.add(urls[i2]);
                        resourcesList.add(resources[i2]);
                    }
                    ++i2;
                }
                resources = resourcesList.toArray(new IResource[resourcesList.size()]);
                urls = urlsList.toArray(new SVNUrl[urlsList.size()]);
            }
        }
        MergeOperation mergeOperation = new MergeOperation(targetPart, resources, urls, null, urls, null, revisions, null);
        mergeOperation.setRecordOnly(true);
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.BlockMergeInputProvider_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BlockMergeInputProvider_merge, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }

    public boolean showOptionsPage() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hideDepth() {
        return true;
    }

    public boolean hideForce() {
        return true;
    }

    public boolean hideIgnoreAncestry() {
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public boolean showBestPracticesPage() {
        return false;
    }
}

