/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.io.IOException;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;

public class SVNBaseDir {
    protected static File getCommonPart(File file1, File file2) {
        int parts2Length;
        int parts1Length;
        String file2AbsPath;
        if (file1 == null) {
            return null;
        }
        if (file2 == null) {
            return null;
        }
        String file1AbsPath = file1.getAbsolutePath();
        if (file1AbsPath.equals(file2AbsPath = file2.getAbsolutePath())) {
            return new File(file1AbsPath);
        }
        String[] file1Parts = StringUtils.split(file1AbsPath, File.separatorChar);
        String[] file2Parts = StringUtils.split(file2AbsPath, File.separatorChar);
        if (file1Parts[0].equals("")) {
            file1Parts[0] = File.separator;
        }
        if (file2Parts[0].equals("")) {
            file2Parts[0] = File.separator;
        }
        int minLength = (parts1Length = file1Parts.length) < (parts2Length = file2Parts.length) ? parts1Length : parts2Length;
        StringBuffer commonsPart = new StringBuffer();
        int i = 0;
        while (i < minLength) {
            String part1 = file1Parts[i];
            String part2 = file2Parts[i];
            if (!part1.equals(part2)) break;
            if (i > 0) {
                commonsPart.append(File.separatorChar);
            }
            commonsPart.append(part1);
            ++i;
        }
        if (commonsPart.length() == 0) {
            return null;
        }
        return new File(commonsPart.toString());
    }

    public static File getBaseDir(File file) {
        return SVNBaseDir.getBaseDir(new File[]{file});
    }

    public static File getBaseDir(File[] files) {
        File rootDir = SVNBaseDir.getRootDir(files);
        File baseDir = SVNBaseDir.getCommonPart(rootDir, new File("."));
        return baseDir;
    }

    public static File getRootDir(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        File[] canonicalFiles = new File[files.length];
        int i = 0;
        while (i < files.length) {
            canonicalFiles[i] = files[i].getAbsoluteFile();
            ++i;
        }
        File commonPart = canonicalFiles[0];
        int i2 = 0;
        while (i2 < files.length) {
            if ((commonPart = SVNBaseDir.getCommonPart(commonPart, canonicalFiles[i2])) == null) {
                return null;
            }
            ++i2;
        }
        if (commonPart.isFile()) {
            return commonPart.getParentFile();
        }
        return commonPart;
    }

    public static String getRelativePath(File rootDir, File file) throws SVNClientException {
        String filePath;
        String rootPath;
        block3: {
            try {
                rootPath = rootDir.getCanonicalPath();
                filePath = file.getCanonicalPath();
                if (filePath.startsWith(rootPath)) break block3;
                return null;
            }
            catch (IOException e) {
                throw SVNClientException.wrapException(e);
            }
        }
        return filePath.substring(rootPath.length());
    }
}

