/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;

public class EclipseSVNAuthenticationManager
extends DefaultSVNAuthenticationManager {
    private static URL DEFAULT_URL;

    public EclipseSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password, File keyFile, String passphrase) {
        super(configDirectory, storeAuth, userName, password, keyFile, passphrase);
    }

    @Override
    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir, String userName) {
        return new KeyringAuthenticationProvider();
    }

    @Override
    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean allowSave) {
        return new DefaultSVNAuthenticationManager.DumbAuthenticationProvider(userName, password, privateKey, passphrase, allowSave){

            @Override
            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 2;
            }
        };
    }

    static {
        try {
            DEFAULT_URL = new URL("http://tmate.org/svn/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static class KeyringAuthenticationProvider
    implements ISVNAuthenticationProvider,
    ISVNPersistentAuthenticationProvider {
        @Override
        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            realm = realm == null ? DEFAULT_URL.toString() : realm;
            Map info = Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)kind);
            if (info != null && "svn.ssl.client-passphrase".equals(kind)) {
                String sslKind = (String)info.get("ssl-kind");
                if (sslKind != null && "MSCAPI".equals(sslKind)) {
                    String alias = (String)info.get("alias");
                    return new SVNSSLAuthentication(sslKind, alias, authMayBeStored, url, false);
                }
                String password = (String)info.get("password");
                if (SVNSSLAuthentication.isCertificatePath(realm)) {
                    if (password != null) {
                        return new SVNPasswordAuthentication("", password, authMayBeStored, url, false);
                    }
                } else {
                    String path = (String)info.get("cert");
                    if (path != null) {
                        SVNSSLAuthentication auth = new SVNSSLAuthentication(new File(path), password, authMayBeStored, url, false);
                        auth.setCertificatePath(path);
                        return auth;
                    }
                }
            } else if (info != null && !info.isEmpty() && info.get("username") != null) {
                if ("svn.simple".equals(kind)) {
                    return new SVNPasswordAuthentication((String)info.get("username"), (String)info.get("password"), authMayBeStored, url, false);
                }
                if ("svn.ssh".equals(kind)) {
                    int port;
                    int n = port = url.hasPort() ? url.getPort() : -1;
                    if (port < 0 && info.get("port") != null) {
                        port = Integer.parseInt((String)info.get("port"));
                    }
                    if (port < 0) {
                        port = url.getPort();
                    }
                    if (info.get("key") != null) {
                        File keyPath = new File((String)info.get("key"));
                        return new SVNSSHAuthentication((String)info.get("username"), keyPath, (String)info.get("passphrase"), port, authMayBeStored, url, false);
                    }
                    if (info.get("password") != null) {
                        return new SVNSSHAuthentication((String)info.get("username"), (String)info.get("password"), port, authMayBeStored, url, false);
                    }
                } else if ("svn.username".equals(kind)) {
                    return new SVNUserNameAuthentication((String)info.get("username"), authMayBeStored, url, false);
                }
            }
            return null;
        }

        @Override
        public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
            return 1;
        }

        @Override
        public void saveAuthentication(SVNAuthentication auth, String kind, String realm) {
            if (!(auth instanceof SVNSSLAuthentication) && (auth.getUserName() == null || "".equals(auth.getUserName()))) {
                return;
            }
            realm = realm == null ? DEFAULT_URL.toString() : realm;
            SVNHashMap info = new SVNHashMap();
            info.put("username", auth.getUserName());
            if (auth instanceof SVNPasswordAuthentication) {
                info.put("password", ((SVNPasswordAuthentication)auth).getPassword());
            } else if (auth instanceof SVNSSHAuthentication) {
                SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
                if (sshAuth.getPrivateKeyFile() != null) {
                    info.put("key", sshAuth.getPrivateKeyFile().getAbsolutePath());
                    if (sshAuth.getPassphrase() != null) {
                        info.put("passphrase", sshAuth.getPassphrase());
                    }
                } else if (sshAuth.getPassword() != null) {
                    info.put("password", sshAuth.getPassword());
                }
                if (sshAuth.getPortNumber() >= 0) {
                    info.put("port", Integer.toString(sshAuth.getPortNumber()));
                }
            } else if (auth instanceof SVNSSLAuthentication) {
                SVNSSLAuthentication sslAuth = (SVNSSLAuthentication)auth;
                String password = sslAuth.getPassword();
                if (password != null && !"".equals(password)) {
                    info.put("password", password);
                }
                if ("SSL".equals(sslAuth.getSSLKind())) {
                    String path = sslAuth.getCertificatePath();
                    if (path != null) {
                        info.put("cert", path);
                    }
                } else if ("MSCAPI".equals(sslAuth.getSSLKind())) {
                    info.put("ssl-kind", sslAuth.getSSLKind());
                    info.put("alias", sslAuth.getAlias());
                }
            }
            try {
                Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)kind, (Map)info);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }

        @Override
        public byte[] loadFingerprints(String realm) {
            Map info = Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)"svn.ssh.server");
            if (info != null && realm.equals(info.get("svn:realmstring"))) {
                return (byte[])info.get("hostkey");
            }
            return null;
        }

        @Override
        public void saveFingerprints(String realm, byte[] fingerprints) {
            SVNHashMap info = new SVNHashMap();
            info.put("svn:realmstring", realm);
            info.put("hostkey", fingerprints);
            try {
                Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)"svn.ssh.server", (Map)info);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }
}

