/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse;

import java.util.Vector;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String TEXT_FONT = "net.sf.colorer.eclipse.presentation.textfont";
    public static final String SPACES_FOR_TABS = "SPACES_FOR_TABS";
    public static final String WORD_WRAP = "WORD_WRAP";
    public static final String WORD_WRAP_PATCH = "WordWrapPatch";
    public static final String FULL_BACK = "FULL_BACK";
    public static final String VERT_CROSS = "VERT_CROSS";
    public static final String HORZ_CROSS = "HORZ_CROSS";
    public static final String HRD_SET = "HRD_SET";
    public static final String USE_BACK = "USE_BACK";
    public static final String PAIRS_MATCH = "PAIRS_MATCH";
    public static final String PROJECTION = "PROJECTION";
    public static final String BACK_SCALE = "BACK_SCALE";
    Combo hrdSets;
    Vector hrdSetsList;

    public PreferencePage() {
        super(Messages.get("prefs.title"), 1);
        this.setPreferenceStore(ColorerPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench iworkbench) {
    }

    public boolean performOk() {
        if (this.hrdSetsList != null) {
            this.getPreferenceStore().setValue(HRD_SET, (String)this.hrdSetsList.elementAt(this.hrdSets.getSelectionIndex()));
        }
        super.performOk();
        return true;
    }

    protected void performApply() {
        if (this.hrdSetsList != null) {
            this.getPreferenceStore().setValue(HRD_SET, (String)this.hrdSetsList.elementAt(this.hrdSets.getSelectionIndex()));
        }
        super.performApply();
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.createHeader(p);
        this.addField((FieldEditor)new BooleanFieldEditor(SPACES_FOR_TABS, Messages.get(SPACES_FOR_TABS), p));
        this.addField((FieldEditor)new BooleanFieldEditor(WORD_WRAP, Messages.get(WORD_WRAP), p));
        this.addField((FieldEditor)new BooleanFieldEditor(WORD_WRAP_PATCH, Messages.get(WORD_WRAP_PATCH), p));
        this.addField((FieldEditor)new BooleanFieldEditor(FULL_BACK, Messages.get(FULL_BACK), p));
        this.addField((FieldEditor)new BooleanFieldEditor(HORZ_CROSS, Messages.get(HORZ_CROSS), p));
        this.addField((FieldEditor)new BooleanFieldEditor(PROJECTION, Messages.get(PROJECTION), p));
        String[][] arrPairs = new String[4][2];
        arrPairs[0][0] = Messages.get("PAIRS_NO");
        arrPairs[0][1] = "PAIRS_NO";
        arrPairs[1][0] = Messages.get("PAIRS_XOR");
        arrPairs[1][1] = "PAIRS_XOR";
        arrPairs[2][0] = Messages.get("PAIRS_OUTLINE");
        arrPairs[2][1] = "PAIRS_OUTLINE";
        arrPairs[3][0] = Messages.get("PAIRS_OUTLINE2");
        arrPairs[3][1] = "PAIRS_OUTLINE2";
        this.addField((FieldEditor)new RadioGroupFieldEditor(PAIRS_MATCH, Messages.get(PAIRS_MATCH), 1, arrPairs, p));
        new Label(p, 0).setText(Messages.get(HRD_SET));
        this.hrdSets = new Combo(p, 12);
        ParserFactory pf = ColorerPlugin.getDefaultPF();
        this.hrdSetsList = ColorerPlugin.getDefault().getHRDList();
        for (int idx = 0; idx < this.hrdSetsList.size(); ++idx) {
            String hrd_name = (String)this.hrdSetsList.elementAt(idx);
            String hrd_descr = pf.getHRDescription("rgb", hrd_name);
            this.hrdSets.add(hrd_descr);
            if (!this.getPreferenceStore().getString(HRD_SET).equals(hrd_name)) continue;
            this.hrdSets.select(this.hrdSets.getItemCount() - 1);
        }
        this.hrdSets.setVisibleItemCount(10);
        this.addField((FieldEditor)new BooleanFieldEditor(USE_BACK, Messages.get(USE_BACK), p));
        ScaleFieldEditor back_scale = new ScaleFieldEditor(BACK_SCALE, Messages.get(BACK_SCALE), p, 0, 10, 1, 5);
        this.addField((FieldEditor)back_scale);
    }

    private void createHeader(Composite contents) {
        final Link link = new Link(contents, 0);
        String target = "org.eclipse.ui.preferencePages.GeneralTextEditor";
        link.setText(Messages.get("TextEditorsRef"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
    }
}

