/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.ftpp;

import java.util.Vector;
import net.sf.colorer.FileType;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.ftpp.FileTypesContentProvider;
import net.sf.colorer.eclipse.ftpp.FileTypesLabelProvider;
import net.sf.colorer.eclipse.ftpp.TypeContentProvider;
import net.sf.colorer.eclipse.ftpp.TypeLabelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FileTypePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    TypeContentProvider typePropertiesProvider;
    TableViewer typePropertiesViewer;
    Table typePropertiesTable;
    TreeViewer typeTreeViewer;
    ComboBoxCellEditor paramCellEditor;
    FileType currentType;
    Vector hrdList = ColorerPlugin.getDefault().getHRDList();
    String[] values_TrueFalseDefault = new String[3];
    String[] values_TrueFalse = new String[2];
    String[] valuesHRD;

    public FileTypePreferencePage() {
        this.setPreferenceStore(ColorerPlugin.getDefault().getPreferenceStore());
        this.values_TrueFalseDefault[0] = Messages.get("ftpp.default");
        this.values_TrueFalseDefault[1] = Messages.get("ftpp.false");
        this.values_TrueFalseDefault[2] = Messages.get("ftpp.true");
        this.values_TrueFalse[0] = Messages.get("ftpp.false");
        this.values_TrueFalse[1] = Messages.get("ftpp.true");
    }

    public void init(IWorkbench iworkbench) {
    }

    public void applyData(Object data) {
        if (data != null && data instanceof FileType && this.typeTreeViewer != null) {
            this.typeTreeViewer.expandAll();
            this.typeTreeViewer.setSelection((ISelection)new StructuredSelection(data), true);
        }
    }

    public boolean performOk() {
        this.currentType = null;
        this.typePropertiesViewer.setInput(null);
        this.typeTreeViewer.setInput(null);
        ColorerPlugin.getDefault().reloadParserFactory();
        this.typeTreeViewer.setInput((Object)ColorerPlugin.getDefaultPF());
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    protected void performDefaults() {
        this.currentType = null;
        this.typePropertiesViewer.setInput(null);
        this.typeTreeViewer.setInput(null);
        ColorerPlugin.getDefault().resetHRCParameters();
        ColorerPlugin.getDefault().reloadParserFactory();
        super.performDefaults();
        this.typeTreeViewer.setInput((Object)ColorerPlugin.getDefaultPF());
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ParserFactory pf = ColorerPlugin.getDefaultPF();
        this.typePropertiesProvider = new TypeContentProvider();
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree(composite, 68352, patternFilter);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.grabExcessVerticalSpace = true;
        filter.setLayoutData((Object)gd);
        this.typeTreeViewer = filter.getViewer();
        this.typeTreeViewer.setContentProvider((IContentProvider)new FileTypesContentProvider());
        this.typeTreeViewer.setLabelProvider((IBaseLabelProvider)new FileTypesLabelProvider());
        this.typeTreeViewer.setInput((Object)pf);
        this.typeTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)new TreeViewSelection());
        this.typeTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object source = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ((TreeViewer)event.getViewer()).setExpandedState(source, !((TreeViewer)event.getViewer()).getExpandedState(source));
            }
        });
        this.typePropertiesViewer = new TableViewer(composite, 68352);
        this.typePropertiesTable = this.typePropertiesViewer.getTable();
        this.typePropertiesViewer.setContentProvider((IContentProvider)this.typePropertiesProvider);
        this.typePropertiesViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider(this.typePropertiesProvider));
        TableColumn tc = new TableColumn(this.typePropertiesTable, 16384);
        tc.setText(Messages.get("ftpp.Parameter"));
        tc.setWidth(300);
        tc = new TableColumn(this.typePropertiesTable, 16384);
        tc.setText(Messages.get("ftpp.Value"));
        tc.setWidth(150);
        CellEditor[] cellEditors = new CellEditor[this.typePropertiesViewer.getTable().getColumnCount()];
        this.paramCellEditor = new ComboBoxCellEditor((Composite)this.typePropertiesTable, this.values_TrueFalseDefault, 8);
        cellEditors[1] = this.paramCellEditor;
        this.typePropertiesViewer.setCellEditors(cellEditors);
        this.typePropertiesViewer.setCellModifier((ICellModifier)new FileTypeCellModifier());
        this.typePropertiesViewer.setColumnProperties(new String[]{"name", "value"});
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.typePropertiesTable.setLayoutData((Object)gd);
        this.typePropertiesTable.setHeaderVisible(true);
        this.typePropertiesTable.setLinesVisible(true);
        this.typePropertiesViewer.setInput(null);
        this.valuesHRD = new String[this.hrdList.size() + 1];
        this.valuesHRD[0] = Messages.get("ftpp.default");
        for (int idx = 1; idx < this.valuesHRD.length; ++idx) {
            this.valuesHRD[idx] = pf.getHRDescription("rgb", (String)this.hrdList.elementAt(idx - 1));
        }
        return composite;
    }

    class TreeViewSelection
    implements ISelectionChangedListener {
        TreeViewSelection() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection != null && selection instanceof FileType) {
                FileTypePreferencePage.this.currentType = (FileType)selection;
                FileTypePreferencePage.this.typePropertiesViewer.setInput(selection);
            } else {
                FileTypePreferencePage.this.currentType = null;
                FileTypePreferencePage.this.typePropertiesViewer.setInput(null);
            }
            FileTypePreferencePage.this.typePropertiesViewer.refresh();
        }
    }

    class FileTypeCellModifier
    implements ICellModifier {
        FileTypeCellModifier() {
        }

        public Object getValue(Object element, String property) {
            if (element.equals("@@HRD@@")) {
                String hrd = ColorerPlugin.getDefault().getPropertyHRD(FileTypePreferencePage.this.currentType);
                return new Integer(FileTypePreferencePage.this.hrdList.indexOf(hrd) + 1);
            }
            if (element.equals("@@WORD_WRAP@@")) {
                return new Integer(ColorerPlugin.getDefault().getPropertyWordWrap(FileTypePreferencePage.this.currentType) + 1);
            }
            int val = ColorerPlugin.getDefault().getPropertyParameter(FileTypePreferencePage.this.currentType, element.toString());
            return new Integer(val);
        }

        public boolean canModify(Object element, String property) {
            if (element.equals("@@HRD@@")) {
                FileTypePreferencePage.this.paramCellEditor.setItems(FileTypePreferencePage.this.valuesHRD);
                return true;
            }
            if (element.equals("@@WORD_WRAP@@")) {
                FileTypePreferencePage.this.paramCellEditor.setItems(FileTypePreferencePage.this.values_TrueFalseDefault);
                return true;
            }
            FileTypePreferencePage.this.paramCellEditor.setItems(FileTypePreferencePage.this.values_TrueFalse);
            String pval = FileTypePreferencePage.this.typePropertiesProvider.type.getParameterDefaultValue(element.toString());
            return pval.equals("true") || pval.equals("false");
        }

        public void modify(Object element, String property, Object value) {
            int i;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element.equals("@@HRD@@")) {
                i = (Integer)value;
                if (i == 0) {
                    ColorerPlugin.getDefault().setPropertyHRD(FileTypePreferencePage.this.currentType, "");
                } else {
                    ColorerPlugin.getDefault().setPropertyHRD(FileTypePreferencePage.this.currentType, (String)FileTypePreferencePage.this.hrdList.elementAt(i - 1));
                }
            }
            if (element.equals("@@WORD_WRAP@@")) {
                i = (Integer)value;
                ColorerPlugin.getDefault().setPropertyWordWrap(FileTypePreferencePage.this.currentType, i - 1);
            }
            i = (Integer)value;
            ColorerPlugin.getDefault().setPropertyParameter(FileTypePreferencePage.this.currentType, element.toString(), i);
            FileTypePreferencePage.this.typePropertiesViewer.refresh();
        }
    }
}

