/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.outline;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.colorer.Region;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.ImageStore;
import net.sf.colorer.eclipse.outline.IWorkbenchOutlineSource;
import net.sf.colorer.eclipse.outline.OutlineElement;
import net.sf.colorer.editor.OutlineItem;
import net.sf.colorer.editor.Outliner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkbenchOutliner
extends Outliner
implements IWorkbenchAdapter,
IWorkbenchOutlineSource {
    Hashtable iconsHash = new Hashtable();
    boolean hierarchy = true;
    static final String defaultIconName = "outline" + File.separator + "def" + File.separator + "Outlined";
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public WorkbenchOutliner(Region filter) {
        super(filter);
    }

    public void setHierarchy(boolean hierarchy) {
        this.hierarchy = hierarchy;
        this.notifyUpdate();
    }

    public void setSorting(boolean sorting) {
    }

    public OutlineItem createItem(int lno, int sx, int length, int curLevel, String itemLabel, Region region) {
        return new OutlineElement(this, lno, sx, length, curLevel, itemLabel, region);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = WorkbenchOutliner.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object object) {
        Vector<OutlineItem> elements;
        block10: {
            OutlineElement el;
            int idx;
            block9: {
                elements = new Vector<OutlineItem>();
                if (this.hierarchy) break block9;
                if (object != this) break block10;
                for (int idx2 = 0; idx2 < this.itemCount(); ++idx2) {
                    elements.addElement(this.getItem(idx2));
                }
                break block10;
            }
            if (object == this) {
                int flevel = 0x100000;
                for (int idx3 = 0; idx3 < this.itemCount(); ++idx3) {
                    if (flevel > this.getItem((int)idx3).level) {
                        flevel = this.getItem((int)idx3).level;
                    }
                    if (this.getItem((int)idx3).level > flevel) continue;
                    elements.addElement(this.getItem(idx3));
                }
            } else if (object instanceof OutlineElement && (idx = this.fOutlineStorage.indexOf(el = (OutlineElement)object)) > -1) {
                int flevel = 0x100000;
                ++idx;
                while (idx < this.itemCount() && this.getItem((int)idx).level > el.level) {
                    if (flevel > this.getItem((int)idx).level) {
                        flevel = this.getItem((int)idx).level;
                    }
                    if (this.getItem((int)idx).level <= flevel) {
                        elements.addElement(this.getItem(idx));
                    }
                    ++idx;
                }
            }
        }
        return elements.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor id = null;
        if (object instanceof OutlineElement) {
            OutlineElement el = (OutlineElement)object;
            id = (ImageDescriptor)this.iconsHash.get(el.region);
            if (id == null) {
                String iconName = this.getIconName(el.region);
                if (iconName == null || iconName.equals(defaultIconName)) {
                    int textindex = el.region.getName().indexOf(58);
                    String text = el.region.getName().substring(textindex + 1, textindex + 2).toUpperCase();
                    Image i = new Image((Device)Display.getCurrent(), 16, 16);
                    GC gc = new GC((Drawable)i);
                    Image def = ImageStore.getID(defaultIconName).createImage();
                    int cw = gc.getFontMetrics().getAverageCharWidth();
                    int ch = gc.getFontMetrics().getHeight();
                    gc.drawImage(def, 0, 0);
                    gc.setAlpha(220);
                    gc.setTextAntialias(1);
                    gc.setForeground(ColorerPlugin.getDefault().getColorManager().getColor(true, 0xDDDDDD));
                    gc.drawText(text, 16 - cw - 2, 16 - ch - 2, 1);
                    gc.setForeground(ColorerPlugin.getDefault().getColorManager().getColor(true, 0x106010));
                    gc.drawText(text, 16 - cw - 1, 16 - ch - 1, 1);
                    id = ImageDescriptor.createFromImageData((ImageData)i.getImageData());
                    def.dispose();
                    gc.dispose();
                } else {
                    id = ImageStore.getID(iconName);
                }
                this.iconsHash.put(el.region, id);
            }
        }
        return id;
    }

    String getIconName(Region region) {
        ImageDescriptor id;
        if (region == null) {
            return null;
        }
        String iconName = null;
        while (region != null && (id = ImageStore.getID(iconName = "outline" + File.separator + region.getName().replace(':', File.separatorChar))) == null) {
            iconName = null;
            region = region.getParent();
        }
        return iconName;
    }

    public String getLabel(Object object) {
        if (object instanceof OutlineElement) {
            OutlineElement el = (OutlineElement)object;
            return el.token.toString();
        }
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getItemByLine(int line) {
        int s = -1;
        int e = this.itemCount();
        OutlineItem found = null;
        int idx = s + (e - s) / 2;
        while (e - s > 1) {
            OutlineItem item = this.getItem(idx);
            if (item.lno == line) {
                return item;
            }
            if (item.lno > line) {
                e = idx;
            } else if (item.lno < line) {
                found = item;
                s = idx;
            }
            idx = s + (e - s) / 2;
        }
        return found;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

