/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.impl;

import java.util.Vector;
import net.sf.colorer.FileType;
import net.sf.colorer.HRCParser;
import net.sf.colorer.LineSource;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.Region;
import net.sf.colorer.RegionHandler;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.EditorListener;
import net.sf.colorer.editor.PairMatch;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.handlers.RegionDefine;
import net.sf.colorer.handlers.RegionMapper;

public class BaseEditorNative
implements BaseEditor {
    private long iptr;
    boolean disposed = false;
    int wStart;
    int wSize;
    int lineCount;
    Region defPairStart = null;
    Region defPairEnd = null;
    Vector editorListeners = new Vector();
    ParserFactory fParserFactory;
    RegionMapper regionMapper;

    public BaseEditorNative(ParserFactory pf, LineSource lineSource) {
        this.iptr = this.init(pf, lineSource);
        this.fParserFactory = pf;
        HRCParser hrcParser = pf.getHRCParser();
        this.defPairStart = hrcParser.getRegion("def:PairStart");
        this.defPairEnd = hrcParser.getRegion("def:PairEnd");
        this.setBackParse(2000);
    }

    void checkActive() {
        if (this.disposed) {
            throw new RuntimeException("checkActive");
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.checkActive();
        this.disposed = true;
        this.regionMapper = null;
        this.finalize(this.iptr);
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
    }

    public void setRegionCompact(boolean compact) {
        this.checkActive();
        this.setRegionCompact(this.iptr, compact);
    }

    public void setFileType(FileType typename) {
        this.checkActive();
        this.setFileType(this.iptr, typename);
        this.modifyEvent(this.iptr, 0);
    }

    public FileType chooseFileType(String fname) {
        this.checkActive();
        this.modifyEvent(this.iptr, 0);
        return this.chooseFileType(this.iptr, fname);
    }

    public FileType getFileType() {
        this.checkActive();
        return this.getFileType(this.iptr);
    }

    public void setRegionMapper(RegionMapper regionMapper) {
        this.checkActive();
        this.setRegionMapper(this.iptr, regionMapper);
        this.regionMapper = regionMapper;
        this.modifyEvent(this.iptr, 0);
    }

    public void setRegionMapper(String hrdClass, String hrdName) {
        this.checkActive();
        this.setRegionMapper(this.iptr, hrdClass, hrdName);
        this.modifyEvent(this.iptr, 0);
    }

    public void addRegionHandler(RegionHandler rh, Region filter) {
        this.checkActive();
        this.addRegionHandler(this.iptr, rh, filter);
    }

    public void removeRegionHandler(RegionHandler rh) {
        this.checkActive();
        this.removeRegionHandler(this.iptr, rh);
    }

    public void addEditorListener(EditorListener el) {
        this.checkActive();
        this.editorListeners.add(el);
    }

    public void removeEditorListener(EditorListener el) {
        this.checkActive();
        this.editorListeners.remove(el);
    }

    public RegionDefine getBackground() {
        this.checkActive();
        return this.getBackground(this.iptr);
    }

    public RegionDefine getVertCross() {
        this.checkActive();
        return this.getVertCross(this.iptr);
    }

    public RegionDefine getHorzCross() {
        this.checkActive();
        return this.getHorzCross(this.iptr);
    }

    public void setBackParse(int backParse) {
        this.checkActive();
        this.setBackParse(this.iptr, backParse);
    }

    public PairMatch getPairMatch(int lineNo, int linePos) {
        this.checkActive();
        LineRegion[] lrArray = this.getLineRegions(lineNo);
        if (lrArray.length == 0) {
            return null;
        }
        LineRegion pair = null;
        for (int idx = 0; idx < lrArray.length; ++idx) {
            LineRegion l1 = lrArray[idx];
            if (l1.region == null || !l1.region.hasParent(this.defPairStart) && !l1.region.hasParent(this.defPairEnd) || linePos < l1.start || linePos > l1.end) continue;
            pair = l1;
        }
        if (pair != null) {
            PairMatch pm = new PairMatch(pair, null, lineNo, -1, -1, false);
            if (pair.region.hasParent(this.defPairStart)) {
                pm.pairBalance = 1;
                pm.topPosition = true;
            }
            return pm;
        }
        return null;
    }

    int getLastVisibleLine() {
        this.checkActive();
        int r1 = this.wStart + this.wSize;
        int r2 = this.lineCount;
        return (r1 > r2 ? r2 : r1) - 1;
    }

    void searchPair(PairMatch pm, int start_line, int end_line) {
        int li;
        this.checkActive();
        LineRegion pair = pm.start;
        int lno = pm.sline;
        LineRegion[] slr = this.getLineRegions(lno);
        for (li = 0; li < slr.length && slr[li] != pair; ++li) {
        }
        if (li == slr.length) {
            return;
        }
        while (true) {
            if (pm.pairBalance > 0) {
                ++li;
                while (li == slr.length && ++lno <= end_line) {
                    slr = this.getLineRegions(lno);
                    li = 0;
                }
                if (lno > end_line) break;
                pair = slr[li];
            } else {
                while (li == 0 && --lno >= start_line) {
                    slr = this.getLineRegions(lno);
                    li = slr.length;
                }
                if (lno < start_line) break;
                pair = slr[--li];
            }
            if (pair.region == null) continue;
            if (pair.region.hasParent(this.defPairStart)) {
                ++pm.pairBalance;
            }
            if (pair.region.hasParent(this.defPairEnd)) {
                --pm.pairBalance;
            }
            if (pm.pairBalance == 0) break;
        }
        if (pm.pairBalance == 0) {
            pm.eline = lno;
            pm.end = pair;
        }
    }

    public void searchLocalPair(PairMatch pm) {
        this.checkActive();
        int end_line = this.getLastVisibleLine();
        this.searchPair(pm, this.wStart, end_line);
    }

    public void searchGlobalPair(PairMatch pm) {
        this.checkActive();
        this.searchPair(pm, 0, this.lineCount - 1);
    }

    public LineRegion[] getLineRegions(int lno) {
        this.checkActive();
        return this.getLineRegions(this.iptr, lno);
    }

    public void validate(int lno) {
        this.checkActive();
        this.validate(this.iptr, lno);
    }

    public void idleJob(int time) {
        this.checkActive();
        this.idleJob(this.iptr, time);
    }

    public void modifyEvent(int topLine) {
        this.checkActive();
        for (int idx = this.editorListeners.size() - 1; idx >= 0; --idx) {
            ((EditorListener)this.editorListeners.elementAt(idx)).modifyEvent(topLine);
        }
        this.modifyEvent(this.iptr, topLine);
    }

    public void modifyLineEvent(int line) {
        this.checkActive();
        this.modifyLineEvent(this.iptr, line);
    }

    public void visibleTextEvent(int wStart, int wSize) {
        this.checkActive();
        this.visibleTextEvent(this.iptr, wStart, wSize);
        this.wStart = wStart;
        this.wSize = wSize;
    }

    public void lineCountEvent(int newLineCount) {
        this.checkActive();
        this.lineCountEvent(this.iptr, newLineCount);
        this.lineCount = newLineCount;
    }

    public ParserFactory getParserFactory() {
        return this.fParserFactory;
    }

    native long init(ParserFactory var1, LineSource var2);

    native void finalize(long var1);

    native void setRegionCompact(long var1, boolean var3);

    native void setRegionMapper(long var1, RegionMapper var3);

    native void setRegionMapper(long var1, String var3, String var4);

    native void addRegionHandler(long var1, RegionHandler var3, Region var4);

    native void removeRegionHandler(long var1, RegionHandler var3);

    native void setFileType(long var1, FileType var3);

    native FileType getFileType(long var1);

    native FileType chooseFileType(long var1, String var3);

    native void setBackParse(long var1, int var3);

    native RegionDefine getBackground(long var1);

    native RegionDefine getVertCross(long var1);

    native RegionDefine getHorzCross(long var1);

    native LineRegion[] getLineRegions(long var1, int var3);

    native void validate(long var1, int var3);

    native void idleJob(long var1, int var3);

    native void modifyEvent(long var1, int var3);

    native void modifyLineEvent(long var1, int var3);

    native void visibleTextEvent(long var1, int var3, int var4);

    native void lineCountEvent(long var1, int var3);
}

