/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.impl;

import java.util.Vector;
import net.sf.colorer.LineSource;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.impl.BaseEditorNative;

public class CachedBaseEditor
extends BaseEditorNative {
    private Vector cacheVector = new Vector();

    public CachedBaseEditor(ParserFactory pf, LineSource lineSource) {
        super(pf, lineSource);
    }

    public LineRegion[] getLineRegions(int lno) {
        LineRegion[] list = (LineRegion[])this.cacheVector.get(lno);
        if (list == null) {
            list = super.getLineRegions(lno);
            this.cacheVector.set(lno, list);
        }
        return list;
    }

    public void modifyEvent(int topLine) {
        super.modifyEvent(topLine);
        while (topLine < this.cacheVector.size()) {
            this.cacheVector.set(topLine, null);
            ++topLine;
        }
    }

    public void modifyLineEvent(int line) {
        super.modifyLineEvent(line);
    }

    public void lineCountEvent(int newLineCount) {
        super.lineCountEvent(newLineCount);
        this.cacheVector.setSize(newLineCount);
    }
}

