/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.swt;

import java.util.ResourceBundle;
import java.util.Vector;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.swt.ColorManager;
import net.sf.colorer.swt.TextColorer;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class ColorerDemo {
    Shell shell;
    ToolBar toolBar;
    StyledText text;
    TextColorer textColorer;
    Vector cachedStyles = new Vector();
    Font font = null;
    boolean isBold = false;
    ExtendedModifyListener extendedModifyListener;
    VerifyKeyListener verifyKeyListener;
    LineStyleListener lineStyleListener;
    static ResourceBundle resources = ResourceBundle.getBundle("net.sf.colorer.swt.ColorerDemo");

    Menu createEditMenu() {
        Menu bar = this.shell.getMenuBar();
        Menu menu = new Menu(bar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(resources.getString("Cut_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorerDemo.this.text.cut();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Copy_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorerDemo.this.text.copy();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Paste_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorerDemo.this.text.paste();
            }
        });
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Font_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorerDemo.this.setFont();
            }
        });
        return menu;
    }

    void createStyledText() {
        this.text = new StyledText((Composite)this.shell, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.setFont(new Font((Device)this.shell.getDisplay(), "Courier New", 10, 0));
        ParserFactory pf = new ParserFactory();
        this.textColorer = new TextColorer(pf, new ColorManager());
        this.textColorer.attach(this.text);
        this.textColorer.chooseFileType("xml.xml");
        this.textColorer.setCross(true, true);
        this.textColorer.setRegionMapper("default", true);
    }

    void createMenuBar() {
        Menu bar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(bar);
        Menu fileMenu = new Menu(bar);
        MenuItem mItem = new MenuItem(fileMenu, 8);
        mItem.setText(resources.getString("File_Exit_menuitem"));
        mItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                System.exit(0);
            }
        });
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(resources.getString("File_menuitem"));
        fileItem.setMenu(fileMenu);
        MenuItem editItem = new MenuItem(bar, 64);
        editItem.setText(resources.getString("Edit_menuitem"));
        editItem.setMenu(this.createEditMenu());
    }

    void createToolBar() {
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.shell);
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.shell.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setText(resources.getString("window_title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColorerDemo.this.font != null) {
                    ColorerDemo.this.font.dispose();
                }
            }
        });
    }

    public Shell open(Display display) {
        this.createShell(display);
        this.createMenuBar();
        this.createToolBar();
        this.createStyledText();
        this.shell.setSize(700, 500);
        this.shell.open();
        return this.shell;
    }

    public static void main(String[] args) {
        Display display = new Display();
        ColorerDemo clrDemo = new ColorerDemo();
        Shell shell = clrDemo.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

