/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.viewer;

import java.io.IOException;
import java.io.Writer;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.handlers.StyledRegion;
import net.sf.colorer.impl.BaseEditorNative;
import net.sf.colorer.impl.ReaderLineSource;
import net.sf.colorer.viewer.ParsedLineWriter;

public class HTMLGenerator {
    ReaderLineSource lineSource;
    String hrdSchema;
    ParserFactory pf;

    public HTMLGenerator(ParserFactory pf, ReaderLineSource input, String hrd) {
        this.lineSource = input;
        this.hrdSchema = hrd;
        this.pf = pf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Writer commonWriter, Writer escapedWriter, String fileName, boolean useLineNumbers, boolean useHtmlSubst, boolean useInfoHeader, boolean useHeaderFooter) throws IOException {
        BaseEditor be = null;
        try {
            be = new BaseEditorNative(this.pf, this.lineSource);
            be.setRegionCompact(true);
            be.setRegionMapper("rgb", this.hrdSchema);
            be.lineCountEvent(this.lineSource.getLineCount());
            be.visibleTextEvent(0, this.lineSource.getLineCount());
            be.chooseFileType(fileName);
            if (useHeaderFooter) {
                commonWriter.write("<html>\n<head>\n<style></style>\n</head>\n<body style='");
                ParsedLineWriter.writeStyle(commonWriter, (StyledRegion)be.getBackground());
                commonWriter.write("'><pre>\n");
            }
            if (useInfoHeader) {
                commonWriter.write("Created with Colorer-take5 Library. Type '" + be.getFileType().getName() + "'\n\n");
            }
            int lni = 0;
            int lwidth = 1;
            int lncount = this.lineSource.getLineCount();
            lni = lncount / 10;
            while (lni > 0) {
                lni /= 10;
                ++lwidth;
            }
            for (int idx = 0; idx < this.lineSource.getLineCount(); ++idx) {
                if (useLineNumbers) {
                    int iwidth = 1;
                    lni = idx / 10;
                    while (lni > 0) {
                        lni /= 10;
                        ++iwidth;
                    }
                    for (lni = iwidth; lni < lwidth; ++lni) {
                        commonWriter.write(32);
                    }
                    commonWriter.write(String.valueOf(idx));
                    commonWriter.write(": ");
                }
                ParsedLineWriter.htmlRGBWrite(commonWriter, escapedWriter, this.lineSource.getLine(idx), be.getLineRegions(idx));
                commonWriter.write("\n");
            }
            if (useHeaderFooter) {
                commonWriter.write("</pre></body></html>\n");
            }
            commonWriter.close();
        }
        finally {
            if (be != null) {
                be.dispose();
            }
        }
    }
}

