
package org.sf.feeling.decompiler.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.DecompilerType;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.editor.SourceMapperFactory;

public class DecompileUtil
{

	public static String decompile( IClassFile cf, String type, boolean always,
			boolean reuseBuf, boolean force ) throws CoreException
	{
		String decompilerType = type;
		String origSrc = cf.getSource( );
		// have to check our mark since all line comments are stripped
		// in debug align mode
		if ( origSrc == null
				|| always
				&& !origSrc.startsWith( JavaDecompilerClassFileEditor.MARK )
				|| ( origSrc.startsWith( JavaDecompilerClassFileEditor.MARK ) && ( !reuseBuf || force ) ) )
		{
			DecompilerSourceMapper sourceMapper = SourceMapperFactory.getSourceMapper( decompilerType );
			char[] src = sourceMapper.findSource( cf.getType( ) );
			if ( src == null )
			{
				if ( DecompilerType.JAD.equals( decompilerType ) )
				{
					src = SourceMapperFactory.getSourceMapper( DecompilerType.JDCORE )
							.findSource( cf.getType( ) );
				}
				else if ( DecompilerType.JDCORE.equals( decompilerType )
						&& UIUtil.isWin32( ) )
				{
					src = SourceMapperFactory.getSourceMapper( DecompilerType.JAD )
							.findSource( cf.getType( ) );
				}
			}
			if ( src == null )
			{
				return origSrc;
			}
			else
				return new String( src );
		}

		return origSrc;
	}
}
