/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SingleCommandOperation
extends RepositoryProviderOperation {
    private Command.LocalOption[] options = Command.NO_LOCAL_OPTIONS;

    public SingleCommandOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options) {
        super(part, mappings);
        if (options != null) {
            this.options = options;
        }
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
        session.open(Policy.subMonitorFor(monitor, 10), this.isServerModificationOperation());
        try {
            IStatus status = this.executeCommand(session, provider, this.getCVSArguments(session, resources), recurse, Policy.subMonitorFor(monitor, 90));
            if (this.isReportableError(status)) {
                throw new CVSException(status);
            }
        }
        finally {
            session.close();
        }
    }

    protected final ICVSResource[] getCVSArguments(IResource[] resources) {
        return super.getCVSArguments(resources);
    }

    protected ICVSResource[] getCVSArguments(Session session, IResource[] resources) {
        return this.getCVSArguments(resources);
    }

    protected void execute(CVSTeamProvider provider, RepositoryProviderOperation.ICVSTraversal entry, IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            super.execute(provider, entry, monitor);
            this.collectStatus(Status.OK_STATUS);
        }
        catch (CVSException e) {
            this.collectStatus(e.getStatus());
        }
    }

    protected boolean isServerModificationOperation() {
        return false;
    }

    protected abstract IStatus executeCommand(Session var1, CVSTeamProvider var2, ICVSResource[] var3, boolean var4, IProgressMonitor var5) throws CVSException, InterruptedException;

    protected Command.LocalOption[] getLocalOptions(boolean recurse) {
        Command.LocalOption[] result = this.options;
        if (recurse) {
            result = Command.DO_NOT_RECURSE.removeFrom(this.options);
        } else {
            result = Command.RECURSE.removeFrom(this.options);
            result = Command.DO_NOT_RECURSE.addTo(this.options);
        }
        return result;
    }

    protected void setLocalOptions(Command.LocalOption[] options) {
        this.options = options;
    }

    protected void addLocalOption(Command.LocalOption option) {
        this.options = option.addTo(this.options);
    }
}

