/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.epic.core.util.CommandLineTokenizer;
import org.epic.core.util.ProcessOutput;
import org.epic.core.util.ScriptExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.util.SourceFormatterException;

public class SourceFormatter
extends ScriptExecutor {
    protected SourceFormatter(ILog log) {
        super(log);
    }

    public static String format(String toFormat, ILog log) throws CoreException {
        return SourceFormatter.format(toFormat, Collections.EMPTY_LIST, log);
    }

    public static String format(String toFormat, List additionalArgs, ILog log) throws CoreException {
        ProcessOutput out = new SourceFormatter(log).run(toFormat, additionalArgs);
        if (out.stdout.startsWith("skipping file: ")) {
            String error = SourceFormatter.truncateString(out.stdout, 160);
            throw new SourceFormatterException((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "perltidy returned unexpected output via stdout, possibly due to invalid options in Source Formatter preferences:\n\n" + error, null), out.stdout);
        }
        if (out.stderr.length() != 0) {
            String error = SourceFormatter.truncateString(out.stderr, 320);
            throw new SourceFormatterException((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "perltidy returned unexpected output via stderr, possibly due to invalid options in Source Formatter preferences:\n\n" + error, null), out.stdout);
        }
        return out.stdout;
    }

    @Override
    protected String getCharsetName() {
        return "utf8";
    }

    @Override
    protected List getCommandLineOpts(List additionalOptions) {
        IPreferenceStore store = PerlEditorPlugin.getDefault().getPreferenceStore();
        int numSpaces = store.getInt("insertTabOnIndent");
        boolean useSpaces = store.getBoolean("spacesInsteadOfTabs");
        int tabWidth = useSpaces ? numSpaces : store.getInt("editorTabWidth");
        int pageSize = store.getInt("printMarginColumn");
        boolean cuddleElse = store.getBoolean("Formatter.cuddledElse");
        boolean bracesLeft = store.getBoolean("Formatter.bracesLeft");
        boolean lineUpParentheses = store.getBoolean("Formatter.lineUpWithParenttheses");
        boolean swallowOptionalBlankLines = store.getBoolean("Formatter.swallowOptionalBlankLines");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-q");
        args.add("--indent-columns=" + tabWidth);
        args.add("--maximum-line-length=" + pageSize);
        if (!useSpaces) {
            args.add("--entab-leading-whitespace=" + tabWidth);
        }
        if (cuddleElse) {
            args.add("--cuddled-else");
        }
        if (bracesLeft) {
            args.add("--opening-brace-on-new-line");
        }
        if (lineUpParentheses) {
            args.add("--line-up-parentheses");
        }
        if (swallowOptionalBlankLines) {
            args.add("--swallow-optional-blank-lines");
        }
        args.addAll(CommandLineTokenizer.tokenize(store.getString("Formatter.perltidyOptions")));
        if (additionalOptions != null) {
            args.addAll(additionalOptions);
        }
        return args;
    }

    @Override
    protected String getExecutable() {
        return "perltidy";
    }

    @Override
    protected String getScriptDir() {
        return "perlutils/perltidy";
    }

    private static String truncateString(String str, int maxLen) {
        if (maxLen < str.length()) {
            return String.valueOf(str.substring(0, Math.min(str.length(), maxLen))) + "...";
        }
        return str;
    }
}

