/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.PerlSourceViewerConfiguration;
import org.epic.perleditor.preferences.ColorEditor;
import org.epic.perleditor.preferences.OverlayPreferenceStore;
import org.epic.perleditor.preferences.PreferencesMessages;
import org.epic.perleditor.preferences.StatusInfo;
import org.epic.perleditor.preferences.StatusUtil;
import org.epic.perleditor.preferences.TabFolderLayout;

public class PerlEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BOLD = "Bold";
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editorTabWidth"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "insertTabOnIndent"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesInsteadOfTabs"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "sourceFolding"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionQuote1"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionQuote2"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionBracket1"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionBracket2"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionBracket3"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoCompletionBracket4"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "nullColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "nullColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "keyword1Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "keyword1ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "keyword2Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "keyword2ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "variableColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "variableColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "comment1Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "comment1ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "comment2Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "comment2ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "literal1Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "literal1ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "literal2Color"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "literal2ColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "labelColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "labelColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "functionColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "functionColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "markupColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markupColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "operatorColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "operatorColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "numberColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "numberColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "invalidColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "invalidColorBold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "errorIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "errorIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "errorIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "warningIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warningIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warningIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "taskIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "bookmarkIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "bookmarkIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "bookmarkIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "searchResultIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "searchResultIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "searchResultIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "othersIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndicationInOverviewRuler")};
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.nullColor, "AbstractTextEditor.Color.Foreground"}, {PreferencesMessages.keyword1Color, "keyword1Color"}, {PreferencesMessages.keyword2Color, "keyword2Color"}, {PreferencesMessages.variableColor, "variableColor"}, {PreferencesMessages.comment1Color, "comment1Color"}, {PreferencesMessages.comment2Color, "comment2Color"}, {PreferencesMessages.literal1Color, "literal1Color"}, {PreferencesMessages.literal2Color, "literal2Color"}, {PreferencesMessages.labelColor, "labelColor"}, {PreferencesMessages.functionColor, "functionColor"}, {PreferencesMessages.markupColor, "markupColor"}, {PreferencesMessages.operatorColor, "operatorColor"}, {PreferencesMessages.numberColor, "numberColor"}, {PreferencesMessages.invalidColor, "invalidColor"}};
    private final String[][] fAppearanceColorListModel = new String[][]{{PreferencesMessages.lineNumberForegroundColor, "lineNumberColor"}, {PreferencesMessages.currentLineHighlighColor, "currentLineColor"}, {PreferencesMessages.printMarginColor2, "printMarginColor"}};
    private final String[][] fAnnotationColorListModel = new String[][]{{PreferencesMessages.errors, "errorIndicationColor", "errorIndication", "errorIndicationInOverviewRuler"}, {PreferencesMessages.warnings, "warningIndicationColor", "warningIndication", "warningIndicationInOverviewRuler"}, {PreferencesMessages.tasks, "taskIndicationColor", "taskIndication", "taskIndicationInOverviewRuler"}, {PreferencesMessages.searchResults, "searchResultIndicationColor", "searchResultIndication", "searchResultIndicationInOverviewRuler"}, {PreferencesMessages.bookmarks, "bookmarkIndicationColor", "bookmarkIndication", "bookmarkIndicationInOverviewRuler"}, {PreferencesMessages.others, "othersIndicationColor", "othersIndication", "othersIndicationInOverviewRuler"}};
    private OverlayPreferenceStore fOverlayStore;
    private Map fColorButtons = new HashMap();
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PerlEditorPreferencePage.this.fOverlayStore.setValue((String)PerlEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            PerlEditorPreferencePage.this.fOverlayStore.setValue((String)PerlEditorPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PerlEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private List fSyntaxColorList;
    private List fAppearanceColorList;
    private List fAnnotationList;
    private ColorEditor fSyntaxForegroundColorEditor;
    private ColorEditor fAppearanceColorEditor;
    private ColorEditor fAnnotationForegroundColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fBoldCheckBox;
    private SourceViewer fPreviewViewer;
    private Color fBackgroundColor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Button fCompletionInsertsRadioButton;
    private Button fCompletionOverwritesRadioButton;

    public PerlEditorPreferencePage() {
        this.setDescription(PreferencesMessages.description);
        this.setPreferenceStore(PerlEditorPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    private void handleSyntaxColorListSelection() {
        int i = this.fSyntaxColorList.getSelectionIndex();
        String key = this.fSyntaxColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + BOLD));
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        this.fShowInTextCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        backgroundComposite.setLayout((Layout)new RowLayout());
        backgroundComposite.setText(PreferencesMessages.backgroundColor);
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = PerlEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                PerlEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                PerlEditorPreferencePage.this.fOverlayStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(PreferencesMessages.systemDefault);
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(PreferencesMessages.custom);
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.foreground);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fSyntaxColorList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fSyntaxColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(PreferencesMessages.color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.bold);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fSyntaxColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PerlEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fSyntaxColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)PerlEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)PerlEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)PerlEditorPreferencePage.this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)PerlEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fSyntaxColorListModel[i][1];
                PerlEditorPreferencePage.this.fOverlayStore.setValue(String.valueOf(key) + PerlEditorPreferencePage.BOLD, PerlEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, 2816);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new PerlSourceViewerConfiguration(this.fOverlayStore, null));
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        this.initializeViewerColors((ISourceViewer)this.fPreviewViewer);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        new PerlPartitioner(PerlEditorPlugin.getDefault().getLog(), (IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p = event.getProperty();
                if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                    PerlEditorPreferencePage.this.initializeViewerColors((ISourceViewer)PerlEditorPreferencePage.this.fPreviewViewer);
                }
                int topIndex = PerlEditorPreferencePage.this.fPreviewViewer.getTextWidget().getTopIndex();
                int caretOffset = PerlEditorPreferencePage.this.fPreviewViewer.getTextWidget().getCaretOffset();
                PerlEditorPreferencePage.this.fPreviewViewer.unconfigure();
                PerlEditorPreferencePage.this.fPreviewViewer.configure((SourceViewerConfiguration)new PerlSourceViewerConfiguration(PerlEditorPreferencePage.this.fOverlayStore, null));
                PerlEditorPreferencePage.this.fPreviewViewer.getTextWidget().setForeground(PerlEditorPlugin.getDefault().getColor("nullColor"));
                PerlEditorPreferencePage.this.fPreviewViewer.refresh();
                PerlEditorPreferencePage.this.fPreviewViewer.getTextWidget().setTopIndex(topIndex);
                PerlEditorPreferencePage.this.fPreviewViewer.getTextWidget().setCaretOffset(caretOffset);
                PerlEditorPreferencePage.this.fPreviewViewer.invalidateTextPresentation();
            }
        });
        return this.fPreviewViewer.getControl();
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        OverlayPreferenceStore store = this.fOverlayStore;
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        this.addTextField(appearanceComposite, PreferencesMessages.displayedTabWidth, "editorTabWidth", 3, 0, true);
        this.addTextField(appearanceComposite, PreferencesMessages.insertTabsOnIndent, "insertTabOnIndent", 3, 0, true);
        this.addTextField(appearanceComposite, PreferencesMessages.printMarginColumn, "printMarginColumn", 3, 0, true);
        this.addCheckBox(appearanceComposite, PreferencesMessages.spacesInsteadOfTabs, "spacesInsteadOfTabs", 0);
        this.addCheckBox(appearanceComposite, PreferencesMessages.showOverviewRuler, "overviewRuler", 0);
        this.addCheckBox(appearanceComposite, PreferencesMessages.showLineNumbers, "lineNumberRuler", 0);
        this.addCheckBox(appearanceComposite, PreferencesMessages.highlightCurrentLine, "currentLine", 0);
        this.addCheckBox(appearanceComposite, PreferencesMessages.showPrintMargin, "printMargin", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(PreferencesMessages.appearanceOptions);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PerlEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)PerlEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)PerlEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Control createAnnotationsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addFiller(composite);
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.presentationOptions);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(PreferencesMessages.showInText);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText(PreferencesMessages.showInOverviewRuler);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText(PreferencesMessages.color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PerlEditorPreferencePage.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fAnnotationColorListModel[i][2];
                PerlEditorPreferencePage.this.fOverlayStore.setValue(key, PerlEditorPreferencePage.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fAnnotationColorListModel[i][3];
                PerlEditorPreferencePage.this.fOverlayStore.setValue(key, PerlEditorPreferencePage.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PerlEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = PerlEditorPreferencePage.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)PerlEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)PerlEditorPreferencePage.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        return composite;
    }

    private Control createTypingPage(Composite parent) {
        Composite typingComposite = new Composite(parent, 0);
        typingComposite.setLayout((Layout)new GridLayout());
        Label l = new Label(typingComposite, 16384);
        l.setText(PreferencesMessages.autoCompletion);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionQuote1, "autoCompletionQuote1", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionQuote2, "autoCompletionQuote2", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionBracket1, "autoCompletionBracket1", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionBracket2, "autoCompletionBracket2", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionBracket3, "autoCompletionBracket3", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.autoCompletionBracket4, "autoCompletionBracket4", 0);
        this.addFiller(typingComposite);
        this.addCheckBox(typingComposite, PreferencesMessages.smartHomeEnd, "AbstractTextEditor.Navigation.SmartHomeEnd", 0);
        this.addCheckBox(typingComposite, PreferencesMessages.subWordNavigation, "subWordNavigation", 0);
        return typingComposite;
    }

    private void addFiller(Composite composite) {
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private static void createDependency(final Button master, final Control slave) {
        PerlEditorPreferencePage.indent(slave);
        master.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addCompletionRadioButtons(Composite contentAssistComposite) {
        Composite completionComposite = new Composite(contentAssistComposite, 0);
        GridData ccgd = new GridData();
        ccgd.horizontalSpan = 2;
        completionComposite.setLayoutData((Object)ccgd);
        GridLayout ccgl = new GridLayout();
        ccgl.marginWidth = 0;
        ccgl.numColumns = 2;
        completionComposite.setLayout((Layout)ccgl);
        SelectionAdapter completionSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerlEditorPreferencePage.this.fCompletionInsertsRadioButton.getSelection();
            }
        };
        this.fCompletionInsertsRadioButton = new Button(completionComposite, 16400);
        this.fCompletionInsertsRadioButton.setText(PreferencesMessages.completionInserts);
        this.fCompletionInsertsRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionInsertsRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        this.fCompletionOverwritesRadioButton = new Button(completionComposite, 16400);
        this.fCompletionOverwritesRadioButton.setText(PreferencesMessages.completionOverwrites);
        this.fCompletionOverwritesRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionOverwritesRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
    }

    private int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = Action.findModifier((String)modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.general);
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.colors);
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.annotationsTabTitle);
        item.setControl(this.createAnnotationsPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.typingTabTitle);
        item.setControl(this.createTypingPage((Composite)folder));
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            this.fSyntaxColorList.add(this.fSyntaxColorListModel[i][0]);
            ++i;
        }
        this.fSyntaxColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PerlEditorPreferencePage.this.fSyntaxColorList != null && !PerlEditorPreferencePage.this.fSyntaxColorList.isDisposed()) {
                    PerlEditorPreferencePage.this.fSyntaxColorList.select(0);
                    PerlEditorPreferencePage.this.handleSyntaxColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PerlEditorPreferencePage.this.fAppearanceColorList != null && !PerlEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    PerlEditorPreferencePage.this.fAppearanceColorList.select(0);
                    PerlEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PerlEditorPreferencePage.this.fAnnotationList != null && !PerlEditorPreferencePage.this.fAnnotationList.isDisposed()) {
                    PerlEditorPreferencePage.this.fAnnotationList.select(0);
                    PerlEditorPreferencePage.this.handleAnnotationListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        for (ColorEditor c : this.fColorButtons.keySet()) {
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        for (Button b : this.fCheckBoxes.keySet()) {
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        for (Text t : this.fTextFields.keySet()) {
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fOverlayStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(default_);
        this.fBackgroundCustomRadioButton.setSelection(!default_);
        this.fBackgroundColorButton.setEnabled(!default_);
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        PerlEditorPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleSyntaxColorListSelection();
        this.handleAppearanceColorListSelection();
        this.handleAnnotationListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed()) {
            this.fBackgroundColor.dispose();
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return PerlEditorPreferencePage.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private static Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.emptyInput);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.bind((String)PreferencesMessages.invalidInput, (Object)number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.bind((String)PreferencesMessages.invalidInput, (Object)number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

