/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.util.ListContentProvider;

public class SSLClientCertificatesMSCapi
extends ListDialog {
    protected String alias;

    public SSLClientCertificatesMSCapi(Shell parent, String realm) {
        super(parent);
        ArrayList<String[]> list = new ArrayList<String[]>();
        Provider pmscapi = Security.getProvider("SunMSCAPI");
        Provider pjacapi = Security.getProvider("CAPI");
        try {
            KeyStore keyStore = null;
            if (pmscapi != null) {
                keyStore = KeyStore.getInstance("Windows-MY", pmscapi);
                pmscapi.setProperty("Signature.SHA1withRSA", "sun.security.mscapi.RSASignature$SHA1");
            } else if (pjacapi != null) {
                keyStore = KeyStore.getInstance("CAPI");
            }
            if (keyStore != null) {
                keyStore.load(null, null);
                Enumeration<String> aliasEnumeration = keyStore.aliases();
                while (aliasEnumeration.hasMoreElements()) {
                    String alias = aliasEnumeration.nextElement();
                    String issuer = "";
                    Certificate cert = keyStore.getCertificate(alias);
                    if (cert instanceof X509Certificate) {
                        issuer = ((X509Certificate)cert).getIssuerDN().getName();
                    }
                    list.add(new String[]{alias, issuer});
                }
            }
        }
        catch (Exception e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        this.setTitle(Policy.bind("SSLClientCertificatesMSCapi.0"));
        this.setAddCancelButton(true);
        LabelProvider lp = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof String[] && ((String[])element).length > 1) {
                    return String.valueOf(((String[])element)[0]) + " | issued by: " + ((String[])element)[1];
                }
                return element.toString();
            }
        };
        this.setLabelProvider((ILabelProvider)lp);
        this.setMessage(Policy.bind("SSLClientCertificatesMSCapi.1"));
        this.setContentProvider(new ListContentProvider());
        this.setInput(list);
    }

    public String getAlias() {
        if (this.getResult() != null && this.getResult().length > 0) {
            Object result = this.getResult()[0];
            this.alias = result instanceof String[] ? ((String[])result)[0] : (String)result;
        }
        return this.alias;
    }
}

