/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.tigris.subversion.subclipse.graph.cache.Branch;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.cache.Path;

public class BranchEditPart
extends AbstractGraphicalEditPart {
    public static final int BRANCH_WIDTH = 220;
    public static final int BRANCH_HEIGHT = 30;
    public static final int BRANCH_OFFSET = 240;

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setBackgroundColor(ColorConstants.white);
        f.setOpaque(true);
        XYLayout layout = new XYLayout();
        f.setLayoutManager((LayoutManager)layout);
        Branch branch = (Branch)this.getModel();
        Rectangle rect = new Rectangle(10 + branch.getIndex() * 240, 10, 220, -1);
        ((AbstractGraphicalEditPart)this.getParent()).getFigure().getLayoutManager().setConstraint((IFigure)f, (Object)rect);
        return f;
    }

    protected List getModelChildren() {
        Branch branch = (Branch)this.getModel();
        ArrayList<Object> children = new ArrayList<Object>();
        Path path = new Path(branch.getPath());
        path.setIndex(branch.getIndex());
        children.add(path);
        List nodes = branch.getNodes();
        Iterator iter = nodes.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.setBranch(branch);
            node.setBranchIndex(i++);
            children.add(node);
        }
        return children;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void hideSelection() {
            }

            protected void showSelection() {
            }
        });
    }
}

