/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.compare;

import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.editors.DocumentLineSource;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.eclipse.jface.TextColorer;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.impl.CachedBaseEditor;
import net.sf.colorer.swt.ColorManager;
import org.eclipse.jface.text.ITextViewer;

public class StubTextEditor
implements IColorerEditorAdapter {
    private BaseEditor fBaseEditor;
    private ITextViewer fViewer;
    private TextColorer fTextColorer;
    private String fTitle;

    public StubTextEditor(ITextViewer viewer, String title) {
        this.fViewer = viewer;
        this.fTitle = title.replaceFirst("\\s\\d+$", "");
        this.fTextColorer = new TextColorer(this);
    }

    public BaseEditor getBaseEditor() {
        if (this.fBaseEditor == null) {
            this.fBaseEditor = new CachedBaseEditor(ColorerPlugin.getDefaultPF(), new DocumentLineSource(this.fViewer.getDocument()));
            this.fBaseEditor.setRegionCompact(true);
        }
        return this.fBaseEditor;
    }

    public void handleAttachComplete() {
        this.fTextColorer.chooseFileType(this.fTitle);
        String hrd = ColorerPlugin.getDefault().getPropertyHRD(this.fTextColorer.getFileType());
        if (hrd == null) {
            hrd = ColorerPlugin.getDefault().getPreferenceStore().getString("HRD_SET");
        }
        this.fTextColorer.setRegionMapper(hrd, ColorerPlugin.getDefault().getPreferenceStore().getBoolean("USE_BACK"));
    }

    public ColorManager getColorManager() {
        return ColorerPlugin.getDefault().getColorManager();
    }

    public void selectAndReveal(int position, int i) {
        this.fViewer.setSelectedRange(position, i);
    }

    public TextColorer getTextColorer() {
        return this.fTextColorer;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void dispose() {
        this.fBaseEditor.dispose();
        this.fBaseEditor = null;
    }
}

