/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleColumnSizeUtil;
import zigen.plugin.db.ext.oracle.internal.OracleDbBlockSizeSearcher;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpaceException;
import zigen.plugin.db.ext.oracle.tablespace.IColumn;
import zigen.plugin.db.ext.oracle.tablespace.OracleIndexColumn;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Table;

public class CalcIndexSpace {
    int block_header = 100;
    double safeCoefficient = 2.0;
    private final long maxRecord;
    private final Table table;
    private final OracleIndexColumn[] columns;
    private final String ownerName;
    private final String tableName;
    private final String indexName;
    private final int pctFree;
    private int blockSize;
    private BigDecimal tableSpaceSize;
    private BigDecimal tableSpaceSafeSize;

    public BigDecimal getTableSpaceSafeSize() {
        return this.tableSpaceSafeSize;
    }

    public BigDecimal getTableSpaceSize() {
        return this.tableSpaceSize;
    }

    public CalcIndexSpace(Table table, String indexName, OracleIndexColumn[] columns, int pctFree, long maxRecord) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
        this.pctFree = pctFree;
        this.ownerName = table.getSchemaName();
        this.tableName = table.getName();
        this.maxRecord = maxRecord;
    }

    public CalcIndexSpace(Table table, int blockSize, String indexName, OracleIndexColumn[] columns, int pctFree, long maxRecord) {
        this.table = table;
        this.blockSize = blockSize;
        this.indexName = indexName;
        this.columns = columns;
        this.pctFree = pctFree;
        this.ownerName = table.getSchemaName();
        this.tableName = table.getName();
        this.maxRecord = maxRecord;
    }

    public void calcurate() throws Exception {
        IDBConfig config = this.table.getDbConfig();
        Connection con = Transaction.getInstance(config).getConnection();
        if (this.blockSize == 0) {
            this.blockSize = OracleDbBlockSizeSearcher.execute(con);
        }
        OracleColumnSizeUtil cs = new OracleColumnSizeUtil();
        int columnAreaSize = cs.getRowLength(con, this.columns);
        this.tableSpaceSize = new BigDecimal(this.getNecessaryBlockSize(this.columns, columnAreaSize, this.maxRecord) * (double)this.blockSize / 1048576.0);
        this.tableSpaceSize = this.tableSpaceSize.setScale(3, 0);
        this.tableSpaceSafeSize = this.tableSpaceSize.multiply(new BigDecimal(this.safeCoefficient));
        this.tableSpaceSafeSize = this.tableSpaceSafeSize.setScale(3, 0);
    }

    public double getBlockHeaderSize() {
        double d = 161.0;
        return d;
    }

    private final double getRiyouKanouArea() {
        double d = Math.ceil(((double)this.blockSize - this.getBlockHeaderSize()) * (1.0 - (double)this.pctFree / 100.0));
        return d;
    }

    private double getIndexValueSize(IColumn[] columns, int columnAreaSize) {
        int entryHeader = 2;
        int rowId = 6;
        int f = 0;
        int v = 0;
        int i = 0;
        while (i < columns.length) {
            IColumn column = columns[i];
            if (column.getColumn_length() < 128) {
                ++f;
            } else {
                ++v;
            }
            ++i;
        }
        double d = entryHeader + rowId + (f * 1 + v * 2) + columnAreaSize;
        return d;
    }

    private final double getAverageRowCountOfBlock(IColumn[] columns, int columnAreaSize) throws CalcTableSpaceException {
        double d = Math.floor(this.getRiyouKanouArea() / this.getIndexValueSize(columns, columnAreaSize));
        return d;
    }

    private final double getNecessaryBlockSize(IColumn[] columns, int columnAreaSize, long totalRow) throws CalcTableSpaceException {
        double d = Math.ceil(1.05 * (double)totalRow / this.getAverageRowCountOfBlock(columns, columnAreaSize));
        return d;
    }

    public void setBlock_header(int block_header) {
        this.block_header = block_header;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setSafeCoefficient(double safeCoefficient) {
        this.safeCoefficient = safeCoefficient;
    }

    public double getSafeCoefficient() {
        return this.safeCoefficient;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CalcIndexSpace:");
        buffer.append(" block_header: ");
        buffer.append(this.block_header);
        buffer.append(" safeCoefficient: ");
        buffer.append(this.safeCoefficient);
        buffer.append(" maxRecord: ");
        buffer.append(this.maxRecord);
        buffer.append(" table: ");
        buffer.append(this.table);
        buffer.append(" { ");
        int i0 = 0;
        while (this.columns != null && i0 < this.columns.length) {
            buffer.append(" columns[" + i0 + "]: ");
            buffer.append(this.columns[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" ownerName: ");
        buffer.append(this.ownerName);
        buffer.append(" tableName: ");
        buffer.append(this.tableName);
        buffer.append(" pctFree: ");
        buffer.append(this.pctFree);
        buffer.append(" blockSize: ");
        buffer.append(this.blockSize);
        buffer.append(" tableSpaceSize: ");
        buffer.append(this.tableSpaceSize);
        buffer.append(" tableSpaceSafeSize: ");
        buffer.append(this.tableSpaceSafeSize);
        buffer.append("]");
        return buffer.toString();
    }

    public String getCalcResult() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" [INDEX]:" + this.indexName + " ");
        sb.append("(");
        int i = 0;
        while (i < this.columns.length) {
            OracleIndexColumn column = this.columns[i];
            if (i == 0) {
                sb.append(column.getColumn_name());
            } else {
                sb.append(", " + column.getColumn_name());
            }
            ++i;
        }
        sb.append(")");
        sb.append("\n");
        sb.append("   TABLE SPACE:");
        sb.append("  " + this.getTableSpaceSize() + " MB");
        sb.append("\n");
        sb.append("   TABLE SPACE :" + this.getSafeCoefficient() + ":");
        sb.append("  " + this.getTableSpaceSafeSize() + " MB");
        sb.append("\n");
        return sb.toString();
    }

    public List getCsvRow() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.ownerName);
        list.add(this.tableName);
        list.add(this.indexName);
        list.add(String.valueOf(this.blockSize));
        list.add(String.valueOf(this.pctFree));
        list.add(String.valueOf(this.maxRecord));
        list.add(String.valueOf(this.tableSpaceSize));
        list.add(String.valueOf(this.safeCoefficient));
        list.add(String.valueOf(this.tableSpaceSafeSize));
        return list;
    }

    public int getBlock_header() {
        return this.block_header;
    }

    public OracleIndexColumn[] getColumns() {
        return this.columns;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public long getMaxRecord() {
        return this.maxRecord;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getPctFree() {
        return this.pctFree;
    }

    public ITable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.tableName;
    }
}

