/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.views.SQLExecuteView;

public class CommitAction
extends Action
implements Runnable {
    private SQLExecuteView view;

    public CommitAction(SQLExecuteView view) {
        this.setText(Messages.getString("CommitAction.0"));
        this.setToolTipText(Messages.getString("CommitAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("commit.gif"));
        this.view = view;
    }

    public void run() {
        try {
            Transaction trans = Transaction.getInstance(this.view.getConfig());
            if (!trans.isConneting()) {
                DbPlugin.getDefault().showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                return;
            }
            int transCount = trans.getTransactionCount();
            trans.commit();
            this.view.setStatusMessage(this.createMessage(transCount));
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private String createMessage(int count) {
        return String.valueOf(count) + Messages.getString("CommitAction.3");
    }
}

