/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.bookmark;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.actions.RegistBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RenameBookmarkFolderAction;
import zigen.plugin.db.ui.bookmark.DragBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.DropBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.Messages;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.WidgetUtil;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeDoubleClickHandler;
import zigen.plugin.db.ui.views.TreeLabelProvider;
import zigen.plugin.db.ui.views.TreeViewListener;
import zigen.plugin.db.ui.views.TreeViewSorter;

public class BookmarkDialog
extends Dialog {
    public static final int BUTTON_WIDTH = 100;
    public static final int HORIZONTAL_SPACING = 3;
    public static final int MARGIN_WIDTH = 0;
    public static final int MARGIN_HEIGHT = 2;
    protected TreeViewer viewer;
    protected TreeContentProvider provider;
    private Button newBtn;
    private Button editBtn;
    private Button removeBtn;
    private TreeItem dragSourceItem;
    private TreeNode selectedNode = null;

    public BookmarkDialog(Shell parent, TreeContentProvider provider) {
        super(parent);
        this.provider = provider;
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("BookmarkDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createListLabel(composite);
        this.createList(composite);
        this.createListEditButtons(composite);
        this.addSeparator(parent);
        return composite;
    }

    private void createListLabel(Composite composite) {
        Label listLabel = new Label(composite, 0);
        listLabel.setText(Messages.getString("BookmarkDialog.1"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        listLabel.setLayoutData((Object)data);
    }

    private void createList(Composite composite) {
        this.viewer = new TreeViewer(composite, 2822);
        int dragOption = 19;
        Transfer[] transfers = new Transfer[]{TreeLeafListTransfer.getInstance()};
        this.viewer.addDragSupport(dragOption, transfers, (DragSourceListener)new DragBookmarkAdapter(this.viewer));
        this.viewer.addDropSupport(dragOption, transfers, (DropTargetListener)new DropBookmarkAdapter(this.viewer));
        this.viewer.addFilter((ViewerFilter)new BookmarkFilter());
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setSorter((ViewerSorter)new TreeViewSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.expandToLevel(2);
        this.viewer.addTreeListener((ITreeViewerListener)new TreeViewListener());
        GridData data = new GridData(1808);
        data.verticalSpan = 4;
        data.widthHint = 200;
        data.heightHint = this.viewer.getTree().getItemHeight() * 10;
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BookmarkDialog.this.tableSelectionChangedHandler(event);
            }
        });
        this.hookDoubleClickAction();
    }

    protected void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickHandler());
    }

    private void createListEditButtons(Composite composite) {
        this.newBtn = WidgetUtil.createButton(composite, 8, Messages.getString("BookmarkDialog.2"), 100, new GridData());
        this.editBtn = WidgetUtil.createButton(composite, 8, Messages.getString("BookmarkDialog.3"), 100, new GridData());
        this.removeBtn = WidgetUtil.createButton(composite, 8, Messages.getString("BookmarkDialog.4"), 100, new GridData());
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BookmarkDialog.this.addButtonPressedHandler();
            }
        });
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BookmarkDialog.this.editButtonPressedHandler();
            }
        });
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BookmarkDialog.this.removeButtonPressedHandler();
            }
        });
    }

    protected void tableSelectionChangedHandler(SelectionChangedEvent event) {
        Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (element instanceof BookmarkRoot) {
            this.editBtn.setEnabled(true);
            this.removeBtn.setEnabled(false);
        } else if (element instanceof BookmarkFolder) {
            this.editBtn.setEnabled(true);
            this.removeBtn.setEnabled(true);
        } else if (element instanceof Bookmark) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(true);
        } else {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        }
    }

    private void addButtonPressedHandler() {
        new RegistBookmarkFolderAction(this.viewer).run();
    }

    private void editButtonPressedHandler() {
        new RenameBookmarkFolderAction((StructuredViewer)this.viewer).run();
    }

    private void removeButtonPressedHandler() {
        Object element = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof BookmarkFolder) {
            new RemoveBookmarkFolderAction((StructuredViewer)this.viewer).run();
        } else if (element instanceof Bookmark) {
            new RemoveBookmarkAction((StructuredViewer)this.viewer).run();
        }
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private boolean save() {
        try {
            Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (element instanceof BookmarkRoot) {
                this.selectedNode = (TreeNode)element;
            } else if (element instanceof BookmarkFolder) {
                this.selectedNode = (TreeNode)element;
            } else {
                this.selectedNode = null;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
            return false;
        }
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    class BookmarkFilter
    extends ViewerFilter {
        BookmarkFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof Root);
        }
    }
}

