/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.IConfirmDDLWizard;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class ConfirmDDLWizardPage
extends DefaultWizardPage {
    public static final String MSG_DSC = Messages.getString("ConfirmDDLWizardPage.0");
    protected SQLDocument document;
    protected ColorManager colorManager = new ColorManager();

    public ConfirmDDLWizardPage() {
        super(Messages.getString("ConfirmDDLWizardPage.1"));
        this.setTitle(Messages.getString("ConfirmDDLWizardPage.2"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = this.createDefaultComposite(parent);
        this.createDDLConstrol(container);
        this.setControl((Control)container);
    }

    protected void createDDLConstrol(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn rulerCol = new LineNumberRulerColumn();
        LineNumberRulerColumnUtil.changeColor(this.colorManager, rulerCol);
        ruler.addDecorator(0, (IVerticalRulerColumn)rulerCol);
        ruler.setFont(DbPlugin.getSmallFont());
        SQLSourceViewer sourceViewer = new SQLSourceViewer(composite, (IVerticalRuler)ruler, null, false, 2818);
        sourceViewer.getTextWidget().setFont(DbPlugin.getSmallFont());
        SQLCodeConfiguration sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        sourceViewer.configure(sqlConfiguration);
        this.document = new SQLDocument();
        sourceViewer.setDocument((IDocument)this.document);
        sourceViewer.setEditable(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.generateSQL();
            this.setDescription(MSG_DSC);
        } else {
            this.setPageComplete(false);
        }
    }

    public void generateSQL() {
        boolean onPatch = DbPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditorPreferencePage.FormatPatch");
        int type = DbPlugin.getDefault().getPreferenceStore().getInt("SQLFormatPreferencePage.UseFormatterType");
        String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
        this.document.set("");
        IWizard wiz = this.getWizard();
        if (wiz instanceof IConfirmDDLWizard) {
            IConfirmDDLWizard _wiz = (IConfirmDDLWizard)wiz;
            try {
                StringBuffer sb = new StringBuffer();
                String[] sqls = _wiz.createSQL();
                int i = 0;
                while (i < sqls.length) {
                    String string = sqls[i];
                    if (string != null && !"".equals(string)) {
                        sb.append(SQLFormatter.format(sqls[i], type, onPatch));
                        if ("/".equals(demiliter)) {
                            sb.append(DbPluginConstant.LINE_SEP);
                        }
                        sb.append(demiliter);
                        sb.append(DbPluginConstant.LINE_SEP);
                        sb.append(DbPluginConstant.LINE_SEP);
                    }
                    ++i;
                }
                if ("".equals(sb.toString().trim())) {
                    this.updateStatus(Messages.getString("ConfirmDDLWizardPage.6"));
                    this.setPageComplete(false);
                } else {
                    this.updateStatus(null);
                    this.document.set(sb.toString());
                    this.setPageComplete(true);
                }
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }

    public SQLDocument getDocument() {
        return this.document;
    }
}

