/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.views.internal.ParseSqlThread;
import zigen.sql.parser.INode;
import zigen.sql.parser.ast.ASTParentheses;

public class UpdateSQLFoldingJob
extends AbstractJob {
    IDocument document;
    int offset;
    ProjectionAnnotationModel model;
    IPreferenceStore st;
    IStatusLineManager statusLineManager;

    public UpdateSQLFoldingJob(ProjectionAnnotationModel model, IDocument document, int offset, IStatusLineManager statusLineManager) {
        super(Messages.getString("UpdateSQLFoldingJob.0"));
        this.model = model;
        this.document = document;
        this.offset = offset;
        this.st = DbPlugin.getDefault().getPreferenceStore();
        this.statusLineManager = statusLineManager;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Update Folding...", -1);
            ParseSqlThread t = new ParseSqlThread(this.document, this.offset);
            Thread th = new Thread(t);
            th.setPriority(1);
            th.start();
            int timeout = 5;
            if (timeout > 0) {
                th.join(timeout * 1000);
            } else {
                th.join();
            }
            if (!t.isComplete()) {
                this.showWarningMessage(this.statusLineManager, "Update Folding is timeout.");
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            this.showResults(new UpdateFoldingAction(t.getNode(), t.getBeginOffset()));
            this.showMessage(this.statusLineManager, "Update Folding is complete.");
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Status.OK_STATUS;
        }
    }

    protected class UpdateFoldingAction
    implements Runnable {
        INode node;
        int beginOffset;

        public UpdateFoldingAction(INode node, int beginOffset) {
            this.node = node;
            this.beginOffset = beginOffset;
        }

        public void run() {
            try {
                if (UpdateSQLFoldingJob.this.model == null || this.node == null) {
                    return;
                }
                UpdateSQLFoldingJob.this.model.removeAllAnnotations();
                this.applyFolding(UpdateSQLFoldingJob.this.model, this.node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void applyFolding(ProjectionAnnotationModel model, INode node) {
            block7: {
                Position position = null;
                try {
                    List list;
                    ASTParentheses p;
                    if (node instanceof ASTParentheses && !(p = (ASTParentheses)node).isForFunction()) {
                        int _offset = this.beginOffset + p.getOffset();
                        int _length = p.getEndOffset() - p.getOffset() + 1;
                        if (_offset >= 0 && _length >= 0) {
                            position = new Position(_offset, _length);
                            model.addAnnotation((Annotation)new ProjectionAnnotation(), position);
                        }
                    }
                    if ((list = node.getChildren()) != null) {
                        int i = 0;
                        while (i < list.size()) {
                            INode _node = node.getChild(i);
                            this.applyFolding(model, _node);
                            ++i;
                        }
                    }
                }
                catch (AssertionFailedException assertionFailedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (position == null) break block7;
                    System.err.println("Folding Error " + position.getOffset() + ", " + position.getLength());
                }
            }
        }
    }
}

