/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.XMLManager;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.wizard.ExpWizardPage1;
import zigen.plugin.db.ui.wizard.Messages;
import zigen.plugin.db.ui.wizard.TableItem;

public class ExpDBConfigWizard
extends Wizard {
    private ExpWizardPage1 page1;
    private Root root;

    public ExpDBConfigWizard(Root root) {
        this.root = root;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new ExpWizardPage1(this.root);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        try {
            ArrayList<IDBConfig> selectList = new ArrayList<IDBConfig>();
            TableItem[] tableItems = this.page1.tableItems;
            int i = 0;
            while (i < tableItems.length) {
                TableItem item = tableItems[i];
                if (item.isChecked()) {
                    selectList.add(item.getConfig());
                }
                ++i;
            }
            return this.save(selectList.toArray(new IDBConfig[0]));
        }
        catch (IOException e) {
            DbPlugin.getDefault().showErrorDialog(e);
            return false;
        }
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    private boolean save(IDBConfig[] configs) throws IOException {
        Shell shell = DbPlugin.getDefault().getShell();
        File file = this.saveXml(shell, null);
        if (file != null) {
            if (file.exists() && !this.confirmOverwrite(shell, file.getName())) {
                return false;
            }
            XMLManager.save(file, configs);
        }
        return true;
    }

    private File saveXml(Shell shell, String defaultFileName) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFileName(defaultFileName);
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setFilterNames(new String[]{Messages.getString("ExpDBConfigWizard.4"), Messages.getString("ExpDBConfigWizard.5")});
        String fileName = dialog.open();
        if (fileName != null) {
            return new File(fileName);
        }
        return null;
    }

    private boolean confirmOverwrite(Shell shell, String fileName) {
        MessageBox msg = new MessageBox(shell, 196);
        msg.setMessage(String.valueOf(Messages.getString("ExpDBConfigWizard.6")) + fileName + Messages.getString("ExpDBConfigWizard.7"));
        msg.setText(Messages.getString("ExpDBConfigWizard.8"));
        int res = msg.open();
        return res == 64;
    }
}

