/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.File;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNTest {
    public static void main(String[] args) throws SVNException {
        SVNURL url = SVNURL.parseURIEncoded("http://svn.svnkit.com/repos/svnkit/trunk");
        File wc = new File("/home/alex/sandbox/svnkit-trunk");
        SvnOperationFactory of = new SvnOperationFactory();
        of.setWcGenerationSticky(true);
        SvnCheckout co = of.createCheckout();
        co.setSqliteJournalMode(SqlJetPagerJournalMode.MEMORY);
        co.setSingleTarget(SvnTarget.fromFile(wc));
        co.setSource(SvnTarget.fromURL(url));
        co.setDepth(SVNDepth.INFINITY);
        long time = System.currentTimeMillis();
        co.run();
        System.out.println("time: " + (System.currentTimeMillis() - time) + " ms.");
    }

    private static class CustomTrustManager
    implements X509TrustManager {
        private final ICustomTrustManagerCallback callback;

        public CustomTrustManager(ICustomTrustManagerCallback callback) {
            this.callback = callback;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate certificate : chain) {
                if (this.callback == null || this.callback.isCertificateTrusted(certificate)) continue;
                throw new SVNSSLUtil.CertificateNotTrustedException("certificate is not trusted");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static interface ICustomTrustManagerCallback {
        public boolean isCertificateTrusted(X509Certificate var1);
    }
}

