/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.views;

import de.loskutov.bco.BytecodeOutlinePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.objectweb.asm.util.Printer;
import org.osgi.framework.Bundle;

public class HelpUtils {
    private static String styleSheet;
    private static final String DOC_BASE;
    private static RGB bg_color_rgb;
    private static RGB fg_color_rgb;

    private static String checkOpcodeName(String opcodeName) {
        int sepIndex = (opcodeName = opcodeName.toLowerCase()).indexOf(95);
        if (sepIndex > 0 && Character.isDigit(opcodeName.charAt(sepIndex + 1))) {
            opcodeName = opcodeName.substring(0, sepIndex);
            switch (opcodeName.charAt(0)) {
                case 'd': {
                    opcodeName = opcodeName + "_d";
                    break;
                }
                case 'f': {
                    opcodeName = opcodeName + "_f";
                    break;
                }
                case 'l': {
                    opcodeName = opcodeName + "_l";
                    break;
                }
                default: {
                    opcodeName = opcodeName + "_n";
                }
            }
        }
        return opcodeName;
    }

    public static URL getHelpResource(int opcode) {
        if (opcode < 0 || opcode >= Printer.OPCODES.length) {
            return null;
        }
        String opcodeName = Printer.OPCODES[opcode];
        if (opcodeName != null) {
            opcodeName = HelpUtils.checkOpcodeName(opcodeName);
        }
        if (opcodeName == null) {
            return null;
        }
        return HelpUtils.getHelpResource(opcodeName);
    }

    private static URL getHelpResource(String name) {
        String href = DOC_BASE + "ref-" + name + ".html";
        return HelpUtils.resolveToHelpUrl(href);
    }

    public static URL getHelpIndex() {
        String href = DOC_BASE + "opcodes.html";
        return HelpUtils.resolveToHelpUrl(href);
    }

    private static String getDocBase() {
        URL base = HelpUtils.resolveToHelpUrl(DOC_BASE);
        if (base != null) {
            return base.toString();
        }
        return null;
    }

    private static URL resolveToHelpUrl(String path) {
        try {
            return BaseHelpSystem.resolve((String)path, (boolean)true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void appendColor(StringBuilder buffer, RGB rgb) {
        buffer.append('#');
        HelpUtils.appendAsHexString(buffer, rgb.red);
        HelpUtils.appendAsHexString(buffer, rgb.green);
        HelpUtils.appendAsHexString(buffer, rgb.blue);
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public static String getHelpStyleSheet() {
        String css;
        if (styleSheet == null) {
            styleSheet = HelpUtils.loadStyleSheet();
        }
        if ((css = styleSheet) == null || css.isEmpty()) {
            return "";
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        StringBuilder sb = new StringBuilder(css);
        sb.append("\nbody {  background-color:");
        HelpUtils.appendColor(sb, bg_color_rgb);
        sb.append(";  color:");
        HelpUtils.appendColor(sb, fg_color_rgb);
        sb.append(";  }\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (styleSheetURL == null) {
            return "";
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder(1500);
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder getOpcodeHelpFor(int opcode) {
        URL helpResource = HelpUtils.getHelpResource(opcode);
        StringBuilder sb = new StringBuilder();
        if (helpResource == null) {
            return sb;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(helpResource.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        int styleEnd = sb.indexOf("</style>");
        if (styleEnd > 0) {
            sb.insert(styleEnd, HelpUtils.getHelpStyleSheet());
        }
        int endHeadIdx = sb.indexOf("</head>");
        String base = HelpUtils.getDocBase();
        if (base != null) {
            sb.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
        }
        return sb;
    }

    static {
        DOC_BASE = "/" + BytecodeOutlinePlugin.getDefault().getBundle().getSymbolicName() + "/doc/";
        bg_color_rgb = new RGB(255, 255, 255);
        fg_color_rgb = new RGB(0, 0, 0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                bg_color_rgb = Display.getDefault().getSystemColor(29).getRGB();
                fg_color_rgb = Display.getDefault().getSystemColor(28).getRGB();
            }
        });
    }
}

