﻿#!perl -p

use utf8;
use warnings;
use strict;

my $tabsize = 4;

	my @LL = <>;
	my $text = undef;

	#####################################
	# StringUtil.append を回避
	#####################################
	s!StringUtil\.append\(!STRINGUTIL_APPEND(! foreach @LL;

	#####################################
	# append() 内の + を append() に変更
	#####################################
	#--[α]行またぎの処理
	#<  items.append("<tr>" +
	#<      "<td>"+a.getItemId()+"</td>" +
	#<      "<td><a action=\"bypass -h npc_"+getObjectId()+"\">"+
	#<      a.getItemName()+"</a></td>" +
	#<      "</tr>");
	#
	#>  items.append("<tr>" +
	#>      "<td>").append(a.getItemId()).append("</td>" +
	#>      "<td><a action=\"bypass -h npc_").append(getObjectId()).append("\">")
	#>      .append(a.getItemName()).append("</a></td>" +
	#>      "</tr>");
	#--[β]行内の処理
	#<  html.append("<td>" + curMsg.getFromName() + "</td>");
	#                   A~~~~                   B~~~~
	#>  html.append("<td>").append(curMsg.getFromName()).append("</td>");
	#                   A~~~~~~~~~~                   B~~~~~~~~~~
	#     A "文字"+以外 --> "文字").append(以外
	#     B 以外+"文字" --> 以外).append("文字"
	#       "文字"+"文字" --> そのまま
	#       以外+以外 --> そのまま
	for (my $i = 0; $i <= $#LL; ++$i) {
		if ($LL[$i] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\(!) {

			my $t = $i; for (;;) {
				# 下準備として、行末の + を、次行先頭に持っていく.
				# （+ を前につけるか、後ろにつけるか、統一させるため）
				#<  htmlCode.append(hoge +
				#<      hage
				#<      + age +
				#<      sage);
				#>  htmlCode.append(hoge
				#>      + hage
				#>      + age
				#>      + sage);
				if ($LL[$t+0] =~ s!\s*[+](\s*)$!$1!) {
					$LL[$t+1] =~ s!^\s*!$&+ !;
					$t += 1;
				} elsif ($LL[$t+1] =~ m!^\s*[+]!) {
					$t += 1;
				} else {
					last;
				}
			}

			#[α]行またぎの処理
			for (my $j = $i; $j <= $t-1; ++$j) {
				unless ($LL[$j+0] =~ m!["]\s*$!
				     && $LL[$j+1] =~ m!^\s*[+]\s*["]!) {
					$LL[$j+0] =~ s!\s*$!)$&!;
					$LL[$j+1] =~ s![+]\s*!.append(!;
				}
			}

			#[β]行内の処理
			for (my $j = $i; $j <= $t; ++$j) {
				$LL[$j] =~ s!["]\s*[+]\s*([^\s"])!").append($1!g;	#[β]A "文字"+以外
				$LL[$j] =~ s!([^"\s])\s*[+]\s*["]!$1).append("!g;	#[β]B 以外+"文字"
			}
			$i = $t;
		}
	}

	############################################
	# append() 行が連続したら、ひとつにまとめる
	############################################
	for (my $i = $#LL - 1; $i >= 0; --$i) {
		my $j = $i + 1;
		# 空行読み飛ばし
		while ($j < $#LL
		       && ($LL[$j] =~ m!^\s*//!s
		        || $LL[$j] =~ m!^\s*$!s )) {$j++}

		# インデントが同じか確かめる
		#   if (条件)
		#       html.append("<a href=...>□</a>"); <┐インデント違いは
		#   html.append("<br>");                   <┘統合できない。
		my $a = ($LL[$i] =~ m!^([ \t]*)!) ? $1 : '';
		my $b = ($LL[$j] =~ m!^([ \t]*)!) ? $1 : '';
		1 while $a =~ s/\t+/' ' x (length($&) * $tabsize - length($`) % $tabsize)/e;
		1 while $b =~ s/\t+/' ' x (length($&) * $tabsize - length($`) % $tabsize)/e;
		next if $a ne $b;

		#<  html.append("<html>");
		#<  html.append("<body>");
		#>  html.append("<html>"
		#>         +/**/"<body>");
		if ($LL[$i] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\(.*"\);\s*$!
		 && $LL[$j] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\("!) {
			$LL[$i] =~ s!\);(\s*)$!$1!;
			$LL[$j] =~ s!^(\s+)[A-Za-z_][A-Za-z_0-9]*\.append\(!$1\t+ !;
		}

		#<  TextBuilder html = new TextBuilder("<html>");
		#<  html.append("<body>");
		#>  TextBuilder html = new TextBuilder("<html>"
		#>         +/**/"<body>");
#-		if ($LL[$i] =~ m!new TextBuilder\(.*"\);\s*$!
		if ($LL[$i] =~ m!^\s+TextBuilder +[A-Za-z_][A-Za-z_0-9]* *= new TextBuilder\(.*"\);\s*$!
		 && $LL[$j] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\("!) {
			$LL[$i] =~ s!\);(\s*)$!$1!;
			$LL[$j] =~ s!^(\s+)[A-Za-z_][A-Za-z_0-9]*\.append\(!$1\t+ !;
		}
		if ($LL[$i] =~ m!^\s+StringBuilder +[A-Za-z_][A-Za-z_0-9]* *= new StringBuilder\(.*"\);\s*$!
		 && $LL[$j] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\("!) {
			$LL[$i] =~ s!\);(\s*)$!$1!;
			$LL[$j] =~ s!^(\s+)[A-Za-z_][A-Za-z_0-9]*\.append\(!$1\t+ !;
		}
		if ($LL[$i] =~ m!^\s+StringBuffer +[A-Za-z_][A-Za-z_0-9]* *= new StringBuffer\(.*"\);\s*$!
		 && $LL[$j] =~ m!^\s+[A-Za-z_][A-Za-z_0-9]*\.append\("!) {
			$LL[$i] =~ s!\);(\s*)$!$1!;
			$LL[$j] =~ s!^(\s+)[A-Za-z_][A-Za-z_0-9]*\.append\(!$1\t+ !;
		}
	}

	foreach (@LL) {
		s!\.append\("(\\[bfnrt"\\])"\)!.append('$1')!g;
		s!\.append\("'"\)!.append('\\'')!g;
		s!\.append\("(.)"\)!.append('$1')!g;
	}

	$text = join '', @LL;
	#####################################
	# StringUtil.append を復帰
	#####################################
	$text =~ s!STRINGUTIL_APPEND\(!StringUtil.append(!g;
	#####################################
	# Ｌ２Ｊ専用
	#####################################
	$text =~ s!new SimpleDateFormat\("dd/MM/yyyy HH:mm"\)!new SimpleDateFormat("yyyy/MM/dd HH:mm")!;
	$text =~ s/\\"l2ui_ch3.smallbutton2_down\\"/\\"L2UI_ct1.button_df_down\\"/g;
	$text =~ s/\\"l2ui_ch3.smallbutton2\\"/\\"L2UI_ct1.button_df\\"/g;
	$text =~ s/(<button value=[^>]*?height)=(1[56789]\b|\\"1[56789]\\"|2[02]\b|\\"2[02]\\")/$1=21/g;

	$text =~ s/\Qnew StringBuilder()/new StringBuilder(256)/g;
	$text =~ s/\Qnew StringBuilder("/new StringBuilder(256).append("/g;

	print $text;
