/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer;

import java.util.Enumeration;
import net.sf.colorer.HRCParser;
import net.sf.colorer.ParserFactoryException;
import net.sf.colorer.TextParser;
import net.sf.colorer.handlers.RegionMapper;
import net.sf.colorer.impl.Logger;

public class ParserFactory {
    long iptr;
    boolean disposed = false;
    static int count = 0;

    public ParserFactory(String catalogPath) {
        this.iptr = this.init(catalogPath);
        if (this.iptr == 0L) {
            this.disposed = true;
        }
        Logger.trace("ParserFactory", "count: " + ++count + " iptr=" + this.iptr);
    }

    public ParserFactory() {
        this.iptr = this.init(null);
        Logger.trace("ParserFactory", "init: count: " + ++count + " iptr=" + this.iptr);
    }

    void checkActive() {
        if (this.disposed) {
            throw new RuntimeException("checkActive");
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.checkActive();
        this.getHRCParser().dispose();
        this.disposed = true;
        this.finalize(this.iptr);
        Logger.trace("ParserFactory", "(fin) iptr=" + this.iptr);
        Logger.trace("ParserFactory", "(fin) count: " + --count);
    }

    protected void finalize() throws Throwable {
        if (this.disposed) {
            return;
        }
        this.dispose();
    }

    public String getVersion() {
        this.checkActive();
        return this.getVersion(this.iptr);
    }

    public Enumeration enumerateHRDClasses() {
        this.checkActive();
        return new Enumeration(){
            int idx = 0;

            public Object nextElement() {
                String cls = ParserFactory.this.enumerateHRDClasses(ParserFactory.this.iptr, this.idx);
                if (cls == null) {
                    return null;
                }
                ++this.idx;
                return cls;
            }

            public boolean hasMoreElements() {
                String cls = ParserFactory.this.enumerateHRDClasses(ParserFactory.this.iptr, this.idx);
                return cls != null;
            }
        };
    }

    public Enumeration enumerateHRDInstances(String classID) {
        this.checkActive();
        return new HRDEnumeration(classID);
    }

    public String getHRDescription(String classID, String nameID) {
        this.checkActive();
        return this.getHRDescription(this.iptr, classID, nameID);
    }

    public HRCParser getHRCParser() {
        this.checkActive();
        return this.getHRCParser(this.iptr);
    }

    public TextParser createTextParser() {
        this.checkActive();
        return this.createTextParser(this.iptr);
    }

    public RegionMapper createStyledMapper(String classID, String nameID) throws ParserFactoryException {
        this.checkActive();
        return this.createStyledMapper(this.iptr, classID, nameID);
    }

    public RegionMapper createTextMapper(String classID, String nameID) throws ParserFactoryException {
        this.checkActive();
        return this.createTextMapper(this.iptr, nameID);
    }

    native long init(String var1);

    native void finalize(long var1);

    native String getVersion(long var1);

    native String enumerateHRDClasses(long var1, int var3);

    native String enumerateHRDInstances(long var1, String var3, int var4);

    native String getHRDescription(long var1, String var3, String var4);

    native HRCParser getHRCParser(long var1);

    native TextParser createTextParser(long var1);

    native RegionMapper createStyledMapper(long var1, String var3, String var4);

    native RegionMapper createTextMapper(long var1, String var3);

    static {
        System.loadLibrary("net_sf_colorer");
    }

    class HRDEnumeration
    implements Enumeration {
        int idx = 0;
        String classID = null;

        HRDEnumeration(String classID) {
            this.classID = classID;
        }

        public Object nextElement() {
            ParserFactory.this.checkActive();
            String cls = ParserFactory.this.enumerateHRDInstances(ParserFactory.this.iptr, this.classID, this.idx);
            if (cls == null) {
                return null;
            }
            ++this.idx;
            return cls;
        }

        public boolean hasMoreElements() {
            ParserFactory.this.checkActive();
            String cls = ParserFactory.this.enumerateHRDInstances(ParserFactory.this.iptr, this.classID, this.idx);
            return cls != null;
        }
    }
}

