/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.editors;

import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.IUpdate;

public class WordWrapAction
extends Action
implements IUpdate {
    private IColorerEditorAdapter fTargetEditor;

    public WordWrapAction(IColorerEditorAdapter targetEditor) {
        this.setActionDefinitionId("net.sf.colorer.eclipse.editors.WordWrapAction");
        this.setText(Messages.get("WordWrapAction"));
        this.setToolTipText(Messages.get("WordWrapAction.tooltip"));
        this.setEditor(targetEditor);
    }

    public void setEditor(IColorerEditorAdapter targetEditor) {
        this.fTargetEditor = targetEditor;
    }

    public void run() {
        ColorerPlugin.getDefault().setPropertyWordWrap(this.fTargetEditor.getTextColorer().getFileType(), this.isChecked() ? 1 : 0);
    }

    public void update() {
        if (this.fTargetEditor == null) {
            return;
        }
        IPreferenceStore prefStore = ColorerPlugin.getDefault().getPreferenceStore();
        int ww = ColorerPlugin.getDefault().getPropertyWordWrap(this.fTargetEditor.getTextColorer().getFileType());
        if (ww == -1) {
            ww = prefStore.getBoolean("WORD_WRAP") ? 1 : 0;
        }
        this.setChecked(ww == 1);
    }
}

