/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.outline;

import java.util.Vector;
import net.sf.colorer.HRCParser;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.ImageStore;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.editors.ColorerEditor;
import net.sf.colorer.eclipse.outline.IWorkbenchOutlineSource;
import net.sf.colorer.eclipse.outline.ParseTreeOutliner;
import net.sf.colorer.eclipse.outline.WorkbenchOutliner;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.OutlineListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ColorerContentOutlinePage
extends ContentOutlinePage
implements OutlineListener {
    Action fLinkToEditorAction = new Action("Link", 2){

        public void run() {
            ColorerContentOutlinePage.this.prefStore.setValue("outline.link", this.isChecked());
        }
    };
    ISelectionListener thisSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ISelection sel = selection;
            if (!ColorerContentOutlinePage.this.fLinkToEditorAction.isChecked() || sel == null || !(sel instanceof ITextSelection)) {
                return;
            }
            int line = ((ITextSelection)sel).getStartLine();
            Object element = ColorerContentOutlinePage.this.fActiveOutlineSource.getItemByLine(line);
            if (element == null) {
                return;
            }
            ColorerContentOutlinePage.this.fProgrammaticChange = true;
            ColorerContentOutlinePage.this.getTreeViewer().expandToLevel(element, 0);
            ColorerContentOutlinePage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection(element), true);
        }
    };
    IWorkbenchOutlineSource fStructureOutline;
    IWorkbenchOutlineSource fParseTreeOutline;
    IWorkbenchOutlineSource fActiveOutlineSource;
    OutlineModeAction structureModeAction;
    OutlineModeAction parseTreeModeAction;
    OutlineModeAction activeAction;
    private Vector selectionListeners = new Vector();
    Thread backgroundUpdater = null;
    boolean outlineModified = true;
    long prevTime = 0L;
    int UPDATE_DELTA = 2000;
    boolean fProgrammaticChange = false;
    IPreferenceStore prefStore = ColorerPlugin.getDefault().getPreferenceStore();
    BaseEditor fBaseEditor;
    ColorerEditor fEditor;

    public void attach(ColorerEditor editor) {
        this.detach();
        this.fEditor = editor;
        this.fBaseEditor = editor.getBaseEditor();
        HRCParser hp = this.fBaseEditor.getParserFactory().getHRCParser();
        this.fStructureOutline = new WorkbenchOutliner(hp.getRegion("def:Outlined"));
        this.fParseTreeOutline = new ParseTreeOutliner();
        this.structureModeAction = new OutlineModeAction("Structure", this.fStructureOutline);
        this.parseTreeModeAction = new OutlineModeAction("ParseTree", this.fParseTreeOutline);
        this.fLinkToEditorAction.setImageDescriptor(ImageStore.getID("regions-tree-link"));
        this.fLinkToEditorAction.setToolTipText(Messages.get("outline.link"));
        this.fLinkToEditorAction.setChecked(this.prefStore.getBoolean("outline.link"));
        this.setActiveOutliner(this.fStructureOutline, this.structureModeAction);
        this.fActiveOutlineSource.setHierarchy(ColorerPlugin.getDefault().getPreferenceStore().getBoolean("Outline.Hierarchy"));
        this.fEditor.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.thisSelectionListener);
        this.notifyUpdate();
        this.backgroundUpdater = new Thread("backgroundUpdater"){
            Display rootDisplay = Display.getCurrent();

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(ColorerContentOutlinePage.this.UPDATE_DELTA);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (Thread.currentThread() != ColorerContentOutlinePage.this.backgroundUpdater) break;
                    this.rootDisplay.syncExec(new Runnable(){

                        public void run() {
                            ColorerContentOutlinePage.this.updateIfChanged();
                        }
                    });
                }
            }
        };
        this.backgroundUpdater.start();
    }

    public void detach() {
        if (this.fEditor != null) {
            this.fEditor.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.thisSelectionListener);
        }
        this.setActiveOutliner(null, null);
        this.backgroundUpdater = null;
        this.fBaseEditor = null;
        this.fEditor = null;
        this.fStructureOutline = null;
        this.fParseTreeOutline = null;
    }

    public void dispose() {
        this.detach();
        super.dispose();
    }

    void setActiveOutliner(IWorkbenchOutlineSource newOutliner, OutlineModeAction action) {
        if (this.fActiveOutlineSource != null) {
            this.fActiveOutlineSource.removeUpdateListener(this);
            if (this.fBaseEditor != null) {
                this.fActiveOutlineSource.detachOutliner(this.fBaseEditor);
            }
            if (this.activeAction != null) {
                this.activeAction.setChecked(false);
            }
        }
        this.fActiveOutlineSource = newOutliner;
        this.activeAction = action;
        if (this.fActiveOutlineSource != null) {
            this.fActiveOutlineSource.addUpdateListener(this);
            this.fActiveOutlineSource.clear();
            if (this.fBaseEditor != null) {
                this.fActiveOutlineSource.attachOutliner(this.fBaseEditor);
            }
            this.activeAction.setChecked(true);
            this.fEditor.invalidateSyntax();
        }
    }

    void update() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        this.getControl().setRedraw(false);
        int hpos = this.getTreeViewer().getTree().getHorizontalBar().getSelection();
        int vpos = this.getTreeViewer().getTree().getVerticalBar().getSelection();
        this.getTreeViewer().setInput((Object)this.fActiveOutlineSource);
        this.getTreeViewer().expandAll();
        this.getControl().setRedraw(true);
        this.getTreeViewer().getTree().getHorizontalBar().setSelection(hpos);
        this.getTreeViewer().getTree().getVerticalBar().setSelection(vpos);
    }

    public void updateIfChanged() {
        if (this.outlineModified) {
            this.update();
            this.outlineModified = false;
        }
    }

    public void notifyUpdate() {
        this.outlineModified = true;
        long cTime = System.currentTimeMillis();
        if (cTime - this.prevTime > (long)this.UPDATE_DELTA && this.fActiveOutlineSource != null) {
            this.updateIfChanged();
            this.prevTime = System.currentTimeMillis();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void createControl(Composite parent) {
        IMenuManager menuManager;
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ColorerContentOutlinePage.this.fProgrammaticChange) {
                    ColorerContentOutlinePage.this.fProgrammaticChange = false;
                    return;
                }
                Object[] list = ColorerContentOutlinePage.this.selectionListeners.toArray();
                for (int idx = list.length - 1; idx >= 0; --idx) {
                    ((ISelectionChangedListener)list[idx]).selectionChanged(event);
                }
            }
        });
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new TreeAction());
            toolBarManager.add((IAction)new SortAction());
            toolBarManager.add((IAction)this.fLinkToEditorAction);
        }
        if ((menuManager = this.getSite().getActionBars().getMenuManager()) != null) {
            menuManager.add((IAction)this.structureModeAction);
            menuManager.add((IAction)this.parseTreeModeAction);
        }
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setInput((Object)this.fActiveOutlineSource);
    }

    class OutlineModeAction
    extends Action {
        String id;
        IWorkbenchOutlineSource outliner;

        OutlineModeAction(String id, IWorkbenchOutlineSource outliner) {
            this.id = id;
            this.outliner = outliner;
            this.setText(Messages.get("outline.options." + id));
            this.setImageDescriptor(ImageStore.getID("outline-options-" + id));
            this.setChecked(ColorerContentOutlinePage.this.fActiveOutlineSource == outliner);
        }

        public void run() {
            if (ColorerContentOutlinePage.this.fActiveOutlineSource != this.outliner) {
                ColorerContentOutlinePage.this.setActiveOutliner(this.outliner, this);
                ColorerContentOutlinePage.this.update();
            }
        }
    }

    class SortAction
    extends Action {
        private ViewerSorter sorter = new WorkbenchViewerSorter();

        public SortAction() {
            super(Messages.get("outline.sort"), ImageStore.getID("outline-sort"));
            this.setToolTipText(Messages.get("outline.sort.tooltip"));
            this.setHoverImageDescriptor(ImageStore.getID("outline-sort-hover"));
            this.setChecked(ColorerPlugin.getDefault().getPreferenceStore().getBoolean("Outline.Sort"));
            ColorerContentOutlinePage.this.getTreeViewer().setSorter(this.isChecked() ? this.sorter : null);
        }

        public void run() {
            this.setChecked(this.isChecked());
            BusyIndicator.showWhile((Display)ColorerContentOutlinePage.this.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ColorerContentOutlinePage.this.getTreeViewer().setSorter(SortAction.this.isChecked() ? SortAction.this.sorter : null);
                }
            });
            ColorerPlugin.getDefault().getPreferenceStore().setValue("Outline.Sort", this.isChecked());
            ColorerContentOutlinePage.this.fActiveOutlineSource.setSorting(this.isChecked());
        }
    }

    class TreeAction
    extends Action {
        public TreeAction() {
            super(Messages.get("outline.tree"), ImageStore.getID("outline-tree"));
            this.setToolTipText(Messages.get("outline.tree.tooltip"));
            this.setHoverImageDescriptor(ImageStore.getID("outline-tree-hover"));
            this.setChecked(ColorerPlugin.getDefault().getPreferenceStore().getBoolean("Outline.Hierarchy"));
        }

        public void run() {
            this.setChecked(this.isChecked());
            ColorerPlugin.getDefault().getPreferenceStore().setValue("Outline.Hierarchy", this.isChecked());
            ColorerContentOutlinePage.this.fActiveOutlineSource.setHierarchy(this.isChecked());
        }
    }
}

