/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.editor;

import java.util.Vector;
import net.sf.colorer.Region;
import net.sf.colorer.RegionHandler;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.EditorListener;
import net.sf.colorer.editor.IOutlineSource;
import net.sf.colorer.editor.OutlineItem;
import net.sf.colorer.editor.OutlineListener;

public class Outliner
implements IOutlineSource {
    protected Vector fOutlineStorage = new Vector();
    Region searchRegion = null;
    int curLevel = 0;
    int modifiedLine = -1;
    private boolean changed = true;
    private boolean lineIsEmpty = true;
    private RegionHandler fRegionHandler = new RegionHandler(){

        public void startParsing(int lno) {
            Outliner.this.curLevel = 0;
        }

        public void endParsing(int lno) {
            if (Outliner.this.modifiedLine < lno) {
                Outliner.this.modifiedLine = lno + 1;
            }
            Outliner.this.curLevel = 0;
            if (Outliner.this.changed) {
                Outliner.this.notifyUpdate();
                Outliner.this.changed = false;
            }
        }

        public void clearLine(int lno, String line) {
            Outliner.this.lineIsEmpty = true;
        }

        public void addRegion(int lno, String line, int sx, int ex, Region region) {
            if (lno < Outliner.this.modifiedLine) {
                return;
            }
            if (!Outliner.this.isOutlined(region)) {
                return;
            }
            String itemLabel = null;
            if (line != null) {
                itemLabel = line.substring(sx, ex);
            }
            if (Outliner.this.lineIsEmpty) {
                Outliner.this.fOutlineStorage.addElement(Outliner.this.createItem(lno, sx, ex - sx, Outliner.this.curLevel, itemLabel, region));
            } else {
                OutlineItem thisItem = (OutlineItem)Outliner.this.fOutlineStorage.lastElement();
                if (itemLabel != null && thisItem.token != null && thisItem.lno == lno) {
                    if (itemLabel.length() > 1) {
                        thisItem.token.append(" ");
                    }
                    thisItem.token.append(itemLabel);
                }
            }
            Outliner.this.changed = true;
            Outliner.this.lineIsEmpty = false;
        }

        public void enterScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            ++Outliner.this.curLevel;
        }

        public void leaveScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            --Outliner.this.curLevel;
        }
    };
    private EditorListener fEditorListener = new EditorListener(){

        public void modifyEvent(int topLine) {
            int new_size;
            for (new_size = Outliner.this.fOutlineStorage.size() - 1; new_size >= 0 && ((OutlineItem)Outliner.this.fOutlineStorage.elementAt((int)new_size)).lno >= topLine; --new_size) {
            }
            Outliner.this.fOutlineStorage.setSize(new_size + 1);
            Outliner.this.modifiedLine = topLine;
            Outliner.this.changed = true;
        }
    };
    Vector listeners = new Vector();

    public Outliner(Region searchRegion) {
        this.searchRegion = searchRegion;
    }

    public void attachOutliner(BaseEditor be) {
        be.addRegionHandler(this.fRegionHandler, this.searchRegion);
        be.addEditorListener(this.fEditorListener);
    }

    public void detachOutliner(BaseEditor be) {
        be.removeRegionHandler(this.fRegionHandler);
        be.removeEditorListener(this.fEditorListener);
    }

    public OutlineItem getItem(int idx) {
        return (OutlineItem)this.fOutlineStorage.elementAt(idx);
    }

    public int itemCount() {
        return this.fOutlineStorage.size();
    }

    public Region getFilter() {
        return this.searchRegion;
    }

    static int manageTree(Vector treeStack, int newLevel) {
        while (treeStack.size() > 0 && newLevel < (Integer)treeStack.lastElement()) {
            treeStack.removeElementAt(treeStack.size() - 1);
        }
        if (treeStack.size() == 0 || newLevel > (Integer)treeStack.lastElement()) {
            treeStack.addElement(new Integer(newLevel));
            return treeStack.size() - 1;
        }
        if (newLevel == (Integer)treeStack.lastElement()) {
            return treeStack.size() - 1;
        }
        return 0;
    }

    public boolean isOutlined(Region region) {
        return region.hasParent(this.searchRegion);
    }

    public void clear() {
        this.fOutlineStorage.setSize(0);
    }

    protected OutlineItem createItem(int lno, int sx, int length, int curLevel, String itemLabel, Region region) {
        return new OutlineItem(lno, sx, length, curLevel, itemLabel, region);
    }

    public void addUpdateListener(OutlineListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeUpdateListener(OutlineListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void notifyUpdate() {
        for (int idx = 0; idx < this.listeners.size(); ++idx) {
            ((OutlineListener)this.listeners.elementAt(idx)).notifyUpdate();
        }
    }
}

