/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt;

import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class CSSActivator
implements BundleActivator {
    private static CSSActivator activator;
    private BundleContext context;
    private ServiceTracker<PackageAdmin, PackageAdmin> pkgAdminTracker;
    private ServiceTracker<LogService, LogService> logTracker;
    private ServiceTracker<IColorAndFontProvider, IColorAndFontProvider> colorAndFontProviderTracker;

    public static CSSActivator getDefault() {
        return activator;
    }

    public Bundle getBundle() {
        return this.context.getBundle();
    }

    public PackageAdmin getBundleAdmin() {
        if (this.pkgAdminTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.pkgAdminTracker = new ServiceTracker(this.context, PackageAdmin.class.getName(), null);
            this.pkgAdminTracker.open();
        }
        return (PackageAdmin)this.pkgAdminTracker.getService();
    }

    public Bundle getBundleForName(String bundleName) {
        Bundle[] bundles = this.getBundleAdmin().getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        activator = this;
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.pkgAdminTracker != null) {
            this.pkgAdminTracker.close();
            this.pkgAdminTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.colorAndFontProviderTracker != null) {
            this.colorAndFontProviderTracker.close();
            this.colorAndFontProviderTracker = null;
        }
        context = null;
    }

    private LogService getLogger() {
        if (this.logTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.logTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logTracker.open();
        }
        return (LogService)this.logTracker.getService();
    }

    public void log(int logError, String message) {
        LogService logger = this.getLogger();
        if (logger != null) {
            logger.log(logError, message);
        }
    }

    public IColorAndFontProvider getColorAndFontProvider() {
        if (this.colorAndFontProviderTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.colorAndFontProviderTracker = new ServiceTracker(this.context, IColorAndFontProvider.class.getName(), null);
            this.colorAndFontProviderTracker.open();
        }
        return (IColorAndFontProvider)this.colorAndFontProviderTracker.getService();
    }
}

