/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractLoadColumnJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;
import zigen.plugin.db.ui.views.TreeContentProvider;

public class RefreshColumnJob
extends AbstractLoadColumnJob {
    private static Object lock = new Object();
    protected TreeViewer treeViewer;
    protected ITable table;
    protected TablePKColumn[] pks = null;
    protected TableFKColumn[] fks = null;
    protected TableConstraintColumn[] cons = null;
    protected TableIDXColumn[] uidxs = null;
    protected TableIDXColumn[] nonuidxs = null;

    public RefreshColumnJob(TreeViewer viewer, ITable table) {
        super(Messages.getString("RefreshColumnJob.0"));
        this.treeViewer = viewer;
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected IStatus run(IProgressMonitor monitor) {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        Connection con = null;
        IDBConfig config = this.table.getDbConfig();
        try {
            try {
                block10: {
                    ITable iTable = this.table;
                    // MONITORENTER : iTable
                    monitor.beginTask(Messages.getString("RefreshColumnJob.6"), 6);
                    con = ConnectionManager.getConnection(config);
                    monitor.beginTask(Messages.getString("RefreshColumnJob.5"), 6);
                    if (this.loadColumnInfo(monitor, con, this.table)) break block10;
                    this.table.setExpanded(false);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    // MONITOREXIT : iTable
                    Object var6_9 = null;
                    ConnectionManager.closeConnection(con);
                    return iStatus;
                }
                this.table.setExpanded(true);
                this.showResults(new RefreshTreeNodeAction(this.treeViewer, this.table));
                // MONITOREXIT : iTable
            }
            catch (NotFoundSynonymInfoException e) {
                this.table.setEnabled(false);
                this.table.removeChildAll();
                this.showResults(new RefreshTreeNodeAction(this.treeViewer, this.table));
                this.showErrorMessage(Messages.getString("RefreshColumnJob.1"), e);
            }
            catch (Exception e) {
                this.table.setExpanded(false);
                this.showErrorMessage(Messages.getString("RefreshColumnJob.2"), e);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            ConnectionManager.closeConnection(con);
            throw throwable;
        }
        ConnectionManager.closeConnection(con);
        tw.stop();
        return Status.OK_STATUS;
    }

    public DataBase findDataBase(Bookmark bookmark) {
        IContentProvider cp;
        if (this.treeViewer != null && (cp = this.treeViewer.getContentProvider()) instanceof TreeContentProvider) {
            TreeContentProvider tcp = (TreeContentProvider)cp;
            return tcp.findDataBase(bookmark);
        }
        return null;
    }
}

