/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.core.util.PerlExecutableUtilities;
import org.epic.core.util.ProcessExecutor;
import org.epic.core.util.ProcessOutput;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlExecutor {
    private boolean disposed;
    private final ProcessExecutor executor;

    public PerlExecutor() {
        this(false);
    }

    public PerlExecutor(ProcessExecutor executor) {
        this.executor = executor;
    }

    public PerlExecutor(boolean ignoreBrokenPipe) {
        this(null, ignoreBrokenPipe);
    }

    public PerlExecutor(String charsetName, boolean ignoreBrokenPipe) {
        this.executor = new ProcessExecutor(charsetName);
        if (ignoreBrokenPipe) {
            this.executor.ignoreBrokenPipe();
        }
    }

    public void dispose() {
        this.disposed = true;
        this.executor.dispose();
    }

    public ProcessOutput execute(File workingDir, List args, String input) throws CoreException {
        if (this.disposed) {
            throw new IllegalStateException("PerlExecutor disposed");
        }
        List commandLine = PerlExecutableUtilities.getPerlCommandLine();
        if (args != null) {
            commandLine.addAll(args);
        }
        try {
            return this.executor.execute(commandLine, input, workingDir);
        }
        catch (InterruptedException e) {
            this.throwCoreException(e);
            return null;
        }
        catch (IOException e) {
            this.throwCoreException(e, commandLine);
            return null;
        }
    }

    public ProcessOutput execute(PerlProject project, List args, String sourceCode) throws CoreException {
        return this.execute((IResource)project.getProject(), args, sourceCode);
    }

    public ProcessOutput execute(IResource resource, List args, String sourceCode) throws CoreException {
        if (this.disposed) {
            throw new IllegalStateException("PerlExecutor disposed");
        }
        if (sourceCode.length() < 1) {
            return new ProcessOutput("", "");
        }
        PerlProject project = PerlCore.create(resource.getProject());
        List commandLine = this.getPerlCommandLine(project);
        if (args != null) {
            commandLine.addAll(args);
        }
        try {
            return this.executor.execute(commandLine, sourceCode, this.getPerlWorkingDir(resource));
        }
        catch (InterruptedException e) {
            this.throwCoreException(e);
            return null;
        }
        catch (IOException e) {
            this.throwCoreException(e, commandLine);
            return null;
        }
    }

    public ProcessOutput execute(ITextEditor editor, List args, String sourceCode) throws CoreException {
        return this.execute((IResource)((IFileEditorInput)editor.getEditorInput()).getFile(), args, sourceCode);
    }

    protected List getPerlCommandLine(PerlProject project) {
        return PerlExecutableUtilities.getPerlCommandLine(project);
    }

    protected File getPerlWorkingDir(IPath resourceLocation) {
        return new File(resourceLocation.makeAbsolute().removeLastSegments(1).toString());
    }

    protected File getPerlWorkingDir(IResource resource) {
        return this.getPerlWorkingDir(resource.getLocation());
    }

    private void throwCoreException(InterruptedException e) throws CoreException {
        Status status = new Status(2, PerlEditorPlugin.getPluginId(), 0, "Execution of a Perl process was aborted.", (Throwable)e);
        throw new CoreException((IStatus)status);
    }

    private void throwCoreException(IOException e, List commandLine) throws CoreException {
        Status status = new Status(4, PerlEditorPlugin.getPluginId(), 0, "Failed to execute command line: " + this.getCommandLineString(commandLine), (Throwable)e);
        throw new CoreException((IStatus)status);
    }

    private String getCommandLineString(List commandLine) {
        StringBuffer buf = new StringBuffer();
        Iterator i = commandLine.iterator();
        while (i.hasNext()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            String str = (String)i.next();
            str = String.valueOf('\"') + str.replaceAll("\"", "\\\"") + '\"';
            buf.append(str);
        }
        return buf.toString();
    }
}

