/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextEditor;
import org.epic.perleditor.editors.util.MarkerUtil;

public class PerlAnnotationHover
implements IAnnotationHover {
    static final int MAX_INFO_LENGTH = 80;
    private TextEditor fTextEditor;

    public PerlAnnotationHover(TextEditor editor) {
        this.fTextEditor = editor;
    }

    public String getHoverInfo(ISourceViewer viewer, int line) {
        String info = null;
        IResource resource = (IResource)this.fTextEditor.getEditorInput().getAdapter(IResource.class);
        List markers = MarkerUtil.getMarkersForLine(resource, line + 1);
        if (markers != null) {
            info = "";
            int i = 0;
            while (i < markers.size()) {
                IMarker marker = (IMarker)markers.get(i);
                String message = marker.getAttribute("message", null);
                if (message != null && message.trim().length() > 0) {
                    if (message.length() > 80) {
                        message = this.splitMessage(message);
                    }
                    info = String.valueOf(info) + message;
                    if (i != markers.size() - 1) {
                        info = String.valueOf(info) + "\n";
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private String splitMessage(String message) {
        String result = "";
        if (message.length() <= 80) {
            return message;
        }
        String tmpStr = new String(message);
        while (tmpStr.length() > 80) {
            int spacepos = tmpStr.indexOf(" ", 80);
            if (spacepos != -1) {
                result = String.valueOf(result) + tmpStr.substring(0, spacepos) + "\n";
                tmpStr = tmpStr.substring(spacepos);
                continue;
            }
            result = String.valueOf(result) + tmpStr.substring(0, 80) + "\n";
            tmpStr = tmpStr.substring(80);
        }
        result = String.valueOf(result) + tmpStr;
        return result;
    }
}

