/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.epic.core.util.StringReaderThread;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.IdleTimerListener;
import org.epic.perleditor.editors.util.PerlValidator;

public class PerlSyntaxValidationThread
extends Thread
implements IdleTimerListener {
    private final Object lock = new Object();
    private final int waitForTermination = 1000;
    private IResource resource;
    private IDocument document;
    private String code;
    private StringReaderThread srt = new StringReaderThread();

    public PerlSyntaxValidationThread() {
        super("PerlSyntaxValidationThread");
    }

    public void dispose() throws InterruptedException {
        this.srt.dispose();
        this.interrupt();
        this.join(1000L);
    }

    @Override
    public void onEditorIdle(ISourceViewer viewer) {
        this.validate();
    }

    public void revalidate() {
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(IResource resource, IDocument document) {
        Object object = this.lock;
        synchronized (object) {
            this.document = document;
            this.resource = resource;
            if (this.document != null) {
                this.validate();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws InterruptedException {
        int exceptions = 0;
        while (!Thread.interrupted()) {
            String text;
            Object object = this.lock;
            synchronized (object) {
                while (this.code == null) {
                    this.lock.wait();
                }
                text = this.code;
                this.code = null;
            }
            try {
                PerlValidator.instance().validate(this.resource, text);
            }
            catch (CoreException e) {
                if (!PerlEditorPlugin.getDefault().hasPerlInterpreter() || ++exceptions >= 5) continue;
                PerlEditorPlugin.getDefault().getLog().log((IStatus)new MultiStatus(PerlEditorPlugin.getPluginId(), 0, new IStatus[]{e.getStatus()}, "An unexpected exception occurred while validating " + this.resource.getProjectRelativePath(), (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        Object object = this.lock;
        synchronized (object) {
            this.code = this.document.get();
            this.lock.notifyAll();
        }
    }
}

